/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorservice.BaseMethods;
import java.util.ArrayList;
import java.util.List;

public class AuxApuracaoReinf2020
extends BaseMethods {
    public List apurarItens2020(List<Rps> listaRps, List<NotaFiscalPropria> listaNotas) {
        ItemReinfNotas2020 ii;
        CadastroNacionalObra cno;
        Short indicadorEmpreitada;
        Short indicadorObra;
        ArrayList<ItemReinf2020> itens = new ArrayList<ItemReinf2020>();
        for (Rps rps : listaRps) {
            Boolean tomadorRegistrado = false;
            indicadorObra = this.getIndicador(rps.getIsObra());
            indicadorEmpreitada = this.getIndicador(rps.getTipoObraConstrucao());
            cno = rps.getCadastroNacionalObra();
            for (ItemReinf2020 item : itens) {
                if (!this.isEquals(item.getPessoa(), rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa()) || !this.isEquals(item.getIndicadorObra(), indicadorObra) || !this.isEquals(item.getIndicadorEmpreitada(), indicadorEmpreitada) || !this.isNull(cno).booleanValue() && !this.isEquals(item.getCno(), cno) || !this.isEquals(item.getEmpresa(), rps.getEmpresa())) continue;
                ii = new ItemReinfNotas2020();
                ii.setRps(rps);
                ii.setItemReinf2020(item);
                item.getItens().add(ii);
                tomadorRegistrado = true;
                break;
            }
            if (tomadorRegistrado.booleanValue()) continue;
            itens.add(this.getItemReinf2020(rps, cno, indicadorObra, indicadorEmpreitada));
        }
        for (NotaFiscalPropria n : listaNotas) {
            Boolean clienteRegistrado = false;
            indicadorObra = this.getIndicador(n.getInformarNotaObra());
            indicadorEmpreitada = this.getIndicador(n.getTipoObraConstrucao());
            cno = n.getCadastroNacionalObra();
            for (ItemReinf2020 item : itens) {
                if (!this.isEquals(item.getPessoa(), n.getUnidadeFatCliente().getCliente().getPessoa()) || !this.isEquals(item.getIndicadorObra(), indicadorObra) || !this.isEquals(item.getIndicadorEmpreitada(), indicadorEmpreitada) || !this.isNull(cno).booleanValue() && !this.isEquals(item.getCno(), cno) || !this.isEquals(item.getEmpresa(), n.getEmpresa())) continue;
                ii = new ItemReinfNotas2020();
                ii.setNotaPropria(n);
                ii.setItemReinf2020(item);
                item.getItens().add(ii);
                clienteRegistrado = true;
                break;
            }
            if (clienteRegistrado.booleanValue()) continue;
            itens.add(this.getItemReinf2020(n, cno, indicadorObra, indicadorEmpreitada));
        }
        return itens;
    }

    private ItemReinf2020 getItemReinf2020(Rps rps, CadastroNacionalObra cno, Short indicadorObra, Short indicadorEmpreitada) {
        ItemReinf2020 i = new ItemReinf2020();
        i.setPessoa(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa());
        i.setIndicadorObra(indicadorObra);
        i.setIndicadorEmpreitada(indicadorEmpreitada);
        i.setCno(cno);
        i.setEmpresa(rps.getEmpresa());
        ItemReinfNotas2020 ii = new ItemReinfNotas2020();
        ii.setRps(rps);
        ii.setItemReinf2020(i);
        i.getItens().add(ii);
        return i;
    }

    private ItemReinf2020 getItemReinf2020(NotaFiscalPropria n, CadastroNacionalObra cno, Short indicadorObra, Short indicadorEmpreitada) {
        ItemReinf2020 i = new ItemReinf2020();
        i.setPessoa(n.getUnidadeFatCliente().getCliente().getPessoa());
        i.setIndicadorObra(indicadorObra);
        i.setIndicadorEmpreitada(indicadorEmpreitada);
        i.setCno(cno);
        i.setEmpresa(n.getEmpresa());
        ItemReinfNotas2020 ii = new ItemReinfNotas2020();
        ii.setNotaPropria(n);
        ii.setItemReinf2020(i);
        i.getItens().add(ii);
        return i;
    }

    private Short getIndicador(Short indicador) {
        if (this.isNull(indicador).booleanValue()) {
            return EnumConstantsMentorSimNao.NAO.getValue();
        }
        return indicador;
    }
}

