/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaoreinf.utility;

import com.touchcomp.basementor.constants.enums.geracaotitulosimpostosretidos.EnumConstGeracaoTitulosImpostosRetidos;
import com.touchcomp.basementor.model.vo.BaixaTituloPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemCooperadoJuros;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4020;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.baixatitulopiscofins.ServiceBaixaTituloPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuxApuracaoReinf4020
extends BaseMethods {
    private final ServiceNotaFiscalTerceirosImpl serviceNotaTerceiros;
    private final ServiceBaixaTituloPisCofinsImpl serviceBaixaTituloPisCofins;

    public AuxApuracaoReinf4020(ServiceNotaFiscalTerceirosImpl serviceNotaTerceiros, ServiceBaixaTituloPisCofinsImpl serviceBaixaTituloPisCofins) {
        this.serviceNotaTerceiros = serviceNotaTerceiros;
        this.serviceBaixaTituloPisCofins = serviceBaixaTituloPisCofins;
    }

    public List<ItemReinf4020> apuracaoValores4020(GrupoEmpresa grupo, OpcoesContabeis opcoesContabeis, R1000 reinf, Date periodo) {
        ArrayList<ItemReinf4020> itens;
        block8: {
            boolean achou;
            List<NotaFiscalTerceiros> notas;
            block7: {
                itens = new ArrayList<ItemReinf4020>();
                notas = this.serviceNotaTerceiros.findNotasNaoApuradasReinf4020(grupo, periodo);
                if (AuxApuracaoReinf4020.isWithData(notas)) {
                    for (NotaFiscalTerceiros notaFiscalTerceiros : notas) {
                        achou = false;
                        for (ItemReinf4020 item : itens) {
                            if (!this.isEquals(item.getEmpresa(), notaFiscalTerceiros.getEmpresa()) || !this.isEquals(item.getPessoa(), notaFiscalTerceiros.getUnidadeFatFornecedor().getPessoa())) continue;
                            achou = true;
                            ItemReinfNotas4020 i = this.buildItemReinfNotas4020(notaFiscalTerceiros);
                            i.setItemReinf(item);
                            item.getItensNotas().add(i);
                            break;
                        }
                        if (achou) continue;
                        itens.add(this.buildItemReinf4020(notaFiscalTerceiros));
                    }
                }
                if (!this.isEquals(opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) break block7;
                List<BaixaTituloPisCofins> baixas = this.serviceBaixaTituloPisCofins.apuracaoValores4020Impostos(grupo, periodo);
                if (!AuxApuracaoReinf4020.isWithData(baixas)) break block8;
                for (BaixaTituloPisCofins baixaTituloPisCofins : baixas) {
                    itens.add(this.buildItemReinf4020(baixaTituloPisCofins));
                }
                break block8;
            }
            notas = this.serviceNotaTerceiros.findNotasOutrasRetencoesReinf4020(grupo, periodo);
            if (AuxApuracaoReinf4020.isWithData(notas)) {
                for (NotaFiscalTerceiros notaFiscalTerceiros : notas) {
                    achou = false;
                    ItemNotaTerceiros itemNfe = (ItemNotaTerceiros)notaFiscalTerceiros.getItemNotaTerceiros().get(0);
                    for (ItemReinf4020 item : itens) {
                        if (!this.isEquals(item.getEmpresa(), notaFiscalTerceiros.getEmpresa()) || !this.isEquals(item.getPessoa(), notaFiscalTerceiros.getUnidadeFatFornecedor().getPessoa())) continue;
                        achou = true;
                        ItemReinfNotas4020 i = this.buildItemReinfNotas4020OutrasRetencoes(notaFiscalTerceiros, itemNfe, reinf);
                        i.setItemReinf(item);
                        item.getItensNotas().add(i);
                        break;
                    }
                    if (achou) continue;
                    itens.add(this.buildItemReinf4020OutrasRetencoes(notaFiscalTerceiros));
                }
            }
        }
        return itens;
    }

    private ItemReinf4020 buildItemReinf4020(NotaFiscalTerceiros nfe) {
        ItemReinf4020 item = new ItemReinf4020();
        item.setEmpresa(nfe.getEmpresa());
        item.setPessoa(nfe.getUnidadeFatFornecedor().getPessoa());
        ItemReinfNotas4020 i = new ItemReinfNotas4020();
        i.setNotaTerceiros(nfe);
        i.setItemReinf(item);
        i.setBaseIrrf(nfe.getValoresNfTerceiros().getValorTotal());
        i.setValorIrrf(nfe.getValoresNfTerceiros().getValorIrrf());
        if (AuxApuracaoReinf4020.isWithData(nfe.getItemNotaTerceiros())) {
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
        }
        item.getItensNotas().add(i);
        return item;
    }

    private ItemReinfNotas4020 buildItemReinfNotas4020(NotaFiscalTerceiros nfe) {
        ItemReinfNotas4020 i = new ItemReinfNotas4020();
        i.setNotaTerceiros(nfe);
        i.setBaseIrrf(nfe.getValoresNfTerceiros().getValorTotal());
        i.setValorIrrf(nfe.getValoresNfTerceiros().getValorIrrf());
        if (AuxApuracaoReinf4020.isWithData(nfe.getItemNotaTerceiros())) {
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
        }
        return i;
    }

    private ItemReinf4020 buildItemReinf4020(BaixaTituloPisCofins baixaTituloPisCofins) {
        ItemReinf4020 itemReinf4020 = new ItemReinf4020();
        itemReinf4020.setPessoa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getPessoa());
        itemReinf4020.setEmpresa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getEmpresa());
        ItemReinfNotas4020 itemReinfNotas4020 = new ItemReinfNotas4020();
        if (this.isNotNull(baixaTituloPisCofins.getBaixaTitulo()).booleanValue() && this.isNotNull(baixaTituloPisCofins.getBaixaTitulo().getTitulo()).booleanValue() && this.isNotNull(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros()).booleanValue()) {
            itemReinfNotas4020.setNotaTerceiros(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros());
            itemReinfNotas4020.setPessoa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa());
        }
        itemReinfNotas4020.setBaseCsll(baixaTituloPisCofins.getValorBCCsll());
        itemReinfNotas4020.setValorCsll(baixaTituloPisCofins.getValorCsll());
        itemReinfNotas4020.setBaseCofins(baixaTituloPisCofins.getValorBCCofins());
        itemReinfNotas4020.setValorCofins(baixaTituloPisCofins.getValorCofins());
        itemReinfNotas4020.setBasePis(baixaTituloPisCofins.getValorBCPis());
        itemReinfNotas4020.setValorPis(baixaTituloPisCofins.getValorPis());
        itemReinfNotas4020.setBaseAgregado(baixaTituloPisCofins.getValorBCLei10833());
        itemReinfNotas4020.setValorAgregado(baixaTituloPisCofins.getValorLei10833());
        itemReinfNotas4020.setNaturezaRendimento(baixaTituloPisCofins.getNatRendReinf());
        itemReinfNotas4020.setItemReinf(itemReinf4020);
        itemReinf4020.getItensNotas().add(itemReinfNotas4020);
        return itemReinf4020;
    }

    private ItemReinfNotas4020 buildItemReinfNotas4020OutrasRetencoes(NotaFiscalTerceiros nfee, ItemNotaTerceiros itemNfe, R1000 reinf) {
        ItemReinfNotas4020 i = new ItemReinfNotas4020();
        i.setNotaTerceiros(nfee);
        if (this.isEquals(itemNfe.getItemNotaLivroFiscal().getPercRedLei10833(), 0.0)) {
            i.setBaseAgregado(nfee.getValoresNfTerceiros().getValorTotal());
        } else {
            i.setBaseAgregado(Double.valueOf(nfee.getValoresNfTerceiros().getValorTotal() - nfee.getValoresNfTerceiros().getValorTotal() * itemNfe.getItemNotaLivroFiscal().getPercRedLei10833() / 100.0));
        }
        i.setValorAgregado(nfee.getValoresNfTerceiros().getValorLei10833());
        i.setBaseCofins(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorCofins(nfee.getValoresNfTerceiros().getValorCofinsST());
        i.setBaseCsll(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorCsll(nfee.getValoresNfTerceiros().getValorContSoc());
        i.setBasePis(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorPis(nfee.getValoresNfTerceiros().getValorPisSt());
        if (AuxApuracaoReinf4020.isWithData(nfee.getItemNotaTerceiros())) {
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
        }
        return i;
    }

    private ItemReinf4020 buildItemReinf4020OutrasRetencoes(NotaFiscalTerceiros nfee) {
        ItemReinf4020 item = new ItemReinf4020();
        item.setEmpresa(nfee.getEmpresa());
        item.setPessoa(nfee.getUnidadeFatFornecedor().getPessoa());
        ItemReinfNotas4020 i = new ItemReinfNotas4020();
        i.setNotaTerceiros(nfee);
        i.setItemReinf(item);
        i.setBaseAgregado(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorAgregado(nfee.getValoresNfTerceiros().getValorLei10833());
        i.setBaseCofins(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorCofins(nfee.getValoresNfTerceiros().getValorCofinsST());
        i.setBaseCsll(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorCsll(nfee.getValoresNfTerceiros().getValorContSoc());
        i.setBasePis(nfee.getValoresNfTerceiros().getValorTotal());
        i.setValorPis(nfee.getValoresNfTerceiros().getValorPisSt());
        if (AuxApuracaoReinf4020.isWithData(nfee.getItemNotaTerceiros())) {
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
        }
        item.getItensNotas().add(i);
        return item;
    }

    public List<ItemReinf4020NaoIdentificado> apuracaoValores4020NaoIdentificado(List<ItemCooperadoJuros> listItemCooperadoJuros) {
        ArrayList<ItemReinf4020NaoIdentificado> listItens4020NaoIdentificado = new ArrayList<ItemReinf4020NaoIdentificado>();
        if (AuxApuracaoReinf4020.isWithData(listItemCooperadoJuros)) {
            for (ItemCooperadoJuros i : listItemCooperadoJuros) {
                this.criarItemReinf4020NaoIdentificado(listItens4020NaoIdentificado, i.getProvisaoJuros().getEmpresa(), i.getCooperado().getCliente().getPessoa().getComplemento().getCnpj(), i.getValorProvisionado(), i.getValorProvisionado(), i.getValorIrrfJurosCoop(), i.getProvisaoJuros().getDataMovimento());
            }
        }
        return listItens4020NaoIdentificado;
    }

    private void criarItemReinf4020NaoIdentificado(List<ItemReinf4020NaoIdentificado> listItens4020NaoIdentificado, Empresa empresa, String cnpj, Double valorBruto, Double baseIrrf, Double valorIrrf, Date dataPagamento) {
        ItemReinf4020NaoIdentificado itens4020NaoIdentificado = new ItemReinf4020NaoIdentificado();
        itens4020NaoIdentificado.setEmpresa(empresa);
        itens4020NaoIdentificado.setCpf(cnpj);
        itens4020NaoIdentificado.setValorBruto(valorBruto);
        itens4020NaoIdentificado.setBaseIrrf(baseIrrf);
        itens4020NaoIdentificado.setValorIrrf(valorIrrf);
        itens4020NaoIdentificado.setDataPagamento(dataPagamento);
        listItens4020NaoIdentificado.add(itens4020NaoIdentificado);
    }
}

