/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaovalorescooperados;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class AuxApuracaoValoresCooperados {
    final ServiceTituloImpl serviceTitulo;
    final ServiceClienteImpl serviceCliente;

    public AuxApuracaoValoresCooperados(ServiceTituloImpl serviceTitulo, ServiceClienteImpl serviceCliente) {
        this.serviceTitulo = serviceTitulo;
        this.serviceCliente = serviceCliente;
    }

    List<ItemApuracaoValoresCooperados> apuracarValoresCooperadoPorPeriodo(Date dataVencimentoInicial, Date dataVencimentoFinal, Empresa empresa, TipoCooperado tipoCooperado, OpcoesFinanceiras opcoesFinanceiras, ClassificacaoClientes classificacaoClientes, CategoriaPessoa categoriaPessoa, Short tipoApuracao, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, Short naoApurarTitulosPeriodoAnterior, Short tipoCliente, Short utilizarClassificacaoTitulo) throws ExceptionInvalidData {
        List<Titulo> titulos;
        List<Object> titulosAtrasados = new ArrayList();
        ArrayList<ItemApuracaoValoresCooperados> apuracoes = new ArrayList<ItemApuracaoValoresCooperados>();
        if (tipoApuracao.equals((short)0)) {
            titulos = this.findTitulosCooperado(dataVencimentoInicial, dataVencimentoFinal, tipoCooperado, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos);
            if (!ToolMethods.isAffirmative((Number)naoApurarTitulosPeriodoAnterior)) {
                titulosAtrasados = this.titulosAbertoMesesAnterioresCooperado(tipoCooperado, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos);
            }
        } else {
            titulos = this.findTitulosCliente(dataVencimentoInicial, dataVencimentoFinal, classificacaoClientes, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, unidadeFatCliente, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
            if (!ToolMethods.isAffirmative((Number)naoApurarTitulosPeriodoAnterior)) {
                titulosAtrasados = this.titulosAbertoMesesAnterioresCliente(classificacaoClientes, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
            }
        }
        this.processarLancamentos(titulos, apuracoes, 0.0);
        this.processarLancamentos(titulosAtrasados, apuracoes, opcoesFinanceiras.getPercMulta());
        return apuracoes;
    }

    private void processarLancamentos(List<Titulo> lancsCooperado, List<ItemApuracaoValoresCooperados> apuracoes, Double percMulta) throws ExceptionInvalidData {
        for (Titulo titulo : lancsCooperado) {
            ItemApuracaoValoresCooperados item;
            Optional<ItemApuracaoValoresCooperados> found = apuracoes.stream().filter(i -> TMethods.isEquals((Object)i.getPessoa().getIdentificador(), (Object)titulo.getPessoa().getIdentificador())).findFirst();
            Double saldoTitulo = titulo.getValorSaldo();
            if (found.isPresent()) {
                item = found.get();
                valor = item.getValor();
                if (titulo.getPagRec().equals((short)1)) {
                    valor = valor - saldoTitulo;
                    titulo.setValorMultaEmbutida(Double.valueOf(saldoTitulo * percMulta / 100.0));
                } else {
                    valor = valor + saldoTitulo;
                }
                item.setValor(valor);
            } else {
                item = new ItemApuracaoValoresCooperados();
                item.setPessoa(titulo.getPessoa());
                valor = item.getValor();
                if (titulo.getPagRec().equals((short)1)) {
                    valor = valor - saldoTitulo;
                    item.setValor(valor);
                } else {
                    valor = valor + saldoTitulo;
                    item.setValor(valor);
                }
                apuracoes.add(item);
            }
            ItemTituloApuracCooperado itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
            itemTitulo.setItemApuracaoCooperado(item);
            item.getTitulos().add(itemTitulo);
        }
        ArrayList<Cliente> clientes = new ArrayList<Cliente>();
        this.cacheClientes(apuracoes, clientes);
        for (ItemApuracaoValoresCooperados itemApuracao : apuracoes) {
            Cliente cliente = this.getCliente(clientes, itemApuracao.getPessoa());
            itemApuracao.setCliente(cliente);
            if (itemApuracao.getValor() <= 0.0) {
                itemApuracao.setTipoCobrancaApuracao(cliente.getFinanceiro().getTipoCobrancaApuracao());
                continue;
            }
            itemApuracao.setTipoCobrancaApuracao(cliente.getFinanceiro().getTipoCobrancaApuracaoCredor());
        }
    }

    private List<Titulo> findTitulosCooperado(Date dataVencimentoInicial, Date dataVencimentoFinal, TipoCooperado tipoCooperado, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        return this.serviceTitulo.findTitulosCooperados(dataVencimentoInicial, dataVencimentoFinal, tipoCooperado, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos);
    }

    private List<Titulo> findTitulosCliente(Date dataVencimentoInicial, Date dataVencimentoFinal, ClassificacaoClientes classificacaoClientes, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        return this.serviceTitulo.findTitulosCliente(dataVencimentoInicial, dataVencimentoFinal, classificacaoClientes, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, unidadeFatCliente, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
    }

    private List<Titulo> titulosAbertoMesesAnterioresCooperado(TipoCooperado tipoCooperado, Date dataVencimentoInicial, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        return this.serviceTitulo.titulosAbertoMesesAnterioresCooperado(tipoCooperado, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos);
    }

    private List<Titulo> titulosAbertoMesesAnterioresCliente(ClassificacaoClientes classificacaoClientes, Date dataVencimentoInicial, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        return this.serviceTitulo.titulosAbertoMesesAnterioresCliente(classificacaoClientes, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
    }

    private Cliente getCliente(List<Cliente> clientes, Pessoa pessoa) throws ExceptionInvalidData {
        for (Cliente cliente : clientes) {
            if (!TMethods.isEquals((Object)cliente.getPessoa().getIdentificador(), (Object)pessoa.getIdentificador())) continue;
            return cliente;
        }
        Cliente cliente = this.serviceCliente.findClienteByPessoa(pessoa);
        if (cliente != null) {
            clientes.add(cliente);
            return cliente;
        }
        throw new ExceptionInvalidData("Cliente nao encontrado para a pessoa: " + pessoa.toString(), new Object[0]);
    }

    private void cacheClientes(List<ItemApuracaoValoresCooperados> apuracoes, List<Cliente> clients) {
        HashSet<Long> pessoas = new HashSet<Long>();
        for (ItemApuracaoValoresCooperados ap : apuracoes) {
            pessoas.add(ap.getPessoa().getIdentificador());
        }
        int regPerTime = 1000;
        LinkedList temp = new LinkedList(pessoas);
        int counter = 0;
        int max = 0;
        while (max < temp.size()) {
            max = (counter + 1) * regPerTime < temp.size() ? (counter + 1) * regPerTime : temp.size();
            List sub = temp.subList(counter * regPerTime, max);
            clients.addAll(this.serviceCliente.findClienteByPessoa(sub.toArray(new Long[0])));
            ++counter;
        }
    }
}

