/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.apuracaovalorescooperados;

import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoApuracaoValoresCooperadosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.apuracaovalorescooperados.AuxApuracaoValoresCooperados;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.grupodebaixa.ServiceGrupoDeBaixaImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceApuracaoValoresCooperadosImpl
extends ServiceGenericEntityImpl<ApuracaoValoresCooperados, Long, DaoApuracaoValoresCooperadosImpl> {
    @Autowired
    ServiceClienteImpl serviceCliente;
    @Autowired
    ServiceTituloImpl serviceTitulo;

    public ServiceApuracaoValoresCooperadosImpl(DaoApuracaoValoresCooperadosImpl dao) {
        super(dao);
    }

    public void findApuracaoAndSetGerouDebContaByTitulos(List<Titulo> listTitulos, Short debitoContaGerado) {
        ArrayList ret = new ArrayList();
        for (Titulo t : listTitulos) {
            ApuracaoValoresCooperados ap = ((DaoApuracaoValoresCooperadosImpl)this.getDao()).findApuracaoByTitulo(t);
            if (ToolMethods.isEquals((Object)ap, null)) continue;
            block1: for (ItemApuracaoValoresCooperados v : ap.getValoresCooperados()) {
                for (ItemTituloApuracCooperado item : v.getTitulos()) {
                    if (!ToolMethods.isEquals((Object)item.getTitulo(), (Object)t)) continue;
                    v.setDebitoContaGerado(debitoContaGerado);
                    continue block1;
                }
            }
        }
        if (!ToolMethods.isWithData(ret)) {
            return;
        }
        this.saveOrUpdate(ret);
    }

    public boolean existDebitoContaGeradoByTitulo(Titulo titulo) {
        return ((DaoApuracaoValoresCooperadosImpl)this.getDao()).debitoContaGerado(titulo);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ApuracaoValoresCooperados excluirBaixaRecebimentoPagamento(ApuracaoValoresCooperados apuracaoValoresCooperados, Short pagRec) {
        GrupoDeBaixa grupoDeBaixa;
        if (this.isEquals(pagRec, (short)1)) {
            grupoDeBaixa = apuracaoValoresCooperados.getGrupoBaixaRecebimento();
            apuracaoValoresCooperados.setGrupoBaixaRecebimento(null);
        } else {
            grupoDeBaixa = apuracaoValoresCooperados.getGrupoBaixaPagamento();
            apuracaoValoresCooperados.setGrupoBaixaPagamento(null);
        }
        ApuracaoValoresCooperados apuracao = ((DaoApuracaoValoresCooperadosImpl)this.getGenericDao()).saveOrUpdate(apuracaoValoresCooperados);
        ServiceGrupoDeBaixaImpl serviceGrupoDeBaixaImpl = (ServiceGrupoDeBaixaImpl)Context.get(ServiceGrupoDeBaixaImpl.class);
        serviceGrupoDeBaixaImpl.delete(grupoDeBaixa);
        return apuracao;
    }

    public List<ItemApuracaoValoresCooperados> apuracarValoresCooperadoPorPeriodo(Date dataVencimentoInicial, Date dataVencimentoFinal, Empresa empresa, TipoCooperado tipoCooperado, ClassificacaoClientes classificacaoClientes, CategoriaPessoa categoriaPessoa, Short tipoApuracao, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, Short naoApurarTitulosPeriodoAnterior, Short tipoCliente, Short utilizarClassificacaoTitulo) throws ExceptionInvalidData {
        return new AuxApuracaoValoresCooperados(this.serviceTitulo, this.serviceCliente).apuracarValoresCooperadoPorPeriodo(dataVencimentoInicial, dataVencimentoFinal, empresa, tipoCooperado, this.getSharedData().getOpcoesFinanceiras(empresa), classificacaoClientes, categoriaPessoa, tipoApuracao, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, unidadeFatCliente, naoApurarTitulosPeriodoAnterior, tipoCliente, utilizarClassificacaoTitulo);
    }
}

