/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.arquivamentodoc;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsGeneric;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.ArquivamentoDocItens;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.TipoArquivamentoDoc;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoArquivamentoDocImpl;
import com.touchcomp.basementorservice.helpers.impl.arquivamentodoc.HelperArquivamentoDoc;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.UtilServiceClass;
import com.touchcomp.basementorservice.service.impl.arquivamentodoc.ServiceArquivamentoDocItensImpl;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileUploadImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.tipoarquivamentodoc.ServiceTipoArquivamentoDocImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorvalidator.entities.impl.arquivamentodoc.web.ValidArquivaDoc;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoDoc;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoDocRes;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoItem;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoItemDetalhes;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOGrupoArquivamentoDoc;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOGrupoArquivamentoDocRequest;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.springframework.stereotype.Service;

@Service
public class ServiceArquivamentoDocImpl
extends ServiceGenericEntityImpl<ArquivamentoDoc, Long, DaoArquivamentoDocImpl> {
    final ValidArquivaDoc validArquivaDoc;
    final ServiceNodoImpl serviceNodoImpl;
    final ServiceArquivamentoDocItensImpl serviceArquivamentoDocItensImpl;
    final ServiceTipoArquivamentoDocImpl serviceTipoArquivamentoDocImpl;
    final HelperArquivamentoDoc helperArquivamento;
    final ServiceFileUploadImpl serviceFileUploadImpl;

    public ServiceArquivamentoDocImpl(DaoArquivamentoDocImpl genericDao, ValidArquivaDoc validArquivaDoc, ServiceNodoImpl serviceNodoImpl, ServiceArquivamentoDocItensImpl serviceArquivamentoDocItensImpl, ServiceTipoArquivamentoDocImpl serviceTipoArquivamentoDocImpl, HelperArquivamentoDoc helperArquivamento, ServiceFileUploadImpl serviceFileUploadImp) {
        super(genericDao);
        this.validArquivaDoc = validArquivaDoc;
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceArquivamentoDocItensImpl = serviceArquivamentoDocItensImpl;
        this.serviceTipoArquivamentoDocImpl = serviceTipoArquivamentoDocImpl;
        this.helperArquivamento = helperArquivamento;
        this.serviceFileUploadImpl = serviceFileUploadImp;
    }

    @Override
    public boolean delete(ArquivamentoDoc vo) {
        this.serviceArquivamentoDocItensImpl.deleteItens(vo.getItensDoc());
        return super.delete(vo);
    }

    public List<ArquivamentoDoc> findArquivamentoDoc(Long idRegistro, String voClass) {
        String full = UtilServiceClass.getFullPathEntity(voClass);
        return ((DaoArquivamentoDocImpl)this.getDao()).findArquivamentoDoc(idRegistro, voClass, full);
    }

    public DTOGrupoArquivamentoDoc findArquivamentoDocDTO(CapsGeneric<Nodo> caps, Long idRegistro) throws ExceptionBase {
        Nodo n = (Nodo)this.serviceNodoImpl.getOrThrow(caps.get());
        if (!ToolMethods.isStrWithData((String)n.getVoClasses())) {
            throw new ExceptionInvalidData("nodo_sem_entidade", new Object[]{n});
        }
        return this.findArquivamentoDocDTO(idRegistro, n.getVoClasses());
    }

    public DTOGrupoArquivamentoDoc findArquivamentoDocDTO(Long idRegistro, String voClass) throws ExceptionBase {
        Nodo nodo = this.serviceNodoImpl.getNodoByVoClassOrTrhow(voClass);
        DTOGrupoArquivamentoDoc doc = new DTOGrupoArquivamentoDoc();
        doc.setEntidade(voClass);
        doc.setNodo(nodo.getDescricao());
        doc.setNodoIdentificador(nodo.getIdentificador());
        List<ArquivamentoDoc> docs = this.findArquivamentoDoc(idRegistro, voClass);
        List<DTOArquivamentoDoc> dtos = this.buildToDTO(docs, DTOArquivamentoDoc.class);
        doc.setArquivamentos(dtos);
        return doc;
    }

    public File getFileArquivamento(CapsGeneric<ArquivamentoDoc> caps) throws ExceptionBase, XMLStreamException {
        ArquivamentoDoc arquivamento = (ArquivamentoDoc)this.getOrThrow(caps.get());
        List<Long> idItens = arquivamento.getItensDoc().stream().map(i -> i.getIdentificador()).collect(Collectors.toList());
        return this.getFileArquivamentoItens(idItens);
    }

    public File getFileArquivamentoItens(List<Long> idItens) throws ExceptionBase, XMLStreamException {
        List itens = this.serviceArquivamentoDocItensImpl.gets((Long[])idItens.toArray(Long[]::new));
        LinkedList<File> files = new LinkedList<File>();
        for (ArquivamentoDocItens item : itens) {
            File temp = ToolFile.createTempFile((String)item.getNomeArquivo());
            byte[] data = this.serviceArquivamentoDocItensImpl.getFileContentData(item);
            ToolFile.writeBytesOnFile((File)temp, (byte[])data);
            files.add(temp);
        }
        if (files.isEmpty()) {
            throw new ExceptionInvalidData("", new Object[0]);
        }
        if (files.size() == 1) {
            return (File)files.get(0);
        }
        File temp = ToolFile.createTempFile((String)"arquivamento.zip");
        ToolZipUtils.compress((File)temp, files);
        return temp;
    }

    public List<DTOGrupoArquivamentoDoc> findArquivamentoDocDTO(List<DTOGrupoArquivamentoDocRequest> input) throws ExceptionBase {
        LinkedList<DTOGrupoArquivamentoDoc> aux = new LinkedList<DTOGrupoArquivamentoDoc>();
        for (DTOGrupoArquivamentoDocRequest req : input) {
            String entidade = req.getEntidade();
            aux.add(this.findArquivamentoDocDTO(req.getIdEntidade(), entidade));
        }
        return aux;
    }

    public DTOArquivamentoDoc saveItens(Long idArquivamentoDoc, List<DTOArquivamentoItem> input, CapsEmpresa capsEmpresaLogado) throws ExceptionObjNotFound, ExceptionBase, XMLStreamException {
        ArquivamentoDoc arquivamento = (ArquivamentoDoc)this.getOrThrow(idArquivamentoDoc);
        this.serviceArquivamentoDocItensImpl.arquivarItens(arquivamento, input);
        return this.buildToDTO(arquivamento, DTOArquivamentoDoc.class);
    }

    public List<DTOArquivamentoItemDetalhes> atualizarItensArquivos(Long idArquivamentoDoc, List<DTOArquivamentoItemDetalhes> input) throws ExceptionObjNotFound, ExceptionBase, XMLStreamException {
        ArquivamentoDoc arquivamento = (ArquivamentoDoc)this.getOrThrow(idArquivamentoDoc);
        return this.serviceArquivamentoDocItensImpl.atualizarItens(arquivamento, input);
    }

    public DTOArquivamentoDoc saveUpdateArquivamento(DTOArquivamentoDocRes input, CapsEmpresa idEmpresa) throws ExceptionBase, XMLStreamException {
        ArquivamentoDoc arquivamento = (ArquivamentoDoc)this.buildToEntity(input);
        arquivamento = this.saveUpdateArquivamento(arquivamento, idEmpresa);
        return this.buildToDTO(arquivamento, DTOArquivamentoDoc.class);
    }

    public ArquivamentoDoc saveUpdateArquivamento(ArquivamentoDoc arquivamento, CapsEmpresa idEmpresa) throws ExceptionBase, XMLStreamException {
        if (arquivamento.getEmpresa() == null && idEmpresa != null) {
            arquivamento.setEmpresa(this.getSharedData().getEmpresa(idEmpresa.get()));
        }
        arquivamento = this.saveOrUpdateOnly(arquivamento);
        return arquivamento;
    }

    @Override
    public ArquivamentoDoc saveOrUpdateOnly(ArquivamentoDoc entity) {
        if (entity.getDataCadastro() == null) {
            entity.setDataCadastro(new Date());
        }
        if (entity.getTipoArquivamentoDoc() == null) {
            entity.setTipoArquivamentoDoc((TipoArquivamentoDoc)this.serviceTipoArquivamentoDocImpl.getFirst());
        }
        for (ArquivamentoDocItens item : entity.getItensDoc()) {
            item.setArquivamentoDoc(entity);
        }
        this.validArquivaDoc.clearContainer();
        this.validArquivaDoc.isValidData((InterfaceVO)entity);
        if (this.validArquivaDoc.hasErrors()) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.GEN.000028", new String[]{this.validArquivaDoc.getContainer().asString()}));
        }
        return super.saveOrUpdateOnly(entity);
    }

    public ArquivamentoDoc saveUpdateArquivamentoitens(ArquivamentoDoc arquivamento) throws ExceptionBase {
        arquivamento = this.saveOrUpdateOnly(arquivamento);
        this.serviceArquivamentoDocItensImpl.arquivarItens(arquivamento);
        return arquivamento;
    }

    public ArquivamentoDoc saveUpdateArquivamentoitens(String descricao, String voClass, Long idRegistro, Empresa empresa, List<String> chavesArquivosAnexos) throws ExceptionBase {
        ArquivamentoDoc arquivamento = this.helperArquivamento.getNovoArquivamento(descricao, voClass, idRegistro, empresa);
        for (String chave : chavesArquivosAnexos) {
            DTOUploadDownloadFileConfig.DTOItem itemChave = this.serviceFileUploadImpl.getFileData(chave);
            ArquivamentoDocItens item = this.helperArquivamento.getNovoItem(itemChave);
            arquivamento.getItensDoc().add(item);
        }
        return this.saveUpdateArquivamentoitens(arquivamento);
    }
}

