/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.arquivamentodoc;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.ArquivamentoDocItens;
import com.touchcomp.basementorbinary.model.ArquivamentoDadosFile;
import com.touchcomp.basementorbinary.service.impl.arquivamentodadosfile.ServiceBinaryArquivamentoDadosFileImpl;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoArquivamentoDocItensImpl;
import com.touchcomp.basementorservice.helpers.impl.arquivamentodoc.HelperArquivamentoDoc;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileUploadImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.impl.arquivamentodoc.web.ValidArquivaDocItem;
import com.touchcomp.basementorxml.model.ArquivamentoDadosDoc;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLArquivamentoDadosDoc;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoItem;
import com.touchcomp.touchvomodel.vo.arquivamentodoc.web.DTOArquivamentoItemDetalhes;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceArquivamentoDocItensImpl
extends ServiceGenericEntityImpl<ArquivamentoDocItens, Long, DaoArquivamentoDocItensImpl> {
    final ServiceXMLArquivamentoDadosDoc serviceXMLArquivamento;
    final ServiceBinaryArquivamentoDadosFileImpl serviceBinaryArquivamento;
    final ServiceFileUploadImpl serviceFileUploadImpl;
    final ValidArquivaDocItem validArquivaDocItem;
    final HelperArquivamentoDoc helperArquivamentoDoc;

    public ServiceArquivamentoDocItensImpl(ServiceXMLArquivamentoDadosDoc serviceXMLArquivamento, ServiceBinaryArquivamentoDadosFileImpl serviceBinaryArquivamento, ServiceFileUploadImpl serviceFileUploadImpl, ValidArquivaDocItem validArquivaDocItem, DaoArquivamentoDocItensImpl genericDao, HelperArquivamentoDoc helperArquivamentoDoc) {
        super(genericDao);
        this.serviceXMLArquivamento = serviceXMLArquivamento;
        this.serviceBinaryArquivamento = serviceBinaryArquivamento;
        this.serviceFileUploadImpl = serviceFileUploadImpl;
        this.validArquivaDocItem = validArquivaDocItem;
        this.helperArquivamentoDoc = helperArquivamentoDoc;
    }

    public void arquivarItens(ArquivamentoDoc arquivamento, List<DTOArquivamentoItem> itens) throws ExceptionBase {
        for (DTOArquivamentoItem itemDTO : itens) {
            ArquivamentoDocItens item = (ArquivamentoDocItens)this.buildToEntity(itemDTO);
            item = this.saveOrUpdateOnly(item);
            File found = this.serviceFileUploadImpl.getFile(item.getPathArquivo());
            String content = this.processFile(found);
            this.arquivarItem(arquivamento, item, content);
        }
    }

    public void arquivarItens(ArquivamentoDoc arquivamento) throws ExceptionBase {
        for (ArquivamentoDocItens item : arquivamento.getItensDoc()) {
            this.arquivarItem(arquivamento, item);
        }
    }

    public ArquivamentoDocItens arquivarItem(ArquivamentoDoc arquivamento, ArquivamentoDocItens item) throws ExceptionBase {
        DTOUploadDownloadFileConfig.DTOItem found = this.serviceFileUploadImpl.getFileData(item.getPathArquivo());
        return this.arquivarItem(arquivamento, item, found);
    }

    public void arquivarItem(ArquivamentoDoc arq, File f) throws ExceptionBase {
        ArquivamentoDocItens item = this.helperArquivamentoDoc.getNovoItem(f);
        this.arquivarItem(arq, item, f);
    }

    public ArquivamentoDocItens arquivarItem(ArquivamentoDoc arquivamento, ArquivamentoDocItens item, File f) throws ExceptionBase {
        item.setNomeArquivo(ToolFile.removeIlegalChars((String)f.getName()));
        item.setDescricao(ToolFile.removeIlegalChars((String)f.getName()));
        item.setPathArquivo(f.getAbsolutePath());
        item = this.saveOrUpdateOnly(item);
        String content = this.processFile(f);
        this.arquivarItem(arquivamento, item, content);
        return item;
    }

    public ArquivamentoDocItens arquivarItem(ArquivamentoDoc arquivamento, ArquivamentoDocItens item, DTOUploadDownloadFileConfig.DTOItem f) throws ExceptionBase {
        item.setNomeArquivo(f.getFileName());
        item.setDescricao(f.getFileName());
        item = this.saveOrUpdateOnly(item);
        String content = this.processFile(this.serviceFileUploadImpl.getFile(f.getChave()));
        this.arquivarItem(arquivamento, item, content);
        return item;
    }

    ArquivamentoDocItens arquivarItem(ArquivamentoDoc entity, ArquivamentoDocItens arquivamentoDocItens, String fileContent) throws ExceptionInvalidData {
        if (ToolMethods.isEqualsNumber((Number)(arquivamentoDocItens = this.saveOrUpdateOnly(arquivamentoDocItens)).getLocalBDArquivamento(), (Number)0)) {
            this.arquivarBDXML(arquivamentoDocItens, fileContent);
        } else {
            this.arquivarBDBinary(arquivamentoDocItens, fileContent);
        }
        arquivamentoDocItens.setArquivamentoDoc(entity);
        return arquivamentoDocItens;
    }

    private void arquivarBDXML(ArquivamentoDocItens arquivamentoDocItens, String filecontent) {
        ArquivamentoDadosDoc d = (ArquivamentoDadosDoc)this.serviceXMLArquivamento.get((Serializable)arquivamentoDocItens.getIdentificador());
        if (d == null) {
            d = new ArquivamentoDadosDoc();
            d.setIdArquivamentoDoc(arquivamentoDocItens.getIdentificador());
        }
        d.setConteudoArquivo(filecontent);
        this.serviceXMLArquivamento.saveOrUpdate((Object)d);
    }

    private void arquivarBDBinary(ArquivamentoDocItens arquivamentoDocItens, String filecontent) {
        ArquivamentoDadosFile d = this.serviceBinaryArquivamento.getArqDadosDocFileByIdItem(arquivamentoDocItens.getIdentificador());
        if (d == null) {
            d = new ArquivamentoDadosFile();
            d.setIdArquivamentoDocItem(arquivamentoDocItens.getIdentificador());
        }
        d.setConteudoArquivo(filecontent);
        this.serviceBinaryArquivamento.saveOrUpdate((Object)d);
    }

    public boolean deleteItens(List<ArquivamentoDocItens> itens) {
        ServiceXMLArquivamentoDadosDoc service = this.getBean(ServiceXMLArquivamentoDadosDoc.class);
        ServiceArquivamentoDocItensImpl serviceItens = this.getBean(ServiceArquivamentoDocItensImpl.class);
        for (ArquivamentoDocItens it : itens) {
            ArquivamentoDadosDoc filecontent = (ArquivamentoDadosDoc)service.get((Serializable)it.getIdentificador());
            serviceItens.delete(it);
            if (filecontent == null) continue;
            service.delete((Object)filecontent);
        }
        return true;
    }

    public byte[] getFileContentData(ArquivamentoDocItens vo) throws ExceptionDecodeHexString, ExceptionZip {
        String data = this.getFileContent(vo);
        return ToolFile.decodeHexAndDecompress((String)data);
    }

    public String processFile(File vo) throws ExceptionBase {
        if (ToolFile.isImage((File)vo)) {
            vo = this.helperArquivamentoDoc.resizeImage(vo, this.getSharedData().getOpcoesSistema());
        }
        if (!this.helperArquivamentoDoc.acceptFile(vo, this.getSharedData().getOpcoesSistema())) {
            throw new ExceptionInvalidData("E.ERP.2027.001", new Object[]{vo});
        }
        return ToolFile.encodeHexAndCompress((File)vo);
    }

    private String getFileContent(ArquivamentoDocItens vo) {
        if (vo.getLocalBDArquivamento() == null || vo.getLocalBDArquivamento() == 0) {
            ServiceXMLArquivamentoDadosDoc service = this.getBean(ServiceXMLArquivamentoDadosDoc.class);
            ArquivamentoDadosDoc d = (ArquivamentoDadosDoc)service.get((Serializable)vo.getIdentificador());
            return d.getConteudoArquivo();
        }
        ServiceBinaryArquivamentoDadosFileImpl service = this.getBean(ServiceBinaryArquivamentoDadosFileImpl.class);
        ArquivamentoDadosFile d = service.getArqDadosDocFileByIdItem(vo.getIdentificador());
        return d.getConteudoArquivo();
    }

    List<DTOArquivamentoItemDetalhes> atualizarItens(ArquivamentoDoc arquivamento, List<DTOArquivamentoItemDetalhes> itens) {
        LinkedList<DTOArquivamentoItemDetalhes> ret = new LinkedList<DTOArquivamentoItemDetalhes>();
        for (DTOArquivamentoItemDetalhes dto : itens) {
            ArquivamentoDocItens item = (ArquivamentoDocItens)this.buildToEntity(dto);
            item.setArquivamentoDoc(arquivamento);
            item = this.saveOrUpdateOnly(item);
            ret.add(this.buildToDTO(item, DTOArquivamentoItemDetalhes.class));
        }
        return ret;
    }

    @Override
    public ArquivamentoDocItens saveOrUpdateOnly(ArquivamentoDocItens entity) {
        this.validArquivaDocItem.clearContainer();
        this.validArquivaDocItem.isValidData((InterfaceVO)entity);
        if (this.validArquivaDocItem.hasErrors()) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.GEN.000028", new String[]{this.validArquivaDocItem.getContainer().asString()}));
        }
        return super.saveOrUpdateOnly(entity);
    }

    public List<ArquivamentoDocItens> arquivarItensFile(ArquivamentoDoc arq, List<File> toAddArqItens) throws ExceptionBase {
        LinkedList<ArquivamentoDocItens> ret = new LinkedList<ArquivamentoDocItens>();
        for (File file : toAddArqItens) {
            ArquivamentoDocItens item = this.helperArquivamentoDoc.getNovoItem(file);
            this.arquivarItem(arq, item);
        }
        return ret;
    }
}

