/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.baixatitulo;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstFormaPagamentoBaixaTitulo;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompBaixaTituloLancamentoGerenciais
extends ServiceGenericImpl {
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public void gerarLancamentosGerenciais(GrupoDeBaixa grupoDeBaixa) {
        if (this.isNotNull(grupoDeBaixa).booleanValue() && SCompBaixaTituloLancamentoGerenciais.isWithData(grupoDeBaixa.getGrupoDeBaixaFormas())) {
            for (GrupoDeBaixaFormas grupoDeBaixaFormas : grupoDeBaixa.getGrupoDeBaixaFormas()) {
                if (!this.isNotNull(grupoDeBaixaFormas.getFormaPagamento()).booleanValue() || this.isEquals(grupoDeBaixaFormas.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CARTAO_DEBITO) || this.isEquals(grupoDeBaixaFormas.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.CARTAO_CREDITO) || this.isEquals(grupoDeBaixaFormas.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.FALTA_PAGAMENTO) || this.isEquals(grupoDeBaixaFormas.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.ANTECIPADO) || this.isEquals(grupoDeBaixaFormas.getFormaPagamento(), EnumConstFormaPagamentoBaixaTitulo.TITULO_ANTECIPADO)) continue;
                this.valoresLancamentosGerenciaisLiquidacao(grupoDeBaixaFormas);
            }
        }
    }

    void valoresLancamentosGerenciaisLiquidacao(GrupoDeBaixaFormas grupoDeBaixaFormas) {
        for (BaixaTitulo baixaTitulo : grupoDeBaixaFormas.getBaixaTitulo()) {
            if (this.isEquals(baixaTitulo.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca(), EnumConstSituacaoCobranca.DESCONTADA.getEnumId())) continue;
            this.valoresLancamentosGerenciaisLiquidacao(baixaTitulo, grupoDeBaixaFormas);
        }
    }

    void valoresLancamentosGerenciaisLiquidacao(BaixaTitulo baixaTitulo, GrupoDeBaixaFormas grupoDeBaixaFormas) {
        if (this.isEquals(baixaTitulo.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca(), EnumConstSituacaoCobranca.DESCONTADA.getEnumId())) {
            return;
        }
        ArrayList<LancamentoCtbGerencial> listLancamentoCtbGerencial = new ArrayList<LancamentoCtbGerencial>();
        Double percentual = baixaTitulo.getValor() / baixaTitulo.getTitulo().getValor();
        for (LancamentoCtbGerencial lancamentoCtbGerencialTitulo : baixaTitulo.getTitulo().getLancCtbGerencial()) {
            Double valor = ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() * percentual), (int)2);
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, lancamentoCtbGerencialTitulo.getDebCred(), lancamentoCtbGerencialTitulo, lancamentoCtbGerencialTitulo.getHistorico(), lancamentoCtbGerencialTitulo.getPlanoContaGerencial(), lancamentoCtbGerencialTitulo.getProvRealizado(), EnumTipoLancamentoCTBGerencial.LIQUIDACAO, valor);
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.001", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialJuros(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrJuros()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.002", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialDesc(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrDesconto()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.003", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialAbatimento(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrAbatimento()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.004", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialAtualMonRecebida(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrAtualizacaoMonetariaRecebida()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.005", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialAtualMonPaga(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrAtualizacaoMonetariaPaga()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.006", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialDespBancPag(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrDespBancariaPaga()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.007", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialTaxaCartao(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrTaxaCartao()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.006", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialDespBancRec(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrDespBancariaRecebida()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.008", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialIofPag(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrIOFPago()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.008", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialIofRec(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrIOFRecebido()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.009", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialMulta(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrMulta()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.010", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialPis(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrPis()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.011", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialCofins(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrConfins()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.012", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialContrSoc(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrContribSocial()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.013", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialCartorioPag(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrDespesaCartorioPaga()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.014", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialCartorioRec(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrDespesaCartorioRecebida()), (int)2));
            this.criarLancamentoGer(listLancamentoCtbGerencial, grupoDeBaixaFormas, this.isEquals(grupoDeBaixaFormas.getGrupoDeBaixa().getPagRec(), EnumConstTituloPagRec.TIPO_TITULO_PAG) ? EnumLancamentoCTBGerencial.DEBITO.getEnumId() : EnumLancamentoCTBGerencial.CREDITO.getEnumId(), lancamentoCtbGerencialTitulo, MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0318.015", (Object[])new Object[]{baixaTitulo.getTitulo().getIdentificador()}), baixaTitulo.getContasBaixa().getPlanoContaGerencialIR(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getEnumId(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, ToolFormatter.arrredondarNumero((Double)(lancamentoCtbGerencialTitulo.getValor() / baixaTitulo.getValor() * baixaTitulo.getVrIR()), (int)2));
        }
        this.assertarDiferencas(listLancamentoCtbGerencial, baixaTitulo);
        baixaTitulo.setLancCTbGerencialLiquidacao(listLancamentoCtbGerencial);
    }

    void criarLancamentoGer(List<LancamentoCtbGerencial> listLancamentoCtbGerencial, GrupoDeBaixaFormas grupoDeBaixaFormas, Short debitoCredito, LancamentoCtbGerencial lancamentoCtbGerencialTitulo, String historico, PlanoContaGerencial planoContaGerencial, Short provisaoRealizado, EnumTipoLancamentoCTBGerencial tipoLancamento, Double valor) {
        if (!SCompBaixaTituloLancamentoGerenciais.isWithData(valor)) {
            return;
        }
        LancamentoCtbGerencial lancamentoCtbGerencial = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, grupoDeBaixaFormas.getGrupoDeBaixa().getDataLiquidacao(), grupoDeBaixaFormas.getGrupoDeBaixa().getDataLiquidacao(), debitoCredito, lancamentoCtbGerencialTitulo.getEmpresa(), lancamentoCtbGerencialTitulo.getGerado(), historico, planoContaGerencial, provisaoRealizado, tipoLancamento.getEnumId(), lancamentoCtbGerencialTitulo.getCentroCusto(), valor, null);
        listLancamentoCtbGerencial.add(lancamentoCtbGerencial);
    }

    void assertarDiferencas(List<LancamentoCtbGerencial> listLancamentoCtbGerencial, BaixaTitulo baixaTitulo) {
        Double valorCredito = 0.0;
        Double valorDebito = 0.0;
        for (LancamentoCtbGerencial lanc : listLancamentoCtbGerencial) {
            if (this.isEquals(lanc.getDebCred(), EnumLancamentoCTBGerencial.CREDITO.getEnumId())) {
                valorCredito = valorCredito + lanc.getValor();
                continue;
            }
            valorDebito = valorDebito + lanc.getValor();
        }
        Double valorTotal = Math.abs(valorCredito - valorDebito);
        listLancamentoCtbGerencial.getLast().setValor(Double.valueOf(listLancamentoCtbGerencial.getLast().getValor() + (baixaTitulo.getTotalOperacao() - valorTotal)));
    }
}

