/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.baixatitulo;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoDeBaixasImpl;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoBaixaTituloImpl
extends ServiceGenericEntityImpl<GrupoDeBaixa, Long, DaoGrupoDeBaixasImpl> {
    private ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl;
    private HelperBaixaTitulos helperBaixaTitulos;

    @Autowired
    public ServiceGrupoBaixaTituloImpl(DaoGrupoDeBaixasImpl genericDao, ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl, HelperBaixaTitulos baixaTitulos) {
        super(genericDao);
        this.serviceOpcoesContabeisBaixaTitulosImpl = serviceOpcoesContabeisBaixaTitulosImpl;
        this.helperBaixaTitulos = baixaTitulos;
    }

    public Boolean updateContasBaixasPorIntervaloDeDatas(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, OpcoesGerenciais opGer) {
        List<GrupoDeBaixa> list = ((DaoGrupoDeBaixasImpl)this.getDao()).findBaixasByGrupoEmpresa(dataInicial, dataFinal, grupoEmpresa.getIdentificador());
        if (this.isNull(list).booleanValue() || list.isEmpty()) {
            return false;
        }
        for (GrupoDeBaixa g : list) {
            this.updateContasBaixas(g, opGer);
        }
        return true;
    }

    public GrupoDeBaixa updateContasBaixas(GrupoDeBaixa gb, OpcoesGerenciais opGer) {
        if (this.isNull(gb).booleanValue()) {
            return null;
        }
        for (GrupoDeBaixaFormas g : gb.getGrupoDeBaixaFormas()) {
            for (BaixaTitulo bt : g.getBaixaTitulo()) {
                OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.getOpcoesContabeisByBaixa(bt, bt.getTitulo().getEmpresa());
                this.helperBaixaTitulos.build(bt);
                this.helperBaixaTitulos.updateContaBaixa(opcoesContabeisBaixaTitulos, opGer);
            }
        }
        gb = ((DaoGrupoDeBaixasImpl)this.getDao()).saveOrUpdate(gb);
        return gb;
    }

    public BorderoTitulos pesquisarBaixaTitulosPorTitulo(Titulo titulo) {
        return ((DaoGrupoDeBaixasImpl)this.getDao()).pesquisarBaixaTitulosPorTitulo(titulo);
    }
}

