/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.bloqueiolancamentocontabil;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabil;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabilEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoBloqueioLancamentoContabilImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroresultadocontfin.ServiceCentroResultadoContFinImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.touchvomodel.vo.bloqueiolancamentocontabilempresa.web.DTOBloqueioLancamentoContabilEmpresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBloqueioLancamentoContabilImpl
extends ServiceGenericEntityImpl<BloqueioLancamentoContabil, Long, DaoBloqueioLancamentoContabilImpl> {
    @Autowired
    ServiceCentroResultadoContFinImpl serviceCentroResultadoContFinImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    ServiceGrupoEmpresaImpl serviceGrupoEmpresaImpl;

    @Autowired
    public ServiceBloqueioLancamentoContabilImpl(DaoBloqueioLancamentoContabilImpl genericDao) {
        super(genericDao);
    }

    public BloqueioLancamentoContabil getVerificarExisteBloqueioNasDatas(Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoBloqueioLancamentoContabilImpl)this.getGenericDao()).getVerificarExisteBloqueioNasDatas(dataFinal, grupoEmpresa);
    }

    public List<BloqueioLancamentoContabilEmpresa> getGrupoEmpesa(List<Empresa> empresas) {
        ArrayList<BloqueioLancamentoContabilEmpresa> bloqueioLancamentoContabilEmpresa = new ArrayList<BloqueioLancamentoContabilEmpresa>();
        for (Empresa a : empresas) {
            BloqueioLancamentoContabilEmpresa b = new BloqueioLancamentoContabilEmpresa();
            b.setCentroResultadoContFin(a.getEmpresaDados().getCentroResultadoContFin());
            bloqueioLancamentoContabilEmpresa.add(b);
        }
        return bloqueioLancamentoContabilEmpresa;
    }

    public BloqueioLancamentoContabilEmpresa getGrupoEmpresaIndividual(Empresa empresa) {
        BloqueioLancamentoContabilEmpresa bloqueioLancamentoContabilEmpresa = new BloqueioLancamentoContabilEmpresa();
        bloqueioLancamentoContabilEmpresa.setCentroResultadoContFin(empresa.getEmpresaDados().getCentroResultadoContFin());
        return bloqueioLancamentoContabilEmpresa;
    }

    public List<BloqueioLancamentoContabil> verificarBloqueioLancamento(Date dataLote, GrupoEmpresa grupoEmpresa) {
        return ((DaoBloqueioLancamentoContabilImpl)this.getGenericDao()).verificarBloqueioLancamento(dataLote, grupoEmpresa);
    }

    @Override
    public BloqueioLancamentoContabil beforeSave(BloqueioLancamentoContabil aux) {
        aux.getBloqueioLancamentoContabilEmpresa().forEach(i -> i.setBloqueio(aux));
        return aux;
    }

    public List<DTOBloqueioLancamentoContabilEmpresa> getGrupoEmpesa(CapsEmpresa capsEmpresa) throws ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        List<Empresa> empresas = this.serviceGrupoEmpresaImpl.importarEmpresasGrupo(empresa.getEmpresaDados().getGrupoEmpresa());
        List bloqueioLancamentoContabilEmpresa = empresas.stream().map(i -> {
            BloqueioLancamentoContabilEmpresa item = new BloqueioLancamentoContabilEmpresa();
            item.setCentroResultadoContFin(i.getEmpresaDados().getCentroResultadoContFin());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(bloqueioLancamentoContabilEmpresa, DTOBloqueioLancamentoContabilEmpresa.class);
    }

    public DTOBloqueioLancamentoContabilEmpresa getGrupoEmpresaIndividual(Long idEmpresa) throws ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(idEmpresa);
        BloqueioLancamentoContabilEmpresa bloqueioLancamentoContabilEmpresa = new BloqueioLancamentoContabilEmpresa();
        bloqueioLancamentoContabilEmpresa.setCentroResultadoContFin(empresa.getEmpresaDados().getCentroResultadoContFin());
        return this.buildToDTOGeneric(bloqueioLancamentoContabilEmpresa, DTOBloqueioLancamentoContabilEmpresa.class);
    }

    public List<DTOBloqueioLancamentoContabilEmpresa> getCarregarCentroResultado(Long[] ids) {
        List listCentroResultadoContFin = this.serviceCentroResultadoContFinImpl.gets(ids);
        List bloqueioLancamentoContabilEmpresa = listCentroResultadoContFin.stream().map(i -> {
            BloqueioLancamentoContabilEmpresa item = new BloqueioLancamentoContabilEmpresa();
            item.setCentroResultadoContFin(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(bloqueioLancamentoContabilEmpresa, DTOBloqueioLancamentoContabilEmpresa.class);
    }
}

