/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.bloqueiolancamentogerencial;

import com.touchcomp.basementor.model.vo.BloqueioLancamentoGerencial;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoGerencialEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.impl.DaoBloqueioLancamentoGerencialImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBloqueioLancamentoGerencialImpl
extends ServiceGenericEntityImpl<BloqueioLancamentoGerencial, Long, DaoBloqueioLancamentoGerencialImpl> {
    private ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    private ServiceEmpresaImpl serviceEmpresa;

    @Autowired
    public ServiceBloqueioLancamentoGerencialImpl(DaoBloqueioLancamentoGerencialImpl genericDao, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceEmpresaImpl serviceEmpresa) {
        super(genericDao);
        this.serviceGrupoEmpresa = serviceGrupoEmpresa;
        this.serviceEmpresa = serviceEmpresa;
    }

    @Override
    public BloqueioLancamentoGerencial beforeSave(BloqueioLancamentoGerencial vo) {
        if (vo.getEmpresas() != null) {
            vo.getEmpresas().forEach(i -> i.setBloqueioLancamentoGerencial(vo));
        }
        return vo;
    }

    public List<BloqueioLancamentoGerencialEmpresa> getEmpresasFromGrupo(GrupoEmpresa grupo) {
        ArrayList<BloqueioLancamentoGerencialEmpresa> ret = new ArrayList<BloqueioLancamentoGerencialEmpresa>();
        List<Empresa> empresas = this.serviceGrupoEmpresa.importarEmpresasGrupo(grupo);
        if (empresas != null) {
            for (Empresa e : empresas) {
                ret.add(this.getBloqueioLancamentoGerencialEmpresa(e));
            }
        }
        return ret;
    }

    private BloqueioLancamentoGerencialEmpresa getBloqueioLancamentoGerencialEmpresa(Empresa e) {
        BloqueioLancamentoGerencialEmpresa vo = new BloqueioLancamentoGerencialEmpresa();
        vo.setEmpresa(e);
        return vo;
    }

    public List<BloqueioLancamentoGerencialEmpresa> getEmpresas(Long[] identificadores) {
        List empresas = this.serviceEmpresa.gets(identificadores);
        ArrayList<BloqueioLancamentoGerencialEmpresa> ret = new ArrayList<BloqueioLancamentoGerencialEmpresa>();
        for (Empresa e : empresas) {
            ret.add(this.getBloqueioLancamentoGerencialEmpresa(e));
        }
        return ret;
    }
}

