/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.bloqueiomovimentobancario;

import com.touchcomp.basementor.model.vo.BloqueioMovimentoBancario;
import com.touchcomp.basementor.model.vo.BloqueioMovimentoBancarioConta;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorservice.dao.impl.DaoBloqueioMovimentoBancarioImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBloqueioMovimentoBancarioImpl
extends ServiceGenericEntityImpl<BloqueioMovimentoBancario, Long, DaoBloqueioMovimentoBancarioImpl> {
    @Autowired
    private ServiceContaValoresImpl serviceContaValores;

    @Autowired
    public ServiceBloqueioMovimentoBancarioImpl(DaoBloqueioMovimentoBancarioImpl genericDao) {
        super(genericDao);
    }

    @Override
    public BloqueioMovimentoBancario beforeSave(BloqueioMovimentoBancario aux) {
        aux.getContasValores().forEach(conta -> conta.setBloqueioMovBancario(aux));
        return aux;
    }

    public List<BloqueioMovimentoBancarioConta> getContasBloqueio(Long[] contas) {
        ArrayList<BloqueioMovimentoBancarioConta> result = new ArrayList<BloqueioMovimentoBancarioConta>();
        List listContas = this.serviceContaValores.gets(contas);
        for (ContaValores vo : listContas) {
            BloqueioMovimentoBancarioConta bc = new BloqueioMovimentoBancarioConta();
            bc.setContaValores(vo);
            result.add(bc);
        }
        return result;
    }

    public BloqueioMovimentoBancario criarBloqueio(ContaValores contaValores, Date dataIn, Date dataFim) {
        BloqueioMovimentoBancario b = new BloqueioMovimentoBancario();
        b.setDataFinal(dataFim);
        b.setEmpresa(contaValores.getAgenciaValor().getEmpresa());
        BloqueioMovimentoBancarioConta bm = new BloqueioMovimentoBancarioConta();
        bm.setBloqueioMovBancario(b);
        bm.setContaValores(contaValores);
        b.getContasValores().add(bm);
        return this.saveOrUpdate(b);
    }
}

