/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.boletotitulo;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.dao.impl.DaoBoletoTituloImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ResultProcessGerBol;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBIUser;
import com.touchcomp.basementorservice.service.interfaces.ServiceBoletoTitulo;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.jboleto.JBoleto;
import org.jboleto.JBoletoBean;
import org.jboleto.control.Generator;
import org.jboleto.control.JasperGenerator;
import org.jboleto.exceptions.BoletoException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBoletoTituloImpl
extends ServiceGenericEntityImpl<BoletoTitulo, Long, DaoBoletoTituloImpl>
implements ServiceBoletoTitulo {
    private JBoletoBean jBoletoBean;
    private File tmp;
    private Generator generator = null;
    private JBoleto jBoleto = null;
    private static final TLogger logger = TLogger.get(ServiceBoletoTituloImpl.class);

    @Autowired
    public ServiceBoletoTituloImpl(DaoBoletoTituloImpl genericDao) {
        super(genericDao);
        try {
            this.tmp = File.createTempFile("boleto", ".pdf");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
        }
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, OpcoesFinanceiras opFin, boolean gerarPDF, Usuario usuario, Grupo grupoUsuario, Empresa empresa) throws ExceptionGeracaoBoletos, ExceptionGeracaoTitulos {
        ResultProcessGerBol res = new ResultProcessGerBol();
        Iterator<Titulo> iterator = titulos.iterator();
        while (iterator.hasNext()) {
            Titulo titulo;
            Titulo titulo2 = titulo = iterator.next();
            this.gerarBoletoTitulo(titulo2, res);
        }
        LinkedList<Object> aux = new LinkedList<BoletoTitulo>();
        for (BoletoTitulo boletoTitulo : res.getBoletos()) {
            aux.add(((DaoBoletoTituloImpl)this.getGenericDao()).saveOrUpdate(boletoTitulo));
            ((DaoBoletoTituloImpl)this.getGenericDao()).getSession().flush();
        }
        res.setBoletos(aux);
        Short s = opFin.getTipoNumeroTitulo();
        aux = new LinkedList();
        for (BoletoTitulo boleto : res.getBoletos()) {
            String str = this.getCodigoBarras(boleto, s);
            boleto.setCodigoBarras(str);
            aux.add(this.saveOrUpdate(boleto));
        }
        res.setBoletos(aux);
        if (gerarPDF && aux.size() > 0) {
            List<DataOutputBI> list = this.gerarBoletoTitulo(aux, usuario, grupoUsuario, empresa, s);
            res.setDataOutput(list);
        }
        return res;
    }

    public BoletoTitulo verificarBoletoTituloAtivo(Titulo t) {
        BoletoTitulo boleto = null;
        if (t.getBoletoTitulo() != null) {
            for (BoletoTitulo bo : t.getBoletoTitulo()) {
                if (bo.getAtivo() != 1) continue;
                boleto = bo;
            }
        }
        return boleto;
    }

    public String getCodigoBarras(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos {
        this.createJBoletoBean(b, tipoNumero);
        Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
        new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto);
        return this.getjBoletoBean().getCodigoBarras();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createJBoletoBean(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos {
        if (b == null) throw new ExceptionGeracaoTitulos("O t\u00c3\u00adtulo " + b.getTitulo().getIdentificador() + " n\u00c3\u00a3o est\u00c3\u00a1 inclu\u00c3\u00addo em uma Carteira de Cobran\u00c3\u00a7a, por isso n\u00c3\u00a3o foi poss\u00c3\u00advel gerar o boleto.");
        this.setjBoletoBean(new JBoletoBean());
        this.getjBoletoBean().setDataDocumento(ToolDate.dateToStr((Date)b.getTitulo().getDataEmissao()));
        this.getjBoletoBean().setDataProcessamento(ToolDate.dateToStr((Date)b.getDataCadastro()));
        this.getjBoletoBean().setCedente(b.getTitulo().getEmpresa().getPessoa().getNome());
        this.getjBoletoBean().setCpfCedente(ToolFormatter.formatCNPJCPF((String)b.getTitulo().getEmpresa().getPessoa().getComplemento().getCnpj()));
        this.getjBoletoBean().setEnderecoCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getLogradouro());
        this.getjBoletoBean().setNumeroCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getNumero());
        this.getjBoletoBean().setBairroCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getBairro());
        this.getjBoletoBean().setCidadeCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        this.getjBoletoBean().setUfCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        this.getjBoletoBean().setCepCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCep());
        this.getjBoletoBean().setNomeSacado(b.getTitulo().getPessoa().getNome());
        Endereco endereco = null;
        endereco = b.getTitulo().getPessoa().getEnderecoCobranca() != null ? b.getTitulo().getPessoa().getEnderecoCobranca() : (b.getTitulo().getInfPagamentoNfPropria() != null ? b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco() : (b.getTitulo().getRps() != null ? b.getTitulo().getRps().getUnidadeTomPrestRPS().getEndereco() : b.getTitulo().getPessoa().getEndereco()));
        if (endereco == null) {
            throw new ExceptionGeracaoTitulos("Erro ao gerar Boleto. A pessoa " + b.getTitulo().getPessoa().getNome().toUpperCase() + " esta sem Endere\u00c3\u00a7o!");
        }
        this.getjBoletoBean().setEnderecoSacado(endereco.getLogradouro() + ", " + endereco.getNumero() + " - " + endereco.getComplemento());
        this.getjBoletoBean().setBairroSacado(endereco.getBairro());
        this.getjBoletoBean().setCidadeSacado(endereco.getCidade().getDescricao());
        this.getjBoletoBean().setUfSacado(endereco.getCidade().getUf().getSigla());
        this.getjBoletoBean().setCepSacado(endereco.getCep());
        this.getjBoletoBean().setNumeroSacado(endereco.getNumero());
        if (b.getCarteiraCobranca().getContaValor().getOperacao() != null) {
            this.getjBoletoBean().setCodigoOperacao(b.getCarteiraCobranca().getContaValor().getOperacao());
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("104")) {
            throw new ExceptionGeracaoTitulos("Para a Institui\u00c3\u00a7\u00c3\u00a3o Financeira " + b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNomeBanco() + " \u00c3\u00a9 necess\u00c3\u00a1rio informar o N\u00c2\u00ba Raz\u00c3\u00a3o da Conta Banc\u00c3\u00a1ria no cadastro da Conta Valor");
        }
        if (!b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("756")) {
            if (b.getCarteiraCobranca().getContaValor().getNumeroConvenio() == null || b.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) throw new ExceptionGeracaoTitulos("Informe o numero do convenio no cadastro da Carteira");
            this.getjBoletoBean().setCodigoFornecidoAgencia(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
        } else {
            this.getjBoletoBean().setCodigoFornecidoAgencia(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
        }
        this.getjBoletoBean().setCpfSacado(ToolFormatter.formatCNPJCPF((String)b.getTitulo().getPessoa().getComplemento().getCnpj()));
        this.getjBoletoBean().setImagemMarketing(this.getImageBoleto(b.getTitulo().getEmpresa()));
        this.getjBoletoBean().setDataVencimento(ToolDate.dateToStr((Date)b.getDataVencimento(), (String)"dd/MM/yyyy"));
        this.getjBoletoBean().setInstrucao1(this.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto1(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao2(this.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto2(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao3(this.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto3(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao4(this.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto4(), b.getTitulo()));
        if (b.getCarteiraCobranca().getCodigoCarteira() == null) {
            throw new ExceptionGeracaoTitulos("C\u00c3\u00b3digo da Carteira n\u00c3\u00a3o informado no cadastro da Carteira de Cobran\u00c3\u00a7a.");
        }
        if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new ExceptionGeracaoTitulos("N\u00c3\u00bamero da Ag\u00c3\u00aancia n\u00c3\u00a3o informado no cadastro da Institui\u00c3\u00a7\u00c3\u00a3o Financeira.");
        }
        if (b.getCarteiraCobranca().getContaValor().getNrConta() == null) {
            throw new ExceptionGeracaoTitulos("N\u00c3\u00bamero da Conta n\u00c3\u00a3o informado no cadastro da Institui\u00c3\u00a7\u00c3\u00a3o Financeira.");
        }
        if (b == null || b.getNumeroTituloInst().equals(null)) {
            throw new ExceptionGeracaoTitulos("N\u00c3\u00bamero do T\u00c3\u00adtulo n\u00c3\u00a3o foi gerado, verifique o cadastro da Carteira de Cobran\u00c3\u00a7a.");
        }
        this.getjBoletoBean().setAceite("N");
        this.getjBoletoBean().setCarteira(b.getCarteiraCobranca().getCodigoCarteira());
        this.getjBoletoBean().setLocalPagamento(b.getCarteiraCobranca().getLocalPagamento());
        this.getjBoletoBean().setAgencia(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia()));
        this.getjBoletoBean().setDvAgencia(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia()));
        this.getjBoletoBean().setContaCorrente(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getNrConta()));
        this.getjBoletoBean().setDvContaCorrente(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getDvConta()));
        this.getjBoletoBean().setEspecieDocumento("OU");
        this.getjBoletoBean().setCodCliente(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getNrCliente()));
        this.getjBoletoBean().setNumConvenio(ToolString.refina((String)b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
        if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("041")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("001")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 17);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("237")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 11);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("104")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("399")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("341")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("389")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("999")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("033")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 12);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("756")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("409")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("422")) {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        } else {
            this.getjBoletoBean().setNossoNumero(ToolString.refina((String)b.getNumeroTituloInst().toString()), 8);
        }
        if (tipoNumero != null && tipoNumero == 1) {
            if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString()));
            } else if (b.getTitulo().getFaturaCte() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getFaturaCte().getIdentificador().toString()));
            } else if (b.getTitulo().getRps() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getRps().getNumero().toString()));
            } else if (b.getTitulo().getOrdemCompra() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getOrdemCompra().getIdentificador().toString()));
            } else if (b.getTitulo().getInfPagamentoPedido() != null && b.getTitulo().getInfPagamentoPedido().getPedido() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getInfPagamentoPedido().getPedido().getIdentificador().toString()));
            } else if (b.getTitulo().getPedidoComercio() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getPedidoComercio().getIdentificador().toString()));
            } else if (b.getTitulo().getAdiantamentoViagem() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getAdiantamentoViagem().getIdentificador().toString()));
            } else if (b.getTitulo().getNotaContratoLocacao() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getNotaContratoLocacao().getNumero().toString()));
            } else if (b.getTitulo().getContratoLocacao() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getContratoLocacao().getNumeroContrato().toString()));
            } else if (b.getTitulo().getApuracaoLocacaoContrato() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getApuracaoLocacaoContrato().getIdentificador().toString()));
            } else if (b.getTitulo().getCte() != null) {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getCte().getNumero().toString()));
            } else {
                this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getIdentificador().toString()));
            }
        } else {
            this.getjBoletoBean().setNoDocumento(ToolString.refina((String)b.getTitulo().getIdentificador().toString()));
        }
        if (b.getInformarValorManual() == null || b.getInformarValorManual() != 1) {
            Double valorTituloTotal = ToolFormatter.arrredondarNumero((Double)b.getValorBoleto(), (int)2);
            this.getjBoletoBean().setValorBoleto(valorTituloTotal.toString());
            Double juros = ToolFormatter.arrredondarNumero((Double)(b.getValorJuros() + b.getValorMulta()), (int)2);
            this.getjBoletoBean().setValorJuros(juros.toString());
            Double valorCobrado = ToolFormatter.arrredondarNumero((Double)b.getValorTotal(), (int)2);
            this.getjBoletoBean().setValorCobrado(valorCobrado.toString());
            Double valorDescontos = ToolFormatter.arrredondarNumero((Double)b.getValorDesconto(), (int)2);
            this.getjBoletoBean().setValorDescontos(valorDescontos.toString());
        } else {
            Double valorTituloTotal = ToolFormatter.arrredondarNumero((Double)b.getValorBase(), (int)2);
            this.getjBoletoBean().setValorBoleto(valorTituloTotal.toString());
            this.getjBoletoBean().setValorCobrado(valorTituloTotal.toString());
        }
        this.getjBoletoBean().setNrBanco(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco());
        if (b.getTitulo().getNumParcTituloEstnota() == null) {
            this.getjBoletoBean().setNumeroParcela(ToolString.refina((String)"1"));
        } else {
            this.getjBoletoBean().setNumeroParcela(ToolString.refina((String)b.getTitulo().getNumParcTituloEstnota().toString()));
        }
        if (b.getCarteiraCobranca().getSituacaoCobranca() == null || b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao() == null || b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao().isEmpty()) {
            throw new ExceptionGeracaoTitulos("Primeiro informe o Codigo Situa\u00c3\u00a7\u00c3\u00a3o na Situa\u00c3\u00a7\u00c3\u00a3o Cobran\u00c3\u00a7a que esta vinculada na Carteira Financeira!");
        }
        this.getjBoletoBean().setModalidadeCobranca(ToolString.refina((String)b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao()));
        this.getjBoletoBean().getCodigoBarras();
    }

    public void gerarBoleto(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos {
        try {
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)new JasperGenerator());
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00c3\u00b3digo de barras errado. Quantidade \u00c3\u00admpar de d\u00c3\u00adgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00c3\u00a7a.");
            }
            this.getjBoleto().addBoleto();
            this.getjBoleto().closeBoleto(this.getTmp().getAbsolutePath());
        }
        catch (BoletoException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.", (Throwable)ex);
        }
    }

    public JasperPrint getJasperPrint(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos {
        try {
            JasperGenerator jp = new JasperGenerator();
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)jp);
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00c3\u00b3digo de barras errado. Quantidade \u00c3\u00admpar de d\u00c3\u00adgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00c3\u00a7a.");
            }
            this.getjBoleto().addBoleto();
            return null;
        }
        catch (BoletoException ex) {
            ex.printStackTrace();
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.", (Throwable)ex);
        }
    }

    public JBoletoBean getjBoletoBean() {
        return this.jBoletoBean;
    }

    public void setjBoletoBean(JBoletoBean jBoletoBean) {
        this.jBoletoBean = jBoletoBean;
    }

    public File getTmp() {
        return this.tmp;
    }

    public void setTmp(File tmp) {
        this.tmp = tmp;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public JBoleto getjBoleto() {
        return this.jBoleto;
    }

    public void setjBoleto(JBoleto jBoleto) {
        this.jBoleto = jBoleto;
    }

    public static String getFixedValue(String chave, Titulo titulo) {
        if (chave.equalsIgnoreCase("dataVencimentoTitulo")) {
            return ToolDate.dateToStr((Date)titulo.getDataVencimento());
        }
        if (chave.equalsIgnoreCase("vlrJuros")) {
            return ToolFormatter.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        }
        if (chave.equalsIgnoreCase("vlrMulta")) {
            return ToolFormatter.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        }
        if (chave.equalsIgnoreCase("numero rps") && titulo.getRps() != null && titulo.getRps().getNumeroNFse() != null) {
            return titulo.getRps().getNumeroNFse().toString();
        }
        if (chave.equalsIgnoreCase("nrParcela") && titulo.getNumParcTituloEstnota() != null) {
            return titulo.getNumParcTituloEstnota().toString();
        }
        if (chave.equalsIgnoreCase("nrParcelas") && titulo.getNumeroParcelas() != null) {
            return titulo.getNumeroParcelas().toString();
        }
        if (chave.equalsIgnoreCase("centroCusto") && titulo.getLancCtbGerencial() != null) {
            return ServiceBoletoTituloImpl.getCentroCustoLancGerencial(titulo.getLancCtbGerencial());
        }
        if (chave.equalsIgnoreCase("planoGerencial") && titulo.getLancCtbGerencial() != null) {
            return ServiceBoletoTituloImpl.getPlanoGerencialLancGerencial(titulo.getLancCtbGerencial());
        }
        if (chave.equalsIgnoreCase("observacao") && titulo.getObservacao() != null && !titulo.getObservacao().isEmpty()) {
            return titulo.getObservacao();
        }
        if (chave.equalsIgnoreCase("vlrDesconto")) {
            return ToolFormatter.formataNumero((Number)titulo.getDescontoFinanceiro(), (int)2);
        }
        if (chave.equalsIgnoreCase("dataLimiteDesconto")) {
            return ToolDate.dateToStr((Date)titulo.getDataLimiteDesconto());
        }
        return "";
    }

    public JBoletoBean gerarBoletoBI(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos {
        if (b.getAtivo() == 0) {
            throw new ExceptionGeracaoTitulos("Boleto inativo: " + b.getNumeroTituloInst());
        }
        if (b.getTitulo() == null) {
            throw new ExceptionGeracaoTitulos("Boleto sem titulo vinculado(Possivel exclus\u00c3\u00a3o do titulo): " + b.getNumeroTituloInst());
        }
        try {
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)new JasperGenerator());
            String codBancoEmissaoBoletoStr = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco() : b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco();
            Integer codBancoEmissaoBoleto = Integer.valueOf(codBancoEmissaoBoletoStr);
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00c3\u00b3digo de barras errado. Quantidade \u00c3\u00admpar de d\u00c3\u00adgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00c3\u00a7a.");
            }
            this.getjBoleto().addBoleto();
            return this.getjBoletoBean();
        }
        catch (BoletoException ex) {
            ex.printStackTrace();
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.\n" + ex.getMessage(), (Throwable)ex);
        }
    }

    private String getImageBoleto(Empresa empresa) {
        try {
            byte[] img = ServiceBoletoTituloImpl.getBytesImageBoleto(empresa);
            if (img != null) {
                File tmp = File.createTempFile("logo", "png", new File(System.getProperty("java.io.tmpdir")));
                FileOutputStream f = null;
                f = new FileOutputStream(tmp);
                f.write(img);
                f.flush();
                f.close();
                return tmp.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.error(ex.getClass(), (Throwable)ex);
        }
        return null;
    }

    private static byte[] getBytesImageBoleto(Empresa empresa) {
        byte[] img = null;
        img = empresa.getEmpresaDados().getLogoBoleto() != null ? empresa.getEmpresaDados().getLogoBoleto() : empresa.getEmpresaDados().getLogoRelatorios();
        return img;
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, CarteiraCobranca carteiraDestino, OpcoesFinanceiras opFin, Usuario usuario, Grupo grupoUsuario, Empresa empresa) throws ExceptionGeracaoBoletos, ExceptionGeracaoTitulos {
        for (Titulo titulo : titulos) {
            titulo.setCartCobrancaDestino(carteiraDestino);
        }
        return this.converterSalvarEGerarBoletoTitulo(titulos, opFin, usuario, grupoUsuario, empresa);
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, OpcoesFinanceiras opFin, Usuario usuario, Grupo grupoUsuario, Empresa empresa) throws ExceptionGeracaoBoletos, ExceptionGeracaoTitulos {
        return this.converterSalvarEGerarBoletoTitulo(titulos, opFin, true, usuario, grupoUsuario, empresa);
    }

    public BoletoTitulo gerarCopiaBoletoTitulo(BoletoTitulo oldBoleto, BoletoTitulo newBoleto, OpcoesFinanceiras opFin) throws ExceptionGeracaoTitulos {
        try {
            newBoleto = this.saveOrUpdate(newBoleto);
            this.addLogBoletoGeradoEmRelacaoAoAnterior(newBoleto);
            Short tipoNumero = opFin.getTipoNumeroTitulo();
            String str = this.getCodigoBarras(newBoleto, tipoNumero);
            newBoleto.setCodigoBarras(str);
            newBoleto = this.saveOrUpdate(newBoleto);
            return newBoleto;
        }
        catch (ExceptionGeracaoTitulos ex) {
            ex.printStackTrace();
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar os boletos." + ex.getMessage(), (Throwable)ex);
        }
    }

    public BoletoTitulo getBoletoAtivo(Titulo titulo) {
        if (titulo.getBoletoTitulo() == null) {
            return null;
        }
        BoletoTitulo found = null;
        for (BoletoTitulo boletoTitulo : titulo.getBoletoTitulo()) {
            if (boletoTitulo.getAtivo() == null || boletoTitulo.getAtivo() != 1) continue;
            found = boletoTitulo;
        }
        return found;
    }

    private boolean validoTirarBoleto(Titulo t, BoletoTitulo b, CarteiraCobranca carteiraCobranca, ResultProcessGerBol result) {
        StringBuilder sb = result.getErrosGerados();
        if (carteiraCobranca.getDataInNossoNumero() == null) {
            sb.append("\nData inicial emissao boleto nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getDataInNossoNumero() != null && new Date().before(carteiraCobranca.getDataInNossoNumero())) {
            sb.append("\nData inicial emissao boleto nao pode ser maior que a data atual ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getNossoNumeroInicial() == null) {
            sb.append("\nNosso numero inicial nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getCodigoCarteira() == null) {
            sb.append("\nCodigo da carteira do banco nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (t.getPagRec() != 1) {
            sb.append("\nTitulo deve ser de recebimento ").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        if (t.getProvisao() != 1) {
            sb.append("\nTitulo deve ser realizado ").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        Double saldo = t.getValor();
        if (t.getIdentificador() != null) {
            saldo = t.getValorSaldo();
        }
        if (b != null && saldo == 0.0) {
            sb.append("\nTitulo j\u00c3\u00a1 baixado.").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        if (sb.length() > 0) {
            System.out.println(sb.toString());
            return false;
        }
        return true;
    }

    public ResultProcessGerBol gerarBoletoTitulo(Titulo t) throws ExceptionGeracaoTitulos {
        ResultProcessGerBol result = new ResultProcessGerBol();
        this.gerarBoletoTitulo(t, result);
        return result;
    }

    public ResultProcessGerBol gerarBoletoTitulo(Titulo t, ResultProcessGerBol result) throws ExceptionGeracaoTitulos {
        CarteiraCobranca cart = t.getCarteiraCobranca();
        if (t.getCartCobrancaDestino() != null) {
            cart = t.getCartCobrancaDestino();
        }
        if (t.getIdentificador() != null && t.getIdentificador() > 0L && t.getValorSaldo() <= 0.0) {
            throw new ExceptionGeracaoTitulos(" O T\u00c3\u00adtulo " + t.toString().toUpperCase() + " n\u00c3\u00a3o possui saldo!");
        }
        BoletoTitulo b = this.getBoletoAtivo(t);
        if (b != null) {
            cart = b.getCarteiraCobranca();
        }
        if (this.validoTirarBoleto(t, b, cart, result)) {
            if (b == null) {
                b = new BoletoTitulo();
                b.setAtivo(Short.valueOf((short)1));
                b.setCalcularDespBanc(Short.valueOf((short)0));
                b.setCalcularJuros(Short.valueOf((short)0));
                b.setCalcularMulta(Short.valueOf((short)0));
                b.setDataCadastro(new Date());
                b.setDataVencimento(t.getDataVencimento());
                b.setPercDesconto(t.getPercDescontoMes());
                b.setPercJuros(t.getPercJurosMes());
                b.setPercMulta(t.getPercMulta());
                b.setValorBase(t.getValor());
                b.setValorTotal(t.getValorSaldo());
                b.setValorBoleto(t.getValorSaldo());
                b.setCarteiraCobranca(cart);
                b.setNrTitulo(t.getIdentificador());
                this.addLogBoleto(b);
            }
            b.setTitulo(t);
            result.getBoletos().add(b);
        }
        return result;
    }

    public void addLogBoleto(BoletoTitulo boleto) {
        ItemAltBoletoHist it = new ItemAltBoletoHist();
        it.setDataAlteracao(new Date());
        it.setBoletoTitulo(boleto);
        StringBuilder sb = new StringBuilder();
        sb.append("Criacao de boleto: Valor base: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorBase(), (int)2));
        sb.append(" Juros: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorJuros(), (int)2));
        sb.append(" Despesas: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorDespBanc(), (int)2));
        sb.append(" Multa: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorMulta(), (int)2));
        sb.append(" Desc: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorDesconto(), (int)2));
        sb.append(" Total: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorTotal(), (int)2));
        it.setObservacao(sb.toString());
        boleto.getItensAltBoleto().add(it);
    }

    private static String getCentroCustoLancGerencial(List<LancamentoCtbGerencial> lancamentos) {
        Object texto = "";
        int nrLanc = 0;
        for (LancamentoCtbGerencial l : lancamentos) {
            if (l.getCentroCusto() == null) continue;
            ++nrLanc;
        }
        int count = 1;
        for (LancamentoCtbGerencial l : lancamentos) {
            if (l.getCentroCusto() == null) continue;
            texto = count == nrLanc ? (String)texto + l.getCentroCusto().getNome() : (String)texto + l.getCentroCusto().getNome() + ", ";
            ++count;
        }
        return texto;
    }

    private static String getPlanoGerencialLancGerencial(List<LancamentoCtbGerencial> lancamentos) {
        Object texto = "";
        int nrLanc = lancamentos.size();
        int count = 1;
        for (LancamentoCtbGerencial l : lancamentos) {
            texto = count == nrLanc ? (String)texto + l.getPlanoContaGerencial().getDescricao() : (String)texto + l.getPlanoContaGerencial().getDescricao() + ", ";
            ++count;
        }
        return texto;
    }

    public void addLogBoletoGeradoEmRelacaoAoAnterior(BoletoTitulo boleto) {
        ItemAltBoletoHist it = new ItemAltBoletoHist();
        it.setDataAlteracao(new Date());
        it.setBoletoTitulo(boleto);
        StringBuilder sb = new StringBuilder();
        sb.append("Criacao de boleto com base em outro boleto: Valor base: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorBase(), (int)2));
        sb.append(" Juros: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorJuros(), (int)2));
        sb.append(" Despesas: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorDespBanc(), (int)2));
        sb.append(" Multa: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorMulta(), (int)2));
        sb.append(" Desc: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorDesconto(), (int)2));
        sb.append(" Total: " + ToolFormatter.arrredondarNumero((Double)boleto.getValorTotal(), (int)2));
        it.setObservacao(sb.toString());
        boleto.getItensAltBoleto().add(it);
    }

    private String getInstrucaoBoleto(String instrucao, Titulo titulo) {
        if (instrucao == null) {
            return "";
        }
        List tokens = ToolString.getReplaceTokens((String)instrucao);
        HashMap<String, String> values = new HashMap<String, String>();
        String value = "";
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            NotaFiscalPropria n = titulo.getInfPagamentoNfPropria() != null ? titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() : null;
            value = this.getValueEmail(tk.getChave(), n);
            if (value == null || value.isEmpty()) {
                value = ServiceBoletoTituloImpl.getFixedValue(tk.getChave(), titulo);
            }
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)instrucao, values);
    }

    public String getValueEmail(String token, NotaFiscalPropria vo) {
        if (token == null || vo == null) {
            return "";
        }
        if ((token = token.replaceAll("\n", "")).equalsIgnoreCase("data emissao np")) {
            return ToolDate.dateToStr((Date)vo.getDataEmissaoNota());
        }
        if (token.equalsIgnoreCase("serie np")) {
            return vo.getSerie();
        }
        if (token.equalsIgnoreCase("numero np")) {
            if (vo.getNumeroNota() != null) {
                return vo.getNumeroNota().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("chave nfe")) {
            if (vo.getChaveNFE() != null) {
                return vo.getChaveNFE();
            }
            return "";
        }
        return "";
    }

    public List<DataOutputBI> gerarBoletoTitulo(List<BoletoTitulo> listBoletoTitulo, Usuario usuario, Grupo grupoUsuario, Empresa empresa, Short tipoNumero) throws ExceptionGeracaoTitulos {
        ArrayList<BusinessIntelligence> listBIBoletos = new ArrayList<BusinessIntelligence>();
        ArrayList aux = new ArrayList();
        ArrayList<BoletoTitulo> boletos = new ArrayList<BoletoTitulo>();
        ArrayList<DataOutputBI> listDataOutput = new ArrayList<DataOutputBI>();
        if (listBoletoTitulo != null && !listBoletoTitulo.isEmpty()) {
            for (BoletoTitulo boletoTitulo : listBoletoTitulo) {
                if (listBIBoletos.contains(boletoTitulo.getCarteiraCobranca().getBiVincCarteiraCobranca())) continue;
                listBIBoletos.add(boletoTitulo.getCarteiraCobranca().getBiVincCarteiraCobranca());
            }
            for (BusinessIntelligence businessIntelligence : listBIBoletos) {
                boletos = new ArrayList();
                HashMap<String, Object> hs = new HashMap<String, Object>();
                hs.put("bi", businessIntelligence);
                for (BoletoTitulo bol : listBoletoTitulo) {
                    if (bol.getCarteiraCobranca().getBiVincCarteiraCobranca() == null) {
                        throw new ExceptionGeracaoTitulos("A Carteira de Cobranca " + bol.getCarteiraCobranca().toString() + " nao possui nenhum BI de impressao de Boleto vinculado!");
                    }
                    if (bol.getCarteiraCobranca().getBiVincCartCobEnvioMassa() == null) {
                        throw new ExceptionGeracaoTitulos("A Carteira de Cobranca " + bol.getCarteiraCobranca().toString() + " nao possui nenhum BI de impressao de Boleto Envio em Massa vinculado!");
                    }
                    if (!businessIntelligence.equals((Object)bol.getCarteiraCobranca().getBiVincCarteiraCobranca())) continue;
                    boletos.add(bol);
                }
                hs.put("boletos", boletos);
                aux.add(hs);
            }
            try {
                for (HashMap hashMap : aux) {
                    BusinessIntelligence bi = (BusinessIntelligence)hashMap.get("bi");
                    List boletoPorBanco = (List)hashMap.get("boletos");
                    ArrayList<JBoletoBean> listJBoletoBean = new ArrayList<JBoletoBean>();
                    for (BoletoTitulo b : boletoPorBanco) {
                        JBoletoBean j = this.gerarBoletoBI(b, tipoNumero);
                        listJBoletoBean.add(j);
                    }
                    listDataOutput.add(this.gerarJasperBoleto(listJBoletoBean, bi, empresa, usuario, grupoUsuario));
                }
            }
            catch (ExceptionGeracaoTitulos ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage());
                throw new ExceptionGeracaoTitulos("Erro ao gerar os Boletos de Cobranca.\n" + ex.getMessage());
            }
        } else {
            throw new ExceptionGeracaoTitulos("Pesquisa ao menos um boleto de cobranca!");
        }
        return listDataOutput;
    }

    private DataOutputBI gerarJasperBoleto(List<JBoletoBean> listJBoletoBean, BusinessIntelligence bi, Empresa empresa, Usuario usuario, Grupo grupoUsuarios) throws ExceptionGeracaoTitulos {
        try {
            DataOutputBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.PDF, EnumConstTipoSistema.INDIFERE, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupoUsuarios, new Object[0]), DataParamsBIUser.newInst().setItOutros("LIST_BOLETO", this.getDadosBoleto(listJBoletoBean)));
            return out;
        }
        catch (ExceptionBuildBI ex) {
            ex.printStackTrace();
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos((Throwable)ex);
        }
    }

    public Object getDadosBoleto(List<JBoletoBean> listJBoletoBean) {
        ArrayList lista = new ArrayList();
        for (JBoletoBean j : listJBoletoBean) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("agencia", j.getAgencia());
            h.put("aceite", j.getAceite());
            h.put("acrescimo", j.getAcrescimo());
            h.put("agenciaCodCedenteFormato", j.getAgenciaCodCedenteFormato());
            h.put("bairroCedente", j.getBairroCedente());
            h.put("bairroSacado", j.getBairroSacado());
            h.put("caminho", j.getCaminho());
            h.put("carteira", j.getCarteira());
            h.put("cedente", j.getCedente());
            h.put("cepSacado", j.getCepSacado());
            h.put("cepCedente", j.getCepCedente());
            h.put("cidadeCedente", j.getCidadeCedente());
            h.put("cidadeSacado", j.getCidadeSacado());
            h.put("codCedenteBB", j.getCodCedenteBB());
            h.put("codCliente", j.getCodCliente());
            h.put("codigoBarras", j.getCodigoBarras());
            h.put("codigoFornecidoAgencia", j.getCodigoFornecidoAgencia());
            h.put("codigoOperacao", j.getCodigoOperacao());
            h.put("contaCorrente", j.getContaCorrente());
            h.put("cpfCedente", j.getCpfCedente());
            h.put("cpfSacado", j.getCpfSacado());
            h.put("dataDocumento", j.getDataDocumento());
            h.put("dataProcessamento", j.getDataProcessamento());
            h.put("dataVencimento", j.getDataVencimento());
            h.put("dvContaCorrente", j.getDvContaCorrente());
            h.put("dvAgencia", j.getDvAgencia());
            h.put("dvCodigoFornecidoAgencia", j.getDvCodigoFornecidoAgencia());
            h.put("dvNossoNumero", j.getDvNossoNumero());
            h.put("enderecoCedente", j.getEnderecoCedente());
            h.put("enderecoSacado", j.getEnderecoSacado());
            h.put("enderecoCodBar", j.getEnderecoCodBar());
            h.put("especieDocumento", j.getEspecieDocumento());
            h.put("fatorVencimento", j.getFatorVencimento());
            h.put("ios", j.getIos());
            h.put("IOS", j.getIOS());
            h.put("instrucao1", j.getInstrucao1());
            h.put("instrucao2", j.getInstrucao2());
            h.put("instrucao3", j.getInstrucao3());
            h.put("instrucao4", j.getInstrucao4());
            h.put("instrucao5", j.getInstrucao5());
            h.put("imagemMarketing", j.getImagemMarketing());
            h.put("linhaDigitavel", j.getLinhaDigitavel());
            h.put("localPagamento", j.getLocalPagamento());
            h.put("localPagamento2", j.getLocalPagamento2());
            h.put("modalidadeCobranca", j.getModalidadeCobranca());
            h.put("moeda", j.getMoeda());
            h.put("numConvenio", j.getNumConvenio());
            h.put("nossoNumero", j.getNossoNumero());
            h.put("nrBanco", j.getNrBanco());
            h.put("nomeSacado", j.getNomeSacado());
            h.put("noDocumento", j.getNoDocumento());
            h.put("nossoNumeroCedente", j.getNossoNumeroCedente());
            h.put("nossoNumeroFormato", j.getNossoNumeroFormato());
            h.put("numeroCedente", j.getNumeroCedente());
            h.put("numeroParcela", j.getNumeroParcela());
            h.put("numeroSacado", j.getNumeroSacado());
            h.put("qtdMoeda", j.getQtdMoeda());
            h.put("tipoSaida", j.getTipoSaida());
            h.put("tituloBoletoHtml", j.getTituloBoletoHtml());
            h.put("ufCedente", j.getUfCedente());
            h.put("ufSacado", j.getUfSacado());
            h.put("valorDescontos", j.getValorDescontos());
            h.put("valorBoleto", j.getValorBoleto());
            h.put("valorMoeda", j.getValorMoeda());
            h.put("valorTitulo", j.getValorTitulo());
            h.put("juros", j.getValorJuros());
            h.put("valorCobrado", j.getValorCobrado());
            lista.add(h);
        }
        return lista;
    }

    private String getMessageErro() {
        return "Alguns boletos n\u00c3\u00a3o foram criados por j\u00c3\u00a1 existirem boletos ativos ou foram criados como inativos e n\u00c3\u00a3o geraram c\u00c3\u00b3digos de barras, pois a carteira de cobran\u00c3\u00a7a do t\u00c3\u00adtulo n\u00c3\u00a3o permite essa opera\u00c3\u00a7\u00c3\u00a3o! \n Titulos: ";
    }

    public HashMap salvarBoletoTitulo(List<BoletoTitulo> boletosTitulos, Short tipoNumero) {
        ArrayList<BoletoTitulo> boletos = new ArrayList<BoletoTitulo>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageErro());
        Boolean criado = true;
        for (BoletoTitulo o : boletosTitulos) {
            BoletoTitulo bb = o;
            Titulo t = bb.getTitulo();
            if (this.verificarExistTitulo(t)) {
                try {
                    bb.setAtivo(Short.valueOf((short)1));
                    bb = this.saveOrUpdate(bb);
                    bb.setCodigoBarras(this.getCodigoBarras(bb, tipoNumero));
                    bb = this.saveOrUpdate(bb);
                    boletos.add(bb);
                }
                catch (ExceptionGeracaoTitulos ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                    bb.setAtivo(Short.valueOf((short)0));
                    bb = this.saveOrUpdate(bb);
                    criado = false;
                    sb.append(t.getIdentificador());
                    sb.append(", ");
                }
                continue;
            }
            criado = false;
            sb.append(t.getIdentificador());
        }
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        if (!criado.booleanValue()) {
            retorno.put("BOLETOS_ERROS", sb.toString());
        }
        if (boletos != null && !boletos.isEmpty()) {
            retorno.put("BOLETOS", boletos);
        }
        return retorno;
    }

    private boolean verificarExistTitulo(Titulo titulo) {
        List<BoletoTitulo> listBoleto = ((DaoBoletoTituloImpl)this.getGenericDao()).findBoletoTituloByTitulo(titulo);
        return listBoleto == null || listBoleto.isEmpty();
    }

    public List<BoletoTitulo> getBoletos(Titulo t) {
        return ((DaoBoletoTituloImpl)this.getDao()).getBoletos(t);
    }

    public List<BoletoTitulo> getBoletosParaCentralCobranca(String cnpj) {
        return ((DaoBoletoTituloImpl)this.getDao()).getBoletosParaCentralCobranca(cnpj);
    }
}

