/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.borderochequesterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.movimentobancario.EnumConstMovimentoBancario;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.borderochequeterceiros.CompLancamentoBorderoChequeTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoBorderoChequesTerceirosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.borderochequeterceirosmovbancario.ServiceBorderoChequeTerceirosMovBancarioImpl;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.chequeterceiros.ServiceChequeTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.lancamentoctbgerencial.ServiceLancamentoCtbGerencialImpl;
import com.touchcomp.basementorservice.service.impl.movimentobancario.ServiceMovimentoBancarioImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.borderochequesterceiros.web.DTOBorderoChequesTerceiros;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceBorderoChequesTerceirosImpl
extends ServiceGenericEntityImpl<BorderoChequesTerceiros, Long, DaoBorderoChequesTerceirosImpl> {
    ServiceMovimentoBancarioImpl serviceMovimentoBancarioImpl;
    ServiceChequeTerceirosImpl serviceChequeTerceirosImpl;
    ServiceBorderoChequeTerceirosMovBancarioImpl serviceBorderoChequeTerceirosMovBancarioImpl;
    CompLancamentoBorderoChequeTerceiros compLancamentoBorderoChequeTerceiros;
    ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl;
    ServiceLancamentoCtbGerencialImpl serviceLancamentoCtbGerencialImpl;

    @Autowired
    public ServiceBorderoChequesTerceirosImpl(DaoBorderoChequesTerceirosImpl dao, ServiceMovimentoBancarioImpl serviceMovimentoBancarioImpl, ServiceChequeTerceirosImpl serviceChequeTerceirosImpl, CompLancamentoBorderoChequeTerceiros compLancamentoBorderoChequeTerceiros, ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl, ServiceLancamentoCtbGerencialImpl serviceLancamentoCtbGerencialImpl, ServiceBorderoChequeTerceirosMovBancarioImpl serviceBorderoChequeTerceirosMovBancarioImpl) {
        super(dao);
        this.serviceMovimentoBancarioImpl = serviceMovimentoBancarioImpl;
        this.serviceChequeTerceirosImpl = serviceChequeTerceirosImpl;
        this.compLancamentoBorderoChequeTerceiros = compLancamentoBorderoChequeTerceiros;
        this.serviceCarteiraCobrancaImpl = serviceCarteiraCobrancaImpl;
        this.serviceLancamentoCtbGerencialImpl = serviceLancamentoCtbGerencialImpl;
        this.serviceBorderoChequeTerceirosMovBancarioImpl = serviceBorderoChequeTerceirosMovBancarioImpl;
    }

    public boolean deleteAndEstornaCarteira(BorderoChequesTerceiros borderoChequesTerceiros, CarteiraCobranca carteiraCobranca) {
        this.refresh(borderoChequesTerceiros);
        borderoChequesTerceiros = (BorderoChequesTerceiros)this.get(borderoChequesTerceiros.getIdentificador());
        for (BorderoChequeTerceirosMovBancario bb : borderoChequesTerceiros.getChequesTerceirosMovBancarios()) {
            this.deleteAndEstornaCarteiraInternal(bb, carteiraCobranca);
        }
        return this.delete(borderoChequesTerceiros);
    }

    public boolean deleteAndEstornaCarteira(BorderoChequeTerceirosMovBancario bb, CarteiraCobranca carteiraCobranca) {
        this.deleteAndEstornaCarteiraInternal(bb, carteiraCobranca);
        return this.serviceBorderoChequeTerceirosMovBancarioImpl.delete(bb);
    }

    private boolean deleteAndEstornaCarteiraInternal(BorderoChequeTerceirosMovBancario bb, CarteiraCobranca carteiraCobranca) {
        MovimentoBancario movDebito;
        ChequeTerceiros ch = bb.getChequeTerceiros();
        ch.setCarteiraCobranca(carteiraCobranca);
        MovimentoBancario movCredito = this.findPenultimoMovimentoBancarioCheque(ch, (short)1, bb.getMovimentoBancarioCredito().getIdentificador());
        if (movCredito != null) {
            movCredito.setDataCompensacao(null);
        }
        if ((movDebito = this.findPenultimoMovimentoBancarioCheque(ch, (short)0, bb.getMovimentoBancarioDebito().getIdentificador())) != null) {
            movDebito.setDataCompensacao(null);
        }
        return true;
    }

    public BorderoChequesTerceiros beforeSaveBordero(BorderoChequesTerceiros borderoChequesTerceiros) {
        for (BorderoChequeTerceirosMovBancario bb : borderoChequesTerceiros.getChequesTerceirosMovBancarios()) {
            MovimentoBancario movDebito;
            ChequeTerceiros c = bb.getChequeTerceiros();
            MovimentoBancario movCredito = this.findUltimoMovimentoBancarioCheque(c, (short)1);
            if (movCredito != null) {
                movCredito.setDataCompensacao(borderoChequesTerceiros.getDataBordero());
                this.serviceMovimentoBancarioImpl.saveOrUpdate(movCredito);
            }
            if ((movDebito = this.findUltimoMovimentoBancarioCheque(c, (short)0)) == null) continue;
            movDebito.setDataCompensacao(borderoChequesTerceiros.getDataBordero());
            this.serviceMovimentoBancarioImpl.saveOrUpdate(movDebito);
        }
        return borderoChequesTerceiros;
    }

    public LoteContabil contabilizar(BorderoChequesTerceiros borderoChequesTerceiros, OpcoesContabeis opCont) throws ExceptionInvalidData {
        return this.compLancamentoBorderoChequeTerceiros.contabilizar(borderoChequesTerceiros, opCont);
    }

    private MovimentoBancario findUltimoMovimentoBancarioCheque(ChequeTerceiros chequeTerceiros, Short debCred) {
        MovimentoBancario mov = null;
        for (MovimentoBancario m : chequeTerceiros.getMovimentosBancarios()) {
            if (mov == null && m.getDataCompensacao() == null && m.getDebCred().equals(debCred) && m.getIdentificador() != null) {
                mov = m;
                continue;
            }
            if (mov == null || m.getDataCompensacao() != null || m.getIdentificador() == null || !m.getDebCred().equals(debCred) || m.getIdentificador() <= mov.getIdentificador()) continue;
            mov = m;
        }
        return mov;
    }

    private MovimentoBancario findPenultimoMovimentoBancarioCheque(ChequeTerceiros chequeTerceiros, Short debCred, Long idMovimentoAtual) {
        MovimentoBancario mov = null;
        for (MovimentoBancario m : chequeTerceiros.getMovimentosBancarios()) {
            if (mov == null && m.getDataCompensacao() != null && ToolMethods.isEquals((Object)m.getDebCred(), (Object)debCred) && !ToolMethods.isEquals((Object)m.getIdentificador(), (Object)idMovimentoAtual)) {
                mov = m;
                continue;
            }
            if (mov == null || m.getDataCompensacao() == null || ToolMethods.isEquals((Object)m.getIdentificador(), (Object)idMovimentoAtual) || ToolMethods.isEquals((Object)m.getIdentificador(), (Object)mov.getIdentificador()) || !ToolMethods.isEquals((Object)m.getDebCred(), (Object)debCred) || m.getIdentificador() <= mov.getIdentificador()) continue;
            mov = m;
        }
        return mov;
    }

    @Async
    public CompletableFuture reprocessarContabilidade(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis opcoes, boolean contApenasBordSemCont) throws ExceptionInvalidData {
        List<BorderoChequesTerceiros> borderos = ((DaoBorderoChequesTerceirosImpl)this.getDao()).get(dataInicial, dataFinal, empresa, contApenasBordSemCont);
        for (BorderoChequesTerceiros bordero : borderos) {
            LoteContabil lote = this.contabilizar(bordero, opcoes);
            lote.setOrigem(ConstEnumOrigemLoteContabil.BORDERO_FINANCEIRO.getValue());
            bordero.setLoteContabil(lote);
            this.saveOrUpdate(bordero);
        }
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public List<DTOBorderoChequesTerceiros.DTOBorderoChequeTerceirosMovBancario> getCarregarBorderoChequesTerceirosMovBancario(Long dataBordero, Long dataEmissaoInicial, Long dataEmissaoFinal, Long dataVencimentoInicial, Long dataVencimentoFinal, Long idCarteiraOrigem, Long idCarteiraDestino) {
        try {
            if (this.isValidFind(new Date(dataBordero), new Date(dataEmissaoInicial), new Date(dataEmissaoFinal), new Date(dataVencimentoInicial), new Date(dataVencimentoFinal), idCarteiraOrigem, idCarteiraDestino)) {
                CarteiraCobranca carteiraCobranca = (CarteiraCobranca)this.serviceCarteiraCobrancaImpl.get(idCarteiraOrigem);
                if (this.isNull(idCarteiraOrigem).booleanValue()) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.001", new Object[]{idCarteiraOrigem}));
                }
                List<ChequeTerceiros> listaChequeTerceiros = this.serviceChequeTerceirosImpl.findChequeTerceiros(new Date(dataEmissaoInicial), new Date(dataEmissaoFinal), new Date(dataVencimentoInicial), new Date(dataVencimentoFinal), carteiraCobranca);
                ArrayList borderoChequeTerceirosMovBancario = new ArrayList();
                if (listaChequeTerceiros.isEmpty()) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.002"));
                }
                listaChequeTerceiros.forEach(i -> {
                    BorderoChequeTerceirosMovBancario b = new BorderoChequeTerceirosMovBancario();
                    b.setChequeTerceiros(i);
                    borderoChequeTerceirosMovBancario.add(b);
                });
                return this.buildToDTOGeneric(borderoChequeTerceirosMovBancario, DTOBorderoChequesTerceiros.DTOBorderoChequeTerceirosMovBancario.class);
            }
        }
        catch (ExceptionRuntimeBase ex) {
            ex.getMessage();
        }
        return null;
    }

    private boolean isValidFind(Date dataBordero, Date dataEmissaoInicial, Date dataEmissaoFinal, Date dataVencimentoInicial, Date dataVencimentoFinal, Long idCarteiraOrigem, Long idCarteiraDestino) {
        if (this.isNull(dataEmissaoInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.003"));
        }
        if (this.isNull(dataEmissaoFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.004"));
        }
        if (dataEmissaoFinal.before(dataEmissaoInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.005"));
        }
        if (this.isNull(dataVencimentoInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.006"));
        }
        if (this.isNull(dataVencimentoFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.007"));
        }
        if (dataVencimentoFinal.before(dataVencimentoInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.008"));
        }
        if (this.isNull(dataBordero).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.009"));
        }
        if (this.isNull(idCarteiraDestino).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.010"));
        }
        if (this.isNull(idCarteiraOrigem).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.011"));
        }
        if (this.isEquals(idCarteiraDestino, idCarteiraOrigem)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.012"));
        }
        return true;
    }

    public DTOBorderoChequesTerceiros.DTOBorderoChequeTerceirosMovBancario getChequeTerceiro(Long idChequeTerceiro, Long dataBordero, Long idCarteiraCobrancaOrigem, Long idCarteiraCobancaDestino) {
        try {
            if (this.isValidAddCheque(new Date(dataBordero), idCarteiraCobrancaOrigem, idCarteiraCobancaDestino)) {
                ChequeTerceiros chequeTerceiro = (ChequeTerceiros)this.serviceChequeTerceirosImpl.get(idChequeTerceiro);
                if (this.isNull(chequeTerceiro).booleanValue()) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.002", new Object[]{idChequeTerceiro}));
                }
                BorderoChequeTerceirosMovBancario borderoChequeTerceirosMovBancario = new BorderoChequeTerceirosMovBancario();
                borderoChequeTerceirosMovBancario.setChequeTerceiros(chequeTerceiro);
                return this.buildToDTOGeneric(borderoChequeTerceirosMovBancario, DTOBorderoChequesTerceiros.DTOBorderoChequeTerceirosMovBancario.class);
            }
        }
        catch (ExceptionRuntimeBase ex) {
            ex.getMessage();
        }
        return null;
    }

    private boolean isValidAddCheque(Date dataBordero, Long idCarteiraCobrancaOrigem, Long idCarteiraCobancaDestino) {
        if (this.isNull(dataBordero).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.009", new Object[]{dataBordero}));
        }
        if (this.isNull(idCarteiraCobancaDestino).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.010", new Object[]{idCarteiraCobancaDestino}));
        }
        if (this.isNull(idCarteiraCobrancaOrigem).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0332.011", new Object[]{idCarteiraCobrancaOrigem}));
        }
        return true;
    }

    @Override
    public BorderoChequesTerceiros beforeSave(BorderoChequesTerceiros aux) {
        aux.getChequesTerceirosMovBancarios().forEach(i -> i.setBorderoChequeTerceiros(aux));
        this.gerarMovimentos(aux);
        return aux;
    }

    private void gerarMovimentos(BorderoChequesTerceiros aux) {
        aux.getChequesTerceirosMovBancarios().forEach(i -> {
            i.setMovimentoBancarioDebito(this.getMovimentoDebito((BorderoChequeTerceirosMovBancario)i, aux.getCarteiraOrigem(), aux.getCarteiraCobranca()));
            i.setMovimentoBancarioCredito(this.getMovimentoCredito((BorderoChequeTerceirosMovBancario)i, aux.getCarteiraOrigem(), aux.getCarteiraCobranca()));
        });
    }

    private MovimentoBancario getMovimentoDebito(BorderoChequeTerceirosMovBancario i, CarteiraCobranca carteiraCobrancaOrigem, CarteiraCobranca carteiraCobrancaDestino) {
        if (!this.isNull(carteiraCobrancaOrigem).booleanValue()) {
            MovimentoBancario movDeb = new MovimentoBancario();
            movDeb.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            movDeb.setDataCadastro(new Date());
            movDeb.setDataLancamento(i.getBorderoChequeTerceiros().getDataBordero());
            if (this.isEquals(carteiraCobrancaOrigem.getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco(), "999")) {
                movDeb.setDataCompensacao(i.getBorderoChequeTerceiros().getDataBordero());
            }
            movDeb.setDebCred(Short.valueOf(EnumConstMovimentoBancario.DEBITO.getValue()));
            movDeb.setEmpresa(i.getBorderoChequeTerceiros().getEmpresa());
            movDeb.setHistorico("Border\u00f4 Cheques Origem: " + carteiraCobrancaOrigem.getContaValor().getDescricao() + " Destino: " + carteiraCobrancaDestino.getContaValor().getDescricao() + " Cheque: " + i.getChequeTerceiros().getNumero().toString());
            movDeb.setContaValor(carteiraCobrancaOrigem.getContaValor());
            movDeb.setValor(i.getChequeTerceiros().getValor());
            i.setMovimentoBancarioDebito(movDeb);
            ContraPartMovimentoBancario contDeb = new ContraPartMovimentoBancario();
            contDeb.setDebCred(Short.valueOf(EnumConstMovimentoBancario.CREDITO.getValue()));
            contDeb.setPlanoConta(movDeb.getContaValor().getPlanoConta());
            contDeb.setHistorico(movDeb.getHistorico());
            contDeb.setPlanoContaGerencial(this.getSharedData().getOpcoesContabeis(i.getBorderoChequeTerceiros().getEmpresa()).getPlanoChequeTerceirosGerencial());
            contDeb.setValor(i.getChequeTerceiros().getValor());
            LancamentoCtbGerencial l = this.serviceLancamentoCtbGerencialImpl.criarLancamentoGerencialMovimentoBancario(movDeb, EnumLancamentoCTBGerencial.DEBITO.getValue(), contDeb.getPlanoContaGerencial(), i.getChequeTerceiros().getValor());
            contDeb.setLancamentoCtbGerencial(l);
            movDeb.getContraPartMovimentoBancario().add(contDeb);
            movDeb.setChequeTerceiros(i.getChequeTerceiros());
            i.getChequeTerceiros().getMovimentosBancarios().add(movDeb);
            return movDeb;
        }
        return null;
    }

    private MovimentoBancario getMovimentoCredito(BorderoChequeTerceirosMovBancario i, CarteiraCobranca carteiraCobrancaOrigem, CarteiraCobranca carteiraCobrancaDestino) {
        if (!this.isNull(carteiraCobrancaDestino).booleanValue()) {
            MovimentoBancario movCred = new MovimentoBancario();
            movCred.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            movCred.setDataCadastro(new Date());
            movCred.setDataLancamento(i.getBorderoChequeTerceiros().getDataBordero());
            movCred.setDebCred(Short.valueOf(EnumConstMovimentoBancario.CREDITO.getValue()));
            movCred.setEmpresa(i.getBorderoChequeTerceiros().getEmpresa());
            if (this.isEquals(carteiraCobrancaDestino.getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco(), "999")) {
                movCred.setDataCompensacao(i.getBorderoChequeTerceiros().getDataBordero());
            }
            movCred.setHistorico("Border\u00f4 Cheques Origem: " + carteiraCobrancaOrigem.getContaValor().getDescricao() + " Destino: " + carteiraCobrancaDestino.getContaValor().getDescricao() + " Cheque: " + i.getChequeTerceiros().getNumero().toString());
            movCred.setContaValor(carteiraCobrancaDestino.getContaValor());
            movCred.setValor(i.getChequeTerceiros().getValor());
            i.setMovimentoBancarioCredito(movCred);
            ContraPartMovimentoBancario contCred = new ContraPartMovimentoBancario();
            contCred.setDebCred(Short.valueOf(EnumConstMovimentoBancario.DEBITO.getValue()));
            contCred.setHistorico(movCred.getHistorico());
            contCred.setPlanoConta(movCred.getContaValor().getPlanoConta());
            contCred.setPlanoContaGerencial(this.getSharedData().getOpcoesContabeis(i.getBorderoChequeTerceiros().getEmpresa()).getPlanoChequeTerceirosGerencial());
            contCred.setValor(i.getChequeTerceiros().getValor());
            LancamentoCtbGerencial l = this.serviceLancamentoCtbGerencialImpl.criarLancamentoGerencialMovimentoBancario(movCred, EnumLancamentoCTBGerencial.CREDITO.getValue(), contCred.getPlanoContaGerencial(), i.getChequeTerceiros().getValor());
            contCred.setLancamentoCtbGerencial(l);
            movCred.getContraPartMovimentoBancario().add(contCred);
            movCred.setChequeTerceiros(i.getChequeTerceiros());
            i.getChequeTerceiros().getMovimentosBancarios().add(movCred);
            return movCred;
        }
        return null;
    }

    public BorderoChequeTerceirosMovBancario getUltimoBorderoChequeTerceiro(Long idCheque) {
        return ((DaoBorderoChequesTerceirosImpl)this.getGenericDao()).getUltimoBorderoChequeTerceiro(idCheque);
    }
}

