/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntTipoTemplate;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBIOutputType;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.BICSVDiretoOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.BIExcelDiretoOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.BIExcelXlsxDiretoOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.BITXTDiretoOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperDocxOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperFileOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperHtmlOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperImageSVGOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperJsonOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperODTOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperOdsOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperPDFOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperPptxtOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperPrintOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperRtfOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperTxtOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperXMLOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperXlsOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperXlsxOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.word.BIWordHTMLOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.word.BIWordOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.word.BIWordPDFOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.word.BIWordRTFOutputter;
import com.touchcomp.basementortools.tools.methods.TMethods;

public class AuxBuildOutput {
    public DataOutputBI converterDataResultFormatoImpBI(ConstEnumFormImprBI formatoImpressao, DataResultBI dataResult, String fileName) throws ExceptionBuildBI {
        if (TMethods.isEquals((Object)dataResult.getResultType(), (Object)EnumConstBIOutputType.TIPO_GERACAO_ARQUIVO)) {
            return new BIJasperFileOutputter().outputData(dataResult, fileName);
        }
        EnumConstBusinessIntTipoTemplate template = EnumConstBusinessIntTipoTemplate.get((Object)dataResult.getBusinessIntelligence().getTipoTemplate());
        if (template == null) {
            template = EnumConstBusinessIntTipoTemplate.JASPER_PRINT;
        }
        switch (template) {
            case WORD: {
                return this.converterWord(formatoImpressao, dataResult, fileName);
            }
        }
        return this.converterJasper(formatoImpressao, dataResult, fileName);
    }

    private DataOutputBI converterJasper(ConstEnumFormImprBI formatoImpressao, DataResultBI dataResult, String fileName) throws ExceptionBuildBI {
        if (dataResult.getPerfil() != null && dataResult.getPerfil().getAssinaturaEletronicaBIPref() != null && !TMethods.isEquals((Object)formatoImpressao, (Object)ConstEnumFormImprBI.PDF)) {
            throw new ExceptionBuildBI("E.ERP.0747.015", new Object[]{formatoImpressao.getExtensao()});
        }
        DataOutputBI out = null;
        switch (formatoImpressao) {
            case EXCEL_DIRETO: {
                out = new BIExcelDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_DIRETO_XLSX: {
                out = new BIExcelXlsxDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case VISUALIZAR: {
                out = new BIJasperPrintOutputter().outputData(dataResult, fileName);
                break;
            }
            case PDF: {
                out = new BIJasperPDFOutputter().outputData(dataResult, fileName);
                break;
            }
            case WORD_DOCX: {
                out = new BIJasperDocxOutputter().outputData(dataResult, fileName);
                break;
            }
            case WORD_RTF: {
                out = new BIJasperRtfOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_XLSX: {
                out = new BIJasperXlsxOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_XLS: {
                out = new BIJasperXlsOutputter().outputData(dataResult, fileName);
                break;
            }
            case ODT: {
                out = new BIJasperODTOutputter().outputData(dataResult, fileName);
                break;
            }
            case ODS: {
                out = new BIJasperOdsOutputter().outputData(dataResult, fileName);
                break;
            }
            case HTML: {
                out = new BIJasperHtmlOutputter().outputData(dataResult, fileName);
                break;
            }
            case IMPRIMIR: {
                out = new BIJasperPrintOutputter().outputData(dataResult, fileName);
                break;
            }
            case TXT: {
                out = new BIJasperTxtOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_DIRETO_CSV: {
                out = new BICSVDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case TXT_DIRETO: {
                out = new BITXTDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case PPT: {
                out = new BIJasperPptxtOutputter().outputData(dataResult, fileName);
                break;
            }
            case ARQUIVO_DIRETO_BI: {
                out = new BIJasperFileOutputter().outputData(dataResult, fileName);
                break;
            }
            case SVG: {
                out = new BIJasperImageSVGOutputter().outputData(dataResult, fileName);
                break;
            }
            case JSON_DIRETO: {
                out = new BIJasperJsonOutputter().outputData(dataResult, fileName);
                break;
            }
            case XML_DIRETO: {
                out = new BIJasperXMLOutputter().outputData(dataResult, fileName);
                break;
            }
            case SOMENTE_JASPER: {
                break;
            }
            default: {
                throw new ExceptionBuildBI("E.ERP.0747.016", new Object[]{formatoImpressao});
            }
        }
        return out;
    }

    private DataOutputBI converterWord(ConstEnumFormImprBI formatoImpressao, DataResultBI dataResult, String fileName) throws ExceptionBuildBI {
        if (dataResult.getPerfil() != null && dataResult.getPerfil().getAssinaturaEletronicaBIPref() != null && !TMethods.isEquals((Object)formatoImpressao, (Object)ConstEnumFormImprBI.PDF)) {
            throw new ExceptionBuildBI("E.ERP.0747.024", new Object[]{dataResult.getBusinessIntelligence()});
        }
        DataOutputBI out = null;
        switch (formatoImpressao) {
            case PDF: {
                out = new BIWordPDFOutputter().outputData(dataResult, fileName);
                break;
            }
            case WORD_DOCX: {
                out = new BIWordOutputter().outputData(dataResult, fileName);
                break;
            }
            case HTML: {
                out = new BIWordHTMLOutputter().outputData(dataResult, fileName);
                break;
            }
            case ARQUIVO_DIRETO_BI: {
                out = new BIWordOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_DIRETO_CSV: {
                out = new BICSVDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case TXT_DIRETO: {
                out = new BITXTDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case WORD_RTF: 
            case ODS: {
                out = new BIWordRTFOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_DIRETO: {
                out = new BIExcelDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_DIRETO_XLSX: {
                out = new BIExcelXlsxDiretoOutputter().outputData(dataResult, fileName);
                break;
            }
            case EXCEL_XLSX: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case EXCEL_XLS: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case VISUALIZAR: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case IMPRIMIR: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case SVG: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case SOMENTE_JASPER: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case TXT: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            case ODT: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
            default: {
                throw new ExceptionBuildBI("E.ERP.0747.026", new Object[]{formatoImpressao.getExtensao()});
            }
        }
        return out;
    }
}

