/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence;

import com.touchcomp.basementor.model.vo.AssinaturaEletBICert;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceDados;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceInfParam;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.dao.builders.AuxCriterionBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.constants.DataBIConstants;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParametersBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBIUser;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.certificado.ToolCertificado;
import com.touchcomp.basementortools.tools.converter.CompObjectConverter;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

class AuxParamsBI
implements DataBIConstants {
    private final Empresa loggedEmpresa;
    private final Usuario loggedUsuario;
    private final BusinessIntelligence bi;
    private final DTOBusinessIntelligenceDet dtoBI;
    private final DataParamsBIUser userRepo;
    private final DataParametersBI biRepo;
    private final BusinessIntelligencePref perfil;
    private static final TLogger logger = TLogger.get(AuxParamsBI.class);

    public AuxParamsBI(Empresa loggedEmpresa, Usuario loggedUsuario, DTOBusinessIntelligenceDet det, BusinessIntelligence bi, DataParamsBIUser userRepo, BusinessIntelligencePref perfil) {
        this.loggedEmpresa = loggedEmpresa;
        this.loggedUsuario = loggedUsuario;
        this.bi = bi;
        this.dtoBI = det;
        this.userRepo = userRepo;
        this.perfil = perfil;
        this.biRepo = new DataParametersBI();
    }

    public DataParametersBI buildParams() throws ExceptionBuildBI {
        this.buildDefParamsOpcionais();
        this.buildParamsSummary();
        this.buildOutrosParametros();
        this.buildParamsEmpresa();
        this.buildParamsUsuario();
        this.buildParamsImagens();
        this.buildParametrosDadosAdicionais(this.dtoBI.getDadosAdicionais());
        this.buildUserRepo();
        this.buildParamsImpressaoSub();
        return this.biRepo;
    }

    public void buildParamsImpressaoSub() {
        this.biRepo.setItDadosOutros("PARAMETROS_IMPRESSAO", ToolMethods.toList((Object[])new Object[]{this.biRepo.getParamsTodosMap()}));
    }

    private void buildOutrosParametros() {
        String tituloRel = this.dtoBI.getDescricao();
        if (ToolMethods.isStrWithData((String)this.dtoBI.getTituloRelatorio())) {
            tituloRel = this.dtoBI.getTituloRelatorio();
        }
        this.biRepo.setItDadosOutros("TITULO_RELATORIO", tituloRel);
        this.biRepo.setItDadosOutros("OBSERVACAO_RELATORIO", this.dtoBI.getObservacao());
        this.biRepo.setItDadosOutros("SITE_TOUCH", "www.touchcomp.com.br");
        this.biRepo.setItDadosOutros("SERIAL_BI", this.dtoBI.getNumeroControle());
        this.biRepo.setItDadosOutros("NUMERO_VERSAO_BI", this.dtoBI.getNumeroVersao());
        this.biRepo.setItDadosOutros("IDENTIFICADOR_BI", this.dtoBI.getIdentificador());
        this.biRepo.setItDadosOutros("STYLE_FILE", "DEFAULT_REPORT_STYLE.jrtx");
        if (!this.biRepo.containsKeyOutros("IMP_PARAMS")) {
            if (this.dtoBI.getNrVersaoEstruturaBI() >= 3) {
                this.biRepo.setItDadosOutros("IMP_PARAMS", (short)1);
            } else {
                this.biRepo.setItDadosOutros("IMP_PARAMS", (short)0);
            }
        }
        if (!this.biRepo.containsKeyOutros("IMP_DATA")) {
            this.biRepo.setItDadosOutros("IMP_DATA", (short)1);
        }
        if (!this.biRepo.containsKeyOutros("IMP_USUARIO")) {
            this.biRepo.setItDadosOutros("IMP_USUARIO", (short)1);
        }
        if (!this.biRepo.containsKeyOutros("IMP_PAGINAS")) {
            this.biRepo.setItDadosOutros("IMP_PAGINAS", (short)1);
        }
    }

    private void buildParamsImagens() throws ExceptionBuildBI {
        try {
            for (BusinessIntelligenceDados img : this.bi.getDadosImagens()) {
                this.biRepo.setItDadosImg(img.getDescricao(), ImageIO.read(new ByteArrayInputStream(img.getDados())));
            }
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionBuildBI("Erro ao processar parametros de imagens.", (Throwable)ex, new Object[0]);
        }
    }

    private void buildParametrosDadosAdicionais(List<DTOBusinessIntelligenceDet.DTODadoAdicional> data) {
        for (DTOBusinessIntelligenceDet.DTODadoAdicional dd : data) {
            this.putIt(dd);
        }
    }

    private void putIt(DTOBusinessIntelligenceDet.DTODadoAdicional dd) {
        this.putItInternal(dd);
        this.buildParametrosDadosAdicionais(dd.getDadosAdicionais());
    }

    private void putItInternal(DTOBusinessIntelligenceDet.DTODadoAdicional dd) {
        if (dd.getTipoCampo() == null) {
            return;
        }
        AuxCriterionBuilder aux = (AuxCriterionBuilder)Context.get(AuxCriterionBuilder.class);
        if (dd.getOperacao() == null) {
            if (ToolMethods.isAffirmative((Number)dd.getUsarCondicaoIn())) {
                this.biRepo.setItDadosAd(dd.getChave(), aux.getInParams(dd.getTipoCampo(), dd.getValorInformado()));
                return;
            }
            this.biRepo.setItDadosAd(dd.getChave(), this.convertValue(dd, dd.getValorInformado()), this.convertValue(dd, dd.getValorInformado1()));
            return;
        }
        EnumConstantsCriteria crit = EnumConstantsCriteria.valueOfByValue((Integer)dd.getOperacao().intValue());
        if (!crit.equals((Object)EnumConstantsCriteria.IN)) {
            this.biRepo.setItDadosAd(dd.getChave(), this.convertValue(dd, dd.getValorInformado()), this.convertValue(dd, dd.getValorInformado1()), crit);
            return;
        }
        if (!ToolMethods.isStrWithData((String)dd.getValorInformado())) {
            this.biRepo.setItDadosAd(dd.getChave(), null);
            return;
        }
        this.biRepo.setItDadosAd(dd.getChave(), (Object)aux.getInParams(dd.getTipoCampo(), dd.getValorInformado()), crit);
    }

    private Object convertValue(DTOBusinessIntelligenceDet.DTODadoAdicional dd, String valorInf) {
        Object value = null;
        try {
            value = CompObjectConverter.convertStringToObject((String)dd.getTipoCampo(), (String)valorInf);
        }
        catch (Throwable t) {
            value = CompObjectConverter.convertStrNativeValue((String)dd.getTipoCampo(), (String)valorInf);
        }
        return value;
    }

    private void buildParamsEmpresa() {
        if (this.loggedEmpresa == null) {
            return;
        }
        this.biRepo.setItDadosOutros("NOME_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getNome()));
        this.biRepo.setItDadosOutros("NOME_FANTASIA_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getNomeFantasia()));
        this.biRepo.setItDadosOutros("EMPRESA_LOGADA", this.loggedEmpresa);
        this.biRepo.setItDadosOutros("CNPJ_EMPRESA", this.emptyIfNull(ToolFormatter.formatCNPJCPF((String)this.loggedEmpresa.getPessoa().getComplemento().getCnpj())));
        this.biRepo.setItDadosOutros("INSCRICAO_ESTADUAL_EMPRESA", this.emptyIfNull(ToolFormatter.formatIE((String)this.loggedEmpresa.getPessoa().getEndereco().getCidade().getUf().getSigla(), (String)this.loggedEmpresa.getPessoa().getComplemento().getInscEst())));
        this.biRepo.setItDadosOutros("LOGRADOURO_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getLogradouro()));
        this.biRepo.setItDadosOutros("BAIRRO_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getBairro()));
        this.biRepo.setItDadosOutros("NUMERO_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getNumero()));
        this.biRepo.setItDadosOutros("COMPLEMENTO_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getComplemento()));
        this.biRepo.setItDadosOutros("CIDADE_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getCidade().getDescricao()));
        this.biRepo.setItDadosOutros("UF_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        this.biRepo.setItDadosOutros("PAIS_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getEndereco().getCidade().getUf().getPais().getDescricao()));
        this.biRepo.setItDadosOutros("TEL_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getComplemento().getFone1()));
        this.biRepo.setItDadosOutros("EMAIL_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getComplemento().getEmailPrincipal()));
        this.biRepo.setItDadosOutros("SITE_EMPRESA", this.emptyIfNull(this.loggedEmpresa.getPessoa().getComplemento().getSite()));
        this.biRepo.setItDadosOutros("P_ALL_PARAMS_STR", this.buildParamsToString(this.dtoBI));
        if (this.loggedEmpresa.getEmpresaDados().getLogoRelatorios() != null) {
            try {
                this.biRepo.setItDadosOutros("LOGO_EMPRESA", ImageIO.read(new ByteArrayInputStream(this.loggedEmpresa.getEmpresaDados().getLogoRelatorios())));
            }
            catch (IOException e) {
                TLogger.get(this.getClass()).error((Throwable)e);
            }
        }
    }

    private void buildParamsUsuario() {
        if (this.loggedUsuario == null) {
            return;
        }
        this.biRepo.setItDadosOutros("NOME_USUARIO", this.loggedUsuario.getUsuarioBasico().getPessoa().getNome());
    }

    String buildParamsToString(DTOBusinessIntelligenceDet bi) {
        StringBuilder sb = new StringBuilder();
        this.appendDadosAdicionais(bi.getDadosAdicionais(), sb);
        return sb.toString();
    }

    private void appendDadosAdicionais(List<DTOBusinessIntelligenceDet.DTODadoAdicional> dadosAdicionalBI, StringBuilder sb) {
        for (DTOBusinessIntelligenceDet.DTODadoAdicional d : dadosAdicionalBI) {
            if (d == null) continue;
            if (!(d.getDescricao() == null || d.getDescricao().equalsIgnoreCase("P_FECHO") || d.getOrganizacional() != null && d.getOrganizacional() != 0)) {
                sb.append("<b>").append(d.getDescricao()).append(":</b> ");
                String value = null;
                value = ToolMethods.isAffirmative((Number)d.getUsarCondicaoIn()) ? d.getValorInformado() : this.getValue(d.getTipoCampo(), d.getValorInformado(), d.getDadosFixos());
                if (value == null || String.valueOf(value).length() == 0 || String.valueOf(value).equals("null")) {
                    value = "";
                }
                sb.append((Object)value);
                sb.append(" | ");
            }
            this.appendDadosAdicionais(d.getDadosAdicionais(), sb);
        }
    }

    private String getValue(String classeParametro, String valorParametro, List<DTOBusinessIntelligenceDet.DTODadoAdicionalFixo> valorFixo) {
        for (DTOBusinessIntelligenceDet.DTODadoAdicionalFixo valorFixoDadoAdicional : valorFixo) {
            if (valorParametro == null || !valorParametro.equalsIgnoreCase(valorFixoDadoAdicional.getValorInformado())) continue;
            return valorFixoDadoAdicional.getDescricao();
        }
        Object found = null;
        try {
            found = CompObjectConverter.convertStrNativeValue((String)classeParametro, (String)valorParametro);
        }
        catch (Exception ex) {
            found = CompObjectConverter.convertStringToObject((String)classeParametro, (String)valorParametro);
        }
        if (found == null) {
            return "";
        }
        return CompObjectConverter.convertValueToString((String)classeParametro, (Object)found);
    }

    private void buildUserRepo() {
        if (this.userRepo != null) {
            this.biRepo.setItOutros(this.userRepo.getParamsDadosOutros());
        }
    }

    private void buildParamsSummary() throws ExceptionBuildBI {
        this.biRepo.setItDadosOutros("P_FECHO", this.dtoBI.getFechoBI());
        LinkedList data = new LinkedList();
        if (this.perfil != null && this.perfil.getAssinaturaEletronicaBIPref() != null) {
            AssinaturaEletBICert c = this.perfil.getAssinaturaEletronicaBIPref().getAssinaturaEletronicaBI().getCertificados();
            try {
                if (ToolCertificado.isExpired((InputStream)new ByteArrayInputStream(c.getConfiguracaoCertificado().getArquivoPFX()), (String)c.getConfiguracaoCertificado().getSenha())) {
                    throw new ExceptionBuildBI("E.ERP.0747.022", new Object[]{c.getConfiguracaoCertificado()});
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("F_ASSINATURA_NOME", c.getPessoaAssinatura().getNome());
                this.biRepo.setItDadosAd("P_ASSINATURA_NOME", c.getPessoaAssinatura().getNome());
                m.put("F_ASSINATURA_ELETRONICA", (short)1);
                this.biRepo.setItDadosAd("P_ASSINATURA_ELETRONICA", (short)1);
                m.put("F_ASSINATURA_DATA", new Date());
                this.biRepo.setItDadosAd("P_ASSINATURA_DATA", new Date());
                if (ToolMethods.isStrWithData((String)c.getImgAssinatura())) {
                    byte[] img = ToolBase64.decodeBase64((String)c.getImgAssinatura());
                    BufferedImage im = ImageIO.read(new ByteArrayInputStream(img));
                    m.put("F_ASSINATURA_IMG", im);
                    this.biRepo.setItDadosAd("P_ASSINATURA_IMG", im);
                }
                this.putDoc(m, c.getPessoaAssinatura().getComplemento().getCnpj(), c);
                data.add(m);
            }
            catch (ExceptionCertificado ex) {
                throw new ExceptionBuildBI("E.ERP.0747.012", new Object[]{c.getPessoaAssinatura(), ex.getFormattedMessage()});
            }
            catch (ExceptionDecodeHexString64 ex) {
                throw new ExceptionBuildBI("E.ERP.0747.012", new Object[]{c.getPessoaAssinatura(), ex.getFormattedMessage()});
            }
            catch (IOException ex) {
                throw new ExceptionBuildBI("E.ERP.0747.012", new Object[0]);
            }
        }
        for (DTOBusinessIntelligenceDet.DTOBusinessIntelligencePrefAss ass : this.dtoBI.getAssinaturasBI()) {
            String doc = ass.getDocumentoIdentificacao();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("F_ASSINATURA_NOME", ass.getNome());
            m.put("F_ASSINATURA_CARGO", ass.getCargo());
            m.put("F_ASSINATURA_DATA", new Date());
            m.put("F_ASSINATURA_ELETRONICA", (short)0);
            m.put("F_ASSINATURA_DOC", doc);
            data.add(m);
        }
        this.biRepo.setItDadosOutros("P_ASSINATURAS", data);
    }

    private void buildDefParamsOpcionais() {
        for (BusinessIntelligenceInfParam param : this.bi.getBusinessIntelligenceInf().getParametrosOpcionaisImpressao()) {
            String value = TString.onlyNumbers((String)param.getValorParametro());
            if (!TMethods.isStrWithData((String)value)) continue;
            this.biRepo.setItDadosOutros(param.getChave(), Short.valueOf(value));
        }
    }

    private Object emptyIfNull(String strParam) {
        if (strParam == null) {
            return "";
        }
        return strParam;
    }

    private void putDoc(Map m, String cpfCnpj, AssinaturaEletBICert c) throws ExceptionBuildBI {
        if (ValidadeCPFCNPJ.isCNPJ((String)cpfCnpj)) {
            if (!ValidadeCPFCNPJ.isValidCnpj((String)cpfCnpj)) {
                throw new ExceptionBuildBI("E.ERP.0747.011", new Object[]{cpfCnpj});
            }
            m.put("F_ASSINATURA_CNPJ", (short)1);
            m.put("F_ASSINATURA_CPF", (short)0);
        } else {
            if (!ValidadeCPFCNPJ.isValideCPF((String)cpfCnpj)) {
                throw new ExceptionBuildBI("E.ERP.0747.011", new Object[]{cpfCnpj});
            }
            m.put("F_ASSINATURA_CNPJ", (short)0);
            m.put("F_ASSINATURA_CPF", (short)1);
        }
        m.put("F_ASSINATURA_DOC", ToolFormatter.formatCNPJCPF((String)cpfCnpj));
    }
}

