/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoGeracao;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.AuxBuildOutput;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.AuxParamsBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl.BIArqBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl.BIHQLBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl.BIJavaCodeBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl.BIObjectBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl.BISQLBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParametersBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBIUser;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper.BIJasperPrintOutputter;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligencepref.ServiceBusinessIntelligencePrefImpl;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class ServiceBuildBusinessIntelligenceImpl
extends ServiceGenericImpl {
    @Autowired
    CompBIDefaultParams compParamsObj;
    @Autowired
    private ServiceBusinessIntelligenceImpl serviceBI;
    @Autowired
    private DaoBuildBusinessIntelligenceImpl daoBuildBI;
    @Autowired
    private ServiceBusinessIntelligencePrefImpl servicePref;
    @Autowired
    private HelperBusinessIntelligence helper;

    public DataResultBI gerarBI(DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros) throws ExceptionBuildBI {
        BusinessIntelligence bi = (BusinessIntelligence)this.serviceBI.get(det.getIdentificador());
        return this.gerarBI(det, bi, perfil, params, outrosParametros);
    }

    public DataResultBI gerarBI(DTOBusinessIntelligenceDet det, BusinessIntelligence bi, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros) throws ExceptionBuildBI {
        return this.gerarBI(det, bi, perfil, params, outrosParametros, null, ConstEnumFormImprBI.SOMENTE_JASPER);
    }

    public DataOutputBI gerarBITestes(BusinessIntelligence bi, DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil, ConstEnumFormImprBI formato, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros, InputStream inputStream) throws ExceptionBuildBI {
        DataResultBI res = this.gerarBI(det, bi, perfil, params, outrosParametros, inputStream, formato);
        return this.converterDataResultFormatoImpBI(formato, res);
    }

    public DataOutputBI gerarBITestesInternos(BusinessIntelligence bi, ConstEnumFormImprBI formato, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros, InputStream inputStream) throws ExceptionBuildBI {
        DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(EnumConstTipoSistema.DESKTOP, params);
        DataResultBI res = this.gerarBI(det, bi, null, params, outrosParametros, inputStream, formato);
        return this.converterDataResultFormatoImpBI(formato, res);
    }

    private DataResultBI gerarBI(DTOBusinessIntelligenceDet det, BusinessIntelligence bi, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> paramsInput, DataParamsBIUser outrosParametros, InputStream inputStream, ConstEnumFormImprBI formatoSaida) throws ExceptionBuildBI {
        AuxParamsBI aux = new AuxParamsBI(paramsInput.getEmpresa(), paramsInput.getUsuario(), det, bi, outrosParametros, perfil);
        DataParametersBI params = aux.buildParams();
        perfil = this.servicePref.saveOrUpdate(perfil);
        DataResultBI dataRes = null;
        EnumConstBITipoGeracao tp = EnumConstBITipoGeracao.get((int)bi.getTipoBI().shortValue());
        switch (tp) {
            case TIPO_GERACAO_BI_OBJETOS: {
                dataRes = new BIObjectBuilder(bi, params, this.daoBuildBI).buildBI();
                dataRes.setBusinessIntelligenceDTO(det);
                dataRes.setPerfil(perfil);
                break;
            }
            case TIPO_GERACAO_BI_SQL: {
                dataRes = new BISQLBuilder(bi, params, this.daoBuildBI).buildBI();
                dataRes.setBusinessIntelligenceDTO(det);
                dataRes.setPerfil(perfil);
                break;
            }
            case TIPO_GERACAO_BI_HIBERNATE: {
                dataRes = new BIHQLBuilder(bi, params, this.daoBuildBI).buildBI();
                dataRes.setBusinessIntelligenceDTO(det);
                dataRes.setPerfil(perfil);
                break;
            }
            case TIPO_GERACAO_BI_CODIGO_JAVA: {
                dataRes = new BIJavaCodeBuilder(bi, params, this.daoBuildBI).buildBI();
                dataRes.setBusinessIntelligenceDTO(det);
                dataRes.setPerfil(perfil);
                break;
            }
            case TIPO_GERACAO_BI_ARQ: {
                dataRes = new BIArqBuilder(bi, params, this.daoBuildBI, inputStream).buildBI();
                dataRes.setBusinessIntelligenceDTO(det);
                dataRes.setPerfil(perfil);
                break;
            }
            default: {
                throw new ExceptionBuildBI("E.ERP.0747.004", new Object[]{bi});
            }
        }
        aux.buildParamsImpressaoSub();
        return dataRes;
    }

    public DataOutputBI converterDataResultJasperPrint(DataResultBI dataResultBI) throws ExceptionBuildBI {
        DataOutputBI out = new BIJasperPrintOutputter().outputData(dataResultBI, null);
        return out;
    }

    public DataOutputBI converterDataResultFormatoImpBI(ConstEnumFormImprBI formatoImpressao, DataResultBI dataResult) throws ExceptionBuildBI {
        return this.converterDataResultFormatoImpBI(formatoImpressao, dataResult, null);
    }

    public DataOutputBI converterDataResultFormatoImpBI(ConstEnumFormImprBI formatoImpressao, DataResultBI dataResult, String fileName) throws ExceptionBuildBI {
        return new AuxBuildOutput().converterDataResultFormatoImpBI(formatoImpressao, dataResult, fileName);
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, Class entityClass, Long idEntity) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            Object found = this.daoBuildBI.getEntityToBuildBI(entityClass, idEntity);
            params.putItAllObj(found);
            this.helper.buildDefValuesParams(det, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, perfil, params, null);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataResultBI gerarBI(DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        return this.gerarBI(det, perfil, params, null);
    }

    public DataOutputBI gerarConverterFormatoImpBI(DTOBusinessIntelligenceDet det, Long idPerfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        BusinessIntelligencePref perfil = (BusinessIntelligencePref)this.servicePref.get(idPerfil);
        try {
            this.helper.buildToTextPreferences(det, perfil);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
        return this.gerarConverterFormatoImpBI(det, perfil, params);
    }

    @Async
    public CompletableFuture<File> gerarConverterFormatoImpBIAsyncFile(DTOBusinessIntelligenceDet det, Long idPerfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        BusinessIntelligencePref perfil = (BusinessIntelligencePref)this.servicePref.get(idPerfil);
        try {
            this.helper.buildToTextPreferences(det, perfil);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
        DataOutputBI res = this.gerarConverterFormatoImpBI(det, perfil, params);
        return CompletableFuture.completedFuture(res.getFile());
    }

    @Async
    public CompletableFuture<File> gerarConverterFormatoImpBIAsync(DTOBusinessIntelligenceDet det, Long idPerfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI, ExceptionIO {
        BusinessIntelligencePref perfil = (BusinessIntelligencePref)this.servicePref.get(idPerfil);
        try {
            this.helper.buildToTextPreferences(det, perfil);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
        DataOutputBI res = this.gerarConverterFormatoImpBI(det, perfil, params);
        return CompletableFuture.completedFuture(res.getFile());
    }

    public DataOutputBI gerarConverterFormatoImpBI(DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        return this.gerarConverterFormatoImpBI(det, det.getFormatoSelecionado(), perfil, params);
    }

    public DataOutputBI gerarConverterFormatoImpBI(DTOBusinessIntelligenceDet det, ConstEnumFormImprBI formatoImpressao, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        DataResultBI dataRes = this.gerarBI(det, perfil, params);
        return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
    }

    public DataOutputBI gerarConverterFormatoImpBI(DTOBusinessIntelligenceDet det, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        DataResultBI dataRes = this.gerarBI(det, null, params);
        return this.converterDataResultFormatoImpBI(det.getFormatoSelecionado(), dataRes);
    }

    public DataOutputBI gerarConverterFormatoImpBITests(DTOBusinessIntelligenceDet det, BusinessIntelligence bi, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        DataResultBI dataRes = this.gerarBI(det, bi, perfil, params, null);
        ConstEnumFormImprBI formatoImpressao = det.getFormatoSelecionado();
        return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
    }

    public DataResultBI gerarBITests(BusinessIntelligence bi, DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params, EnumConstTipoSistema tipo) throws ExceptionBuildBI {
        DataResultBI dataRes = this.gerarBI(det, bi, perfil, params, null);
        return dataRes;
    }

    public DataResultBI gerarBITests(BusinessIntelligence bi, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> params, EnumConstTipoSistema tipo) throws ExceptionBuildBI {
        DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
        return this.gerarBITests(bi, det, perfil, params, tipo);
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI, ExceptionReflection {
        return this.gerarConverterFormatoImpBI(bi, tipo, params, null);
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros) throws ExceptionBuildBI, ExceptionReflection {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            this.helper.buildDefValuesParams(det, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            this.helper.reloadPref(perfil, tipo, params);
            ConstEnumFormImprBI formatoImpressao = det.getFormatoSelecionado();
            DataResultBI dataRes = this.gerarBI(det, perfil, params, outrosParametros);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI, ExceptionIO {
        return this.gerarConverterFormatoImpBI(bi, formatoImpressao, tipo, params, null);
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros) throws ExceptionBuildBI {
        try {
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            return this.gerarConverterFormatoImpBI(bi, perfil, formatoImpressao, tipo, params, outrosParametros);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarConverterFormatoImpBI(BusinessIntelligence bi, BusinessIntelligencePref perfil, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            this.helper.buildDefValuesParams(det, params);
            this.helper.reloadPref(perfil, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, perfil, params, outrosParametros);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarConverterFormatoImpBIStream(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros, InputStream inputStream) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, bi, perfil, params, outrosParametros, inputStream, formatoImpressao);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarConverterFormatoImpBIStream(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, InputStream inputStream, String fileName) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, bi, perfil, params, null, inputStream, formatoImpressao);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes, fileName);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarConverterFormatoImpBIStream(BusinessIntelligence bi, ConstEnumFormImprBI formatoImpressao, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, DataParamsBIUser outrosParametros, InputStream inputStream, String fileName) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, bi, perfil, params, outrosParametros, inputStream, formatoImpressao);
            return this.converterDataResultFormatoImpBI(formatoImpressao, dataRes, fileName);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataResultBI gerarBI(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params, Object entity) throws ExceptionBuildBI {
        try {
            params.putItAllObj(entity);
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            this.helper.buildDefValuesParams(det, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            this.helper.reloadPref(perfil, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, perfil, params, null);
            return dataRes;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataResultBI gerarBI(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI {
        try {
            DTOBusinessIntelligenceDet det = this.helper.build(bi).buildToDTO(tipo, params);
            BusinessIntelligencePref perfil = this.servicePref.getPrefDefaultOrCreate(bi, tipo, params);
            this.helper.reloadPref(perfil, tipo, params);
            DataResultBI dataRes = this.gerarBI(det, perfil, params, null);
            return dataRes;
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public DataOutputBI gerarBIdEntidade(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> params, Long idEntity, Class entityClass) throws ExceptionEmail, ExceptionBuildBI {
        DataOutputBI dataOutputBi = this.gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.PDF, EnumConstTipoSistema.MOBILE, params, entityClass, idEntity);
        return dataOutputBi;
    }

    public void gerarBIdEntidadeEnviarEmail(BusinessIntelligence bi, ServidorEmail serv, ModeloEmail mod, DefaultBIParamsMap<String, Object> params, String emails, Long idEntity, Class entityClass) throws ExceptionEmail, ExceptionBuildBI {
        if (serv == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0496.001"));
        }
        if (mod == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0132.001"));
        }
        if (emails == null || emails.length() == 0) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0748.001"));
        }
        DataOutputBI dataOutputBi = this.gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.PDF, EnumConstTipoSistema.MOBILE, params, entityClass, idEntity);
        Email email = new Email();
        email.addAnexos(new File[]{dataOutputBi.getFile()});
        email.setAssunto(mod.getTituloEmail());
        email.setCorpoMensagem(mod.getModelo());
        email.addDestinatarios(new String[]{emails});
        email.setServidor(new Email.ServidorEmail(serv.getServidor(), serv.getServidorImap(), serv.getServidorPop(), serv.getEmail(), serv.getSenha(), serv.getPortaEmail(), serv.getNaoAutenticarEmail(), serv.getLogin(), serv.getServerProperties(), serv.getGerarArquivoExtensaoEml(), serv.getDebugServer()));
        ToolSendEmail.sendEmailWithException((Email)email);
    }
}

