/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.bicode;

import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBIOutputType;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIPrepareCleanQuery;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.bicode.BaseBIParams;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.map.ToolMap;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericImpl;
import java.io.Serializable;
import java.sql.Date;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public abstract class BaseBICode
extends ValidGenericImpl<DataParamsBI> {
    private Session session;
    private BaseBIParams params;
    private BusinessIntelligence businessInteligence;
    private static TLogger logger = TLogger.get(BaseBICode.class);
    private EntityManager entityManager;

    public abstract DataResultBI processData() throws ExceptionBuildBI;

    public void isValidData(DataParamsBI params) {
    }

    public void init() {
    }

    public String getSimpleName() {
        return "BI";
    }

    public Session getSession() {
        return this.session;
    }

    public String getOutputFileName() {
        return null;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public <T> T getByID(Class<T> classe, Serializable id) {
        return (T)this.session.get(classe, id);
    }

    public Query querySql(String query) {
        return this.session.createSQLQuery(query);
    }

    public Query queryHql(String query) {
        return this.session.createQuery(query);
    }

    public Criteria criteria(Class voClass) {
        return this.session.createCriteria(voClass);
    }

    public Criteria criteria(String voClass) {
        return this.session.createCriteria(voClass);
    }

    public List toListMap(Criteria c) {
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    public List toList(Criteria c) {
        return c.list();
    }

    public Map firstResultMap(Criteria c) {
        c.setMaxResults(1);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (Map)c.uniqueResult();
    }

    public Object firstResult(Criteria c) {
        c.setMaxResults(1);
        return c.uniqueResult();
    }

    public List toListMap(Query c) {
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    public List toList(Query c) {
        return c.list();
    }

    public Map firstResultMap(Query c) {
        c.setMaxResults(1);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (Map)c.uniqueResult();
    }

    public Object firstResult(Query c) {
        c.setMaxResults(1);
        return c.uniqueResult();
    }

    public List getParamAsList(String key) {
        LinkedList ret = this.getAsList(this.getParams().getParameters().getParamsTodos(), key);
        if (ret == null) {
            ret = new LinkedList();
        }
        return ret;
    }

    public List getAsList(Map map, String key) {
        Object obj = map.get(key);
        if (obj == null) {
            return null;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            return (List)obj;
        }
        if (obj.getClass().isArray()) {
            Object[] data = (Object[])obj;
            return Arrays.asList(data);
        }
        return Arrays.asList(obj);
    }

    public Double getParamAsDouble(String key) {
        return this.getAsDouble(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Double getAsDouble(Map map, String key) {
        return (Double)map.get(key);
    }

    public Float getParamAsFloat(String key) {
        return this.getAsFloat(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Float getAsFloat(Map map, String key) {
        return (Float)map.get(key);
    }

    public Integer getParamAsInt(String key) {
        return this.getAsInt(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Integer getAsInt(Map map, String key) {
        return (Integer)map.get(key);
    }

    public Short getParamAsShort(String key) {
        return this.getAsShort(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Short getAsShort(Map map, String key) {
        return (Short)map.get(key);
    }

    public Long getParamAsLong(String key) {
        return this.getAsLong(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Long getAsLong(Map map, String key) {
        return (Long)map.get(key);
    }

    public String getParamAsString(String key) {
        return this.getAsString(this.getParams().getParameters().getParamsTodos(), key);
    }

    public String getAsString(Map map, String key) {
        return (String)map.get(key);
    }

    public java.util.Date getParamAsDate(String key) {
        return this.getAsDate(this.getParams().getParameters().getParamsTodos(), key);
    }

    public java.util.Date getAsDate(Map map, String key) {
        return (java.util.Date)map.get(key);
    }

    public Date getParamAsSQLDate(String key) {
        return this.getAsSQLDate(this.getParams().getParameters().getParamsTodos(), key);
    }

    public Date getAsSQLDate(Map map, String key) {
        return (Date)map.get(key);
    }

    public TLogger getLogger() {
        return logger;
    }

    public void doLogError(Exception ex) {
        logger.error(ex.getClass(), (Throwable)ex);
    }

    public void putParam(String key, Object value) {
        this.getParams().getParameters().getParamsOutrosParametros().put(key, value);
    }

    public void putAllParam(Map values) {
        this.getParams().getParameters().getParamsOutrosParametros().putAll(values);
    }

    public BaseBIParams getParams() {
        return this.params;
    }

    public void setParams(BaseBIParams params) {
        this.params = params;
    }

    public <T> T getBean(Class<T> beanClass) {
        return (T)ConfApplicationContext.getBean(beanClass);
    }

    public String getDialogMsg(String messageCode) {
        String ret = MessagesBaseMentor.getDialogMsg((String)messageCode, (Object[])new Object[0]);
        if (TMethods.isStrWithData((String)ret) && !this.isEquals(ret, messageCode)) {
            return ret;
        }
        if (this.getBusinessInteligence() != null && this.getBusinessInteligence().getDadosAdicionalBI() != null) {
            String aux = this.getMsgFromParam(messageCode, this.getBusinessInteligence().getDadosAdicionalBI());
            if (aux != null) {
                ret = aux;
            }
            return ret;
        }
        return ret;
    }

    private String getMsgFromParam(String messageCode, List<DadoAdicionalBI> parametros) {
        String ret = null;
        for (DadoAdicionalBI param : parametros) {
            if (TMethods.isEquals((Object)param.getChaveParametro(), (Object)messageCode)) {
                ret = param.getDescricaoParametro();
                break;
            }
            ret = this.getMsgFromParam(messageCode, param.getDadoAdicionalBIFilhos());
            if (!TMethods.isStrWithData((String)ret)) continue;
            break;
        }
        return ret;
    }

    public String prepareQuery(String str, Map params) throws ExceptionJEPParser {
        return CompBIPrepareCleanQuery.prepareAndCleanQuery(str, params);
    }

    public static List concatAndSumMaps(List<Map> data1, List<Map> data2, String[] keys, String[] toSum) {
        return ToolMap.concatAndSumMaps(data1, data2, (String[])keys, (String[])toSum);
    }

    public boolean isEquals(Object ob1, Object ob2) {
        return Objects.equals(ob1, ob2);
    }

    public boolean isNotEquals(Object ob1, Object ob2) {
        return !this.isEquals(ob1, ob2);
    }

    public EnumConstBIOutputType getOutputType() {
        return EnumConstBIOutputType.TIPO_GERACAO_NORMAL;
    }

    public <E> AuxCriteriaBuilder<E> critBuilder(Class<E> clazz) {
        return new AuxCriteriaBuilder<E>(this.getSession(), clazz);
    }

    public BusinessIntelligence getBusinessInteligence() {
        return this.businessInteligence;
    }

    public void setBusinessInteligence(BusinessIntelligence businessInteligence) {
        this.businessInteligence = businessInteligence;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

