/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl;

import com.touchcomp.basementor.model.vo.BusinessIntConsHQL;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIPrepareCleanQuery;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.BIBaseBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParametersBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.Query;
import org.hibernate.transform.ResultTransformer;

public class BIHQLBuilder
extends BIBaseBuilder
implements ResultTransformer {
    public BIHQLBuilder(BusinessIntelligence bi, DataParametersBI dpr, DaoBuildBusinessIntelligenceImpl dbbii) {
        super(bi, dpr, dbbii);
    }

    public BIHQLBuilder() {
    }

    @Override
    public DataResultBI buildBI() throws ExceptionBuildBI {
        try {
            List<Map> ret = this.buildList(this.getBi().getBusinessIntConsHQL(), this.getParams().getParamsTodosMap());
            DataResultBI d = new DataResultBI(ret);
            d.setParameters(this.convertParams(this.getParams()));
            d.setBusinessIntelligence(this.getBi());
            return d;
        }
        catch (ExceptionJEPParser ex) {
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    private List<Map> buildList(BusinessIntConsHQL b, Map parametros) throws ExceptionJEPParser {
        TreeMap aux;
        Query query = this.getQuery(b, parametros);
        List results = query.list();
        if (b.getRecursivo() != null && b.getRecursivo() == 1) {
            for (Map result : results) {
                aux = new TreeMap();
                aux.putAll(parametros);
                aux.putAll(result);
                this.buildList(b, result, aux);
            }
        }
        if (b.getConsultasHQL().size() > 0) {
            for (Map result : results) {
                aux = new TreeMap();
                aux.putAll(parametros);
                aux.putAll(result);
                for (BusinessIntConsHQL bu : b.getConsultasHQL()) {
                    this.buildList(bu, result, aux);
                }
            }
        }
        return results;
    }

    private void buildList(BusinessIntConsHQL bu, Map result, Map parametros) throws ExceptionJEPParser {
        List<Map> l = this.buildList(bu, parametros);
        result.put(bu.getNome(), l);
    }

    private void setParametro(Query s, String key, Object value) {
        if (Date.class.isInstance(value)) {
            s.setDate(key, (Date)value);
        } else if (Integer.class.isInstance(value)) {
            s.setInteger(key, ((Integer)value).intValue());
        } else if (Long.class.isInstance(value)) {
            s.setLong(key, ((Long)value).longValue());
        } else if (Short.class.isInstance(value)) {
            s.setShort(key, ((Short)value).shortValue());
        } else if (Double.class.isInstance(value)) {
            s.setDouble(key, ((Double)value).doubleValue());
        } else if (Float.class.isInstance(value)) {
            s.setFloat(key, ((Float)value).floatValue());
        } else if (String.class.isInstance(value)) {
            s.setString(key, (String)value);
        } else {
            s.setParameter(key, value);
        }
    }

    protected Query getQuery(BusinessIntConsHQL vo, Map parametros) throws ExceptionJEPParser {
        String str = vo.getQuery();
        str = CompBIPrepareCleanQuery.prepareAndCleanQuery(str, parametros);
        Query query = this.getDao().getQuery(str);
        String[] stringArray = query.getNamedParameters();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String o;
            String key = o = stringArray[i];
            Object value = parametros.get(key);
            this.setParametro(query, key, value);
        }
        query.setResultTransformer((ResultTransformer)this);
        return query;
    }

    public Object transformTuple(Object[] os, String[] strings) {
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>();
        for (int i = 0; i < os.length; ++i) {
            t.put(strings[i], os[i]);
        }
        return t;
    }

    public List transformList(List list) {
        return list;
    }
}

