/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligenceOpObj;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.OrderNodeBI;
import com.touchcomp.basementor.model.vo.WhereNodeBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.BIBaseBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParameter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParametersBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.hibernate.transform.ResultTransformer;

public class BIObjectBuilder
extends BIBaseBuilder
implements ResultTransformer {
    private AuxCriteriaBuilder auxCriteriaBuilder;
    private Map<String, DataParameter> allParams = new HashMap<String, DataParameter>();

    public BIObjectBuilder(BusinessIntelligence bi, DataParametersBI params, DaoBuildBusinessIntelligenceImpl dao) {
        super(bi, params, dao);
    }

    @Override
    public DataResultBI buildBI() throws ExceptionBuildBI {
        this.allParams.putAll(this.getParams().getParamsDadosOutros());
        this.allParams.putAll(this.getParams().getParamsDadosAdicionais());
        this.getCriteria(this.getBi().getBusinessIntelligenceObjetos().getClasseModeloBI());
        List<Map> ret = this.auxCriteriaBuilder.getResultMap();
        DataResultBI d = new DataResultBI(ret);
        d.setBusinessIntelligence(this.getBi());
        d.setParameters(this.convertParams(this.getParams()));
        return d;
    }

    private void getCriteria(ClasseModeloBI classeModeloBI) throws ExceptionBuildBI {
        if (classeModeloBI == null) {
            throw new ExceptionBuildBI("E.ERP.0747.024", new Object[0]);
        }
        try {
            this.auxCriteriaBuilder = new AuxCriteriaBuilder(this.getDao().getSession(), Class.forName(classeModeloBI.getClasse()));
            this.auxCriteriaBuilder.getCriteria().distinct(TMethods.isAffirmative((Number)this.getBi().getBusinessIntelligenceObjetos().getUsarDistinct()));
            LinkedList<Expression> groupBy = new LinkedList<Expression>();
            boolean useGroupBy = this.addFieldsSelection(classeModeloBI, groupBy);
            this.addWhere(classeModeloBI, useGroupBy, groupBy);
            this.addOrder(classeModeloBI, useGroupBy, groupBy);
            this.auxCriteriaBuilder.groupBy(groupBy);
        }
        catch (ClassNotFoundException ex) {
            TLogger.get((Object)this).error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    private boolean addFieldsSelection(ClasseModeloBI vo, List<Expression> groupBy) {
        boolean flag = false;
        boolean useDistinct = vo.getBusinessIntelligenceObjetos().getUsarDistinct() != null && vo.getBusinessIntelligenceObjetos().getUsarDistinct() == 1;
        List<CheckNodeBI> aggregation = vo.getNodosSelecao().stream().filter(i -> EnumConstBusinessIntelligenceOpObj.isAggregation((Short)i.getOperacao())).collect(Collectors.toList());
        List<CheckNodeBI> common = vo.getNodosSelecao().stream().filter(i -> !EnumConstBusinessIntelligenceOpObj.isAggregation((Short)i.getOperacao())).collect(Collectors.toList());
        this.addNodes(aggregation, flag, useDistinct, false, groupBy);
        this.addNodes(common, flag, useDistinct, !aggregation.isEmpty(), groupBy);
        return !aggregation.isEmpty();
    }

    private boolean addNodes(List<CheckNodeBI> nodes, boolean flag, boolean useDistinct, boolean useGroupBy, List<Expression> groupBy) {
        for (CheckNodeBI c : nodes) {
            From from = this.getFrom(c.getFullPathAtributo());
            this.addProperty(from, c.getAtributo(), useDistinct, flag, c, useGroupBy, groupBy);
        }
        return flag;
    }

    private boolean addProperty(From from, String field, boolean useDistinct, boolean flag, CheckNodeBI c, boolean useGroupBy, List<Expression> groupBy) {
        EnumConstBusinessIntelligenceOpObj op = EnumConstBusinessIntelligenceOpObj.get((Object)c.getOperacao());
        if (op == null) {
            op = EnumConstBusinessIntelligenceOpObj.OP_NENHUMA;
        }
        switch (op) {
            case OP_AVG: {
                this.auxCriteriaBuilder.avg(AuxCriteriaBuilder.pair(from, field, c.getDescricao()));
                break;
            }
            case OP_SUM: {
                this.auxCriteriaBuilder.sum(AuxCriteriaBuilder.pair(from, field, c.getDescricao()));
                break;
            }
            case OP_COUNT: {
                this.auxCriteriaBuilder.count(AuxCriteriaBuilder.pair(from, field, c.getDescricao()));
                break;
            }
            case OP_MAX: {
                this.auxCriteriaBuilder.max(AuxCriteriaBuilder.pair(from, field, c.getDescricao()));
                break;
            }
            case OP_MIN: {
                this.auxCriteriaBuilder.min(AuxCriteriaBuilder.pair(from, field, c.getDescricao()));
                break;
            }
            default: {
                if (!useGroupBy) {
                    this.auxCriteriaBuilder.select(from, AuxCriteriaBuilder.pair(field, c.getDescricao()));
                    break;
                }
                this.auxCriteriaBuilder.groupBySelect(from, AuxCriteriaBuilder.pair(field, c.getDescricao()));
                groupBy.add(this.auxCriteriaBuilder.getExpression(from, field));
            }
        }
        return flag;
    }

    private void addOrder(ClasseModeloBI vo, boolean useGroupBy, List<Expression> groupBy) throws ExceptionBuildBI {
        for (OrderNodeBI c : vo.getNodosOrdenacao()) {
            From f = this.getFrom(c.getFullPathAtributo());
            if (c.getCheckNodeBI() != null) {
                Expression expression = this.getExpression(f, c.getCheckNodeBI().getOperacao(), c.getAtributo());
                if (c.getOpcao() == 0) {
                    this.auxCriteriaBuilder.orderAsc(f, expression);
                    continue;
                }
                this.auxCriteriaBuilder.orderDesc(f, expression);
                continue;
            }
            if (c.getOpcao() == 0) {
                this.auxCriteriaBuilder.orderAsc(f, c.getAtributo());
            } else {
                this.auxCriteriaBuilder.orderDesc(f, c.getAtributo());
            }
            if (!useGroupBy) continue;
            this.auxCriteriaBuilder.groupBy(f, new AuxCriteriaBuilder.Pair(f, c.getAtributo()));
            groupBy.add(this.auxCriteriaBuilder.getExpression(f, c.getAtributo()));
        }
    }

    private void addWhere(ClasseModeloBI cl, boolean useGroupBy, List<Expression> groupBy) throws ExceptionBuildBI {
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        LinkedList<Predicate> having = new LinkedList<Predicate>();
        this.addWhere(cl.getNodosCondicao(), predicates, having, useGroupBy, groupBy);
        this.auxCriteriaBuilder.where(predicates);
        this.auxCriteriaBuilder.having(having);
    }

    private Predicate getPredicate(WhereNodeBI c, Predicate ... predicates) {
        Predicate current = c.getOpcao() == 1 ? this.auxCriteriaBuilder.getOr(predicates) : this.auxCriteriaBuilder.getAnd(predicates);
        return current;
    }

    private void addWhere(List<WhereNodeBI> list, List<Predicate> predicates, List<Predicate> having, boolean useGroupBy, List<Expression> groupBy) throws ExceptionBuildBI {
        for (WhereNodeBI c : list) {
            Predicate aux;
            DataParameter param;
            if (c.getOpcao() != 99 && !c.getFilhos().isEmpty()) {
                Predicate disConj;
                LinkedList<Predicate> auxPredicates = new LinkedList<Predicate>();
                LinkedList<Predicate> auxHaving = new LinkedList<Predicate>();
                this.addWhere(c.getFilhos(), auxPredicates, auxHaving, useGroupBy, groupBy);
                if (!auxPredicates.isEmpty()) {
                    disConj = this.getPredicate(c, auxPredicates.toArray(new Predicate[0]));
                    predicates.add(disConj);
                }
                if (auxHaving.isEmpty()) continue;
                disConj = this.getPredicate(c, auxHaving.toArray(new Predicate[0]));
                having.add(disConj);
                continue;
            }
            if (c.getOperacao() == null) continue;
            Object param1 = null;
            Object param2 = null;
            Object chave = c.getChave();
            if (!ToolMethods.isStrWithData((String)chave)) {
                chave = c.getAtributo();
            }
            if ((param = this.allParams.get(chave)) == null) {
                chave = c.getAtributo();
                if (c.getFullPathAtributo() != null) {
                    chave = c.getFullPathAtributo() + (String)chave;
                }
            }
            if ((param = this.allParams.get(chave)) == null) {
                throw new ExceptionBuildBI("Parametro " + c.getChave() + " nao esta presente.", new Object[0]);
            }
            param1 = param.getValue();
            param2 = param.getValue1();
            EnumConstantsCriteria op = param.getOperation();
            From from = this.getFrom(c.getFullPathAtributo());
            if (c.getCheckNodeBI() != null) {
                Expression expression = this.getExpression(from, c.getCheckNodeBI().getOperacao(), c.getAtributo());
                aux = this.getDao().getPredicate(this.auxCriteriaBuilder.getBuilder(), expression, c.getAtributo(), c.getClasse(), op, param1, param2);
                having.add(aux);
                continue;
            }
            aux = this.getDao().getPredicate(this.auxCriteriaBuilder.getBuilder(), this.auxCriteriaBuilder.getCriteria(), from, c.getAtributo(), c.getClasse(), op, param1, param2);
            predicates.add(aux);
        }
    }

    public Object transformTuple(Object[] os, String[] strings) {
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>();
        for (int i = 0; i < os.length; ++i) {
            t.put(strings[i], os[i]);
        }
        return t;
    }

    public List transformList(List list) {
        return list;
    }

    private From getFrom(String fullPathAtributo) {
        String str = fullPathAtributo;
        str = str != null ? str : "";
        StringTokenizer sk = new StringTokenizer(str, ".");
        Join from = this.auxCriteriaBuilder.from();
        while (sk.hasMoreTokens()) {
            String token = sk.nextToken();
            from = this.auxCriteriaBuilder.joinLeft((From)from, token);
        }
        return from;
    }

    private Expression getExpression(From from, Short operacao, String field) throws ExceptionBuildBI {
        EnumConstBusinessIntelligenceOpObj type = EnumConstBusinessIntelligenceOpObj.get((Object)operacao);
        if (type == null) {
            type = EnumConstBusinessIntelligenceOpObj.OP_NENHUMA;
        }
        return switch (type) {
            case EnumConstBusinessIntelligenceOpObj.OP_AVG -> this.auxCriteriaBuilder.getAvgExpression(AuxCriteriaBuilder.pair(from, field));
            case EnumConstBusinessIntelligenceOpObj.OP_SUM -> this.auxCriteriaBuilder.getSumExpression(AuxCriteriaBuilder.pair(from, field));
            case EnumConstBusinessIntelligenceOpObj.OP_COUNT -> this.auxCriteriaBuilder.getCountExpression(AuxCriteriaBuilder.pair(from, field));
            case EnumConstBusinessIntelligenceOpObj.OP_MAX -> this.auxCriteriaBuilder.getMaxExpression(AuxCriteriaBuilder.pair(from, field));
            case EnumConstBusinessIntelligenceOpObj.OP_MIN -> this.auxCriteriaBuilder.getMinExpression(AuxCriteriaBuilder.pair(from, field));
            default -> throw new ExceptionBuildBI("", new Object[0]);
        };
    }
}

