/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.impl;

import com.touchcomp.basementor.model.vo.BusinessIntConsSQL;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIPrepareCleanQuery;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.builder.BIBaseBuilder;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParametersBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.Query;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;

public class BISQLBuilder
extends BIBaseBuilder
implements ResultTransformer {
    public BISQLBuilder(BusinessIntelligence bi, DataParametersBI params, DaoBuildBusinessIntelligenceImpl dao) {
        super(bi, params, dao);
    }

    public BISQLBuilder() {
    }

    @Override
    public DataResultBI buildBI() throws ExceptionBuildBI {
        try {
            List<Map> data = this.buildList(this.getBi().getBusinessIntConsSQL(), this.getParams().getParamsTodosMap());
            DataResultBI ret = new DataResultBI(data);
            ret.setBusinessIntelligence(this.getBi());
            ret.setParameters(this.convertParams(this.getParams()));
            return ret;
        }
        catch (ExceptionJEPParser ex) {
            throw new ExceptionBuildBI("", (Throwable)ex, new Object[0]);
        }
    }

    private List<Map> buildList(BusinessIntConsSQL b, Map parametros) throws ExceptionJEPParser {
        TreeMap aux;
        if (b.getQuery() == null || b.getQuery().trim().length() == 0) {
            throw new RuntimeException("Informe a consulta para cada query.");
        }
        Query query = this.getQuery(b, parametros);
        List results = query.list();
        if (b.getRecursivo() != null && b.getRecursivo() == 1) {
            for (Map result : results) {
                aux = new TreeMap();
                aux.putAll(parametros);
                aux.putAll(result);
                this.buildList(b, result, aux);
            }
        }
        if (b.getConsultasSQL().size() > 0) {
            for (Map result : results) {
                aux = new TreeMap();
                aux.putAll(parametros);
                aux.putAll(result);
                for (BusinessIntConsSQL bu : b.getConsultasSQL()) {
                    this.buildList(bu, result, aux);
                }
            }
        }
        return results;
    }

    private void buildList(BusinessIntConsSQL bu, Map result, Map parametros) throws ExceptionJEPParser {
        List<Map> l = this.buildList(bu, parametros);
        result.put(bu.getNome(), l);
    }

    private void setParametro(Query s, String key, Object value) {
        if (Date.class.isInstance(value)) {
            s.setDate(key, (Date)value);
        } else if (Integer.class.isInstance(value)) {
            s.setInteger(key, ((Integer)value).intValue());
        } else if (Long.class.isInstance(value)) {
            s.setLong(key, ((Long)value).longValue());
        } else if (Short.class.isInstance(value)) {
            s.setShort(key, ((Short)value).shortValue());
        } else if (Double.class.isInstance(value)) {
            s.setDouble(key, ((Double)value).doubleValue());
        } else if (Float.class.isInstance(value)) {
            s.setFloat(key, ((Float)value).floatValue());
        } else if (String.class.isInstance(value)) {
            s.setString(key, (String)value);
        } else {
            s.setParameter(key, value);
        }
    }

    protected Query getQuery(BusinessIntConsSQL vo, Map parametros) throws ExceptionJEPParser {
        String str = vo.getQuery();
        str = CompBIPrepareCleanQuery.prepareAndCleanQuery(str, parametros);
        NativeQuery query = this.getDao().sqlQuery(str);
        String[] stringArray = query.getNamedParameters();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String o;
            String key = o = stringArray[i];
            Object value = parametros.get(key);
            this.setParametro((Query)query, key, value);
        }
        query.setResultTransformer((ResultTransformer)this);
        return query;
    }

    public Object transformTuple(Object[] os, String[] strings) {
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>();
        for (int i = 0; i < os.length; ++i) {
            t.put(strings[i], os[i]);
        }
        return t;
    }

    public List transformList(List list) {
        return list;
    }
}

