/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter;

import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.Date;

public abstract class BIBaseOutputter {
    protected static final TLogger logger = TLogger.get(BIBaseOutputter.class);

    public abstract DataOutputBI outputData(DataResultBI var1, String var2) throws ExceptionBuildBI;

    public File createTempFile(DataResultBI dataResult, String prefix, String sufix) throws ExceptionIO, ExceptionBuildBI {
        if (sufix != null && !((String)sufix).startsWith(".")) {
            sufix = "." + (String)sufix;
        }
        File output = this.createTempFile(dataResult, null, prefix, (String)sufix);
        return output;
    }

    public File createTempFile(DataResultBI dataResult, String fileNameInp, String prefix, String sufix) throws ExceptionIO, ExceptionBuildBI {
        if (sufix == null) {
            throw new ExceptionErroProgramacao("Necessario informar sufixo do BI.");
        }
        File output = this.getOutputFile(fileNameInp, dataResult, prefix, sufix);
        if (ToolMethods.isStrWithData((String)fileNameInp) && output.exists() && !output.delete()) {
            throw new ExceptionBuildBI("E.GEN.000027", new Object[]{output.getName(), output.getParent()});
        }
        return output;
    }

    private File getOutputFile(String fileNameParam, DataResultBI dataResult, String prefix, String sufix) {
        String baseFileName = "";
        if (TMethods.isStrWithData((String)fileNameParam)) {
            baseFileName = fileNameParam;
            baseFileName = this.appendSuffix(baseFileName, sufix);
            return ToolFile.createTempFile((String)baseFileName);
        }
        if (dataResult != null && TMethods.isStrWithData((String)dataResult.getFileOutputName())) {
            baseFileName = dataResult.getFileOutputName();
            baseFileName = this.appendSuffix(baseFileName, sufix);
            return ToolFile.createTempFile((String)baseFileName);
        }
        if (dataResult != null && dataResult.getBusinessIntelligence() != null && dataResult.getBusinessIntelligence().getBusinessIntelligenceInf() != null && TMethods.isStrWithData((String)dataResult.getBusinessIntelligence().getBusinessIntelligenceInf().getNomeArquivoGerado())) {
            baseFileName = dataResult.getBusinessIntelligence().getBusinessIntelligenceInf().getNomeArquivoGerado();
            baseFileName = this.getFileName(baseFileName, null, sufix);
            return ToolFile.createTempFile((String)baseFileName);
        }
        if (dataResult != null && dataResult.getBusinessIntelligence() != null) {
            baseFileName = String.valueOf(dataResult.getBusinessIntelligence().getIdentificador());
        }
        String fileName = this.getFileName(baseFileName, prefix, sufix);
        File output = ToolFile.createTempFile((String)fileName);
        return output;
    }

    private String appendSuffix(String fileName, String sufix) {
        if (!((String)fileName).endsWith(sufix)) {
            int index = ((String)fileName).lastIndexOf(".");
            if (index >= 0) {
                fileName = ((String)fileName).substring(0, index);
            }
            fileName = (String)fileName + sufix;
        }
        return fileName;
    }

    private String getFileName(String idBI, String prefix, String sufix) {
        Object name = "";
        if (TMethods.isStrWithData((String)prefix)) {
            name = (String)name + prefix + "_";
        }
        if (TMethods.isStrWithData((String)idBI)) {
            name = (String)name + idBI + "_";
        }
        name = (String)name + new Date().getTime();
        name = this.appendSuffix((String)name, sufix);
        return name;
    }
}

