/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementortools.tools.map.ToolMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BICSVDiretoOutputter
extends BIBaseOutputter {
    private Set<String> cabecalho = new HashSet<String>();

    @Override
    public DataOutputBI outputData(DataResultBI data, String fileName) throws ExceptionBuildBI {
        try {
            File arquivo = this.createTempFile(data, fileName, ConstEnumFormImprBI.EXCEL_DIRETO_CSV.getExtensao());
            arquivo.deleteOnExit();
            ArrayList<Map> aux = new ArrayList();
            if (data.getData() != null) {
                aux = ToolMap.resumeMaps(data.getData());
            }
            FileWriter out = new FileWriter(arquivo);
            this.createCabe(aux);
            this.writeCabec(aux, out);
            this.writeOnFile(aux, out);
            out.flush();
            out.close();
            DataOutputBI d = new DataOutputBI();
            d.setFile(arquivo);
            return d;
        }
        catch (IOException ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
        catch (ExceptionIO ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
    }

    private void checkFields(Map mapInp, List<Map> ret, List keyCache) {
        boolean containsCollection = false;
        Set keys = mapInp.keySet();
        for (Object key : keys) {
            Object found = mapInp.get(key);
            if (!(found instanceof Collection) || ((Collection)found).isEmpty() || keyCache.contains(key)) continue;
            keyCache.add(key);
            this.addToMap(mapInp, (Collection)found, ret, keyCache);
            containsCollection = true;
        }
        if (!containsCollection) {
            ret.add(mapInp);
        }
    }

    private void addToMap(Map mapInp, Collection<Map> collection, List<Map> ret, List keyCache) {
        for (Map map : collection) {
            map.putAll(mapInp);
            this.checkFields(map, ret, keyCache);
        }
    }

    private void writeCabec(List<Map> aux, FileWriter out) throws IOException {
        for (String str : this.cabecalho) {
            out.write(str);
            out.write(";");
        }
        out.write("\r\n");
    }

    private void writeOnFile(List<Map> aux, FileWriter out) throws IOException {
        for (Map map : aux) {
            for (String key : this.cabecalho) {
                Object ob = map.get(key);
                if (ob != null) {
                    out.write(String.valueOf(ob));
                }
                out.write(";");
            }
            out.write("\r\n");
        }
    }

    private void createCabe(List<Map> aux) {
        if (aux.isEmpty()) {
            return;
        }
        this.cabecalho = aux.get(0).keySet();
    }
}

