/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementortools.tools.map.ToolMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;

public class BIExcelDiretoOutputter
extends BIBaseOutputter {
    private final List<String> cabecalho = new LinkedList<String>();
    private CellStyle numberCellStille;
    private CellStyle dateCellStyle;

    @Override
    public DataOutputBI outputData(DataResultBI data, String fileName) throws ExceptionBuildBI {
        try {
            File arquivo = this.createTempFile(data, fileName, ConstEnumFormImprBI.EXCEL_XLS.getExtensao());
            arquivo.deleteOnExit();
            HSSFWorkbook wb = new HSSFWorkbook();
            String sheetName = "BI";
            HSSFSheet sheet1 = wb.createSheet(sheetName);
            List aux = new ArrayList<Map>();
            if (data.getData() != null) {
                aux = ToolMap.resumeMaps(data.getData());
            }
            this.appendCabecalho(aux);
            this.appendToFileMain(sheet1, 1, aux, wb);
            this.createCabecalho(sheet1);
            FileOutputStream movimento = null;
            movimento = new FileOutputStream(arquivo);
            wb.write((OutputStream)movimento);
            movimento.flush();
            movimento.close();
            DataOutputBI out = new DataOutputBI();
            out.setFile(arquivo);
            return out;
        }
        catch (IOException ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
        catch (ExceptionIO ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionBuildBI("E.ERP.0747.027", (Throwable)ex, new Object[0]);
        }
    }

    private void createCabecalho(HSSFSheet sheet1) {
        HSSFRow row = sheet1.createRow(0);
        int i = 0;
        Iterator<String> iterator = this.cabecalho.iterator();
        while (iterator.hasNext()) {
            String o;
            String aux = o = iterator.next();
            row.createCell(i).setCellValue(aux);
            ++i;
        }
    }

    private void appendToFileMain(HSSFSheet sheet1, int rowCount, List<Map> resultados, HSSFWorkbook wb) {
        int collumnCount = 0;
        for (Map map : resultados) {
            HSSFRow row = sheet1.createRow(rowCount);
            this.appendToFile(row, map, collumnCount, wb);
            ++rowCount;
        }
    }

    private void appendToFile(HSSFRow row, Map map, int collumnCount, HSSFWorkbook wb) {
        for (String key : this.cabecalho) {
            HSSFCell cell;
            Object object = map.get(key);
            if (object instanceof Date) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleDate(wb));
                cell.setCellValue((Date)object);
                ++collumnCount;
                continue;
            }
            if (object instanceof Float) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                ++collumnCount;
                continue;
            }
            if (object instanceof Double) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                ++collumnCount;
                continue;
            }
            if (object instanceof BigDecimal) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                ++collumnCount;
                continue;
            }
            if (object instanceof Number) {
                cell = row.createCell(collumnCount);
                cell.setCellValue(Double.parseDouble(object.toString()));
                ++collumnCount;
                continue;
            }
            if (object instanceof Collection) {
                ++collumnCount;
                continue;
            }
            if (object != null) {
                row.createCell(collumnCount).setCellValue(object.toString());
                ++collumnCount;
                continue;
            }
            row.createCell(collumnCount).setCellValue("");
            ++collumnCount;
        }
    }

    private void appendCabecalho(List<Map> maps) {
        int count = -1;
        for (Map m : maps) {
            Set keySet = m.keySet();
            if (count != -1 && keySet.size() == count) continue;
            for (Object key : keySet) {
                this.addToCabecalho(key);
            }
        }
    }

    private void addToCabecalho(Object key) {
        if (!this.cabecalho.contains(String.valueOf(key))) {
            this.cabecalho.add(String.valueOf(key));
        }
    }

    private void checkFields(Map mapInp, List<Map> ret, List keyCache) {
        boolean containsCollection = false;
        Set keys = mapInp.keySet();
        for (Object key : keys) {
            Object found = mapInp.get(key);
            if (!(found instanceof Collection) || ((Collection)found).isEmpty() || keyCache.contains(key)) continue;
            keyCache.add(key);
            this.addToMap(mapInp, (Collection)found, ret, keyCache);
            containsCollection = true;
        }
        if (!containsCollection) {
            ret.add(mapInp);
        }
    }

    private void addToMap(Map mapInp, Collection<Map> collection, List<Map> ret, List keyCache) {
        for (Map map : collection) {
            map.putAll(mapInp);
            this.checkFields(map, ret, keyCache);
        }
    }

    private CellStyle getCellStyleDate(HSSFWorkbook wb) {
        if (this.dateCellStyle == null) {
            this.dateCellStyle = wb.createCellStyle();
            short df = wb.createDataFormat().getFormat("dd/MM/yyyy HH:mm:ss");
            this.dateCellStyle.setDataFormat(df);
        }
        return this.dateCellStyle;
    }

    private CellStyle getCellStyleNumberDec(HSSFWorkbook wb) {
        if (this.numberCellStille == null) {
            this.numberCellStille = wb.createCellStyle();
            short df = wb.createDataFormat().getFormat(".##0,00");
            this.numberCellStille.setDataFormat(df);
        }
        return this.numberCellStille;
    }
}

