/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementortools.tools.map.ToolMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BIExcelXlsxDiretoOutputter
extends BIBaseOutputter {
    private final List<String> cabecalho = new LinkedList<String>();
    private CellStyle numberCellStille;
    private CellStyle dateCellStyle;

    @Override
    public DataOutputBI outputData(DataResultBI data, String fileName) throws ExceptionBuildBI {
        try {
            File arquivo = this.createTempFile(data, fileName, ConstEnumFormImprBI.EXCEL_XLSX.getExtensao());
            arquivo.deleteOnExit();
            XSSFWorkbook wb = new XSSFWorkbook();
            String sheetName = "business_intelligence";
            XSSFSheet sheet1 = wb.createSheet(sheetName);
            ArrayList<Map> aux = new ArrayList();
            if (data.getData() != null) {
                aux = ToolMap.resumeMaps(data.getData());
            }
            this.appendToFileMain(sheet1, 1, aux, wb);
            this.createCabecalho(sheet1);
            FileOutputStream movimento = null;
            movimento = new FileOutputStream(arquivo);
            wb.write((OutputStream)movimento);
            movimento.flush();
            movimento.close();
            DataOutputBI out = new DataOutputBI();
            out.setFile(arquivo);
            return out;
        }
        catch (IOException ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
        catch (ExceptionIO ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
    }

    private void createCabecalho(XSSFSheet sheet1) {
        XSSFRow row = sheet1.createRow(0);
        int i = 0;
        Iterator<String> iterator = this.cabecalho.iterator();
        while (iterator.hasNext()) {
            String o;
            String aux = o = iterator.next();
            row.createCell(i).setCellValue(aux);
            ++i;
        }
    }

    private void appendToFileMain(XSSFSheet sheet1, int rowCount, List<Map> resultados, XSSFWorkbook wb) {
        int collumnCount = 0;
        for (Map map : resultados) {
            XSSFRow row = sheet1.createRow(rowCount);
            this.appendToFile((Row)row, map, collumnCount, wb);
            ++rowCount;
        }
    }

    private void appendToFile(Row row, int collumnCount, List<Map> resultados, XSSFWorkbook wb) {
        for (Map map : resultados) {
            this.appendToFile(row, map, collumnCount, wb);
        }
    }

    private void appendToFile(Row row, Map map, int collumnCount, XSSFWorkbook wb) {
        Set keySet = map.keySet();
        for (Object key : keySet) {
            Cell cell;
            Object object = map.get(key);
            if (object instanceof Date) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleDate(wb));
                cell.setCellValue((Date)object);
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            if (object instanceof Float) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            if (object instanceof Double) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            if (object instanceof BigDecimal) {
                cell = row.createCell(collumnCount);
                cell.setCellStyle(this.getCellStyleNumberDec(wb));
                cell.setCellValue(Double.parseDouble(object.toString()));
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            if (object instanceof Number) {
                cell = row.createCell(collumnCount);
                cell.setCellValue(Double.parseDouble(object.toString()));
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            if (object instanceof Collection) continue;
            if (object != null) {
                row.createCell(collumnCount).setCellValue(object.toString());
                this.addToCabecalho(key);
                ++collumnCount;
                continue;
            }
            row.createCell(collumnCount).setCellValue("");
            this.addToCabecalho(key);
            ++collumnCount;
        }
    }

    private void addToCabecalho(Object key) {
        if (!this.cabecalho.contains(key) && key != null) {
            this.cabecalho.add(key.toString());
        }
    }

    private void checkFields(Map mapInp, List<Map> ret) {
        boolean containsCollection = false;
        Set keys = mapInp.keySet();
        for (Object key : keys) {
            Object found = mapInp.get(key);
            if (!(found instanceof Collection) || ((Collection)found).isEmpty()) continue;
            this.addToMap(mapInp, (Collection)found, ret);
            containsCollection = true;
        }
        if (!containsCollection) {
            ret.add(mapInp);
        }
    }

    private void addToMap(Map mapInp, Collection<Map> collection, List<Map> ret) {
        for (Map map : collection) {
            this.checkFields(map, ret);
            map.putAll(mapInp);
        }
    }

    private CellStyle getCellStyleDate(XSSFWorkbook wb) {
        if (this.dateCellStyle == null) {
            this.dateCellStyle = wb.createCellStyle();
            short df = wb.createDataFormat().getFormat("dd/MM/yyyy HH:mm:ss");
            this.dateCellStyle.setDataFormat(df);
        }
        return this.dateCellStyle;
    }

    private CellStyle getCellStyleNumberDec(XSSFWorkbook wb) {
        if (this.numberCellStille == null) {
            this.numberCellStille = wb.createCellStyle();
            short df = wb.createDataFormat().getFormat(".##0,00");
            this.numberCellStille.setDataFormat(df);
        }
        return this.numberCellStille;
    }
}

