/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.jasperprint.AuxJasperPrint;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;

public class BIJasperImageSVGOutputter
extends BIBaseOutputter {
    @Override
    public DataOutputBI outputData(DataResultBI data, String fileName) throws ExceptionBuildBI {
        File file;
        try {
            file = this.createTempFile(data, fileName, ConstEnumFormImprBI.SVG.getExtensao());
        }
        catch (ExceptionIO ex) {
            logger.error((Throwable)ex);
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
        DataOutputBI out = new DataOutputBI();
        try {
            out = new AuxJasperPrint().gerarJasperPrint(data);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.buildErrorImage(out, file);
            return out;
        }
        try {
            this.buildOutputReport(out, file);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.buildErrorImage(out, file);
        }
        return out;
    }

    public void buildOutputReport(DataOutputBI out, File file) throws ExceptionJasperReports, ExceptionIO {
        try {
            JasperPrint jasperPrint = out.getJasperPrint();
            Document document = GenericDOMImplementation.getDOMImplementation().createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGraphics2D graphics2d = new SVGGraphics2D(document);
            graphics2d.setSVGCanvasSize(new Dimension(jasperPrint.getPageWidth(), jasperPrint.getPageHeight()));
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
            output.setGraphics2D((Graphics2D)graphics2d);
            exporter.setExporterOutput((ExporterOutput)output);
            if (!jasperPrint.getPages().isEmpty()) {
                SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
                configuration.setPageIndex(Integer.valueOf(0));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
                exporter.exportReport();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter svgWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                graphics2d.stream((Writer)svgWriter);
            } else {
                InputStream in = this.getClass().getResourceAsStream("/templates_reports/imagem_relatorio_sem_dados.svg");
                ToolFile.writeBytesOnFile((File)file, (byte[])ToolFile.getBytesFromFile((InputStream)in));
            }
            out.setFile(file);
            System.out.println("File: " + file.getAbsolutePath());
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            InputStream in = this.getClass().getResourceAsStream("/templates_reports/imagem_relatorio_erro.svg");
            ToolFile.writeBytesOnFile((File)file, (byte[])ToolFile.getBytesFromFile((InputStream)in));
        }
        catch (IOException ex) {
            InputStream in = this.getClass().getResourceAsStream("/templates_reports/imagem_relatorio_erro.svg");
            ToolFile.writeBytesOnFile((File)file, (byte[])ToolFile.getBytesFromFile((InputStream)in));
        }
    }

    private void buildErrorImage(DataOutputBI out, File file) throws ExceptionBuildBI {
        InputStream in = this.getClass().getResourceAsStream("/templates_reports/imagem_relatorio_erro.svg");
        try {
            ToolFile.writeBytesOnFile((File)file, (byte[])ToolFile.getBytesFromFile((InputStream)in));
        }
        catch (ExceptionIO ex1) {
            logger.error((Throwable)ex1);
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex1, new Object[0]);
        }
        out.setFile(file);
    }
}

