/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.model.vo.AssinaturaEletronicaBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.jasperprint.AuxJasperPrint;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.pdf.ToolPDF;
import com.touchcomp.basementortools.tools.pdf.model.PDFSignParams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfReportConfiguration;

public class BIJasperPDFOutputter
extends BIBaseOutputter {
    @Override
    public DataOutputBI outputData(DataResultBI data, String fileName) throws ExceptionBuildBI {
        try {
            DataOutputBI out = new AuxJasperPrint().gerarJasperPrint(data);
            this.buildOutputReport(out, this.createTempFile(data, fileName, ConstEnumFormImprBI.PDF.getExtensao()));
            this.assinarEletronicamente(data, out);
            return out;
        }
        catch (ExceptionJasperReports ex) {
            logger.error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
        catch (ExceptionIO ex) {
            logger.error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public void buildOutputReport(DataOutputBI out, File output) throws ExceptionJasperReports {
        try {
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(out.getJasperPrint()));
            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(output));
            SimplePdfReportConfiguration config = new SimplePdfReportConfiguration();
            exporter.setConfiguration((ReportExportConfiguration)config);
            exporter.exportReport();
            out.setFile(output);
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionJasperReports("E.ERP.0747.003", (Throwable)ex);
        }
    }

    private void assinarEletronicamente(DataResultBI data, DataOutputBI out) throws ExceptionBuildBI {
        if (data.getPerfil() == null || data.getPerfil().getAssinaturaEletronicaBIPref() == null) {
            return;
        }
        AssinaturaEletronicaBI ass = data.getPerfil().getAssinaturaEletronicaBIPref().getAssinaturaEletronicaBI();
        int pageNr = 1;
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        float heigth = 0.0f;
        List pages = out.getJasperPrint().getPages();
        int count = 1;
        for (JRPrintPage page : pages) {
            List elements = page.getElements();
            for (JRPrintElement element : elements) {
                String key = element.getKey();
                if (!ToolMethods.isEqualsIgnoreCase((String)key, (String)"F_RECTANGLE_DIGI_SIGN")) continue;
                pageNr = count;
                x = element.getX();
                y = element.getY();
                width = element.getWidth();
                heigth = element.getHeight();
                break;
            }
            ++count;
        }
        try (FileInputStream fip = new FileInputStream(out.getFile());){
            PDFSignParams params = new PDFSignParams();
            params.setArquivo((InputStream)fip);
            if (ToolMethods.isWithData((Number)ass.getCertificados().getTamanhoFonte())) {
                params.setFontSize(ass.getCertificados().getTamanhoFonte().floatValue());
            }
            params.setPageNumber(pageNr);
            if (ToolMethods.isStrWithData((String)ass.getCertificados().getImgAssinatura())) {
                ByteArrayInputStream fipAssinatura = new ByteArrayInputStream(ToolBase64.decodeBase64((String)ass.getCertificados().getImgAssinatura()));
                params.setAssinaturaImg((InputStream)fipAssinatura);
            }
            ByteArrayInputStream fipCertificado = new ByteArrayInputStream(ass.getCertificados().getConfiguracaoCertificado().getArquivoPFX());
            params.getSecurity().setCertificate((InputStream)fipCertificado);
            params.getSecurity().setPassword(ass.getCertificados().getConfiguracaoCertificado().getSenha());
            params.getProperties().setContact(ass.getCertificados().getContato());
            params.getProperties().setLocation(ass.getCertificados().getLocalizacao());
            params.getProperties().setLocationCaption(ass.getCertificados().getLocalizacaoLegenda());
            params.getProperties().setReason(ass.getCertificados().getRazao());
            params.getProperties().setReasonCaption(ass.getCertificados().getRazaoLegenda());
            if (TMethods.isStrWithData((String)ass.getCertificados().getTextoAssinatura())) {
                Object text = ass.getCertificados().getTextoAssinatura();
                text = (String)text + "\n" + ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy HH:mm:ss z");
                params.getProperties().setSignText((String)text);
            }
            y = (float)out.getJasperPrint().getPageHeight() - (y + (float)out.getJasperPrint().getBottomMargin().intValue() + 30.0f);
            params.getPosition().setHeight(heigth);
            if (ToolMethods.isWithData((Number)ass.getCertificados().getAlturaQuadroAssinatura())) {
                params.getPosition().setHeight(ass.getCertificados().getAlturaQuadroAssinatura().floatValue());
            }
            params.getPosition().setWidth(width);
            if (ToolMethods.isWithData((Number)ass.getCertificados().getLarguraQuadroAssinatura())) {
                params.getPosition().setWidth(ass.getCertificados().getLarguraQuadroAssinatura().floatValue());
            }
            params.getPosition().setX(x);
            params.getPosition().setY(y);
            if (data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoHorX() != null && data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoHorX().floatValue() != 0.0f) {
                params.getPosition().setX(params.getPosition().getX() + data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoHorX().floatValue());
            } else if (ass.getCertificados().getDeslocamentoHorX() != null && ass.getCertificados().getDeslocamentoHorX().floatValue() != 0.0f) {
                params.getPosition().setX(params.getPosition().getX() + ass.getCertificados().getDeslocamentoHorX().floatValue());
            }
            if (data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoVertY() != null && data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoVertY().floatValue() != 0.0f) {
                params.getPosition().setY(params.getPosition().getY() + data.getPerfil().getAssinaturaEletronicaBIPref().getDeslocamentoVertY().floatValue());
            } else if (ass.getCertificados().getDeslocamentoVertY() != null && ass.getCertificados().getDeslocamentoVertY().floatValue() != 0.0f) {
                params.getPosition().setY(params.getPosition().getY() + ass.getCertificados().getDeslocamentoVertY().floatValue());
            }
            if (ToolMethods.isWithData((Number)data.getPerfil().getAssinaturaEletronicaBIPref().getAlturaQuadroAssinatura())) {
                params.getPosition().setHeight(data.getPerfil().getAssinaturaEletronicaBIPref().getAlturaQuadroAssinatura().floatValue());
            }
            if (ToolMethods.isWithData((Number)data.getPerfil().getAssinaturaEletronicaBIPref().getLarguraQuadroAssinatura())) {
                params.getPosition().setWidth(data.getPerfil().getAssinaturaEletronicaBIPref().getLarguraQuadroAssinatura().floatValue());
            }
            if (ToolMethods.isWithData((Number)data.getPerfil().getAssinaturaEletronicaBIPref().getPosicaoX())) {
                params.getPosition().setX(data.getPerfil().getAssinaturaEletronicaBIPref().getPosicaoX().floatValue());
            }
            if (ToolMethods.isWithData((Number)data.getPerfil().getAssinaturaEletronicaBIPref().getPosicaoY())) {
                params.getPosition().setY(data.getPerfil().getAssinaturaEletronicaBIPref().getPosicaoY().floatValue());
            }
            if (ToolMethods.isWithData((Number)data.getPerfil().getAssinaturaEletronicaBIPref().getTamanhoFonte())) {
                params.setFontSize(data.getPerfil().getAssinaturaEletronicaBIPref().getTamanhoFonte().floatValue());
            }
            File assinado = ToolPDF.assinarPDF((PDFSignParams)params);
            out.setFile(assinado);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionBuildBI("E.ERP.0747.017", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionBuildBI("E.ERP.0747.017", (Throwable)ex, new Object[]{ex.getMessage()});
        }
    }
}

