/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.impl.jasper;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.BIBaseOutputter;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class BIJasperXMLOutputter
extends BIBaseOutputter {
    @Override
    public DataOutputBI outputData(DataResultBI dataResult, String fileName) throws ExceptionBuildBI {
        try {
            File arquivo = this.createTempFile(dataResult, fileName, ConstEnumFormImprBI.XML_DIRETO.getExtensao());
            arquivo.deleteOnExit();
            Element root = new Element("data");
            this.convert(dataResult.getData(), root);
            String xml = ToolJdom.toXml((Element)root);
            ToolFile.writeStringInFile((File)arquivo, (String)xml);
            DataOutputBI d = new DataOutputBI();
            d.setFile(arquivo);
            return d;
        }
        catch (ExceptionIO ex) {
            throw new ExceptionBuildBI("E.ERP.0747.003", (Throwable)ex, new Object[0]);
        }
    }

    private void convert(List<Map> data, Element root) {
        for (Map map : data) {
            if (map == null) continue;
            Element item = new Element("item");
            root.addContent((Content)item);
            this.convert(map, item);
        }
    }

    private void convert(Map map, Element item) {
        Set keys = map.keySet();
        for (Object key : keys) {
            String name = String.valueOf(key);
            Element ele = new Element(name);
            Object value = map.get(key);
            if (value != null) {
                if (ToolReflections.isCollection(value.getClass())) {
                    this.convert((List)value, ele);
                } else if (Map.class.isAssignableFrom(value.getClass())) {
                    this.convert((Map)value, ele);
                } else if (Date.class.isAssignableFrom(value.getClass())) {
                    ele.setText(String.valueOf(((Date)value).getTime()));
                } else {
                    ele.setText(String.valueOf(value));
                }
            }
            item.addContent((Content)ele);
        }
    }
}

