/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.jasperprint;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.model.bi.BIParamPrefUser;
import com.touchcomp.basementorservice.model.bi.BIPrefUser;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.constants.DataBIConstants;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import org.apache.commons.io.IOUtils;

public class AuxJasperPrint
implements DataBIConstants {
    protected TLogger logger = TLogger.get(this.getClass());

    private File getArquivoPrincipal(BusinessIntelligence vo, DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref, File tmpDir) throws ExceptionJasperReports {
        try {
            String chaveLayout = this.getChaveLayoutSel(det, pref);
            File main = null;
            for (BusinessIntelligenceFiles b : vo.getBusinessIntelligenceFiles()) {
                File tmp = this.salvarTMPFile(b, tmpDir);
                if ((b.getArquivoPrincipal() != 1 || !TMethods.isEquals((Object)chaveLayout, (Object)b.getChaveLayout())) && (chaveLayout != null || main != null)) continue;
                main = tmp;
            }
            if (main == null || vo.getBusinessIntelligenceFiles().isEmpty()) {
                if (TMethods.isStrWithData((String)chaveLayout)) {
                    throw new ExceptionJasperReports("E.ERP.0747.006", new Object[]{chaveLayout});
                }
                throw new ExceptionJasperReports("E.ERP.0747.005", new Object[0]);
            }
            return main;
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionJasperReports("E.ERP.0747.007", new Object[]{ex.getMessage()});
        }
        catch (ExceptionIO ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionJasperReports("E.ERP.0747.007", new Object[]{ex.getMessage()});
        }
    }

    private File salvarTMPFile(BusinessIntelligenceFiles b, File tmpDir) throws FileNotFoundException, IOException {
        String path = tmpDir.getAbsolutePath() + File.separator + b.getNome() + ".jasper";
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fo = new FileOutputStream(f);
        fo.write(b.getSourceJasper());
        fo.flush();
        fo.close();
        return f;
    }

    public DataOutputBI gerarJasperPrint(DataResultBI vo) throws ExceptionJasperReports {
        File tmpDir = new File(ToolFile.getTMPDir() + File.separator + new Date().getTime());
        tmpDir.mkdirs();
        try {
            DataOutputBI out;
            String path;
            this.writeDataSub(tmpDir);
            File pathOb = this.getArquivoPrincipal(vo.getBusinessIntelligence(), vo.getBusinessIntelligenceDTO(), vo.getPerfil(), tmpDir);
            Map<String, Object> params = vo.getParameters().getParamsTodos();
            List<Map> ds = null;
            InputStream xml = null;
            String tagXmlInicial = null;
            if (vo.getXml() == null && vo.getTagInicialXml() == null) {
                ds = vo.getData();
            } else {
                xml = vo.getXml();
                tagXmlInicial = vo.getTagInicialXml();
            }
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            if (pathOb instanceof File) {
                File file = pathOb;
                if (!file.exists()) {
                    throw new ExceptionJasperReports("E.ERP.0747.020", new Object[]{file.getAbsolutePath()});
                }
                path = file.getAbsolutePath();
            } else {
                path = ((Object)pathOb).toString();
            }
            params.put("REPORT_LOCALE", Locale.getDefault());
            params.put("REPORT_RESOURCE_BUNDLE", MessagesBaseMentor.getResourceBundleReports());
            System.out.println(path);
            JasperPrint jp = null;
            jp = xml != null && tagXmlInicial != null ? JasperFillManager.fillReport((String)path, params, (JRDataSource)new JRXmlDataSource(xml, tagXmlInicial)) : JasperFillManager.fillReport((String)path, params, (JRDataSource)new JRBeanCollectionDataSource(ds));
            AuxJasperPrint.correctPageNumbers(jp);
            DataOutputBI dataOutputBI = out = new DataOutputBI(jp);
            return dataOutputBI;
        }
        catch (IOException e) {
            throw new ExceptionJasperReports("E.ERP.0747.003", (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (JRException ex) {
            throw new ExceptionJasperReports("E.ERP.0747.003", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        finally {
            ToolFile.delete((File)tmpDir);
        }
    }

    protected static void correctPageNumbers(JasperPrint jasperPrint) {
        List listPages = jasperPrint.getPages();
        int numberOfPages = listPages.size();
        int currentPageIndex = 1;
        for (JRPrintPage currentPage : listPages) {
            List listElements = currentPage.getElements();
            for (Object element : listElements) {
                if (!(element instanceof JRTemplatePrintText)) continue;
                JRTemplatePrintText templatePrintText = (JRTemplatePrintText)element;
                if (templatePrintText.getKey() != null && templatePrintText.getKey().equalsIgnoreCase("textFieldCurrentPage")) {
                    templatePrintText.setText(String.valueOf(currentPageIndex));
                }
                if (templatePrintText.getKey() == null || !templatePrintText.getKey().equalsIgnoreCase("textFieldNumberOfPages")) continue;
                templatePrintText.setText(String.valueOf(numberOfPages));
            }
            ++currentPageIndex;
        }
    }

    public void writeDataSub(File tmpDir) throws FileNotFoundException, IOException {
        FileOutputStream out;
        InputStream in;
        File f = new File(tmpDir.getAbsolutePath() + File.separator + "DEFAULT_REPORT_STYLE.jrtx");
        if (!f.exists()) {
            in = this.getStreeamTemplate();
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_CABECALHO_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalPortrait("SUB_CABECALHO_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_RODAPE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalPortrait("SUB_RODAPE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_RODAPE_LAST_PAGE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalPortrait("SUB_RODAPE_LAST_PAGE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_SUMARY_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalPortrait("SUB_SUMARY_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_SUMARY_BI_ASSINATURAS_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalPortrait("SUB_SUMARY_BI_ASSINATURAS_2.jasper");
            out = new FileOutputStream(f);
            if (ToolMethods.isNotNull((Object)in).booleanValue()) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_CABECALHO_LANDSCAPE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalLandscape("SUB_CABECALHO_LANDSCAPE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_RODAPE_LANDSCAPE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalLandscape("SUB_RODAPE_LANDSCAPE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_RODAPE_LAST_PAGE_LANDSCAPE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalLandscape("SUB_RODAPE_LAST_PAGE_LANDSCAPE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_SUMARY_LANDSCAPE_BI_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalLandscape("SUB_SUMARY_LANDSCAPE_BI_2.jasper");
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "SUB_SUMARY_LANDSCAPE_BI_ASSINATURAS_2.jasper")).exists()) {
            in = this.getStreeamTemplatePrincipalLandscape("SUB_SUMARY_LANDSCAPE_BI_ASSINATURAS_2.jasper");
            out = new FileOutputStream(f);
            if (ToolMethods.isNotNull((Object)in).booleanValue()) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        if (!(f = new File(tmpDir.getAbsolutePath() + File.separator + "DEFAULT_REPORT_STYLE.jrtx")).exists()) {
            in = this.getStreeamTemplate();
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private InputStream getStreeamTemplatePrincipalPortrait(String fileName) {
        return this.getClass().getResourceAsStream("/templates_reports/portrait/" + fileName);
    }

    private InputStream getStreeamTemplatePrincipalLandscape(String fileName) {
        return this.getClass().getResourceAsStream("/templates_reports/landscape/" + fileName);
    }

    private InputStream getStreeamTemplate() {
        return this.getClass().getResourceAsStream("/templates_reports/DEFAULT_REPORT_STYLE.jrtx");
    }

    protected String getChaveLayoutSel(DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref) throws ExceptionIO {
        Map options;
        String json;
        BIPrefUser data;
        Optional<BIParamPrefUser> found;
        if (pref != null && TMethods.isStrWithData((String)pref.getDadosUtilizados()) && (found = (data = (BIPrefUser)ToolJson.readJson((String)(json = pref.getDadosUtilizados()), BIPrefUser.class, (Map)(options = ToolMethods.toMap((ToolMethods.Pair[])new ToolMethods.Pair[]{ToolMethods.pair((Object)DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, (Object)false)})))).getParams().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)"P_ROOT_REPORT_KEY_LAYOUT")).findFirst()).isPresent() && TMethods.isStrWithData((String)found.get().getValor1())) {
            return found.get().getValor1();
        }
        for (DTOBusinessIntelligenceDet.DTODadoAdicional d : det.getDadosAdicionais()) {
            if (!TMethods.isEquals((Object)d.getChave(), (Object)"P_ROOT_REPORT_KEY_LAYOUT")) continue;
            return d.getValorInformado();
        }
        return null;
    }
}

