/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class AuxWordParagraph {
    void process(List<XWPFParagraph> paragraphs, Map<String, Object> params, Map<String, Object> mainReg) throws ExceptionReflection {
        for (XWPFParagraph p : paragraphs) {
            this.updateFields(p, mainReg, "\\$F\\{[^}]+\\}");
            this.updateFields(p, params, "\\$P\\{[^}]+\\}");
        }
    }

    private void updateFields(XWPFParagraph para, Map reg, String regex) throws ExceptionReflection {
        String content = para.getText();
        Pattern pattern = Pattern.compile(regex);
        Matcher matchers = pattern.matcher(content);
        LinkedList<StringToken> tokens = new LinkedList<StringToken>();
        while (matchers.find()) {
            String mainText = matchers.group();
            String field = mainText.substring(mainText.indexOf("{") + 1);
            field = field.substring(0, field.indexOf("}"));
            String ob = this.getValue(field, reg);
            tokens.add(new StringToken(mainText, ob));
        }
        if (!tokens.isEmpty()) {
            for (StringToken token : tokens) {
                content = content.replace(token.getChave(), token.getValor());
            }
            while (!para.getRuns().isEmpty()) {
                para.removeRun(0);
            }
            XWPFRun run = para.createRun();
            run.setText(content);
        }
    }

    private String getValue(String mainText, Map reg) throws ExceptionReflection {
        Object ob = ToolReflections.getFieldValueFromGetMethod((String)mainText, (Object)reg);
        if (ob == null) {
            ob = "";
        }
        if (ToolReflections.isPrimitiveIntNumber((Object)ob)) {
            return ob.toString();
        }
        if (ToolReflections.isPrimitiveDecNumber((Object)ob)) {
            return ToolFormatter.formataNumero((Number)((Number)ob), (int)2);
        }
        if (ToolReflections.isPrimitiveDate((Object)ob)) {
            return ToolDate.dateToStr((Date)((Date)ob));
        }
        return ob.toString();
    }
}

