/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.model.bi.BIParamPrefUser;
import com.touchcomp.basementorservice.model.bi.BIPrefUser;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.constants.DataBIConstants;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParameter;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word.AuxWordFoot;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word.AuxWordHeader;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word.AuxWordParagraph;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word.AuxWordTable;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public class AuxWordPrint
implements DataBIConstants {
    protected TLogger logger = TLogger.get(this.getClass());

    private File getArquivoPrincipal(BusinessIntelligence vo, DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref) throws ExceptionBuildBI {
        try {
            String chaveLayout = this.getChaveLayoutSel(det, pref);
            File main = null;
            for (BusinessIntelligenceFiles b : vo.getBusinessIntelligenceFiles()) {
                File tmp = this.salvarTMPFile(b);
                if ((b.getArquivoPrincipal() != 1 || !TMethods.isEquals((Object)chaveLayout, (Object)b.getChaveLayout())) && (chaveLayout != null || main != null)) continue;
                main = tmp;
            }
            if (main == null || vo.getBusinessIntelligenceFiles().isEmpty()) {
                if (TMethods.isStrWithData((String)chaveLayout)) {
                    throw new ExceptionBuildBI("E.ERP.0747.006", new Object[]{chaveLayout});
                }
                throw new ExceptionBuildBI("E.ERP.0747.005", new Object[0]);
            }
            return main;
        }
        catch (ExceptionIO | IOException ex) {
            this.logger.error(ex.getClass(), ex);
            throw new ExceptionBuildBI("E.ERP.0747.007", new Object[]{ex.getMessage()});
        }
    }

    private File salvarTMPFile(BusinessIntelligenceFiles b) throws FileNotFoundException, IOException, ExceptionBuildBI {
        String path = ToolFile.getTMPDir() + File.separator + b.getNome() + ".docx";
        File f = new File(path);
        if (f.exists()) {
            Files.delete(f.toPath());
        }
        try (FileOutputStream fo = new FileOutputStream(f);){
            fo.write(b.getSourceJasper());
            fo.flush();
        }
        return f;
    }

    public DataOutputBI gerarOutput(DataResultBI vo) throws ExceptionBuildBI {
        DataOutputBI dataOutputBI;
        File pathOb = this.getArquivoPrincipal(vo.getBusinessIntelligence(), vo.getBusinessIntelligenceDTO(), vo.getPerfil());
        Map<String, Object> params = this.getParams(vo);
        List<Map> ds = vo.getData();
        File file = pathOb;
        if (!file.exists()) {
            throw new ExceptionBuildBI("E.ERP.0747.020", new Object[]{file.getAbsolutePath()});
        }
        if (ds.size() > 1) {
            throw new ExceptionBuildBI("E.ERP.0747.025", new Object[0]);
        }
        Map mainReg = ds.get(0);
        XWPFDocument doc = new XWPFDocument((InputStream)new FileInputStream(file));
        try {
            new AuxWordParagraph().process(doc.getParagraphs(), params, mainReg);
            new AuxWordTable().process(doc.getTables(), params, mainReg);
            new AuxWordFoot().process(doc.getFootnotes(), params, (Map<String, Object>)mainReg);
            new AuxWordHeader().process(doc.getHeaderList(), params, (Map<String, Object>)mainReg);
            File gen = ToolFile.createTempFile((String)"temp_bi_word", (String)".docx");
            try (FileOutputStream fout = new FileOutputStream(gen);){
                doc.write((OutputStream)fout);
                fout.flush();
            }
            DataOutputBI out = new DataOutputBI();
            out.setFile(gen);
            dataOutputBI = out;
        }
        catch (Throwable throwable) {
            try {
                try {
                    doc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ExceptionReflection | IOException | XmlException ex) {
                throw new ExceptionBuildBI("E.ERP.0747.007", ex, new Object[]{ex.getMessage()});
            }
        }
        doc.close();
        return dataOutputBI;
    }

    protected String getChaveLayoutSel(DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref) throws ExceptionIO {
        Map options;
        String json;
        BIPrefUser data;
        Optional<BIParamPrefUser> found;
        if (det == null) {
            return null;
        }
        if (pref != null && TMethods.isStrWithData((String)pref.getDadosUtilizados()) && (found = (data = (BIPrefUser)ToolJson.readJson((String)(json = pref.getDadosUtilizados()), BIPrefUser.class, (Map)(options = ToolMethods.toMap((ToolMethods.Pair[])new ToolMethods.Pair[]{ToolMethods.pair((Object)DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, (Object)false)})))).getParams().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)"P_ROOT_REPORT_KEY_LAYOUT")).findFirst()).isPresent() && TMethods.isStrWithData((String)found.get().getValor1())) {
            return found.get().getValor1();
        }
        for (DTOBusinessIntelligenceDet.DTODadoAdicional d : det.getDadosAdicionais()) {
            if (!TMethods.isEquals((Object)d.getChave(), (Object)"P_ROOT_REPORT_KEY_LAYOUT")) continue;
            return d.getValorInformado();
        }
        return null;
    }

    private Map<String, Object> getParams(DataResultBI vo) {
        Map<String, Object> params = vo.getParameters().getParamsTodos();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof DataParameter) {
                DataParameter p = (DataParameter)entry.getValue();
                ret.put(entry.getKey(), p.getValue());
                continue;
            }
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }
}

