/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class AuxWordRun {
    public void process(List<XWPFRun> runs, Map params, Map mainReg) throws ExceptionReflection {
        if (runs == null) {
            return;
        }
        for (XWPFRun r : runs) {
            this.process(r, params, mainReg);
        }
    }

    public void process(XWPFRun r, Map params, Map field) throws ExceptionReflection {
        String text = r.getText(0);
        if (text == null) {
            return;
        }
        this.updateFields(r, field, "\\$F\\{[^}]+\\}");
        this.updateFields(r, params, "\\$P\\{[^}]+\\}");
    }

    private void updateFields(XWPFRun r, Map reg, String regex) throws ExceptionReflection {
        String content = r.getText(0);
        Pattern pattern = Pattern.compile(regex);
        Matcher matchers = pattern.matcher(content);
        while (matchers.find()) {
            String mainText = matchers.group();
            String field = mainText.substring(mainText.indexOf("{") + 1);
            field = field.substring(0, field.indexOf("}"));
            String ob = this.getValue(field, reg);
            String updatedContent = content.replace(mainText, ob);
            r.setText(updatedContent, 0);
        }
    }

    private String getValue(String mainText, Map reg) throws ExceptionReflection {
        Object ob = ToolReflections.getFieldValueFromGetMethod((String)mainText, (Object)reg);
        if (ob == null) {
            ob = "";
        }
        if (ToolReflections.isPrimitiveIntNumber((Object)ob)) {
            return ob.toString();
        }
        if (ToolReflections.isPrimitiveDecNumber((Object)ob)) {
            return ToolFormatter.formataNumero((Number)((Number)ob), (int)2);
        }
        if (ToolReflections.isPrimitiveDate((Object)ob)) {
            return ToolDate.dateToStr((Date)((Date)ob));
        }
        return ob.toString();
    }
}

