/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.word.AuxWordParagraph;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;

public class AuxWordTable {
    public void process(List<XWPFTable> tables, Map params, Map mainReg) throws IOException, XmlException, ExceptionReflection {
        for (XWPFTable tbl : tables) {
            this.process(tbl, params, mainReg);
        }
    }

    public void process(XWPFTable tbl, Map params, Map mainReg) throws IOException, XmlException, ExceptionReflection {
        List rows = tbl.getRows();
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() == 1) {
            this.processRow(tbl, (XWPFTableRow)rows.get(0), params, mainReg);
            return;
        }
        XWPFTableRow header = (XWPFTableRow)rows.get(0);
        String fieldData = this.getFieldTable(header);
        Object data = mainReg.get(fieldData);
        if (data == null) {
            data = params.get(fieldData);
        }
        this.processRow(tbl, header, params, mainReg);
        if (data == null || !List.class.isAssignableFrom(data.getClass())) {
            for (int i = 1; i < rows.size(); ++i) {
                this.processRow(tbl, tbl.getRow(i), params, mainReg);
            }
            return;
        }
        XWPFTableRow baseRow = (XWPFTableRow)rows.get(1);
        List dados = (List)data;
        int i = 1;
        for (Map dado : dados) {
            HashMap novosDadosCombinados = new HashMap(mainReg);
            novosDadosCombinados.putAll(this.appendFakeMap(dado, fieldData, i));
            CTRow ctrow = CTRow.Factory.parse((InputStream)baseRow.getCtRow().newInputStream());
            XWPFTableRow newRow = new XWPFTableRow(ctrow, tbl);
            this.processRow(tbl, newRow, params, novosDadosCombinados);
            tbl.addRow(newRow, i);
            ++i;
        }
        if (i > 1) {
            tbl.removeRow(i);
        }
        if (tbl.getRows().size() > i) {
            for (int j = i + 1; j < tbl.getRows().size(); ++j) {
                this.processRow(tbl, tbl.getRow(j), params, mainReg);
            }
        }
    }

    private void processRow(XWPFTable tbl, XWPFTableRow get, Map params, Map mainReg) throws IOException, XmlException, ExceptionReflection {
        for (XWPFTableCell tableCell : get.getTableCells()) {
            new AuxWordParagraph().process(tableCell.getParagraphs(), params, mainReg);
            new AuxWordTable().process(tableCell.getTables(), params, mainReg);
        }
    }

    private String getFieldTable(XWPFTableRow header) {
        for (XWPFTableCell cell : header.getTableCells()) {
            List paras = cell.getParagraphs();
            String temp = this.getFieldTable(paras);
            if (!ToolMethods.isStrWithData((String)temp)) continue;
            return temp;
        }
        return null;
    }

    private String getFieldTable(List<XWPFParagraph> paras) {
        Pattern pattern = Pattern.compile("\\$T\\{[^}]+\\}");
        String field = null;
        for (XWPFParagraph para : paras) {
            String text = para.getText();
            Matcher matcher = pattern.matcher(text);
            String content = text;
            if (matcher.find()) {
                String mainText = matcher.group();
                field = mainText.substring(mainText.indexOf("{") + 1);
                field = field.substring(0, field.indexOf("}"));
                String newText = "";
                content = content.replace(mainText, newText);
            }
            while (!para.getRuns().isEmpty()) {
                para.removeRun(0);
            }
            XWPFRun run = para.createRun();
            run.setText(content);
        }
        return field;
    }

    private Map appendFakeMap(Map dado, String fieldData, int i) {
        HashMap<String, Map> temp = new HashMap<String, Map>();
        temp.put(fieldData, dado);
        return temp;
    }
}

