/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildcustoprodlinhaprod;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstCustoPcpTipoMaterial;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstCustoPcpTpAnaCusto;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstCustoPcpTpCapProdutiva;
import com.touchcomp.basementor.constants.enums.custopcplinhaprod.EnumConstTipoPesq;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.impl.engenhariaprodutos.EnumEngProdutos;
import com.touchcomp.basementorexceptions.exceptions.impl.engenhariaprodutos.ExceptionEngProdutos;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.analisecustoprod.ServiceAnaliseCustoProdImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.ServiceEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCotacaoMoeda;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeFormulaProduto;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementorservice.service.interfaces.ServiceRoteiroProducao;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoEstoque;
import com.touchcomp.basementorservice.service.interfaces.ServiceTabelaPrecoBaseProduto;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UtilEngenhariaProdutos {
    private final ServiceRoteiroProducao serviceRoteiroProduto = (ServiceRoteiroProducao)ConfApplicationContext.getBean(ServiceRoteiroProducao.class);
    private final ServiceGradeFormulaProduto serviceGradeFormulaProduto = (ServiceGradeFormulaProduto)ConfApplicationContext.getBean(ServiceGradeFormulaProduto.class);
    private final ServiceNotaFiscalTerceiros serviceNFTerceiros = (ServiceNotaFiscalTerceiros)ConfApplicationContext.getBean(ServiceNotaFiscalTerceiros.class);
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerc = (ServiceNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(ServiceNotaFiscalTerceirosImpl.class);
    private final ServiceEventoOsProducaoLinhaProdImpl serviceEvtOSLinProd = (ServiceEventoOsProducaoLinhaProdImpl)ConfApplicationContext.getBean(ServiceEventoOsProducaoLinhaProdImpl.class);
    private final ServiceCelulaProdutivaImpl serviceCelulaProdutiva = (ServiceCelulaProdutivaImpl)ConfApplicationContext.getBean(ServiceCelulaProdutivaImpl.class);
    private final ServiceAnaliseCustoProdImpl serviceAnaliseCustoProd = (ServiceAnaliseCustoProdImpl)ConfApplicationContext.getBean(ServiceAnaliseCustoProdImpl.class);
    private final ServiceTabelaPrecoBaseProduto serviceTabelaPrecoBaseProd = (ServiceTabelaPrecoBaseProduto)ConfApplicationContext.getBean(ServiceTabelaPrecoBaseProduto.class);
    private final ServiceCotacaoMoeda serviceCotacaoMoeda = (ServiceCotacaoMoeda)ConfApplicationContext.getBean(ServiceCotacaoMoeda.class);
    private final ServiceSaldoEstoque serviceSaldoEstoque = (ServiceSaldoEstoque)ConfApplicationContext.getBean(ServiceSaldoEstoque.class);
    private List<SaldoEstoqueGeralBasico> saldoEstoqueProdutoUnificado = null;
    private List<Map<String, Object>> analiseCusto = null;
    private final Date dataConsulta;
    private final Date dataInicial;
    private final Date dataFinal;
    private Double qtdeReferencia;
    private final Integer nivelMax;
    private final EnumConstCustoPcpTpAnaCusto tipoAnaliseCustoIndireto;
    private final Long idAnaliseCusto;
    private final EnumConstTipoPesq tipoRel;
    private final Long idInicial;
    private final Long idFinal;
    private final Long idMoedaPadrao;
    private final EnumConstantsMentorSimNao carregarSaldosEstCache;
    private final EnumConstantsMentorSimNao carregarTabPrecos;
    private final EnumConstantsMentorSimNao validarExisteRoteiro;
    private final EnumConstCustoPcpTpCapProdutiva carregarCapacidadeRoteiroApont;
    private final Empresa empresa;
    private final List<VOEngenhariaProdutos> cache;
    private final EnumConstantsMentorSimNao filtraEspecie;
    private final Long idInicialEspecie;
    private final Long idFinalEspecie;
    private final EnumConstantsMentorSimNao filtraSubEspecie;
    private final Long idInicialSubEspecie;
    private final Long idFinalSubEspecie;
    private final EnumConstantsMentorSimNao somenteFormulacoesAtivas;
    private final double percEficiencia;

    public UtilEngenhariaProdutos(Date dataConsulta, Date dataInicial, Date dataFinal, Double qtdeReferencia, Integer nivelMax, EnumConstCustoPcpTpAnaCusto tipoAnaliseCustoIndireto, Long idAnaliseCusto, EnumConstTipoPesq tipoRel, Long idInicial, Long idFinal, Long idMoedaPadrao, EnumConstantsMentorSimNao carregarSaldosEstCache, EnumConstantsMentorSimNao carregarTabPrecos, EnumConstantsMentorSimNao validarExisteRoteiro, EnumConstCustoPcpTpCapProdutiva carregarCapacidadeRoteiroApont, Empresa empresa, List<VOEngenhariaProdutos> cache, double percEficiencia, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormulacoesAtivas) {
        if (dataConsulta == null) {
            dataConsulta = new Date();
        }
        this.dataConsulta = dataConsulta;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        if (qtdeReferencia <= 0.0) {
            qtdeReferencia = 1.0;
        }
        this.qtdeReferencia = qtdeReferencia;
        if (nivelMax <= 0) {
            nivelMax = 999;
        }
        this.nivelMax = nivelMax;
        this.tipoAnaliseCustoIndireto = tipoAnaliseCustoIndireto;
        this.idAnaliseCusto = idAnaliseCusto;
        this.tipoRel = tipoRel;
        this.idInicial = idInicial;
        this.idFinal = idFinal;
        this.idMoedaPadrao = idMoedaPadrao;
        this.carregarSaldosEstCache = carregarSaldosEstCache;
        this.carregarTabPrecos = carregarTabPrecos;
        this.carregarCapacidadeRoteiroApont = carregarCapacidadeRoteiroApont;
        this.empresa = empresa;
        this.cache = cache;
        if (percEficiencia <= 0.0 || percEficiencia > 100.0) {
            percEficiencia = 100.0;
        }
        this.percEficiencia = percEficiencia;
        this.validarExisteRoteiro = validarExisteRoteiro;
        this.filtraEspecie = filtraEspecie;
        this.idInicialEspecie = idInicialEspecie;
        this.idFinalEspecie = idFinalEspecie;
        this.filtraSubEspecie = filtraSubEspecie;
        this.idInicialSubEspecie = idInicialSubEspecie;
        this.idFinalSubEspecie = idFinalSubEspecie;
        this.somenteFormulacoesAtivas = somenteFormulacoesAtivas;
    }

    public List<VOEngenhariaProdutos> processData() throws ExceptionEngProdutos {
        try {
            if (this.qtdeReferencia == null || this.qtdeReferencia <= 0.0) {
                this.qtdeReferencia = 1.0;
            }
            List<VOEngenhariaProdutos> dados = this.getDados();
            return dados;
        }
        catch (ExceptionEngProdutos ex) {
            throw ex;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionEngProdutos(ex, new Object[]{ex.getMessage()});
        }
    }

    private List<VOEngenhariaProdutos> getDados() throws ExceptionEngProdutos {
        List<VOEngenhariaProdutos> formulacoes = new LinkedList<VOEngenhariaProdutos>();
        if (null != this.tipoRel) {
            switch (this.tipoRel) {
                case FORMULACAO: {
                    formulacoes = this.getFormulacoesFormulacao();
                    break;
                }
                case FORMULACAO_PRINCIPAL_SOMENTE: {
                    formulacoes = this.getFormulacoesFormulacaoPrincipalProd();
                    break;
                }
                case GRUPO_PRODUTOS: {
                    formulacoes = this.getFormulacoesGrupoProdutos();
                    break;
                }
                case PRODUTO: {
                    formulacoes = this.getFormulacoesProdutos();
                    break;
                }
                default: {
                    throw new ExceptionEngProdutos(EnumEngProdutos.TIPO_RELATORIO_NAO_MAPEADO, new Object[]{this.tipoRel});
                }
            }
        }
        this.setInfoFormulacoes(formulacoes);
        this.putQtdBaseRefParaCalculo(formulacoes);
        this.getItens(formulacoes, 1, "1");
        this.calcularQuantidade(formulacoes, this.qtdeReferencia);
        this.calcularPrecoMedio(formulacoes);
        this.calcularUltCusto(formulacoes);
        this.calcularTempoRoteiro(formulacoes);
        this.calcularValoresCustoPrincipal(formulacoes);
        return formulacoes;
    }

    private void calcularValoresCustoPrincipal(List<VOEngenhariaProdutos> itens) {
        for (VOEngenhariaProdutos item : itens) {
            this.calcularValoresCusto(item, item.getItens());
        }
    }

    private void calcularValoresCusto(VOEngenhariaProdutos pai, List<VOEngenhariaProdutos> itens) {
        if (pai.getCarregadoTabPrecos() == 1) {
            this.calcularValoresCustoFilho(pai);
        }
        for (VOEngenhariaProdutos item : itens) {
            this.calcularValoresCusto(item, item.getItens());
            this.calcularValoresCustoFilho(item);
        }
        this.calcularTotalPai(pai);
    }

    private void calcularTotalPai(VOEngenhariaProdutos pai) {
        if (pai == null) {
            return;
        }
        if (pai.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_MATERIA_PRIMA.getValue()) {
            return;
        }
        if (pai.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_SEMI_ACAB_ACABADO.getValue()) {
            for (VOEngenhariaProdutos filho : pai.getItens()) {
                pai.setTotalGeralUltPrecoCusto(Double.valueOf(pai.getTotalGeralUltPrecoCusto() + filho.getTotalGeralUltPrecoCusto()));
                pai.setTotalGeralUltPrecoMedio(Double.valueOf(pai.getTotalGeralUltPrecoMedio() + filho.getTotalGeralUltPrecoMedio()));
                pai.setTotalUltPrecoCusto(Double.valueOf(pai.getTotalUltPrecoCusto() + filho.getTotalUltPrecoCusto()));
                pai.setTotalUltPrecoMedio(Double.valueOf(pai.getTotalUltPrecoMedio() + filho.getTotalGeralUltPrecoMedio()));
            }
        }
        this.calcularValoresCustoRoteiro(pai);
        pai.setTotalGeralUltPrecoCusto(Double.valueOf(pai.getTotalGeralUltPrecoCusto() + pai.getCustoRoteiroCalc()));
        pai.setTotalGeralUltPrecoMedio(Double.valueOf(pai.getTotalGeralUltPrecoMedio() + pai.getCustoRoteiroCalc()));
    }

    private void calcularValoresCustoRoteiro(VOEngenhariaProdutos aux) {
        if (aux.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_SEMI_ACAB_ACABADO.getValue()) {
            double custoUnitarioRoteiro = 0.0;
            double valorTotalCelula = 0.0;
            double capacidadeTotal = 0.0;
            double capRoteiroTotal = 0.0;
            List itensRoteiro = aux.getItensRoteiro();
            for (VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro item : itensRoteiro) {
                Double capProdutiva = item.getCapacidadeProdutiva();
                if (this.carregarCapacidadeRoteiroApont == null || this.carregarCapacidadeRoteiroApont == EnumConstCustoPcpTpCapProdutiva.TP_ANAL_CAP_PROD_ROTEIRO_PROD) {
                    capProdutiva = capProdutiva * (this.percEficiencia > 0.0 ? this.percEficiencia / 100.0 : 1.0);
                }
                if (capProdutiva == null || !(capProdutiva > 0.0)) continue;
                double valorCelula = this.getValorHora(item.getIdCelulaProdutiva());
                custoUnitarioRoteiro += valorCelula / capProdutiva;
                capacidadeTotal += capProdutiva.doubleValue();
                capRoteiroTotal += item.getCapacidadeRoteiro().doubleValue();
                valorTotalCelula += valorCelula;
            }
            aux.setCustoRoteiroCalc(Double.valueOf(custoUnitarioRoteiro * aux.getQuantidadeCalculada()));
            aux.setCustoCelula(Double.valueOf(valorTotalCelula));
            aux.setCapacidadeRoteiro(Double.valueOf(capRoteiroTotal));
            aux.setCapacidadeUtilizada(Double.valueOf(capacidadeTotal));
            aux.setCustoRoteiro(Double.valueOf(custoUnitarioRoteiro));
        }
    }

    private void calcularValoresCustoFilho(VOEngenhariaProdutos aux) {
        if (aux.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_MATERIA_PRIMA.getValue() || aux.getCarregadoTabPrecos() == 1) {
            aux.setCustoPrMedioMateriais(Double.valueOf(aux.getQuantidadeCalculada() * aux.getPrecoMedio()));
            aux.setCustoUltCustoMateriais(Double.valueOf(aux.getQuantidadeCalculada() * aux.getUltPrecoCusto()));
            aux.setTotalGeralUltPrecoCusto(aux.getCustoUltCustoMateriais());
            aux.setTotalGeralUltPrecoMedio(aux.getCustoPrMedioMateriais());
            aux.setTotalUltPrecoCusto(aux.getUltPrecoCusto());
            aux.setTotalUltPrecoMedio(aux.getTotalUltPrecoMedio());
        }
    }

    private void calcularPrecoMedio(List<VOEngenhariaProdutos> itens) {
        for (VOEngenhariaProdutos item : itens) {
            if (this.carregarTabPrecos == EnumConstantsMentorSimNao.SIM) {
                Double valorPR = this.carregarPrecosTabPrecos(item.getIdProduto());
                item.setPrecoMedio(valorPR);
                item.setCarregadoTabPrecos(Short.valueOf(valorPR != null && valorPR > 0.0 ? (short)1 : 0));
            }
            if (item.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_MATERIA_PRIMA.getValue() && item.getCarregadoTabPrecos() == 0) {
                VOEngenhariaProdutos found = this.getFromCachePrMedio(item.getIdGradeCor());
                if (found != null) {
                    item.setPrecoMedio(found.getPrecoMedio());
                } else {
                    Double valorPR = this.getPrecoMedioGradeCor(item.getIdProduto());
                    item.setPrecoMedio(valorPR);
                }
                item.setPrecoMedioCarregado(Short.valueOf((short)1));
            }
            if (item.getCarregadoTabPrecos() != 0) continue;
            this.calcularPrecoMedio(item.getItens());
        }
    }

    private void calcularUltCusto(List<VOEngenhariaProdutos> itens) {
        for (VOEngenhariaProdutos item : itens) {
            if (this.carregarTabPrecos == EnumConstantsMentorSimNao.SIM) {
                Double valorPR = this.carregarPrecosTabPrecos(item.getIdProduto());
                item.setUltPrecoCusto(valorPR);
                item.setCarregadoTabPrecos(Short.valueOf(valorPR != null && valorPR > 0.0 ? (short)1 : 0));
            }
            if (item.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_MATERIA_PRIMA.getValue() && item.getCarregadoTabPrecos() == 0) {
                VOEngenhariaProdutos found = this.getFromCacheUltCusto(item.getIdGradeCor());
                if (found != null) {
                    item.setUltPrecoCusto(found.getUltPrecoCusto());
                    item.setDataUltCusto(found.getDataUltCusto());
                    item.setNrDocUltCusto(found.getNrDocUltCusto());
                } else {
                    CustoProdutoUltimaNF ret = this.getUltPrecoCusto(item.getIdProduto());
                    if (ret != null) {
                        Double valorCusto = ret.getValorCusto();
                        Date data = ret.getDataUltCompra();
                        Long numeroNota = ret.getNumeroNF();
                        item.setUltPrecoCusto(valorCusto);
                        item.setDataUltCusto(data);
                        item.setNrDocUltCusto((Number)numeroNota);
                    }
                }
            }
            if (item.getCarregadoTabPrecos() != 0) continue;
            this.calcularUltCusto(item.getItens());
        }
    }

    private void calcularQuantidade(List<VOEngenhariaProdutos> itens, Double qtdeReferencia) {
        for (VOEngenhariaProdutos item : itens) {
            Double quantidadeCalculada = qtdeReferencia * (item.getQuantidade() / (item.getQuantidadeRefFormulacao() != null && item.getQuantidadeRefFormulacao() > 0.0 ? item.getQuantidadeRefFormulacao() : 1.0));
            item.setQuantidadeCalculada(quantidadeCalculada);
            this.calcularQuantidade(item.getItens(), quantidadeCalculada);
        }
    }

    private void getItens(List<VOEngenhariaProdutos> itens, int nivel, String nivelDesc) {
        for (VOEngenhariaProdutos item : itens) {
            item.setNivelDesc(nivelDesc);
        }
        if (nivel + 1 > this.nivelMax) {
            return;
        }
        for (VOEngenhariaProdutos item : itens) {
            List<VOEngenhariaProdutos> ret = this.getItensFormulacao(item);
            if (ret.isEmpty()) {
                item.setTipoMat(EnumConstCustoPcpTipoMaterial.TIPO_MAT_MATERIA_PRIMA.getValue());
            } else {
                item.setTipoMat(EnumConstCustoPcpTipoMaterial.TIPO_MAT_SEMI_ACAB_ACABADO.getValue());
                this.getItens(ret, nivel + 1, nivelDesc + "." + (nivel + 1));
                item.setItens(ret);
            }
            item.setNivel(nivel);
        }
    }

    private void calcularTempoRoteiro(List<VOEngenhariaProdutos> itens) throws ExceptionEngProdutos {
        for (VOEngenhariaProdutos item : itens) {
            if (item.getTipoMat() == EnumConstCustoPcpTipoMaterial.TIPO_MAT_SEMI_ACAB_ACABADO.getValue()) {
                List<Map<String, Object>> itensRoteiro = this.getRoteiroProduto(item);
                if (itensRoteiro.isEmpty() && EnumConstantsMentorSimNao.SIM == this.validarExisteRoteiro) {
                    throw new ExceptionEngProdutos(EnumEngProdutos.PRODUTO_SEM_ROTEIRO_PRODUCAO, new Object[]{item.getIdProduto() + "-" + item.getProduto(), item.getGradeProduto()});
                }
                if (itensRoteiro != null) {
                    for (Map<String, Object> map : itensRoteiro) {
                        VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro v = new VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro(item);
                        v.setCapacidadeProdutiva((Double)map.get("CAPACIDADE_PRODUTIVA"));
                        v.setCapacidadeRoteiro((Double)map.get("CAPACIDADE_PRODUTIVA_ROTEIRO"));
                        v.setCelulaProdutiva((String)map.get("CELULA"));
                        v.setIdCelulaProdutiva((Long)map.get("ID_CELULA_PRODUTIVA"));
                        v.setIdRoteiroProducao((Long)map.get("ID_ROTEIRO_PRODUCAO"));
                        v.setTempo((Double)map.get("TEMPO"));
                        item.getItensRoteiro().add(v);
                    }
                }
            }
            this.calcularTempoRoteiro(item.getItens());
        }
    }

    private List<Map<String, Object>> getRoteiroProduto(VOEngenhariaProdutos item) {
        if (this.carregarCapacidadeRoteiroApont == EnumConstCustoPcpTpCapProdutiva.TP_ANAL_CAP_PROD_ROTEIRO_PROD) {
            return this.getCapacidadeRoteiro(item);
        }
        if (this.carregarCapacidadeRoteiroApont == EnumConstCustoPcpTpCapProdutiva.TP_ANAL_CAP_PROD_APONTADA) {
            return this.getCapacidadeApontada(item);
        }
        return this.getCapacidadeRoteiro(item);
    }

    private List<Map<String, Object>> getCapacidadeApontada(VOEngenhariaProdutos item) {
        Long idGradeCor = item.getIdGradeCor();
        return this.serviceEvtOSLinProd.getQuantidadeApontadaEvt(idGradeCor, this.dataInicial, this.dataFinal);
    }

    private List<Map<String, Object>> getCapacidadeRoteiro(VOEngenhariaProdutos item) {
        Long idRoteiro = this.serviceRoteiroProduto.getIDRoteiroByIdGradeAtivo(item.getIdGradeCor());
        if (idRoteiro == null && this.validarExisteRoteiro == EnumConstantsMentorSimNao.SIM) {
            throw new RuntimeException("Roteiro de producao nao encontrado para produto, porem existe formulacao: " + item.getIdProduto() + " - " + item.getProduto());
        }
        if (idRoteiro != null) {
            List<Map<String, Object>> r = this.serviceRoteiroProduto.getFasesProdRoteiroMap(idRoteiro);
            return r;
        }
        return new ArrayList<Map<String, Object>>();
    }

    private Double getPrecoMedioGradeCor(Long idProduto) {
        if (this.carregarSaldosEstCache == EnumConstantsMentorSimNao.SIM) {
            return this.findSaldoCache(idProduto);
        }
        return this.findSaldoDireto(idProduto);
    }

    private Double findSaldoDireto(Long idProduto) {
        SaldoEstoqueGeralBasico sal = this.serviceSaldoEstoque.findSaldoProdutoBasico(idProduto, this.empresa.getIdentificador(), this.dataConsulta, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (sal == null || sal.getValorMedio() == null) {
            return 0.0;
        }
        return sal.getValorMedio();
    }

    private Double findSaldoCache(Long idProduto) {
        if (this.saldoEstoqueProdutoUnificado == null) {
            this.loadCacheSaldos(this.empresa, this.dataConsulta);
        }
        for (SaldoEstoqueGeralBasico h : this.saldoEstoqueProdutoUnificado) {
            Long idProdutoAux = h.getIdProduto();
            if (idProduto.longValue() != ((Number)idProdutoAux).longValue()) continue;
            Double precoMedio = h.getValorMedio();
            return precoMedio != null ? precoMedio : 0.0;
        }
        return 0.0;
    }

    private CustoProdutoUltimaNF getUltPrecoCusto(Long idProduto) {
        return this.serviceNotaFiscalTerc.getUltimoCustoProd(idProduto, this.empresa.getIdentificador());
    }

    private List<VOEngenhariaProdutos> getFormulacoesGrupoProdutos() {
        return this.serviceGradeFormulaProduto.getFormulacoesByGrupoProdutosEngProd(this.idInicial, this.idFinal, this.filtraEspecie, this.idInicialEspecie, this.idFinalEspecie, this.filtraSubEspecie, this.idInicialSubEspecie, this.idFinalSubEspecie, this.somenteFormulacoesAtivas);
    }

    private List<VOEngenhariaProdutos> getFormulacoesFormulacao() {
        return this.serviceGradeFormulaProduto.getFormulacoesEngProd(this.idInicial, this.idFinal, this.filtraEspecie, this.idInicialEspecie, this.idFinalEspecie, this.filtraSubEspecie, this.idInicialSubEspecie, this.idFinalSubEspecie, this.somenteFormulacoesAtivas);
    }

    private List<VOEngenhariaProdutos> getFormulacoesFormulacaoPrincipalProd() {
        return this.serviceGradeFormulaProduto.getFormulacoesEngProdPrincProd(this.idInicial, this.idFinal, this.filtraEspecie, this.idInicialEspecie, this.idFinalEspecie, this.filtraSubEspecie, this.idInicialSubEspecie, this.idFinalSubEspecie, this.somenteFormulacoesAtivas);
    }

    private List<VOEngenhariaProdutos> getFormulacoesProdutos() {
        return this.serviceGradeFormulaProduto.getFormulacoesByProdutoEngProd(this.idInicial, this.idFinal, this.filtraEspecie, this.idInicialEspecie, this.idFinalEspecie, this.filtraSubEspecie, this.idInicialSubEspecie, this.idFinalSubEspecie, this.somenteFormulacoesAtivas);
    }

    private List<VOEngenhariaProdutos> getItensFormulacao(VOEngenhariaProdutos item) {
        Long idForm = item.getIdFormulacao();
        if (idForm == null || idForm <= 0L) {
            idForm = this.serviceGradeFormulaProduto.getPrimeiroIdGradeFormulaProdutoAtiva(item.getIdGradeCor(), this.somenteFormulacoesAtivas);
        }
        if (idForm == null) {
            return new ArrayList<VOEngenhariaProdutos>();
        }
        item.setFormulacao("Form. ID: " + idForm);
        return this.serviceGradeFormulaProduto.getItensFormulacaoEngProd(idForm);
    }

    private void loadCacheSaldos(Empresa emp, Date dataConsulta) {
        this.saldoEstoqueProdutoUnificado = this.serviceSaldoEstoque.findSaldoProdutoListaBasico(null, null, dataConsulta, emp.getIdentificador(), emp.getIdentificador(), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        System.out.println("Saldos carregados: " + this.saldoEstoqueProdutoUnificado.size());
    }

    private List<Map<String, Object>> getAnaliseCustoCelula() {
        if (this.tipoAnaliseCustoIndireto != EnumConstCustoPcpTpAnaCusto.NAO_ANALISAR) {
            if (this.tipoAnaliseCustoIndireto == EnumConstCustoPcpTpAnaCusto.ANALISAR_POR_CELULA) {
                this.analiseCusto = this.serviceCelulaProdutiva.getValorHoraCelulasProd();
            }
            if (this.analiseCusto == null && this.tipoAnaliseCustoIndireto == EnumConstCustoPcpTpAnaCusto.ANALISAR_POR_ANALISE && this.idAnaliseCusto != null) {
                this.analiseCusto = this.serviceAnaliseCustoProd.getValorHoraCelulasProd(this.idAnaliseCusto);
            }
        }
        if (this.analiseCusto == null) {
            this.analiseCusto = new LinkedList<Map<String, Object>>();
        }
        return this.analiseCusto;
    }

    private Double getValorHora(Long idCelula) {
        for (Map<String, Object> hashMap : this.getAnaliseCustoCelula()) {
            Long idCel = (Long)hashMap.get("ID_CELULA_PRODUTIVA");
            Double valorCel = (Double)hashMap.get("VALOR_HORA");
            if (!idCel.equals(idCelula)) continue;
            return valorCel;
        }
        return 0.0;
    }

    private void putQtdBaseRefParaCalculo(List<VOEngenhariaProdutos> formulacoes) {
        for (VOEngenhariaProdutos r : formulacoes) {
            r.setQuantidade(Double.valueOf(1.0));
        }
    }

    private Double carregarPrecosTabPrecos(Long idProduto) {
        Map<String, Object> dadosPrecoProd = this.serviceTabelaPrecoBaseProd.getDadosPrecoProdEngProd(idProduto, this.dataConsulta);
        if (dadosPrecoProd == null) {
            return 0.0;
        }
        Double valorVenda = (Double)dadosPrecoProd.get("VALOR_VENDA");
        Long idMoeda = (Long)dadosPrecoProd.get("ID_MOEDA");
        Double cotacaoMoeda = 1.0;
        if (this.idMoedaPadrao != null && idMoeda != null && this.idMoedaPadrao.longValue() != idMoeda.longValue()) {
            cotacaoMoeda = this.getUltimaCotacaoMoeda(idMoeda);
        }
        if (cotacaoMoeda == null) {
            cotacaoMoeda = 1.0;
        }
        return valorVenda * cotacaoMoeda;
    }

    private Double getUltimaCotacaoMoeda(Long idMoeda) {
        return this.serviceCotacaoMoeda.getValorUltimaCotacaoMoeda(idMoeda);
    }

    private VOEngenhariaProdutos getFromCachePrMedio(Long idGradeCor) {
        if (this.cache == null) {
            return null;
        }
        Optional<VOEngenhariaProdutos> found = this.cache.stream().filter(i -> i.getPrecoMedioCarregado() == 1 && i.getIdGradeCor().equals(idGradeCor)).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    private VOEngenhariaProdutos getFromCacheUltCusto(Long idGradeCor) {
        if (this.cache == null) {
            return null;
        }
        Optional<VOEngenhariaProdutos> found = this.cache.stream().filter(i -> i.getUltimoCustoCarregado() == 1 && i.getIdGradeCor().equals(idGradeCor)).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    private void setInfoFormulacoes(List<VOEngenhariaProdutos> formulacoes) {
        for (VOEngenhariaProdutos f : formulacoes) {
            f.setFormulacao("Form. ID: " + f.getIdFormulacao());
        }
    }
}

