/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildhomedashboards;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.configuracaopainelbi.EnumConstConfigPainelTipo;
import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBIItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.configuracaopainelbi.ServiceConfiguracaoPainelBIItemImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.InterfaceSCResult;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import com.touchcomp.touchvomodel.vo.configuracaopainelbi.execucao.v2.DTOConfigPainelBIItemExec;
import java.io.File;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceBuildHomeDashboardsImpl
extends ServiceGenericImpl {
    final ServiceConfiguracaoPainelBIItemImpl serviceConfiguracaoPainelBIItemImpl;
    final ServiceBuildBusinessIntelligenceImpl serviceBuild;
    final ServiceBuildSmartComponentImpl serviceBuildSmartComponentImpl;
    final ServiceEmpresaImpl serviceEmpresa;
    final ServiceUsuarioImpl serviceUsuario;
    final ServiceGrupoUsuariosImpl serviceUserGroup;
    final HelperBusinessIntelligence helperBusinessIntelligence;

    public ServiceBuildHomeDashboardsImpl(ServiceConfiguracaoPainelBIItemImpl serviceConfiguracaoPainelBIItemImpl, ServiceBuildBusinessIntelligenceImpl serviceBuild, ServiceBuildSmartComponentImpl serviceBuildSmartComponentImpl, ServiceEmpresaImpl serviceEmpresa, ServiceUsuarioImpl serviceUsuario, ServiceGrupoUsuariosImpl serviceUserGroup, HelperBusinessIntelligence helperBusinessIntelligence) {
        this.serviceConfiguracaoPainelBIItemImpl = serviceConfiguracaoPainelBIItemImpl;
        this.serviceBuild = serviceBuild;
        this.serviceBuildSmartComponentImpl = serviceBuildSmartComponentImpl;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceUsuario = serviceUsuario;
        this.serviceUserGroup = serviceUserGroup;
        this.helperBusinessIntelligence = helperBusinessIntelligence;
    }

    public synchronized DTOConfigPainelBIItemExec buildPainel(Long idItemPainel, ConstEnumFormImprBI formato, Long idEmpresa, Long idUsuario, Long idGrupoUsuarios) throws ExceptionBuildBI, ExceptionIO, ExceptionInvalidData, ExceptionObjNotFound, ExceptionReflection {
        String content;
        DefaultBIParamsMap<String, Object> params = CompBIDefaultParams.getDefParamsMap((Empresa)this.serviceEmpresa.getOrThrow(idEmpresa), (Usuario)this.serviceUsuario.getOrThrow(idUsuario), (Grupo)this.serviceUserGroup.getOrThrow(idGrupoUsuarios), new Object[0]);
        System.out.println("ID Config: " + idItemPainel);
        ConfiguracaoPainelBIItem item = (ConfiguracaoPainelBIItem)this.serviceConfiguracaoPainelBIItemImpl.getOrThrow(idItemPainel);
        if (formato == null) {
            formato = ConstEnumFormImprBI.SVG;
        }
        if (TMethods.isEqualsNumber((Number)item.getConfiguracaoPainelBILinha().getConfiguracaoPainelBI().getTipoPainel(), (Number)EnumConstConfigPainelTipo.BUSINESS_INTELLIGENCE.getEnumId())) {
            BusinessIntelligence bi = item.getBusinessIntelligencePref().getBusinessIntelligence();
            System.out.println("Construindo Painel: " + bi.getIdentificador().toString());
            DTOBusinessIntelligenceDet dto = this.helperBusinessIntelligence.build(bi).buildToDTO(bi, EnumConstTipoSistema.WEB, params);
            dto = this.helperBusinessIntelligence.buildToObjectPreferences(dto, item.getBusinessIntelligencePref(), formato);
            dto.setFormatoSelecionado(formato);
            dto.setTipoSistema(EnumConstTipoSistema.DESKTOP);
            DataOutputBI out = this.serviceBuild.gerarConverterFormatoImpBI(dto, formato, item.getBusinessIntelligencePref(), params);
            byte[] data = ToolFile.getBytesFromFile((File)out.getFile());
            content = ToolHexString.encodeToHex((byte[])data);
            System.out.println("Termino Painel: " + item.getIdentificador() + " BI: " + bi.getIdentificador());
        } else {
            SmartComponentPref pref = item.getSmartComponentPref();
            if (!TMethods.isEquals((Object)pref.getSmartComponente().getTipoComponente(), (Object)EnumConstSmartComponente.SMART_COMPONENTS_DASHBOARD.getValue())) {
                throw new ExceptionInvalidData("E.ERP.1947.002", new Object[]{pref.getSmartComponente()});
            }
            BaseSmartComponenteResult<InterfaceSCResult> res = this.serviceBuildSmartComponentImpl.buildSC(pref, new TaskCreator.TaskProgress());
            if (res.getStatus().isErro()) {
                throw new ExceptionInvalidData("E.ERP.1947.003", new Object[]{res.getMensagem()});
            }
            content = ToolJson.toJson((Object)res.getResult());
            content = ToolHexString.encodeToHex((String)content);
            System.out.println("Termino Painel: " + item.getIdentificador() + " Smart Component: " + pref.getSmartComponente().getIdentificador());
        }
        DTOConfigPainelBIItemExec ret = new DTOConfigPainelBIItemExec();
        ret.setContent(content);
        ret.setDescricao(item.getDescricao());
        ret.setIdentificador(item.getIdentificador());
        ret.setTipo(item.getConfiguracaoPainelBILinha().getConfiguracaoPainelBI().getTipoPainel());
        return ret;
    }

    @Cacheable(cacheNames={"1550_ITENS_BI_PAINEL_DASHBOARD"}, unless="#result == null", keyGenerator="customKeyGenerator")
    public DTOConfigPainelBIItemExec buildPainelWithCache(Long idItemPainel, ConstEnumFormImprBI formato, Long idEmpresa, Long idUsuario, Long idGrupoUsuarios) throws ExceptionBuildBI, ExceptionIO, ExceptionInvalidData, ExceptionObjNotFound, ExceptionReflection {
        return this.buildPainel(idItemPainel, formato, idEmpresa, idUsuario, idGrupoUsuarios);
    }

    @CacheEvict(cacheNames={"1550_ITENS_BI_PAINEL_DASHBOARD"}, keyGenerator="customKeyGenerator")
    public DTOConfigPainelBIItemExec buildPainelWithCacheEvict(Long idItemPainel, ConstEnumFormImprBI formato, Long idEmpresa, Long idUsuario, Long idGrupoUsuarios) throws ExceptionBuildBI, ExceptionIO, ExceptionInvalidData, ExceptionObjNotFound, ExceptionReflection {
        return this.buildPainelWithCache(idItemPainel, formato, idEmpresa, idUsuario, idGrupoUsuarios);
    }
}

