/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.buildindiceeconomico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoNormEnc;
import com.touchcomp.basementor.model.impl.LinhasIndiceEcoCalculado;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.MetaControleContLinha;
import com.touchcomp.basementor.model.vo.MetaControleContLinhaVlr;
import com.touchcomp.basementor.model.vo.MetaControleContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.EnumExcepIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.ExceptionIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoConta;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoConta;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

class AuxBuildIndiceEconomico {
    private static final TLogger logger = TLogger.get(AuxBuildIndiceEconomico.class);
    protected ServicePlanoConta servicePlanoConta;
    protected ServiceSaldoConta serviceSaldoConta;

    public AuxBuildIndiceEconomico(ServicePlanoConta servicePlanoConta, ServiceSaldoConta serviceSaldoConta) {
        this.servicePlanoConta = servicePlanoConta;
        this.serviceSaldoConta = serviceSaldoConta;
    }

    public List gerarIndiceEconomico(IndiceEconomico indiceEconomico, MetaControleContabil meta, GrupoEmpresa empresa, Date dataInicial, Date dataFinal, EnumConstantsTipoSaldoNormEnc tipoRel, EnumConstantsMentorSimNao imprimirDataAnteriores) throws ExceptionIndiceEconomico {
        Date dataInUmAnoAnterior = this.getDataAno(dataInicial, 1);
        Date dataFimUmAnoAnterior = this.getDataAno(dataFinal, 1);
        Date dataInDoisAnosAnteriores = this.getDataAno(dataInicial, 2);
        Date dataFimDoisAnosAnteriores = this.getDataAno(dataFinal, 2);
        return this.getValores(indiceEconomico, dataInicial, dataFinal, imprimirDataAnteriores, dataInUmAnoAnterior, dataFimUmAnoAnterior, dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, tipoRel, empresa, meta);
    }

    private Double getTotalFormula(String expressao, Date dataInicial, Date dataFinal, List linhas, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) throws ExceptionIndiceEconomico {
        try {
            if (expressao == null || expressao.isEmpty()) {
                return 0.0;
            }
            List token = ToolString.getReplaceTokens((String)expressao);
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Object o : token) {
                StringToken sk = (StringToken)o;
                m.put(sk.getChave(), this.getFixedValue(sk.getChave(), dataInicial, dataFinal, linhas, gr, tipoRel));
            }
            return ToolJepExpressionParser.evaluate((String)expressao, m);
        }
        catch (ExceptionJEPParser ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.EXPRESSAO_INVALIDA, new Object[]{expressao});
        }
    }

    private List getValuesFromRows(List linhas, Date dataInicial, Date dataFinal, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel, MetaControleContabil meta) throws ExceptionIndiceEconomico {
        this.orderLinhas(linhas);
        Double soma = 0.0;
        Double somaMeta = 0.0;
        Double valor = 0.0;
        Double valorMeta = 0.0;
        for (Object o : linhas) {
            LinhasIndiceEconomico linha = (LinhasIndiceEconomico)o;
            System.out.println("Calculando linha " + linha.getDescricao());
            if (linha.getSinal() != null && linha.getSinal() != 2) {
                if (linha.getInformaValor() != null && linha.getInformaValor() == 1) {
                    valor = linha.getValor();
                    valorMeta = linha.getValorMeta();
                } else {
                    valor = this.getTotalFormula(linha.getExpressao(), dataInicial, dataFinal, linhas, gr, tipoRel);
                    valorMeta = this.getTotalFormulaMeta(linha.getExpressao(), linhas, dataInicial, dataFinal, meta);
                }
                valor = valor == null ? 0.0 : valor;
                valorMeta = valorMeta == null ? 0.0 : valorMeta;
                valor = linha.getSinal() == 1 ? valor * -1.0 : valor;
                valorMeta = linha.getSinal() == 1 ? valorMeta * -1.0 : valorMeta;
                linha.setValor(valor);
                linha.setValorMeta(valorMeta);
                linha.setDifMetaReal(Double.valueOf(valorMeta - valor));
                if (valorMeta != 0.0) {
                    linha.setPercMetaRealizado(Double.valueOf((Math.abs(valor / valorMeta) - 1.0) * 100.0));
                } else {
                    linha.setPercMetaRealizado(Double.valueOf(0.0));
                }
                soma = soma + valor;
                somaMeta = somaMeta + valorMeta;
                continue;
            }
            linha.setValor(soma);
            linha.setValorMeta(somaMeta);
            linha.setDifMetaReal(Double.valueOf(somaMeta - soma));
            if (somaMeta != 0.0) {
                linha.setPercMetaRealizado(Double.valueOf((Math.abs(soma / somaMeta) - 1.0) * 100.0));
                continue;
            }
            linha.setPercMetaRealizado(Double.valueOf(0.0));
        }
        return linhas;
    }

    private Double getTotalFormulaMeta(String expressao, List linhas, Date dataInicial, Date dataFinal, MetaControleContabil meta) throws ExceptionIndiceEconomico {
        try {
            if (expressao == null || expressao.isEmpty()) {
                return 0.0;
            }
            List token = ToolString.getReplaceTokens((String)expressao);
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Object o : token) {
                StringToken sk = (StringToken)o;
                m.put(sk.getChave(), this.getFixedValueMeta(sk.getChave(), dataInicial, dataFinal, linhas, meta));
            }
            return ToolJepExpressionParser.evaluate((String)expressao, m);
        }
        catch (ExceptionJEPParser ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.EXPRESSAO_INVALIDA, new Object[]{expressao});
        }
    }

    private List<LinhasIndiceEcoCalculado> getValores(IndiceEconomico indiceEconomico, Date dataInicial, Date dataFinal, EnumConstantsMentorSimNao imprimirDataAnteriores, Date dataInUmAnoAnterior, Date dataFimUmAnoAnterior, Date dataInDoisAnosAnteriores, Date dataFimDoisAnosAnteriores, EnumConstantsTipoSaldoNormEnc tipoRel, GrupoEmpresa grupoEmpresa, MetaControleContabil meta) throws ExceptionIndiceEconomico {
        List lista = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInicial, dataFinal, grupoEmpresa, tipoRel, meta);
        ArrayList<LinhasIndiceEcoCalculado> maps = new ArrayList<LinhasIndiceEcoCalculado>();
        for (Object o : lista) {
            LinhasIndiceEconomico linha = (LinhasIndiceEconomico)o;
            LinhasIndiceEcoCalculado linhasIndiceEcoCalculado = new LinhasIndiceEcoCalculado();
            linhasIndiceEcoCalculado.setIdLinhaIndiceEconomico(linha.getIdentificador());
            linhasIndiceEcoCalculado.setNrLinhaIndice(linha.getIndice());
            linhasIndiceEcoCalculado.setDescricaoLinha(linha.getDescricao());
            linhasIndiceEcoCalculado.setValor(linha.getValor());
            linhasIndiceEcoCalculado.setValorMeta(linha.getValorMeta());
            linhasIndiceEcoCalculado.setNegrito(linha.getNegrito());
            linhasIndiceEcoCalculado.setDataInicial(dataInicial);
            linhasIndiceEcoCalculado.setDataFinal(dataFinal);
            linhasIndiceEcoCalculado.setLinha(linha);
            maps.add(linhasIndiceEcoCalculado);
        }
        if (imprimirDataAnteriores != null && imprimirDataAnteriores == EnumConstantsMentorSimNao.SIM) {
            List anoAnterior = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInUmAnoAnterior, dataFimUmAnoAnterior, grupoEmpresa, tipoRel, meta);
            for (LinhasIndiceEcoCalculado map : maps) {
                for (Object o : anoAnterior) {
                    LinhasIndiceEconomico linha = (LinhasIndiceEconomico)o;
                    if (!map.getIdLinhaIndiceEconomico().equals(linha.getIdentificador())) continue;
                    map.setValorUmAnoAntes(linha.getValor());
                    map.setDataInUmAnoAntes(dataInUmAnoAnterior);
                    map.setDataFimUmAnoAntes(dataFimUmAnoAnterior);
                }
            }
            List doisAnosAnteriores = this.getValuesFromRows(indiceEconomico.getLinhas(), dataInDoisAnosAnteriores, dataFimDoisAnosAnteriores, grupoEmpresa, tipoRel, meta);
            for (LinhasIndiceEcoCalculado linhasIndiceEcoCalculado : maps) {
                for (Object o : doisAnosAnteriores) {
                    LinhasIndiceEconomico linha = (LinhasIndiceEconomico)o;
                    if (!linhasIndiceEcoCalculado.getIdLinhaIndiceEconomico().equals(linha.getIdentificador())) continue;
                    linhasIndiceEcoCalculado.setValorDoisAnosAntes(linha.getValor());
                    linhasIndiceEcoCalculado.setDataInDoisAnosAntes(dataInDoisAnosAnteriores);
                    linhasIndiceEcoCalculado.setDataFimDoisAnosAntes(dataFimDoisAnosAnteriores);
                }
            }
        }
        return maps;
    }

    private Double getSaldoAtualConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr) {
        double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador());
        valor = saldo != null ? Math.abs(saldo.getSaldoAtual()) : 0.0;
        return valor;
    }

    private Double getSaldoAnteriorConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr) {
        double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador());
        valor = saldo != null ? Math.abs(saldo.getSaldoAnterior()) : 0.0;
        return valor;
    }

    private Double getDebitosConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr) {
        double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador());
        valor = saldo != null ? Math.abs(saldo.getValorDebito()) : 0.0;
        return valor;
    }

    private Double getCreditosConta(Date dataInicial, Date dataFinal, PlanoConta pc, GrupoEmpresa gr) {
        double valor = 0.0;
        SaldoContaContabil saldo = this.getSaldoContabil(pc.getCodigo(), dataInicial, dataFinal, gr.getIdentificador());
        valor = saldo != null ? Math.abs(saldo.getValorCredito()) : 0.0;
        return valor;
    }

    private Double getSaldoEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr);
        return Math.abs(s.getSaldoAtual());
    }

    private Double getDebitosEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr);
        return Math.abs(s.getValorDebito());
    }

    private Double getCreditosEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr);
        return Math.abs(s.getValorCredito());
    }

    private Double getSaldoAnteriorEncerramentoConta(Date data, PlanoConta pc, GrupoEmpresa gr) {
        SaldoContaContabil s = this.getSaldo(data, pc, gr);
        return Math.abs(s.getSaldoAnterior());
    }

    public Object getFixedValue(String chave, Date dataInicial, Date dataFinal, List<LinhasIndiceEconomico> linhas, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) throws ExceptionIndiceEconomico {
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = Integer.valueOf(linha);
            if (index > linhas.size()) {
                throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.LINHA_INDICE_INVALIDO, new Object[]{chave});
            }
            LinhasIndiceEconomico ind = linhas.get(index - 1);
            Double valor = ind.getValor();
            valor = valor == null ? 0.0 : valor;
            System.out.println("Linha:" + linha + " Saldo: " + valor);
            return valor.toString();
        }
        if (chave.startsWith("saldo.anterior.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            Double saldo = this.getSaldoPCAnterior(this.getPlanoConta(codigoPC), dataInicial, dataFinal, gr, tipoRel);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("creditos.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            Double saldo = this.getCreditosPC(this.getPlanoConta(codigoPC), dataInicial, dataFinal, gr, tipoRel);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("debitos.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            Double saldo = this.getDebitosPC(this.getPlanoConta(codigoPC), dataInicial, dataFinal, gr, tipoRel);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            Double saldo = this.getSaldoPC(this.getPlanoConta(codigoPC), dataInicial, dataFinal, gr, tipoRel);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.TOKEN_FORMULA_INVALIDO, new Object[]{chave});
    }

    private Object getFixedValueMeta(String chave, Date dataInicial, Date dataFinal, List<LinhasIndiceEconomico> linhas, MetaControleContabil meta) throws ExceptionIndiceEconomico {
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = Integer.valueOf(linha);
            if (index > linhas.size()) {
                throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.LINHA_INDICE_INVALIDO, new Object[]{chave});
            }
            LinhasIndiceEconomico ind = linhas.get(index - 1);
            Double valor = ind.getValorMeta();
            if (valor == null) {
                valor = 0.0;
            } else if (valor.isNaN() || valor.isInfinite()) {
                valor = 0.0;
            }
            System.out.println("Linha:" + linha + " Saldo: " + valor);
            return valor.toString();
        }
        if (chave.startsWith("saldo.anterior.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.getPlanoConta(codigoPC);
            Double saldo = this.getMetaContabilGerencial(pc, (short)2, dataInicial, dataFinal, meta);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("creditos.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.getPlanoConta(codigoPC);
            Double saldo = this.getMetaContabilGerencial(pc, (short)1, dataInicial, dataFinal, meta);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("debitos.pc")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.getPlanoConta(codigoPC);
            Double saldo = this.getMetaContabilGerencial(pc, (short)0, dataInicial, dataFinal, meta);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        if (chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.getPlanoConta(codigoPC);
            Double saldo = this.getMetaContabilGerencial(pc, (short)3, dataInicial, dataFinal, meta);
            saldo = saldo == null ? 0.0 : saldo;
            System.out.println("PC:" + codigoPC + " Saldo: " + saldo);
            return saldo.toString();
        }
        throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.TOKEN_FORMULA_INVALIDO, new Object[]{chave});
    }

    private PlanoConta getPlanoConta(String codigoPC) throws ExceptionIndiceEconomico {
        PlanoConta pc = this.servicePlanoConta.findByCodigo(codigoPC);
        if (pc == null) {
            throw new ExceptionIndiceEconomico(EnumExcepIndiceEconomico.PLANO_CONTAS_NAO_EXISTE, new Object[]{codigoPC});
        }
        return pc;
    }

    private Double getSaldoPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) {
        if (tipoRel == EnumConstantsTipoSaldoNormEnc.TIPO_SALDO_NORMAL) {
            return this.getSaldoAtualConta(dataInicial, dataFinal, planoConta, gr);
        }
        return this.getSaldoEncerramentoConta(dataFinal, planoConta, gr);
    }

    private Double getSaldoPCAnterior(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) {
        if (tipoRel == EnumConstantsTipoSaldoNormEnc.TIPO_SALDO_NORMAL) {
            return this.getSaldoAnteriorConta(dataInicial, dataFinal, planoConta, gr);
        }
        return this.getSaldoAnteriorEncerramentoConta(dataFinal, planoConta, gr);
    }

    private Double getDebitosPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) {
        if (tipoRel == EnumConstantsTipoSaldoNormEnc.TIPO_SALDO_NORMAL) {
            return this.getDebitosConta(dataInicial, dataFinal, planoConta, gr);
        }
        return this.getDebitosEncerramentoConta(dataFinal, planoConta, gr);
    }

    private Double getCreditosPC(PlanoConta planoConta, Date dataInicial, Date dataFinal, GrupoEmpresa gr, EnumConstantsTipoSaldoNormEnc tipoRel) {
        if (tipoRel == EnumConstantsTipoSaldoNormEnc.TIPO_SALDO_NORMAL) {
            return this.getCreditosConta(dataInicial, dataFinal, planoConta, gr);
        }
        return this.getCreditosEncerramentoConta(dataFinal, planoConta, gr);
    }

    private void orderLinhas(List<LinhasIndiceEconomico> linhas) {
        Collections.sort(linhas, (o1, o2) -> o1.getIndice().compareTo(o2.getIndice()));
    }

    private double getMetaContabilGerencial(PlanoConta planoContaCont, Short tipoSaldo, Date dataInicial, Date dataFinal, MetaControleContabil meta) {
        if (meta == null) {
            return 0.0;
        }
        for (MetaControleContLinha mt : meta.getMetasLinhas()) {
            if (!mt.getPlanoConta().equals((Object)planoContaCont) || mt.getTipoValor() == null || !mt.getTipoValor().equals(tipoSaldo)) continue;
            return this.filtraSomaValores(mt.getValoresLinhas(), dataInicial, dataFinal);
        }
        return 0.0;
    }

    private double filtraSomaValores(List<MetaControleContLinhaVlr> valoresLinhas, Date dataInicial, Date dataFinal) {
        double soma = 0.0;
        for (MetaControleContLinhaVlr vlr : valoresLinhas) {
            if (vlr.getIntervaloControleContPer() == null || !ToolDate.dateBetween((Date)vlr.getIntervaloControleContPer().getDataInicial(), (Date)dataInicial, (Date)dataFinal).booleanValue() || !ToolDate.dateBetween((Date)vlr.getIntervaloControleContPer().getDataFinal(), (Date)dataInicial, (Date)dataFinal).booleanValue()) continue;
            soma += vlr.getValorMeta().doubleValue();
        }
        return soma;
    }

    private SaldoContaContabil getSaldoContabil(String codigo, Date dataInicial, Date dataFinal, Long idGrupoEmpresa) {
        return this.serviceSaldoConta.findSaldoContaUnica(null, null, codigo, dataInicial, dataFinal, idGrupoEmpresa, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL);
    }

    private SaldoContaContabil getSaldo(Date data, PlanoConta pc, GrupoEmpresa gr) {
        return this.serviceSaldoConta.findSaldoContaUnicaEncerramento(null, null, pc.getCodigo(), data, gr.getIdentificador(), EnumConstantsTipoSaldo.TIPO_SALDO_GERAL);
    }

    private Date getDataAno(Date dataInicialP, int i) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataInicialP);
        g.set(1, g.get(1) - i);
        return g.getTime();
    }
}

