/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligenceOpImpressao;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceInfParam;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.outputter.jasperprint.AuxJasperPrint;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jdom2.Element;

public class AuxCheckAssinaturasTemplate {
    void checkBI(BusinessIntelligence vo) throws ExceptionJasperReports, ExceptionIO {
        if (vo.getBusinessIntelligenceInf() == null) {
            return;
        }
        Optional<BusinessIntelligenceInfParam> found = vo.getBusinessIntelligenceInf().getParametrosOpcionaisImpressao().stream().filter(i -> ToolMethods.isEquals((Object)i.getChave(), (Object)EnumConstBusinessIntelligenceOpImpressao.IMP_ASSINATURAS.getEnumId())).findFirst();
        if (!found.isPresent()) {
            return;
        }
        if (!ToolMethods.isWithData((Collection)vo.getBusinessIntelligenceFiles())) {
            return;
        }
        List mains = vo.getBusinessIntelligenceFiles().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getArquivoPrincipal())).collect(Collectors.toList());
        for (BusinessIntelligenceFiles main : mains) {
            if (main.getSourceJasper() == null) continue;
            File temp = ToolFile.createAndWrite((String)"temp_file_bi", (String)"jasper", (byte[])main.getSourceJasper());
            this.validarAssinaturasOverflow(temp);
        }
    }

    private void validarAssinaturasOverflow(File f) throws ExceptionJasperReports {
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((File)f);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JRXmlWriter.writeReport((JRReport)report, (OutputStream)bout, (String)"UTF-8");
            String jrxml = new String(bout.toByteArray());
            Element root = ToolJdom.getRootElement((String)jrxml);
            if (root == null) {
                return;
            }
            Element summary = root.getChild("summary", root.getNamespace());
            if (summary == null) {
                return;
            }
            Element band = summary.getChild("band", root.getNamespace());
            if (band == null) {
                return;
            }
            List subreports = band.getChildren("subreport", root.getNamespace());
            if (subreports == null || subreports.isEmpty()) {
                return;
            }
            for (Element subreport : subreports) {
                String overflowType = subreport.getAttributeValue("overflowType");
                String subreportExpression = subreport.getChildText("subreportExpression", root.getNamespace());
                if (subreportExpression == null || !subreportExpression.contains("SUB_SUMARY_LANDSCAPE_BI") && !subreportExpression.contains("SUB_SUMARY_BI") || ToolMethods.isEquals((Object)overflowType, (Object)"Stretch")) continue;
                throw new ExceptionJasperReports("E.ERP.0747.023", new Object[0]);
            }
        }
        catch (JRException ex) {
            Logger.getLogger(AuxJasperPrint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExceptionJDom ex) {
            Logger.getLogger(AuxJasperPrint.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

