/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.businessintelligence;

import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jdom2.Document;
import org.jdom2.Element;

public class AuxRecompileBI {
    void recompile(BusinessIntelligence bi) throws Exception {
        for (BusinessIntelligenceFiles fi : bi.getBusinessIntelligenceFiles()) {
            File temp = ToolFile.createTempFile((String)"temp_file_bi.jasper");
            ToolFile.writeBytesOnFile((File)temp, (byte[])fi.getSourceJasper());
            if (fi.getSourceJasper() == null || fi.getSourceJasper().length <= 0) continue;
            this.alterLayout(temp, fi);
        }
    }

    private void alterLayout(File f, BusinessIntelligenceFiles bf) throws Exception {
        JasperReport report = (JasperReport)JRLoader.loadObject((File)f);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JRXmlWriter.writeReport((JRReport)report, (OutputStream)bout, (String)"UTF-8");
        String jrxml = new String(bout.toByteArray());
        Document doc = ToolJdom.getDocument((String)jrxml);
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        Element summary = root.getChild("summary", root.getNamespace());
        if (summary == null) {
            return;
        }
        Element band = summary.getChild("band", root.getNamespace());
        if (band == null) {
            return;
        }
        List subreports = band.getChildren("subreport", root.getNamespace());
        if (subreports == null || subreports.isEmpty()) {
            return;
        }
        boolean alter = false;
        for (Element subreport : subreports) {
            String overflowType = subreport.getAttributeValue("overflowType");
            String subreportExpression = subreport.getChildText("subreportExpression", root.getNamespace());
            if (subreportExpression == null || !subreportExpression.contains("SUB_SUMARY_LANDSCAPE_BI") && !subreportExpression.contains("SUB_SUMARY_BI") || ToolMethods.isEquals((Object)overflowType, (Object)"Stretch")) continue;
            subreport.setAttribute("overflowType", "Stretch");
            alter = true;
        }
        if (!alter) {
            return;
        }
        File tempJrxml = ToolFile.createTempFile((String)"temp_report.jrxml");
        ToolJdom.writeXMLPretty((Document)doc, (File)tempJrxml);
        File tempJasper = ToolFile.createTempFile((String)"temp_report.jasper");
        JasperCompileManager.compileReportToFile((String)tempJrxml.getAbsolutePath(), (String)tempJasper.getAbsolutePath());
        bf.setSourceJasper(ToolFile.getBytesFromFile((File)tempJasper));
        bf.setSourceJrxml(ToolFile.getBytesFromFile((File)tempJrxml));
    }
}

