/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.impl.BusinessIntelligenceTemp;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceArquivo;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.helpers.impl.usuario.HelperUsuario;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.AuxCheckAssinaturasTemplate;
import com.touchcomp.basementorservice.service.impl.businessintelligence.AuxRecompileBI;
import com.touchcomp.basementorservice.service.impl.businessintelligence.DadosBILocais;
import com.touchcomp.basementorservice.service.impl.businessintelligencearquivo.ServiceBusinessIntelligenceArquivoImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligencepref.ServiceBusinessIntelligencePrefImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceBusinessIntelligence;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceRes;
import com.touchcomp.touchvomodel.vo.businessintelligencesincronizacao.DTOBusinessIntelligenceItem;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceBusinessIntelligenceImpl
extends ServiceGenericEntityImpl<BusinessIntelligence, Long, DaoBusinessIntelligenceImpl>
implements ServiceBusinessIntelligence {
    @Autowired
    HelperUsuario helperUsuario;
    @Autowired
    HelperBusinessIntelligence helperBI;
    @Autowired
    ServiceBusinessIntelligenceArquivoImpl serviceBusinessIntelligenceArquivoImpl;

    @Override
    public BusinessIntelligence beforeSaveEntity(BusinessIntelligence vo) {
        if (vo.getDadosAdicionalBI() != null) {
            vo.getDadosAdicionalBI().forEach(dadosAdicionalBI -> dadosAdicionalBI.setBusinessInteligence(vo));
        }
        if (vo.getBusinessIntelligenceFiles() != null) {
            vo.getBusinessIntelligenceFiles().forEach(businessIntelligenceFile -> businessIntelligenceFile.setBusinessIntelligence(vo));
        }
        if (vo.getDadosImagens() != null) {
            vo.getDadosImagens().forEach(dadosImagen -> dadosImagen.setBusinessIntelligence(vo));
        }
        if (vo.getFormatosGeracao() != null) {
            vo.getFormatosGeracao().forEach(formatosGeracao -> formatosGeracao.setBusinessIntelligence(vo));
        }
        if (vo.getBusinessIntelligenceObjetos() != null && vo.getBusinessIntelligenceObjetos().getClasseModeloBI() != null) {
            ClasseModeloBI cl = vo.getBusinessIntelligenceObjetos().getClasseModeloBI();
            if (cl.getNodosCondicao() != null) {
                cl.getNodosCondicao().forEach(nodosCondicao -> nodosCondicao.setClasseModelo(cl));
            }
            if (cl.getNodosOrdenacao() != null) {
                cl.getNodosOrdenacao().forEach(order -> order.setClasseModelo(cl));
            }
            if (cl.getNodosSelecao() != null) {
                cl.getNodosSelecao().forEach(check -> check.setClasseModelo(cl));
            }
            cl.setBusinessIntelligenceObjetos(vo.getBusinessIntelligenceObjetos());
        }
        if (vo.getBusinessIntConsSQL() != null && vo.getBusinessIntConsSQL().getConsultasSQL() != null) {
            vo.getBusinessIntConsSQL().getConsultasSQL().forEach(consultasSQL -> consultasSQL.setBusinessIntConsSQL(vo.getBusinessIntConsSQL()));
        }
        if (vo.getBusinessJavaClassCode() != null) {
            vo.getBusinessJavaClassCode().setBusinessIntelligence(vo);
        }
        if (vo.getBusinessIntelligenceInf() != null) {
            vo.getBusinessIntelligenceInf().setBusinessIntelligence(vo);
            if (vo.getBusinessIntelligenceInf().getEmpresas() != null) {
                vo.getBusinessIntelligenceInf().getEmpresas().forEach(be -> be.setBusinessIntelligenceInf(vo.getBusinessIntelligenceInf()));
            }
            if (vo.getBusinessIntelligenceInf().getGrupos() != null) {
                vo.getBusinessIntelligenceInf().getGrupos().forEach(bg -> bg.setBusinessIntelligenceInf(vo.getBusinessIntelligenceInf()));
            }
            if (vo.getBusinessIntelligenceInf().getNodos() != null) {
                vo.getBusinessIntelligenceInf().getNodos().forEach(bn -> bn.setBusinessIntelligenceInf(vo.getBusinessIntelligenceInf()));
            }
        }
        try {
            new AuxCheckAssinaturasTemplate().checkBI(vo);
        }
        catch (ExceptionIO | ExceptionJasperReports ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)ex);
        }
        return vo;
    }

    @Autowired
    public ServiceBusinessIntelligenceImpl(DaoBusinessIntelligenceImpl genericDao) {
        super(genericDao);
    }

    @Override
    @Transactional(readOnly=true)
    public List<BusinessIntelligenceTemp> findBIsUsuario(Empresa empresa, Usuario usuario) {
        Grupo gr = this.helperUsuario.getGrupo(usuario.getUsuarioBasico(), empresa);
        if (gr == null) {
            return new LinkedList<BusinessIntelligenceTemp>();
        }
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).findBIsUsuario(empresa.getIdentificador(), gr.getIdentificador());
    }

    @Transactional(readOnly=true)
    public List<DTOBusinessIntelligenceRes> findBIsGrupoUsuarioRes(Long idEmpresa, Long idGrupoUsuario) {
        List<BusinessIntelligenceTemp> data = ((DaoBusinessIntelligenceImpl)this.getGenericDao()).findBIsUsuario(idEmpresa, idGrupoUsuario);
        LinkedList<DTOBusinessIntelligenceRes> ret = new LinkedList<DTOBusinessIntelligenceRes>();
        for (BusinessIntelligenceTemp bi : data) {
            ret.add(this.convert(bi));
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public List<BusinessIntelligenceTemp> findBIsNodo(Nodo nodo, Empresa empresa, Usuario usuario) {
        return this.findBIsNodo(nodo, empresa, this.helperUsuario.getGrupo(usuario.getUsuarioBasico(), empresa));
    }

    public List<BusinessIntelligenceTemp> findBIsNodo(Nodo nodo, Empresa empresa, Grupo grupo) {
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).findBIsNodo(nodo.getIdentificador(), empresa.getIdentificador(), grupo.getIdentificador());
    }

    @Override
    @Transactional(readOnly=true)
    public List<BusinessIntelligence> findBusinessIntelligenceByUser(Long idUsuario) {
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).findBIsIdUsuario(idUsuario);
    }

    @Transactional(readOnly=true)
    public DTOBusinessIntelligenceDet findBIUsuario(Long idBI, EnumConstTipoSistema tipo, Empresa empresa, Usuario usuario, Grupo grupoUsuarios) throws ExceptionIO, ExceptionBuildBI {
        BusinessIntelligence bi = (BusinessIntelligence)((DaoBusinessIntelligenceImpl)this.getDao()).get(idBI);
        ServiceBusinessIntelligencePrefImpl serviceBIPref = this.getBean(ServiceBusinessIntelligencePrefImpl.class);
        BusinessIntelligencePref pref = serviceBIPref.getPrefDefaultOrCreate(bi, tipo, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupoUsuarios, new Object[0]));
        DTOBusinessIntelligenceDet ret = this.helperBI.build(bi).buildToDTO(tipo, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupoUsuarios, new Object[0]), pref);
        return ret;
    }

    @Transactional(readOnly=true)
    public DTOBusinessIntelligenceDet findBIUsuario(Long idBI, EnumConstTipoSistema tipo, Empresa empresa, Usuario usuario, Grupo grupo, Long idPerfil) throws ExceptionIO, ExceptionReflection, ExceptionBuildBI {
        BusinessIntelligence bi = (BusinessIntelligence)((DaoBusinessIntelligenceImpl)this.getDao()).get(idBI);
        ServiceBusinessIntelligencePrefImpl serviceBIPref = this.getBean(ServiceBusinessIntelligencePrefImpl.class);
        BusinessIntelligencePref pref = (BusinessIntelligencePref)serviceBIPref.get(idPerfil);
        DTOBusinessIntelligenceDet ret = this.helperBI.build(bi).buildToDTO(tipo, CompBIDefaultParams.getDefParamsMap(empresa, usuario, grupo, new Object[0]), pref);
        return ret;
    }

    public String hqlToSql(String hql) {
        return ((DaoBusinessIntelligenceImpl)this.getDao()).hqlToSql(hql);
    }

    public List<DTOBusinessIntelligenceRes> findBIsNodo(Long idNodo, Long idEmpresa, Long idGrupoUsuario) {
        List<BusinessIntelligenceTemp> temp = ((DaoBusinessIntelligenceImpl)this.getGenericDao()).findBIsNodo(idNodo, idEmpresa, idGrupoUsuario);
        LinkedList<DTOBusinessIntelligenceRes> ret = new LinkedList<DTOBusinessIntelligenceRes>();
        for (BusinessIntelligenceTemp bt : temp) {
            ret.add(this.convert(bt));
        }
        return ret;
    }

    private DTOBusinessIntelligenceRes convert(BusinessIntelligenceTemp bt) {
        DTOBusinessIntelligenceRes r = new DTOBusinessIntelligenceRes();
        r.setDescricao(bt.getDescricao());
        r.setIdentificacao(this.helperBI.getIdentificacao(bt));
        r.setIdentificador(bt.getIdentificador());
        r.setObservacao(bt.getObservacao());
        r.setNumeroBI(bt.getNumeroBI());
        return r;
    }

    public List<DTOBusinessIntelligenceItem> getVersoesLocaisBI() {
        return ((DaoBusinessIntelligenceImpl)this.getDao()).getVersoesLocaisBI();
    }

    public void ativarInativarBI(Long idBI, Short ativar, String motivo) {
        BusinessIntelligence bi = (BusinessIntelligence)((DaoBusinessIntelligenceImpl)this.getDao()).get(idBI);
        if (bi == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail(""));
        }
        bi.setAtivo(ativar);
        bi.setMotivoInativacao(motivo);
        this.saveOrUpdate(bi);
    }

    public void arquivarBI(Long idBI, Long versaoSistema) throws ExceptionIO {
        BusinessIntelligence bi = (BusinessIntelligence)((DaoBusinessIntelligenceImpl)this.getDao()).get(idBI);
        if (bi == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail(""));
        }
        this.serviceBusinessIntelligenceArquivoImpl.arquivarBI(bi, versaoSistema);
    }

    public BusinessIntelligence desarquivarBI(Long idArquivamento, Long versaoSistema) throws ExceptionIO, ExceptionObjNotFound {
        BusinessIntelligenceArquivo arq = (BusinessIntelligenceArquivo)this.serviceBusinessIntelligenceArquivoImpl.getOrThrow(idArquivamento);
        BusinessIntelligence vo = (BusinessIntelligence)this.getOrThrow(arq.getIdBusinessIntelligence());
        BusinessIntelligence bi = this.serviceBusinessIntelligenceArquivoImpl.desarquivarBI(arq, vo, versaoSistema);
        bi = this.saveOrUpdate(bi);
        this.serviceBusinessIntelligenceArquivoImpl.delete(arq);
        return bi;
    }

    public void excluirArquivoBI(Long idArquivamentoBI) {
        this.serviceBusinessIntelligenceArquivoImpl.deleteById(new Long[]{idArquivamentoBI});
    }

    public List<BusinessIntelligence> getBIsToDiscontinue() {
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).getBIsToDiscontinue();
    }

    public List<GenericMapValues<DadosBILocais>> getBILocais() {
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).getBILocais();
    }

    public BusinessIntelligence getBI(Long numeroBI, Long versaoRep, Long versao) {
        return ((DaoBusinessIntelligenceImpl)this.getGenericDao()).getBI(numeroBI, versaoRep, versao);
    }

    @Transactional
    public BusinessIntelligence resave(BusinessIntelligence newBI, BusinessIntelligence old) {
        ((DaoBusinessIntelligenceImpl)this.getDao()).flushData();
        ((DaoBusinessIntelligenceImpl)this.getDao()).evict(old);
        ((DaoBusinessIntelligenceImpl)this.getDao()).getSession().clear();
        return this.saveOrUpdate(newBI);
    }

    public void recompilarTodosBI() throws Exception {
        List data = ((DaoBusinessIntelligenceImpl)this.getDao()).getAll();
        for (BusinessIntelligence bi : data) {
            new AuxRecompileBI().recompile(bi);
            this.saveOrUpdate(bi);
        }
    }

    public void reimportBI(BusinessIntelligence newBI, BusinessIntelligence old) {
        this.reload(old);
        newBI.setIdentificador(old.getIdentificador());
        newBI.setDataAtualizacao(old.getDataAtualizacao());
        newBI.setDataCadastro(new Date());
        newBI.setBusinessIntelligenceInf(old.getBusinessIntelligenceInf());
        newBI.setFormatosGeracao(old.getFormatosGeracao());
        this.beforeSaveEntity(newBI);
        ((DaoBusinessIntelligenceImpl)this.getDao()).flushData();
        ((DaoBusinessIntelligenceImpl)this.getDao()).evict(old);
        this.saveOrUpdateOnly(newBI);
    }
}

