/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.businessintelligencearquivo;

import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceArquivo;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorservice.dao.impl.DaoBusinessIntelligenceArquivoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBusinessIntelligenceArquivoImpl
extends ServiceGenericEntityImpl<BusinessIntelligenceArquivo, Long, DaoBusinessIntelligenceArquivoImpl> {
    @Autowired
    CompExpImpEntityXML compExpImpEntityXMl;

    public ServiceBusinessIntelligenceArquivoImpl(DaoBusinessIntelligenceArquivoImpl dao) {
        super(dao);
    }

    public void arquivarBI(BusinessIntelligence bi, Long versaoSistema) throws ExceptionIO {
        BusinessIntelligenceArquivo ba = new BusinessIntelligenceArquivo();
        ba.setDataArquivamento(new Date());
        ba.setDescricao(bi.getDescricao());
        ba.setIdBusinessIntelligence(bi.getIdentificador());
        ba.setNumeroVersao(bi.getNumeroVersao());
        ba.setNumeroVersaoRep(bi.getNumeroVersaoRep());
        ba.setObservacao(bi.getObservacao());
        byte[] data = this.compExpImpEntityXMl.entityToByte(bi, versaoSistema);
        ba.setDadosBI(data);
        this.saveOrUpdate(ba);
    }

    public BusinessIntelligence desarquivarBI(BusinessIntelligenceArquivo arq, BusinessIntelligence vo, Long versaoSistema) throws ExceptionIO, ExceptionObjNotFound {
        BusinessIntelligence bi = (BusinessIntelligence)this.compExpImpEntityXMl.byteToEntity(arq.getDadosBI(), versaoSistema, true, "com.touchcomp.basementor.model.vo");
        bi.setFormatosGeracao(vo.getFormatosGeracao());
        bi.setBusinessIntelligenceInf(vo.getBusinessIntelligenceInf());
        bi.setIdentificador(vo.getIdentificador());
        return bi;
    }

    public List<BusinessIntelligenceArquivo> findArquivamentos(Long idBusinessIntelligence) {
        return ((DaoBusinessIntelligenceArquivoImpl)this.getGenericDao()).findArquivamentos(idBusinessIntelligence);
    }
}

