/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.businessintelligencepref;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBusinessIntelligencePrefImpl;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceBusinessIntelligencePref;
import com.touchcomp.touchvomodel.vo.businessintelligencepref.DTOBusinessIntelligencePref;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceBusinessIntelligencePrefImpl
extends ServiceGenericEntityImpl<BusinessIntelligencePref, Long, DaoBusinessIntelligencePrefImpl>
implements ServiceBusinessIntelligencePref {
    ServiceBusinessIntelligenceImpl serviceBI;
    HelperBusinessIntelligence helperBI;

    @Autowired
    public ServiceBusinessIntelligencePrefImpl(DaoBusinessIntelligencePrefImpl genericDao, ServiceBusinessIntelligenceImpl serviceBI, HelperBusinessIntelligence helperBI) {
        super(genericDao);
        this.serviceBI = serviceBI;
        this.helperBI = helperBI;
    }

    @Override
    @Transactional(readOnly=true)
    public List<BusinessIntelligencePref> getAllByBIPrefGlobal(BusinessIntelligence businessIntelligence) {
        return ((DaoBusinessIntelligencePrefImpl)this.getGenericDao()).getAllByBIGlobal(businessIntelligence);
    }

    @Override
    @Transactional(readOnly=true)
    public List<BusinessIntelligencePref> getAllByBIAndUser(BusinessIntelligence businessIntelligence, Usuario user) {
        return ((DaoBusinessIntelligencePrefImpl)this.getGenericDao()).getAllByBIAndUser(businessIntelligence, user);
    }

    public BusinessIntelligencePref getPrefDefaultOrCreate(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        if (params.getUsuario() != null) {
            BusinessIntelligencePref found = ((DaoBusinessIntelligencePrefImpl)this.getGenericDao()).getPrefDefaultUser(bi, params.getUsuario().getIdentificador());
            if (found == null) {
                found = this.createDefaultUsuario(bi, tipo, params);
            }
            return found;
        }
        BusinessIntelligencePref found = this.getPrefDefaultOrCreate(bi, params);
        if (found == null) {
            found = this.createDefaultUsuario(bi, tipo, params);
        }
        return found;
    }

    @Transactional
    public BusinessIntelligencePref getPrefDefaultOrCreate(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        BusinessIntelligencePref found = ((DaoBusinessIntelligencePrefImpl)this.getGenericDao()).getPrefDefaultGlobal(bi.getIdentificador());
        if (found == null) {
            found = this.createDefault(bi, params);
        }
        return found;
    }

    @Transactional(readOnly=true)
    public List<DTOBusinessIntelligencePref> getPrefsBIUsuario(Long idBI, Long idUsuarioLogado) {
        List<BusinessIntelligencePref> ret = ((DaoBusinessIntelligencePrefImpl)this.getDao()).getPrefsBIUsuario(idBI, idUsuarioLogado);
        return this.buildToDTO(ret, DTOBusinessIntelligencePref.class);
    }

    public List<DTOBusinessIntelligencePref> getPrefsBIUsuarioOrCreateDef(Long idBI, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        List<DTOBusinessIntelligencePref> res = this.getPrefsBIUsuario(idBI, params.getUsuario().getIdentificador());
        if (res.isEmpty()) {
            BusinessIntelligence bi = (BusinessIntelligence)this.serviceBI.get(idBI);
            this.createDefaultUsuario(bi, tipo, params);
        }
        return this.getPrefsBIUsuario(idBI, params.getUsuario().getIdentificador());
    }

    private BusinessIntelligencePref createDefaultUsuario(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        if (bi == null) {
            return null;
        }
        BusinessIntelligencePref pr = this.helperBI.build(bi).createPrefUser(tipo, params);
        return ((DaoBusinessIntelligencePrefImpl)this.getDao()).saveOrUpdate(pr);
    }

    private BusinessIntelligencePref createDefault(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        BusinessIntelligencePref pr = this.helperBI.build(bi).createPrefGlobal(EnumConstTipoSistema.INDIFERE, params);
        return ((DaoBusinessIntelligencePrefImpl)this.getDao()).saveOrUpdate(pr);
    }

    public List<DTOBusinessIntelligencePref> getPrefsBIGlobalOrCreateDef(Long idBI, EnumConstTipoSistema enumConstTipoSistema, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        List<DTOBusinessIntelligencePref> res = this.getPrefsBI(idBI, enumConstTipoSistema);
        if (res.isEmpty()) {
            BusinessIntelligence bi = (BusinessIntelligence)this.serviceBI.get(idBI);
            this.createDefault(bi, params);
        }
        return this.getPrefsBI(idBI, enumConstTipoSistema);
    }

    public List<DTOBusinessIntelligencePref> getPrefsBIGlobalOrCreateDef(BusinessIntelligence bi, EnumConstTipoSistema tipo) {
        return this.getPrefsBI(bi.getIdentificador(), tipo);
    }

    private List<DTOBusinessIntelligencePref> getPrefsBI(Long idBI, EnumConstTipoSistema tipo) {
        List<BusinessIntelligencePref> ret = ((DaoBusinessIntelligencePrefImpl)this.getDao()).getPrefDefaultGlobal(idBI, tipo);
        return this.buildToDTO(ret, DTOBusinessIntelligencePref.class);
    }
}

