/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cadastroeventoconsignado;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuxCadastroEventoConsignado {
    public Date calculaDataFinalDesconto(Date dataInicio, Integer qtdeParcelas) {
        Date dataFinal = new Date(dataInicio.getTime());
        dataFinal = ToolDate.addMonthToDate((Date)dataFinal, (Integer)(qtdeParcelas - 1));
        dataFinal = ToolDate.getLastDateOnMonth((Date)dataFinal);
        return dataFinal;
    }

    public Date calculaDataFinalDesconto(Long dataInicio, Integer qtdeParcelas) {
        Date date = new Date(dataInicio);
        return this.calculaDataFinalDesconto(date, qtdeParcelas);
    }

    public List<EventoColaborador> criarLancamentosConsignados(CadastroEventoConsignado vo) {
        ArrayList<EventoColaborador> evts = new ArrayList<EventoColaborador>();
        Date dataInicial = vo.getDataInicioDesconto();
        Date dataFinal = vo.getDataFinalDesconto();
        Double valor = ToolFormatter.arrredondarNumero((Double)(vo.getValor() / (double)vo.getNrParcelas().intValue()), (int)2);
        Integer numeroParcelas = vo.getNrParcelas();
        Double valorDebitado = 0.0;
        Integer contabilizado = 1;
        if (vo.getNrParcelas() > 1) {
            do {
                if (contabilizado < numeroParcelas) {
                    valorDebitado = valorDebitado + valor;
                } else {
                    valor = vo.getValor() - valorDebitado;
                }
                EventoColaborador evt = this.getEvento(vo, dataInicial, ToolDate.getLastDateOnMonth((Date)dataInicial), valor);
                evts.add(evt);
                dataInicial = ToolDate.nextMonth((Date)dataInicial, (int)1);
            } while ((contabilizado = Integer.valueOf(contabilizado + 1)) <= numeroParcelas);
        } else {
            EventoColaborador evt = this.getEvento(vo, dataInicial, dataFinal, valor);
            evts.add(evt);
        }
        return evts;
    }

    private EventoColaborador getEvento(CadastroEventoConsignado vo, Date dataInicial, Date dataFinal, Double valor) {
        EventoColaborador evt = new EventoColaborador();
        evt.setColaborador(vo.getColaborador());
        evt.setDataInicial(dataInicial);
        evt.setDataFinal(dataFinal);
        evt.setEventoConsignado(vo);
        evt.setMes(Short.valueOf(ToolDate.monthFromDate((Date)dataInicial).shortValue()));
        evt.setTipoCalculoEvento(vo.getEventoConsignado());
        evt.setValor(valor);
        evt.setTipoOcorrencia(Short.valueOf(EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getValue()));
        return evt;
    }
}

