/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cadastroeventoconsignado;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoCadastroEventoConsignadoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cadastroeventoconsignado.AuxCadastroEventoConsignado;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementorvalidator.entities.impl.cadastroeventoconsignado.ValidCadastroEventoConsignado;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCadastroEventoConsignadoImpl
extends ServiceGenericEntityImpl<CadastroEventoConsignado, Long, DaoCadastroEventoConsignadoImpl> {
    @Autowired
    public ServiceCadastroEventoConsignadoImpl(DaoCadastroEventoConsignadoImpl dao) {
        super(dao);
    }

    @Override
    public CadastroEventoConsignado beforeSave(CadastroEventoConsignado vo) {
        List<CadastroEventoConsignado> eventosNoPeriodo;
        if (vo.getEventoColaborador() != null) {
            vo.getEventoColaborador().forEach(evt -> evt.setEventoConsignado(vo));
        }
        if ((eventosNoPeriodo = this.getEventosConsignadoPeriodo(vo)) != null && !eventosNoPeriodo.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1148.001", new String[]{ToolDate.dateToStr((Date)vo.getDataInicioDesconto()), ToolDate.dateToStr((Date)vo.getDataFinalDesconto())}));
        }
        if (this.isEquals(vo.getRenegociado(), EnumConstantsMentorSimNao.SIM.getValue())) {
            vo.getEventoColaborador().forEach(i -> i.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue())));
        }
        return vo;
    }

    public List<CadastroEventoConsignado> getEventosConsignadoPeriodo(CadastroEventoConsignado cadastroEventoConsignado) {
        return ((DaoCadastroEventoConsignadoImpl)this.getDao()).verificarExisteEventoConsignado(cadastroEventoConsignado);
    }

    public List<EventoColaborador> criarLancamentosConsignados(CadastroEventoConsignado vo) throws ExceptionInvalidData {
        List<CadastroEventoConsignado> eventosNoPeriodo;
        ValidCadastroEventoConsignado valid = this.getBean(ValidCadastroEventoConsignado.class);
        if (valid != null) {
            valid.clear();
            valid.isValidWithoutEvento(vo);
            if (valid.hasErrors()) {
                throw new ExceptionInvalidData(valid.toString(), new Object[0]);
            }
        }
        if ((eventosNoPeriodo = this.getEventosConsignadoPeriodo(vo)) != null && !eventosNoPeriodo.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1148.001", new String[]{ToolDate.dateToStr((Date)vo.getDataInicioDesconto()), ToolDate.dateToStr((Date)vo.getDataFinalDesconto())}));
        }
        List<EventoColaborador> evts = new AuxCadastroEventoConsignado().criarLancamentosConsignados(vo);
        return evts;
    }
}

