/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cadastrorateiopensaoalimenticia;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.CadastroRateioPensaoAlimenticia;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCadastroRateioPensaoAlimenticia;
import com.touchcomp.basementor.model.vo.ItemRateioBeneficiarioPensao;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorservice.dao.impl.DaoCadastroRateioPensaoAlimenticiaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ServiceCadastroRateioPensaoAlimenticiaImpl
extends ServiceGenericEntityImpl<CadastroRateioPensaoAlimenticia, Long, DaoCadastroRateioPensaoAlimenticiaImpl> {
    final ServiceMovimentoFolhaImpl serviceMovFolha;

    public ServiceCadastroRateioPensaoAlimenticiaImpl(ServiceMovimentoFolhaImpl serviceMovFolha, DaoCadastroRateioPensaoAlimenticiaImpl genericDao) {
        super(genericDao);
        this.serviceMovFolha = serviceMovFolha;
    }

    public List<ItemCadastroRateioPensaoAlimenticia> criarItensRateioPensaoAlimenticia(Empresa empresa, Date periodo, TipoCalculoEvento tipoCalculoEvento, TipoCalculo tipoCalculo) {
        List<Map<String, Object>> itens = this.serviceMovFolha.getItens(empresa, periodo, tipoCalculoEvento, tipoCalculo);
        LinkedList<ItemCadastroRateioPensaoAlimenticia> ret = new LinkedList<ItemCadastroRateioPensaoAlimenticia>();
        for (Map<String, Object> itemMov : itens) {
            ItemCadastroRateioPensaoAlimenticia item = new ItemCadastroRateioPensaoAlimenticia();
            item.setColaborador((Colaborador)itemMov.get("F_COLABORADOR"));
            item.setValorTotalPensao((Double)itemMov.get("F_VALOR"));
            HelperColaborador helperColaborador = new HelperColaborador();
            List deps = helperColaborador.build(item.getColaborador()).getDependentesPensao(periodo);
            for (ColaboradorDependente dep : deps) {
                ItemRateioBeneficiarioPensao itemBeneficiario = new ItemRateioBeneficiarioPensao();
                itemBeneficiario.setBeneficiarioPensao(dep);
                itemBeneficiario.setValorPensao(Double.valueOf(0.0));
                itemBeneficiario.setItemRateioPensao(item);
                item.getRateioBeneficiario().add(itemBeneficiario);
            }
            ret.add(item);
        }
        return ret;
    }
}

