/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cadastrorateiovalorplanosaude;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.CadastroRateioValorPlanoSaude;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCadastroDependentePlanoSaude;
import com.touchcomp.basementor.model.vo.ItemCadastroRateioValorPlanoSaude;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorservice.dao.impl.DaoCadastroRateioValorPlanoSaudeImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCadastroRateioValorPlanoSaudeImpl
extends ServiceGenericEntityImpl<CadastroRateioValorPlanoSaude, Long, DaoCadastroRateioValorPlanoSaudeImpl> {
    ServiceMovimentoFolhaImpl service;
    HelperColaborador helperColaborador;

    public ServiceCadastroRateioValorPlanoSaudeImpl(ServiceMovimentoFolhaImpl service, HelperColaborador helperColaborador, DaoCadastroRateioValorPlanoSaudeImpl genericDao) {
        super(genericDao);
        this.service = service;
        this.helperColaborador = helperColaborador;
    }

    @Autowired
    public ServiceCadastroRateioValorPlanoSaudeImpl(DaoCadastroRateioValorPlanoSaudeImpl dao) {
        super(dao);
    }

    public List<ItemCadastroRateioValorPlanoSaude> getItensCadastroPlanoSaude(Date periodo, Empresa logedEmpresa, TipoCalculoEvento tipoCalculo) {
        List<Map<String, Object>> dados = this.service.getItens(logedEmpresa, periodo, tipoCalculo);
        LinkedList<ItemCadastroRateioValorPlanoSaude> itens = new LinkedList<ItemCadastroRateioValorPlanoSaude>();
        for (Map<String, Object> h : dados) {
            Colaborador colaborador = (Colaborador)h.get("F_COLABORADOR");
            Double valorPlano = (Double)h.get("F_VALOR");
            ItemCadastroRateioValorPlanoSaude item = new ItemCadastroRateioValorPlanoSaude();
            item.setValorTotalDescontoPlanoSaude(valorPlano);
            item.setColaborador(colaborador);
            item.setValorPlanoSaudeTitular(valorPlano);
            List deps = this.helperColaborador.build(colaborador).getDependentesPlanoSaude(periodo);
            for (ColaboradorDependente dep : deps) {
                ItemCadastroDependentePlanoSaude itemDep = new ItemCadastroDependentePlanoSaude();
                itemDep.setDependente(dep);
                itemDep.setItemCadastroRateio(item);
                itemDep.setValorPlanoDependente(Double.valueOf(0.0));
                item.getItensDepentendes().add(itemDep);
            }
            itens.add(item);
        }
        return itens;
    }
}

