/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.calculoinssempresa;

import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoPeriodo;
import com.touchcomp.basementor.model.vo.GeracaoArquivoGps;
import com.touchcomp.basementorservice.dao.impl.DaoCalculoInssEmpresa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fechamentoperiodo.ServiceFechamentoPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.geracaoarquivogps.GeracaoArquivoGpsService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalculoInssEmpresaService
extends ServiceGenericEntityImpl<CalculoInssEmpresa, Long, DaoCalculoInssEmpresa> {
    ServiceFechamentoPeriodoImpl serviceFechamentoPeriodo;
    GeracaoArquivoGpsService geracaoArquivoGpsService;

    @Autowired
    public CalculoInssEmpresaService(DaoCalculoInssEmpresa genericDao, ServiceFechamentoPeriodoImpl serviceFechamentoPeriodo, GeracaoArquivoGpsService geracaoArquivoGpsService) {
        super(genericDao);
        this.serviceFechamentoPeriodo = serviceFechamentoPeriodo;
        this.geracaoArquivoGpsService = geracaoArquivoGpsService;
    }

    public Boolean estornaMovimentoFolha(CalculoInssEmpresa calculo) {
        FechamentoPeriodo fechamentoPeriodo = this.serviceFechamentoPeriodo.getFechamentoByCalculoInss(calculo);
        GeracaoArquivoGps gArquiGps = null;
        if (!this.isNull(fechamentoPeriodo).booleanValue()) {
            gArquiGps = this.geracaoArquivoGpsService.getGeracaoArquivoByFechamento(fechamentoPeriodo);
        }
        Boolean sucesso = this.delete(calculo);
        if (!this.isNull(gArquiGps).booleanValue()) {
            sucesso = sucesso != false && this.geracaoArquivoGpsService.delete(gArquiGps);
        }
        if (!this.isNull(fechamentoPeriodo).booleanValue()) {
            sucesso = sucesso != false && this.serviceFechamentoPeriodo.delete(fechamentoPeriodo);
        }
        return sucesso;
    }

    public Double percentualDesoneracaoInssEmpresa(Date dataInicio, Date dataFinal, Empresa empresa) {
        return ((DaoCalculoInssEmpresa)this.getGenericDao()).percentualDesoneracaoInssEmpresa(dataInicio, dataFinal, empresa);
    }
}

