/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.calculoinssempresa;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.calculoinssempresa.CompCalculoInssEmpresa;
import com.touchcomp.basementorservice.dao.impl.DaoCalculoInssEmpresaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculo.ServiceTipoCalculoImpl;
import com.touchcomp.touchvomodel.vo.calculoinssempresa.web.DTOCalculoInssEmpresa;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCalculoInssEmpresaImpl
extends ServiceGenericEntityImpl<CalculoInssEmpresa, Long, DaoCalculoInssEmpresaImpl> {
    ServiceTipoCalculoImpl serviceTituloCalculo;
    CompCalculoInssEmpresa compCalculoInssEmpresa;

    @Autowired
    public ServiceCalculoInssEmpresaImpl(DaoCalculoInssEmpresaImpl dao, ServiceTipoCalculoImpl serviceTituloCalculo, CompCalculoInssEmpresa compCalculoInssEmpresa) {
        super(dao);
        this.serviceTituloCalculo = serviceTituloCalculo;
        this.compCalculoInssEmpresa = compCalculoInssEmpresa;
    }

    @Override
    public CalculoInssEmpresa beforeSave(CalculoInssEmpresa c) {
        c.getAberturasPeriodo().forEach(i -> i.setCalculoInss(c));
        return c;
    }

    public Double getPercDesoneracao(AberturaPeriodo aberturaPeriodo) {
        return ((DaoCalculoInssEmpresaImpl)this.getGenericDao()).getPercDesoneracao(aberturaPeriodo);
    }

    public List<HashMap> getDadosInssByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoCalculoInssEmpresaImpl)this.getGenericDao()).getDadosInssByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public DTOCalculoInssEmpresa buscarAberturaPeriodo(Date periodo, Long idTipoCalculo, Empresa empresa, EmpresaRh empresaRh) throws ExceptionObjNotFound {
        TipoCalculo tipoCalculo = (TipoCalculo)this.serviceTituloCalculo.getOrThrow(idTipoCalculo);
        return this.buildToDTOGeneric(this.compCalculoInssEmpresa.buscarAberturaPeriodo(periodo, tipoCalculo, empresa, empresaRh), DTOCalculoInssEmpresa.class);
    }

    public List<HashMap> findCalculoInssEmpresaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoCalculoInssEmpresaImpl)this.getGenericDao()).findCalculoInssEmpresaPorDataPagamentoEmpresa(dataPagamento, empresa);
    }
}

