/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.categoriaproduto;

import com.touchcomp.basementor.model.vo.CategoriaProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementorservice.dao.impl.DaoCategoriaProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.categoriaproduto.web.DTOCategoriaProdutoArvore;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceCategoriaProdutoImpl
extends ServiceGenericEntityImpl<CategoriaProduto, Long, DaoCategoriaProdutoImpl> {
    public ServiceCategoriaProdutoImpl(DaoCategoriaProdutoImpl repository) {
        super(repository);
    }

    public List<CategoriaProduto> getAltCriaVincProdTabBase(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, int maxRegs) {
        return ((DaoCategoriaProdutoImpl)this.getDao()).getAltCriaVincProdTabBase(lastSinc, tabBase, firstRes, maxRegs);
    }

    public List<DTOCategoriaProdutoArvore> getCategoriasArvore() {
        List<DTOCategoriaProdutoArvore> categorias = ((DaoCategoriaProdutoImpl)this.getDao()).getDadosCategoriaAtivas();
        LinkedList<DTOCategoriaProdutoArvore> data = new LinkedList<DTOCategoriaProdutoArvore>();
        for (DTOCategoriaProdutoArvore aux : categorias) {
            if (aux.getCategoriaPaiIdentificador() == null) {
                data.add(aux);
                continue;
            }
            Optional<DTOCategoriaProdutoArvore> found = categorias.stream().filter(j -> this.isEquals(j.getIdentificador(), aux.getCategoriaPaiIdentificador())).findFirst();
            if (!found.isPresent()) continue;
            found.get().getCategoriasFilhas().add(aux);
        }
        this.ordenar(data);
        return data;
    }

    private void ordenar(List<DTOCategoriaProdutoArvore> data) {
        Collections.sort(data, (c1, c2) -> c1.getDescricao().compareTo(c2.getDescricao()));
        for (DTOCategoriaProdutoArvore dto : data) {
            this.ordenar(dto.getCategoriasFilhas());
        }
    }
}

