/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.celulaprodutiva;

import com.touchcomp.basementor.constants.enums.celulaprodutiva.EnumConstCelulaProdTipoCusto;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.dao.impl.DaoCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.celulaprodutiva.web.DTOCelulaProdutiva;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCelulaProdutivaImpl
extends ServiceGenericEntityImpl<CelulaProdutiva, Long, DaoCelulaProdutivaImpl> {
    @Autowired
    public ServiceCelulaProdutivaImpl(DaoCelulaProdutivaImpl genericDao) {
        super(genericDao);
    }

    public List<Map<String, Object>> getValorHoraCelulasProd() {
        return ((DaoCelulaProdutivaImpl)this.getGenericDao()).getValorHoraCelulasProd();
    }

    public Double getCustoCelulaProdutiva(EnumConstCelulaProdTipoCusto tipoCusto, Date data, CelulaProdutiva celulaProdutiva) {
        if (tipoCusto == EnumConstCelulaProdTipoCusto.ANALISE_CUSTO_HORA_CEL_INF) {
            return celulaProdutiva.getValorCustoHora();
        }
        Double valor = this.getValorCustoHoraAnalise(celulaProdutiva, data);
        return valor;
    }

    public Double getCustoCelulaProdutiva(EnumConstCelulaProdTipoCusto tipoCusto, CelulaProdutiva celulaProdutiva) {
        return this.getCustoCelulaProdutiva(tipoCusto, new Date(), celulaProdutiva);
    }

    public Double getValorCustoHoraAnalise(CelulaProdutiva celulaProdutiva, Date data) {
        Double valor = ((DaoCelulaProdutivaImpl)this.getDao()).getValorCustoHoraAnalise(celulaProdutiva, data);
        return valor != null ? valor : 0.0;
    }

    @Override
    public CelulaProdutiva beforeSave(CelulaProdutiva aux) {
        aux.getCentroEstoque().forEach(i -> i.setCelulaProdutiva(aux));
        aux.getEquipamentos().forEach(i -> i.setCelulaProdutiva(aux));
        return super.beforeSave(aux);
    }

    public List<CelulaProdutiva> getCelulasAtivas(Empresa emp) {
        return this.getCelulasAtivas(emp, (short)0, new LinkedList<Long>());
    }

    public List<CelulaProdutiva> getCelulasAtivas(Empresa emp, Short filtrarCelula, List<Long> idCelulas) {
        return ((DaoCelulaProdutivaImpl)this.getDao()).getCelulasAtivas(emp, filtrarCelula, idCelulas);
    }

    public CentroEstoque getCentroEstoqueComProd(CelulaProdutiva cel, Empresa empresa) {
        return ((DaoCelulaProdutivaImpl)this.getDao()).getCentroEstoqueComProd(cel, empresa);
    }

    public List<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> getCentrosEstoqueComProd(Long idCelulaProdutiva, Empresa empresa, Class<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> aClass) {
        List data = ((DaoCelulaProdutivaImpl)this.getDao()).getCentroEstoqueComProd(idCelulaProdutiva, empresa);
        return this.buildToDTOGeneric(data, aClass);
    }

    public List<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> getCentrosEstoqueRequisicao(Long idCelulaProdutiva, Empresa empresa, Class<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> aClass) {
        List data = ((DaoCelulaProdutivaImpl)this.getDao()).getCentrosEstoqueRequisicao(idCelulaProdutiva, empresa);
        return this.buildToDTOGeneric(data, aClass);
    }

    public List<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> getCentrosEstoqueComProdFaseProdutiva(Long idFaseProdutiva, Empresa empresa, Class<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> aClass) {
        List data = ((DaoCelulaProdutivaImpl)this.getDao()).getCentrosEstoqueComProdFaseProdutiva(idFaseProdutiva, empresa);
        return this.buildToDTOGeneric(data, aClass);
    }

    public List<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> getCentrosEstoqueRequisicaoFaseProdutiva(Long idFaseProdutiva, Empresa empresa, Class<DTOCelulaProdutiva.DTOCelulaProdCentroEstoque> aClass) {
        List data = ((DaoCelulaProdutivaImpl)this.getDao()).getCentrosEstoqueRequisicaoFaseProdutiva(idFaseProdutiva, empresa);
        return this.buildToDTOGeneric(data, aClass);
    }

    public List<CelulaProdutivaEquipamento> getEquipamentos(Short filtrarCelula, List<Long> idCelulas, Short filtrarEquipamentos, List<Long> idEquipamentos, Short filtrarCentroCusto, List<Long> idCentrosCusto, Short filtrarEmpresaProprietarias, List<Long> idEmpresasProprietarias, Short filtrarFabricantes, List<Long> idFabricantes, Short filtrarFornecedores, List<Long> idFornecedores, Short filtrarTipoEquipamento, List<Long> idTipoEquipamentos) {
        return ((DaoCelulaProdutivaImpl)this.getDao()).getEquipamentos(filtrarCelula, idCelulas, filtrarEquipamentos, idEquipamentos, filtrarCentroCusto, idCentrosCusto, filtrarEmpresaProprietarias, idEmpresasProprietarias, filtrarFabricantes, idFabricantes, filtrarFornecedores, idFornecedores, filtrarTipoEquipamento, idTipoEquipamentos);
    }

    public List<DTOEntidadeRes> getCelulasProdutivasEmpresa(Empresa empresa) {
        return this.buildToDTO(((DaoCelulaProdutivaImpl)this.getGenericDao()).getCelulasProdutivasEmpresa(empresa), DTOEntidadeRes.class);
    }
}

