/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.celulaprodutiva;

import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoQtd;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoTipoEvento;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.ServiceEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.planejtempotrabalhopcp.ServicePlanejTempoTrabalhoPCPImpl;
import com.touchcomp.basementortools.tools.map.annotations.ToMapProperty;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ServiceDesempenhoOEECelProdutivaImpl
extends ServiceGenericImpl {
    final ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl;
    final ServiceEventoOsProducaoLinhaProdImpl serviceEventoOSProducaoImpl;
    final ServicePlanejTempoTrabalhoPCPImpl servicePlanejamentoTempoImpl;

    public ServiceDesempenhoOEECelProdutivaImpl(ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl, ServiceEventoOsProducaoLinhaProdImpl serviceEventoOSProducaoImpl, ServicePlanejTempoTrabalhoPCPImpl servicePlanejamentoTempoImpl) {
        this.serviceCelulaProdutivaImpl = serviceCelulaProdutivaImpl;
        this.serviceEventoOSProducaoImpl = serviceEventoOSProducaoImpl;
        this.servicePlanejamentoTempoImpl = servicePlanejamentoTempoImpl;
    }

    public List<DTOOEECelulaProdutiva> calcularOEE(DTOOEEParams params) {
        Empresa emp = this.getSharedData().getEmpresa(params.getIdEmpresa());
        if (emp == null) {
            return new LinkedList<DTOOEECelulaProdutiva>();
        }
        List<CelulaProdutiva> celulas = this.serviceCelulaProdutivaImpl.getCelulasAtivas(emp, params.getFiltrarCelulaProdutiva(), params.getIdCelulasProdutivas());
        LinkedList<DTOOEECelulaProdutiva> celulasProdutivas = new LinkedList<DTOOEECelulaProdutiva>();
        for (CelulaProdutiva celula : celulas) {
            DTOOEECelulaProdutiva dto = new DTOOEECelulaProdutiva();
            dto.setDescricao(celula.getDescricao());
            dto.setIdentificador(celula.getIdentificador());
            celulasProdutivas.add(dto);
            this.putTempoProgramadoCelula(celula, dto, params);
            this.putTemposProducoesCelula(celula, dto, params);
            this.putProducoesCelula(celula, dto, params);
        }
        this.calcularIndicadoresTipoCelula(celulasProdutivas);
        return celulasProdutivas;
    }

    private void putTempoProgramadoCelula(CelulaProdutiva celula, DTOOEECelulaProdutiva dtoCelula, DTOOEEParams params) {
        List<DiaPlanejTempoTrabalhoPCP> diasTrabalho = this.servicePlanejamentoTempoImpl.getDiasTrabalhoPlanejados(celula, params.getDataInicial(), params.getDataFinal());
        int nrDias = 0;
        for (DiaPlanejTempoTrabalhoPCP dia : diasTrabalho) {
            DTOOEECelulaProdutiva.DTOOeeColetasDia dto = new DTOOEECelulaProdutiva.DTOOeeColetasDia();
            dto.setDataColeta(dia.getDia());
            dto.setTempoPlanejado(dia.getNumeroHorasTrab());
            dtoCelula.getColetasDia().add(dto);
            ++nrDias;
        }
    }

    private void putTemposProducoesCelula(CelulaProdutiva celula, DTOOEECelulaProdutiva dtoCelula, DTOOEEParams params) {
        List<GenericMapValues<GenMapEvtProducaoTipoEvento>> eventos = this.serviceEventoOSProducaoImpl.getApontamentosTipoEvento((short)1, celula.getIdentificador(), params.getDataInicial(), params.getDataFinal(), (short)5, (short)0);
        for (GenericMapValues<GenMapEvtProducaoTipoEvento> evento : eventos) {
            DTOOEECelulaProdutiva.DTOOeeColetasDia dia;
            int tipoEvento = evento.getInteger(GenMapEvtProducaoTipoEvento.CODIGO_TIPO_EVENTO);
            if (!TMethods.isEquals((Object)tipoEvento, (Object)0)) continue;
            Optional<DTOOEECelulaProdutiva.DTOOeeColetasDia> foundDia = dtoCelula.getColetasDia().stream().filter(i -> TMethods.isEquals((Object)i.getDataColeta(), (Object)evento.getDate(GenMapEvtProducaoTipoEvento.DATA))).findFirst();
            if (!foundDia.isPresent()) {
                dia = new DTOOEECelulaProdutiva.DTOOeeColetasDia();
                dia.setDataColeta(evento.getDate(GenMapEvtProducaoTipoEvento.DATA));
                dtoCelula.getColetasDia().add(dia);
            } else {
                dia = foundDia.get();
            }
            dia.setTempoProducao(dia.getTempoProducao() + evento.getDouble(GenMapEvtProducaoTipoEvento.HORAS_EVENTO));
        }
    }

    private void putProducoesCelula(CelulaProdutiva celula, DTOOEECelulaProdutiva dtoCelula, DTOOEEParams params) {
        List<GenericMapValues<GenMapEvtProducaoQtd>> producoes = this.serviceEventoOSProducaoImpl.getApontamentosProducaoQtd((short)1, celula.getIdentificador(), (short)0, 0L, (short)1, EnumConstTipoProducao.PRODUCAO, params.getDataInicial(), params.getDataFinal(), false);
        List<GenericMapValues<GenMapEvtProducaoQtd>> refugos = this.serviceEventoOSProducaoImpl.getApontamentosProducaoProdSubosQtd((short)1, celula.getIdentificador(), (short)0, 0L, (short)1, EnumConstTipoProducao.REFUGO, params.getDataInicial(), params.getDataFinal(), true);
        producoes.addAll(refugos);
        for (GenericMapValues<GenMapEvtProducaoQtd> producao : producoes) {
            DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia produtoDia;
            DTOOEECelulaProdutiva.DTOOeeColetasDia dia;
            Optional<DTOOEECelulaProdutiva.DTOOeeColetasDia> foundDia = dtoCelula.getColetasDia().stream().filter(i -> TMethods.isEquals((Object)i.getDataColeta(), (Object)producao.getDate(GenMapEvtProducaoQtd.DATA))).findFirst();
            if (!foundDia.isPresent()) {
                dia = new DTOOEECelulaProdutiva.DTOOeeColetasDia();
                dia.setDataColeta(producao.getDate(GenMapEvtProducaoQtd.DATA));
                dtoCelula.getColetasDia().add(dia);
            } else {
                dia = foundDia.get();
            }
            Optional<DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia> foundProduto = dia.getProducoesProdutos().stream().filter(i -> TMethods.isEquals((Object)i.getIdentificador(), (Object)producao.getLong(GenMapEvtProducaoQtd.ID_PRODUTO))).findFirst();
            if (!foundProduto.isPresent()) {
                produtoDia = new DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia();
                produtoDia.setCodigoAuxiliar(producao.getString(GenMapEvtProducaoQtd.CODIGO_AUX_PRODUTO));
                produtoDia.setIdentificador(producao.getLong(GenMapEvtProducaoQtd.ID_PRODUTO));
                produtoDia.setProduto(producao.getString(GenMapEvtProducaoQtd.PRODUTO));
                produtoDia.setUnidadeMedida(producao.getString(GenMapEvtProducaoQtd.UN_PRODUTO));
                dia.getProducoesProdutos().add(produtoDia);
            } else {
                produtoDia = foundProduto.get();
            }
            DTOOEECelulaProdutiva.DTOOeeApontamentos apontamento = new DTOOEECelulaProdutiva.DTOOeeApontamentos();
            apontamento.setHorasProducao(producao.getDouble(GenMapEvtProducaoQtd.HORA_PRODUCAO));
            apontamento.setHorasProducaoRoteiro(producao.getDouble(GenMapEvtProducaoQtd.HORA_PRODUCAO_ROTEIRO));
            apontamento.setQuantidadeProduzida(producao.getDouble(GenMapEvtProducaoQtd.QUANTIDADE_TOTAL));
            apontamento.setTipoProducao(producao.getShort(GenMapEvtProducaoQtd.TIPO_PRODUCAO));
            produtoDia.getApontamentos().add(apontamento);
        }
    }

    private void calcularIndicadoresTipoCelula(List<DTOOEECelulaProdutiva> celulasProdutivas) {
        for (DTOOEECelulaProdutiva celula : celulasProdutivas) {
            double percPerformance = 0.0;
            double percDisponibilidade = 0.0;
            double percQualidade = 0.0;
            double quantidadeEsperada = 0.0;
            double quantidadeProduzida = 0.0;
            double quantidadeRefugo = 0.0;
            for (DTOOEECelulaProdutiva.DTOOeeColetasDia dia : celula.getColetasDia()) {
                this.calcularDia(dia);
                percPerformance += dia.getPercPerformance().doubleValue();
                percDisponibilidade += dia.getPercDisponibilidade().doubleValue();
                percQualidade += dia.getPercQualidade().doubleValue();
                quantidadeEsperada += dia.getQuantidadeEsperada().doubleValue();
                quantidadeProduzida += dia.getQuantidadeProduzida().doubleValue();
                quantidadeRefugo += dia.getQuantidadeRefugo().doubleValue();
            }
            celula.setQuantidadeEsperada(quantidadeEsperada);
            celula.setQuantidadeProduzida(quantidadeProduzida);
            celula.setQuantidadeRefugo(quantidadeRefugo);
            int contador = !celula.getEquipamentos().isEmpty() ? celula.getEquipamentos().size() : 1;
            celula.setPercPerformance(percPerformance / (double)contador);
            celula.setPercDisponibilidade(percDisponibilidade / (double)contador);
            celula.setPercQualidade(percQualidade / (double)contador);
            celula.setPercOee(celula.getPercDisponibilidade() / 100.0 * celula.getPercPerformance() / 100.0 * celula.getPercQualidade() / 100.0 * 100.0);
        }
    }

    private void calcularDia(DTOOEECelulaProdutiva.DTOOeeColetasDia dia) {
        double percPerformanceDia = 0.0;
        double percQualidadeDia = 0.0;
        double tempoProducao = 0.0;
        for (DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia produto : dia.getProducoesProdutos()) {
            double quantidadeEsperadaProd = 0.0;
            double quantidadeProduzidaProd = 0.0;
            double quantidadeRefugoProd = 0.0;
            double tempoEsperadoProd = 0.0;
            double tempoProducaoProd = 0.0;
            for (DTOOEECelulaProdutiva.DTOOeeApontamentos apontamento : produto.getApontamentos()) {
                if (ToolMethods.isEquals((Object)EnumConstTipoProducao.PRODUCAO.getValue(), (Object)apontamento.getTipoProducao())) {
                    apontamento.setQuantidadeEsperada(apontamento.getQuantidadeProduzida() / apontamento.getHorasProducaoRoteiro() * apontamento.getHorasProducao());
                    quantidadeProduzidaProd += apontamento.getQuantidadeProduzida().doubleValue();
                    quantidadeEsperadaProd += apontamento.getQuantidadeEsperada().doubleValue();
                    tempoEsperadoProd += apontamento.getHorasProducaoRoteiro().doubleValue();
                    tempoProducaoProd += apontamento.getHorasProducao().doubleValue();
                    continue;
                }
                quantidadeRefugoProd += apontamento.getQuantidadeProduzida().doubleValue();
            }
            produto.setQuantidadeEsperada(quantidadeEsperadaProd);
            produto.setQuantidadeProduzida(quantidadeProduzidaProd);
            produto.setQuantidadeRefugo(quantidadeRefugoProd);
            produto.setTempoProducao(tempoProducaoProd);
            produto.setTempoEsperado(tempoEsperadoProd);
            if (produto.getQuantidadeEsperada() > 0.0) {
                produto.setPercPerformance(produto.getQuantidadeProduzida() / produto.getQuantidadeEsperada() * 100.0);
            }
            if (produto.getQuantidadeProduzida() + produto.getQuantidadeRefugo() > 0.0) {
                produto.setPercQualidade(produto.getQuantidadeProduzida() / (produto.getQuantidadeProduzida() + produto.getQuantidadeRefugo()) * 100.0);
            }
            percPerformanceDia += produto.getPercPerformance().doubleValue();
            percQualidadeDia += produto.getPercQualidade().doubleValue();
            tempoProducao += produto.getTempoProducao().doubleValue();
        }
        int contador = !dia.getProducoesProdutos().isEmpty() ? dia.getProducoesProdutos().size() : 1;
        dia.setTempoProducao(tempoProducao);
        dia.setPercQualidade(percQualidadeDia / (double)contador);
        dia.setPercPerformance(percPerformanceDia / (double)contador);
        if (dia.getTempoPlanejado() > 0.0) {
            dia.setPercDisponibilidade(dia.getTempoProducao() / dia.getTempoPlanejado() * 100.0);
        }
        dia.setPercOee(dia.getPercDisponibilidade() / 100.0 * dia.getPercPerformance() / 100.0 * dia.getPercQualidade() / 100.0 * 100.0);
    }

    public static class DTOOEEParams {
        private Date dataInicial;
        private Date dataFinal;
        private Long idEmpresa;
        private Short tipoOrigemTempoPlanejado;
        private Short tipoOrigemTempoProducao;
        private Short tipoAnaliseCelEquip;
        private Short filtrarCelulaProdutiva;
        private List<Long> idCelulasProdutivas = new LinkedList<Long>();
        private Short filtrarEquipamentos;
        private List<Long> idEquipamentos = new LinkedList<Long>();
        private Short filtrarCentroCusto;
        private List<Long> idCentrosCusto = new LinkedList<Long>();
        private Short filtrarFabricantes;
        private List<Long> idFabricantes = new LinkedList<Long>();
        private Short filtrarFornecedores;
        private List<Long> idFornecedores = new LinkedList<Long>();
        private Short filtrarEmpresaProprietarias;
        private List<Long> idEmpresasProprietarias = new LinkedList<Long>();
        private Short filtrarTipoEquipamento;
        private List<Long> idTipoEquipamentos = new LinkedList<Long>();

        @Generated
        public DTOOEEParams() {
        }

        @Generated
        public Date getDataInicial() {
            return this.dataInicial;
        }

        @Generated
        public Date getDataFinal() {
            return this.dataFinal;
        }

        @Generated
        public Long getIdEmpresa() {
            return this.idEmpresa;
        }

        @Generated
        public Short getTipoOrigemTempoPlanejado() {
            return this.tipoOrigemTempoPlanejado;
        }

        @Generated
        public Short getTipoOrigemTempoProducao() {
            return this.tipoOrigemTempoProducao;
        }

        @Generated
        public Short getTipoAnaliseCelEquip() {
            return this.tipoAnaliseCelEquip;
        }

        @Generated
        public Short getFiltrarCelulaProdutiva() {
            return this.filtrarCelulaProdutiva;
        }

        @Generated
        public List<Long> getIdCelulasProdutivas() {
            return this.idCelulasProdutivas;
        }

        @Generated
        public Short getFiltrarEquipamentos() {
            return this.filtrarEquipamentos;
        }

        @Generated
        public List<Long> getIdEquipamentos() {
            return this.idEquipamentos;
        }

        @Generated
        public Short getFiltrarCentroCusto() {
            return this.filtrarCentroCusto;
        }

        @Generated
        public List<Long> getIdCentrosCusto() {
            return this.idCentrosCusto;
        }

        @Generated
        public Short getFiltrarFabricantes() {
            return this.filtrarFabricantes;
        }

        @Generated
        public List<Long> getIdFabricantes() {
            return this.idFabricantes;
        }

        @Generated
        public Short getFiltrarFornecedores() {
            return this.filtrarFornecedores;
        }

        @Generated
        public List<Long> getIdFornecedores() {
            return this.idFornecedores;
        }

        @Generated
        public Short getFiltrarEmpresaProprietarias() {
            return this.filtrarEmpresaProprietarias;
        }

        @Generated
        public List<Long> getIdEmpresasProprietarias() {
            return this.idEmpresasProprietarias;
        }

        @Generated
        public Short getFiltrarTipoEquipamento() {
            return this.filtrarTipoEquipamento;
        }

        @Generated
        public List<Long> getIdTipoEquipamentos() {
            return this.idTipoEquipamentos;
        }

        @Generated
        public void setDataInicial(Date dataInicial) {
            this.dataInicial = dataInicial;
        }

        @Generated
        public void setDataFinal(Date dataFinal) {
            this.dataFinal = dataFinal;
        }

        @Generated
        public void setIdEmpresa(Long idEmpresa) {
            this.idEmpresa = idEmpresa;
        }

        @Generated
        public void setTipoOrigemTempoPlanejado(Short tipoOrigemTempoPlanejado) {
            this.tipoOrigemTempoPlanejado = tipoOrigemTempoPlanejado;
        }

        @Generated
        public void setTipoOrigemTempoProducao(Short tipoOrigemTempoProducao) {
            this.tipoOrigemTempoProducao = tipoOrigemTempoProducao;
        }

        @Generated
        public void setTipoAnaliseCelEquip(Short tipoAnaliseCelEquip) {
            this.tipoAnaliseCelEquip = tipoAnaliseCelEquip;
        }

        @Generated
        public void setFiltrarCelulaProdutiva(Short filtrarCelulaProdutiva) {
            this.filtrarCelulaProdutiva = filtrarCelulaProdutiva;
        }

        @Generated
        public void setIdCelulasProdutivas(List<Long> idCelulasProdutivas) {
            this.idCelulasProdutivas = idCelulasProdutivas;
        }

        @Generated
        public void setFiltrarEquipamentos(Short filtrarEquipamentos) {
            this.filtrarEquipamentos = filtrarEquipamentos;
        }

        @Generated
        public void setIdEquipamentos(List<Long> idEquipamentos) {
            this.idEquipamentos = idEquipamentos;
        }

        @Generated
        public void setFiltrarCentroCusto(Short filtrarCentroCusto) {
            this.filtrarCentroCusto = filtrarCentroCusto;
        }

        @Generated
        public void setIdCentrosCusto(List<Long> idCentrosCusto) {
            this.idCentrosCusto = idCentrosCusto;
        }

        @Generated
        public void setFiltrarFabricantes(Short filtrarFabricantes) {
            this.filtrarFabricantes = filtrarFabricantes;
        }

        @Generated
        public void setIdFabricantes(List<Long> idFabricantes) {
            this.idFabricantes = idFabricantes;
        }

        @Generated
        public void setFiltrarFornecedores(Short filtrarFornecedores) {
            this.filtrarFornecedores = filtrarFornecedores;
        }

        @Generated
        public void setIdFornecedores(List<Long> idFornecedores) {
            this.idFornecedores = idFornecedores;
        }

        @Generated
        public void setFiltrarEmpresaProprietarias(Short filtrarEmpresaProprietarias) {
            this.filtrarEmpresaProprietarias = filtrarEmpresaProprietarias;
        }

        @Generated
        public void setIdEmpresasProprietarias(List<Long> idEmpresasProprietarias) {
            this.idEmpresasProprietarias = idEmpresasProprietarias;
        }

        @Generated
        public void setFiltrarTipoEquipamento(Short filtrarTipoEquipamento) {
            this.filtrarTipoEquipamento = filtrarTipoEquipamento;
        }

        @Generated
        public void setIdTipoEquipamentos(List<Long> idTipoEquipamentos) {
            this.idTipoEquipamentos = idTipoEquipamentos;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DTOOEEParams)) {
                return false;
            }
            DTOOEEParams other = (DTOOEEParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$idEmpresa = this.getIdEmpresa();
            Long other$idEmpresa = other.getIdEmpresa();
            if (this$idEmpresa == null ? other$idEmpresa != null : !((Object)this$idEmpresa).equals(other$idEmpresa)) {
                return false;
            }
            Short this$tipoOrigemTempoPlanejado = this.getTipoOrigemTempoPlanejado();
            Short other$tipoOrigemTempoPlanejado = other.getTipoOrigemTempoPlanejado();
            if (this$tipoOrigemTempoPlanejado == null ? other$tipoOrigemTempoPlanejado != null : !((Object)this$tipoOrigemTempoPlanejado).equals(other$tipoOrigemTempoPlanejado)) {
                return false;
            }
            Short this$tipoOrigemTempoProducao = this.getTipoOrigemTempoProducao();
            Short other$tipoOrigemTempoProducao = other.getTipoOrigemTempoProducao();
            if (this$tipoOrigemTempoProducao == null ? other$tipoOrigemTempoProducao != null : !((Object)this$tipoOrigemTempoProducao).equals(other$tipoOrigemTempoProducao)) {
                return false;
            }
            Short this$tipoAnaliseCelEquip = this.getTipoAnaliseCelEquip();
            Short other$tipoAnaliseCelEquip = other.getTipoAnaliseCelEquip();
            if (this$tipoAnaliseCelEquip == null ? other$tipoAnaliseCelEquip != null : !((Object)this$tipoAnaliseCelEquip).equals(other$tipoAnaliseCelEquip)) {
                return false;
            }
            Short this$filtrarCelulaProdutiva = this.getFiltrarCelulaProdutiva();
            Short other$filtrarCelulaProdutiva = other.getFiltrarCelulaProdutiva();
            if (this$filtrarCelulaProdutiva == null ? other$filtrarCelulaProdutiva != null : !((Object)this$filtrarCelulaProdutiva).equals(other$filtrarCelulaProdutiva)) {
                return false;
            }
            Short this$filtrarEquipamentos = this.getFiltrarEquipamentos();
            Short other$filtrarEquipamentos = other.getFiltrarEquipamentos();
            if (this$filtrarEquipamentos == null ? other$filtrarEquipamentos != null : !((Object)this$filtrarEquipamentos).equals(other$filtrarEquipamentos)) {
                return false;
            }
            Short this$filtrarCentroCusto = this.getFiltrarCentroCusto();
            Short other$filtrarCentroCusto = other.getFiltrarCentroCusto();
            if (this$filtrarCentroCusto == null ? other$filtrarCentroCusto != null : !((Object)this$filtrarCentroCusto).equals(other$filtrarCentroCusto)) {
                return false;
            }
            Short this$filtrarFabricantes = this.getFiltrarFabricantes();
            Short other$filtrarFabricantes = other.getFiltrarFabricantes();
            if (this$filtrarFabricantes == null ? other$filtrarFabricantes != null : !((Object)this$filtrarFabricantes).equals(other$filtrarFabricantes)) {
                return false;
            }
            Short this$filtrarFornecedores = this.getFiltrarFornecedores();
            Short other$filtrarFornecedores = other.getFiltrarFornecedores();
            if (this$filtrarFornecedores == null ? other$filtrarFornecedores != null : !((Object)this$filtrarFornecedores).equals(other$filtrarFornecedores)) {
                return false;
            }
            Short this$filtrarEmpresaProprietarias = this.getFiltrarEmpresaProprietarias();
            Short other$filtrarEmpresaProprietarias = other.getFiltrarEmpresaProprietarias();
            if (this$filtrarEmpresaProprietarias == null ? other$filtrarEmpresaProprietarias != null : !((Object)this$filtrarEmpresaProprietarias).equals(other$filtrarEmpresaProprietarias)) {
                return false;
            }
            Short this$filtrarTipoEquipamento = this.getFiltrarTipoEquipamento();
            Short other$filtrarTipoEquipamento = other.getFiltrarTipoEquipamento();
            if (this$filtrarTipoEquipamento == null ? other$filtrarTipoEquipamento != null : !((Object)this$filtrarTipoEquipamento).equals(other$filtrarTipoEquipamento)) {
                return false;
            }
            Date this$dataInicial = this.getDataInicial();
            Date other$dataInicial = other.getDataInicial();
            if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
                return false;
            }
            Date this$dataFinal = this.getDataFinal();
            Date other$dataFinal = other.getDataFinal();
            if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
                return false;
            }
            List<Long> this$idCelulasProdutivas = this.getIdCelulasProdutivas();
            List<Long> other$idCelulasProdutivas = other.getIdCelulasProdutivas();
            if (this$idCelulasProdutivas == null ? other$idCelulasProdutivas != null : !((Object)this$idCelulasProdutivas).equals(other$idCelulasProdutivas)) {
                return false;
            }
            List<Long> this$idEquipamentos = this.getIdEquipamentos();
            List<Long> other$idEquipamentos = other.getIdEquipamentos();
            if (this$idEquipamentos == null ? other$idEquipamentos != null : !((Object)this$idEquipamentos).equals(other$idEquipamentos)) {
                return false;
            }
            List<Long> this$idCentrosCusto = this.getIdCentrosCusto();
            List<Long> other$idCentrosCusto = other.getIdCentrosCusto();
            if (this$idCentrosCusto == null ? other$idCentrosCusto != null : !((Object)this$idCentrosCusto).equals(other$idCentrosCusto)) {
                return false;
            }
            List<Long> this$idFabricantes = this.getIdFabricantes();
            List<Long> other$idFabricantes = other.getIdFabricantes();
            if (this$idFabricantes == null ? other$idFabricantes != null : !((Object)this$idFabricantes).equals(other$idFabricantes)) {
                return false;
            }
            List<Long> this$idFornecedores = this.getIdFornecedores();
            List<Long> other$idFornecedores = other.getIdFornecedores();
            if (this$idFornecedores == null ? other$idFornecedores != null : !((Object)this$idFornecedores).equals(other$idFornecedores)) {
                return false;
            }
            List<Long> this$idEmpresasProprietarias = this.getIdEmpresasProprietarias();
            List<Long> other$idEmpresasProprietarias = other.getIdEmpresasProprietarias();
            if (this$idEmpresasProprietarias == null ? other$idEmpresasProprietarias != null : !((Object)this$idEmpresasProprietarias).equals(other$idEmpresasProprietarias)) {
                return false;
            }
            List<Long> this$idTipoEquipamentos = this.getIdTipoEquipamentos();
            List<Long> other$idTipoEquipamentos = other.getIdTipoEquipamentos();
            return !(this$idTipoEquipamentos == null ? other$idTipoEquipamentos != null : !((Object)this$idTipoEquipamentos).equals(other$idTipoEquipamentos));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DTOOEEParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $idEmpresa = this.getIdEmpresa();
            result = result * 59 + ($idEmpresa == null ? 43 : ((Object)$idEmpresa).hashCode());
            Short $tipoOrigemTempoPlanejado = this.getTipoOrigemTempoPlanejado();
            result = result * 59 + ($tipoOrigemTempoPlanejado == null ? 43 : ((Object)$tipoOrigemTempoPlanejado).hashCode());
            Short $tipoOrigemTempoProducao = this.getTipoOrigemTempoProducao();
            result = result * 59 + ($tipoOrigemTempoProducao == null ? 43 : ((Object)$tipoOrigemTempoProducao).hashCode());
            Short $tipoAnaliseCelEquip = this.getTipoAnaliseCelEquip();
            result = result * 59 + ($tipoAnaliseCelEquip == null ? 43 : ((Object)$tipoAnaliseCelEquip).hashCode());
            Short $filtrarCelulaProdutiva = this.getFiltrarCelulaProdutiva();
            result = result * 59 + ($filtrarCelulaProdutiva == null ? 43 : ((Object)$filtrarCelulaProdutiva).hashCode());
            Short $filtrarEquipamentos = this.getFiltrarEquipamentos();
            result = result * 59 + ($filtrarEquipamentos == null ? 43 : ((Object)$filtrarEquipamentos).hashCode());
            Short $filtrarCentroCusto = this.getFiltrarCentroCusto();
            result = result * 59 + ($filtrarCentroCusto == null ? 43 : ((Object)$filtrarCentroCusto).hashCode());
            Short $filtrarFabricantes = this.getFiltrarFabricantes();
            result = result * 59 + ($filtrarFabricantes == null ? 43 : ((Object)$filtrarFabricantes).hashCode());
            Short $filtrarFornecedores = this.getFiltrarFornecedores();
            result = result * 59 + ($filtrarFornecedores == null ? 43 : ((Object)$filtrarFornecedores).hashCode());
            Short $filtrarEmpresaProprietarias = this.getFiltrarEmpresaProprietarias();
            result = result * 59 + ($filtrarEmpresaProprietarias == null ? 43 : ((Object)$filtrarEmpresaProprietarias).hashCode());
            Short $filtrarTipoEquipamento = this.getFiltrarTipoEquipamento();
            result = result * 59 + ($filtrarTipoEquipamento == null ? 43 : ((Object)$filtrarTipoEquipamento).hashCode());
            Date $dataInicial = this.getDataInicial();
            result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
            Date $dataFinal = this.getDataFinal();
            result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
            List<Long> $idCelulasProdutivas = this.getIdCelulasProdutivas();
            result = result * 59 + ($idCelulasProdutivas == null ? 43 : ((Object)$idCelulasProdutivas).hashCode());
            List<Long> $idEquipamentos = this.getIdEquipamentos();
            result = result * 59 + ($idEquipamentos == null ? 43 : ((Object)$idEquipamentos).hashCode());
            List<Long> $idCentrosCusto = this.getIdCentrosCusto();
            result = result * 59 + ($idCentrosCusto == null ? 43 : ((Object)$idCentrosCusto).hashCode());
            List<Long> $idFabricantes = this.getIdFabricantes();
            result = result * 59 + ($idFabricantes == null ? 43 : ((Object)$idFabricantes).hashCode());
            List<Long> $idFornecedores = this.getIdFornecedores();
            result = result * 59 + ($idFornecedores == null ? 43 : ((Object)$idFornecedores).hashCode());
            List<Long> $idEmpresasProprietarias = this.getIdEmpresasProprietarias();
            result = result * 59 + ($idEmpresasProprietarias == null ? 43 : ((Object)$idEmpresasProprietarias).hashCode());
            List<Long> $idTipoEquipamentos = this.getIdTipoEquipamentos();
            result = result * 59 + ($idTipoEquipamentos == null ? 43 : ((Object)$idTipoEquipamentos).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams(dataInicial=" + String.valueOf(this.getDataInicial()) + ", dataFinal=" + String.valueOf(this.getDataFinal()) + ", idEmpresa=" + this.getIdEmpresa() + ", tipoOrigemTempoPlanejado=" + this.getTipoOrigemTempoPlanejado() + ", tipoOrigemTempoProducao=" + this.getTipoOrigemTempoProducao() + ", tipoAnaliseCelEquip=" + this.getTipoAnaliseCelEquip() + ", filtrarCelulaProdutiva=" + this.getFiltrarCelulaProdutiva() + ", idCelulasProdutivas=" + String.valueOf(this.getIdCelulasProdutivas()) + ", filtrarEquipamentos=" + this.getFiltrarEquipamentos() + ", idEquipamentos=" + String.valueOf(this.getIdEquipamentos()) + ", filtrarCentroCusto=" + this.getFiltrarCentroCusto() + ", idCentrosCusto=" + String.valueOf(this.getIdCentrosCusto()) + ", filtrarFabricantes=" + this.getFiltrarFabricantes() + ", idFabricantes=" + String.valueOf(this.getIdFabricantes()) + ", filtrarFornecedores=" + this.getFiltrarFornecedores() + ", idFornecedores=" + String.valueOf(this.getIdFornecedores()) + ", filtrarEmpresaProprietarias=" + this.getFiltrarEmpresaProprietarias() + ", idEmpresasProprietarias=" + String.valueOf(this.getIdEmpresasProprietarias()) + ", filtrarTipoEquipamento=" + this.getFiltrarTipoEquipamento() + ", idTipoEquipamentos=" + String.valueOf(this.getIdTipoEquipamentos()) + ")";
        }
    }

    public static class DTOOEECelulaProdutiva {
        @ToMapProperty(value="F_ID_CELULA")
        private Long identificador;
        @ToMapProperty(value="F_NOME_CELULA")
        private String descricao;
        @ToMapProperty(value="F_TEMPO_PRODUCAO_CELULA")
        private Double tempoProducao = 0.0;
        @ToMapProperty(value="F_TEMPO_PLANEJADO_CELULA")
        private Double tempoPlanejado = 0.0;
        @ToMapProperty(value="F_QTD_REFUGO_CELULA")
        private Double quantidadeRefugo = 0.0;
        @ToMapProperty(value="F_QTD_PRODUZIDA_CELULA")
        private Double quantidadeProduzida = 0.0;
        @ToMapProperty(value="F_QTD_ESPERADA_CELULA")
        private Double quantidadeEsperada = 0.0;
        @ToMapProperty(value="F_PERC_DISPONIBILIDADE_CELULA")
        private Double percDisponibilidade = 0.0;
        @ToMapProperty(value="F_PERC_QUALIDADE_CELULA")
        private Double percQualidade = 0.0;
        @ToMapProperty(value="F_PERC_PERFORMANCE_CELULA")
        private Double percPerformance = 0.0;
        @ToMapProperty(value="F_PERC_OEE_CELULA")
        private Double percOee = 0.0;
        @ToMapProperty(value="F_EQUIPAMENTOS_CELULA")
        private List<DTOOEEEquipamento> equipamentos = new LinkedList<DTOOEEEquipamento>();
        @ToMapProperty(value="F_COLETAS_DIA_CELULA")
        private List<DTOOeeColetasDia> coletasDia = new LinkedList<DTOOeeColetasDia>();

        @Generated
        public DTOOEECelulaProdutiva() {
        }

        @Generated
        public Long getIdentificador() {
            return this.identificador;
        }

        @Generated
        public String getDescricao() {
            return this.descricao;
        }

        @Generated
        public Double getTempoProducao() {
            return this.tempoProducao;
        }

        @Generated
        public Double getTempoPlanejado() {
            return this.tempoPlanejado;
        }

        @Generated
        public Double getQuantidadeRefugo() {
            return this.quantidadeRefugo;
        }

        @Generated
        public Double getQuantidadeProduzida() {
            return this.quantidadeProduzida;
        }

        @Generated
        public Double getQuantidadeEsperada() {
            return this.quantidadeEsperada;
        }

        @Generated
        public Double getPercDisponibilidade() {
            return this.percDisponibilidade;
        }

        @Generated
        public Double getPercQualidade() {
            return this.percQualidade;
        }

        @Generated
        public Double getPercPerformance() {
            return this.percPerformance;
        }

        @Generated
        public Double getPercOee() {
            return this.percOee;
        }

        @Generated
        public List<DTOOEEEquipamento> getEquipamentos() {
            return this.equipamentos;
        }

        @Generated
        public List<DTOOeeColetasDia> getColetasDia() {
            return this.coletasDia;
        }

        @Generated
        public void setIdentificador(Long identificador) {
            this.identificador = identificador;
        }

        @Generated
        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }

        @Generated
        public void setTempoProducao(Double tempoProducao) {
            this.tempoProducao = tempoProducao;
        }

        @Generated
        public void setTempoPlanejado(Double tempoPlanejado) {
            this.tempoPlanejado = tempoPlanejado;
        }

        @Generated
        public void setQuantidadeRefugo(Double quantidadeRefugo) {
            this.quantidadeRefugo = quantidadeRefugo;
        }

        @Generated
        public void setQuantidadeProduzida(Double quantidadeProduzida) {
            this.quantidadeProduzida = quantidadeProduzida;
        }

        @Generated
        public void setQuantidadeEsperada(Double quantidadeEsperada) {
            this.quantidadeEsperada = quantidadeEsperada;
        }

        @Generated
        public void setPercDisponibilidade(Double percDisponibilidade) {
            this.percDisponibilidade = percDisponibilidade;
        }

        @Generated
        public void setPercQualidade(Double percQualidade) {
            this.percQualidade = percQualidade;
        }

        @Generated
        public void setPercPerformance(Double percPerformance) {
            this.percPerformance = percPerformance;
        }

        @Generated
        public void setPercOee(Double percOee) {
            this.percOee = percOee;
        }

        @Generated
        public void setEquipamentos(List<DTOOEEEquipamento> equipamentos) {
            this.equipamentos = equipamentos;
        }

        @Generated
        public void setColetasDia(List<DTOOeeColetasDia> coletasDia) {
            this.coletasDia = coletasDia;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DTOOEECelulaProdutiva)) {
                return false;
            }
            DTOOEECelulaProdutiva other = (DTOOEECelulaProdutiva)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$identificador = this.getIdentificador();
            Long other$identificador = other.getIdentificador();
            if (this$identificador == null ? other$identificador != null : !((Object)this$identificador).equals(other$identificador)) {
                return false;
            }
            Double this$tempoProducao = this.getTempoProducao();
            Double other$tempoProducao = other.getTempoProducao();
            if (this$tempoProducao == null ? other$tempoProducao != null : !((Object)this$tempoProducao).equals(other$tempoProducao)) {
                return false;
            }
            Double this$tempoPlanejado = this.getTempoPlanejado();
            Double other$tempoPlanejado = other.getTempoPlanejado();
            if (this$tempoPlanejado == null ? other$tempoPlanejado != null : !((Object)this$tempoPlanejado).equals(other$tempoPlanejado)) {
                return false;
            }
            Double this$quantidadeRefugo = this.getQuantidadeRefugo();
            Double other$quantidadeRefugo = other.getQuantidadeRefugo();
            if (this$quantidadeRefugo == null ? other$quantidadeRefugo != null : !((Object)this$quantidadeRefugo).equals(other$quantidadeRefugo)) {
                return false;
            }
            Double this$quantidadeProduzida = this.getQuantidadeProduzida();
            Double other$quantidadeProduzida = other.getQuantidadeProduzida();
            if (this$quantidadeProduzida == null ? other$quantidadeProduzida != null : !((Object)this$quantidadeProduzida).equals(other$quantidadeProduzida)) {
                return false;
            }
            Double this$quantidadeEsperada = this.getQuantidadeEsperada();
            Double other$quantidadeEsperada = other.getQuantidadeEsperada();
            if (this$quantidadeEsperada == null ? other$quantidadeEsperada != null : !((Object)this$quantidadeEsperada).equals(other$quantidadeEsperada)) {
                return false;
            }
            Double this$percDisponibilidade = this.getPercDisponibilidade();
            Double other$percDisponibilidade = other.getPercDisponibilidade();
            if (this$percDisponibilidade == null ? other$percDisponibilidade != null : !((Object)this$percDisponibilidade).equals(other$percDisponibilidade)) {
                return false;
            }
            Double this$percQualidade = this.getPercQualidade();
            Double other$percQualidade = other.getPercQualidade();
            if (this$percQualidade == null ? other$percQualidade != null : !((Object)this$percQualidade).equals(other$percQualidade)) {
                return false;
            }
            Double this$percPerformance = this.getPercPerformance();
            Double other$percPerformance = other.getPercPerformance();
            if (this$percPerformance == null ? other$percPerformance != null : !((Object)this$percPerformance).equals(other$percPerformance)) {
                return false;
            }
            Double this$percOee = this.getPercOee();
            Double other$percOee = other.getPercOee();
            if (this$percOee == null ? other$percOee != null : !((Object)this$percOee).equals(other$percOee)) {
                return false;
            }
            String this$descricao = this.getDescricao();
            String other$descricao = other.getDescricao();
            if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
                return false;
            }
            List<DTOOEEEquipamento> this$equipamentos = this.getEquipamentos();
            List<DTOOEEEquipamento> other$equipamentos = other.getEquipamentos();
            if (this$equipamentos == null ? other$equipamentos != null : !((Object)this$equipamentos).equals(other$equipamentos)) {
                return false;
            }
            List<DTOOeeColetasDia> this$coletasDia = this.getColetasDia();
            List<DTOOeeColetasDia> other$coletasDia = other.getColetasDia();
            return !(this$coletasDia == null ? other$coletasDia != null : !((Object)this$coletasDia).equals(other$coletasDia));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DTOOEECelulaProdutiva;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $identificador = this.getIdentificador();
            result = result * 59 + ($identificador == null ? 43 : ((Object)$identificador).hashCode());
            Double $tempoProducao = this.getTempoProducao();
            result = result * 59 + ($tempoProducao == null ? 43 : ((Object)$tempoProducao).hashCode());
            Double $tempoPlanejado = this.getTempoPlanejado();
            result = result * 59 + ($tempoPlanejado == null ? 43 : ((Object)$tempoPlanejado).hashCode());
            Double $quantidadeRefugo = this.getQuantidadeRefugo();
            result = result * 59 + ($quantidadeRefugo == null ? 43 : ((Object)$quantidadeRefugo).hashCode());
            Double $quantidadeProduzida = this.getQuantidadeProduzida();
            result = result * 59 + ($quantidadeProduzida == null ? 43 : ((Object)$quantidadeProduzida).hashCode());
            Double $quantidadeEsperada = this.getQuantidadeEsperada();
            result = result * 59 + ($quantidadeEsperada == null ? 43 : ((Object)$quantidadeEsperada).hashCode());
            Double $percDisponibilidade = this.getPercDisponibilidade();
            result = result * 59 + ($percDisponibilidade == null ? 43 : ((Object)$percDisponibilidade).hashCode());
            Double $percQualidade = this.getPercQualidade();
            result = result * 59 + ($percQualidade == null ? 43 : ((Object)$percQualidade).hashCode());
            Double $percPerformance = this.getPercPerformance();
            result = result * 59 + ($percPerformance == null ? 43 : ((Object)$percPerformance).hashCode());
            Double $percOee = this.getPercOee();
            result = result * 59 + ($percOee == null ? 43 : ((Object)$percOee).hashCode());
            String $descricao = this.getDescricao();
            result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
            List<DTOOEEEquipamento> $equipamentos = this.getEquipamentos();
            result = result * 59 + ($equipamentos == null ? 43 : ((Object)$equipamentos).hashCode());
            List<DTOOeeColetasDia> $coletasDia = this.getColetasDia();
            result = result * 59 + ($coletasDia == null ? 43 : ((Object)$coletasDia).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva(identificador=" + this.getIdentificador() + ", descricao=" + this.getDescricao() + ", tempoProducao=" + this.getTempoProducao() + ", tempoPlanejado=" + this.getTempoPlanejado() + ", quantidadeRefugo=" + this.getQuantidadeRefugo() + ", quantidadeProduzida=" + this.getQuantidadeProduzida() + ", quantidadeEsperada=" + this.getQuantidadeEsperada() + ", percDisponibilidade=" + this.getPercDisponibilidade() + ", percQualidade=" + this.getPercQualidade() + ", percPerformance=" + this.getPercPerformance() + ", percOee=" + this.getPercOee() + ", equipamentos=" + String.valueOf(this.getEquipamentos()) + ", coletasDia=" + String.valueOf(this.getColetasDia()) + ")";
        }

        public static class DTOOeeApontamentos {
            @ToMapProperty(value="F_TIPO_PRODUCAO_APONT")
            private Short tipoProducao;
            @ToMapProperty(value="F_QTD_PRODUZIDA_APONT")
            private Double quantidadeProduzida = 0.0;
            @ToMapProperty(value="F_QTD_ESPERADA_APONT")
            private Double quantidadeEsperada = 0.0;
            @ToMapProperty(value="F_HORAS_PROD_APONT")
            private Double horasProducao = 0.0;
            @ToMapProperty(value="F_HORAS_PROD_ROTEIRO_APONT")
            private Double horasProducaoRoteiro = 0.0;

            @Generated
            public DTOOeeApontamentos() {
            }

            @Generated
            public Short getTipoProducao() {
                return this.tipoProducao;
            }

            @Generated
            public Double getQuantidadeProduzida() {
                return this.quantidadeProduzida;
            }

            @Generated
            public Double getQuantidadeEsperada() {
                return this.quantidadeEsperada;
            }

            @Generated
            public Double getHorasProducao() {
                return this.horasProducao;
            }

            @Generated
            public Double getHorasProducaoRoteiro() {
                return this.horasProducaoRoteiro;
            }

            @Generated
            public void setTipoProducao(Short tipoProducao) {
                this.tipoProducao = tipoProducao;
            }

            @Generated
            public void setQuantidadeProduzida(Double quantidadeProduzida) {
                this.quantidadeProduzida = quantidadeProduzida;
            }

            @Generated
            public void setQuantidadeEsperada(Double quantidadeEsperada) {
                this.quantidadeEsperada = quantidadeEsperada;
            }

            @Generated
            public void setHorasProducao(Double horasProducao) {
                this.horasProducao = horasProducao;
            }

            @Generated
            public void setHorasProducaoRoteiro(Double horasProducaoRoteiro) {
                this.horasProducaoRoteiro = horasProducaoRoteiro;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DTOOeeApontamentos)) {
                    return false;
                }
                DTOOeeApontamentos other = (DTOOeeApontamentos)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Short this$tipoProducao = this.getTipoProducao();
                Short other$tipoProducao = other.getTipoProducao();
                if (this$tipoProducao == null ? other$tipoProducao != null : !((Object)this$tipoProducao).equals(other$tipoProducao)) {
                    return false;
                }
                Double this$quantidadeProduzida = this.getQuantidadeProduzida();
                Double other$quantidadeProduzida = other.getQuantidadeProduzida();
                if (this$quantidadeProduzida == null ? other$quantidadeProduzida != null : !((Object)this$quantidadeProduzida).equals(other$quantidadeProduzida)) {
                    return false;
                }
                Double this$quantidadeEsperada = this.getQuantidadeEsperada();
                Double other$quantidadeEsperada = other.getQuantidadeEsperada();
                if (this$quantidadeEsperada == null ? other$quantidadeEsperada != null : !((Object)this$quantidadeEsperada).equals(other$quantidadeEsperada)) {
                    return false;
                }
                Double this$horasProducao = this.getHorasProducao();
                Double other$horasProducao = other.getHorasProducao();
                if (this$horasProducao == null ? other$horasProducao != null : !((Object)this$horasProducao).equals(other$horasProducao)) {
                    return false;
                }
                Double this$horasProducaoRoteiro = this.getHorasProducaoRoteiro();
                Double other$horasProducaoRoteiro = other.getHorasProducaoRoteiro();
                return !(this$horasProducaoRoteiro == null ? other$horasProducaoRoteiro != null : !((Object)this$horasProducaoRoteiro).equals(other$horasProducaoRoteiro));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DTOOeeApontamentos;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Short $tipoProducao = this.getTipoProducao();
                result = result * 59 + ($tipoProducao == null ? 43 : ((Object)$tipoProducao).hashCode());
                Double $quantidadeProduzida = this.getQuantidadeProduzida();
                result = result * 59 + ($quantidadeProduzida == null ? 43 : ((Object)$quantidadeProduzida).hashCode());
                Double $quantidadeEsperada = this.getQuantidadeEsperada();
                result = result * 59 + ($quantidadeEsperada == null ? 43 : ((Object)$quantidadeEsperada).hashCode());
                Double $horasProducao = this.getHorasProducao();
                result = result * 59 + ($horasProducao == null ? 43 : ((Object)$horasProducao).hashCode());
                Double $horasProducaoRoteiro = this.getHorasProducaoRoteiro();
                result = result * 59 + ($horasProducaoRoteiro == null ? 43 : ((Object)$horasProducaoRoteiro).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeApontamentos(tipoProducao=" + this.getTipoProducao() + ", quantidadeProduzida=" + this.getQuantidadeProduzida() + ", quantidadeEsperada=" + this.getQuantidadeEsperada() + ", horasProducao=" + this.getHorasProducao() + ", horasProducaoRoteiro=" + this.getHorasProducaoRoteiro() + ")";
            }
        }

        public static class DTOOeeProducoesProdutosDia {
            @ToMapProperty(value="F_ID_PROD")
            private Long identificador;
            @ToMapProperty(value="F_COD_AUXILIAR_PROD")
            private String codigoAuxiliar;
            @ToMapProperty(value="F_NOME_PRODUTO_PROD")
            private String produto;
            @ToMapProperty(value="F_UNIDADE_MEDIDA_PROD")
            private String unidadeMedida;
            @ToMapProperty(value="F_TEMPO_PRODUCAO_PROD")
            private Double tempoProducao = 0.0;
            @ToMapProperty(value="F_TEMPO_ESPERADO_PROD")
            private Double tempoEsperado = 0.0;
            @ToMapProperty(value="F_QTD_REFUGO_PROD")
            private Double quantidadeRefugo = 0.0;
            @ToMapProperty(value="F_QTD_PRODUZIDA_PROD")
            private Double quantidadeProduzida = 0.0;
            @ToMapProperty(value="F_QTD_ESPERADA_PROD")
            private Double quantidadeEsperada = 0.0;
            @ToMapProperty(value="F_PERC_QUALIDADE_PROD")
            private Double percQualidade = 0.0;
            @ToMapProperty(value="F_PERC_PERFORMANCE_PROD")
            private Double percPerformance = 0.0;
            @ToMapProperty(value="F_APONTAMENTOS_DIA")
            private List<DTOOeeApontamentos> apontamentos = new LinkedList<DTOOeeApontamentos>();

            @Generated
            public DTOOeeProducoesProdutosDia() {
            }

            @Generated
            public Long getIdentificador() {
                return this.identificador;
            }

            @Generated
            public String getCodigoAuxiliar() {
                return this.codigoAuxiliar;
            }

            @Generated
            public String getProduto() {
                return this.produto;
            }

            @Generated
            public String getUnidadeMedida() {
                return this.unidadeMedida;
            }

            @Generated
            public Double getTempoProducao() {
                return this.tempoProducao;
            }

            @Generated
            public Double getTempoEsperado() {
                return this.tempoEsperado;
            }

            @Generated
            public Double getQuantidadeRefugo() {
                return this.quantidadeRefugo;
            }

            @Generated
            public Double getQuantidadeProduzida() {
                return this.quantidadeProduzida;
            }

            @Generated
            public Double getQuantidadeEsperada() {
                return this.quantidadeEsperada;
            }

            @Generated
            public Double getPercQualidade() {
                return this.percQualidade;
            }

            @Generated
            public Double getPercPerformance() {
                return this.percPerformance;
            }

            @Generated
            public List<DTOOeeApontamentos> getApontamentos() {
                return this.apontamentos;
            }

            @Generated
            public void setIdentificador(Long identificador) {
                this.identificador = identificador;
            }

            @Generated
            public void setCodigoAuxiliar(String codigoAuxiliar) {
                this.codigoAuxiliar = codigoAuxiliar;
            }

            @Generated
            public void setProduto(String produto) {
                this.produto = produto;
            }

            @Generated
            public void setUnidadeMedida(String unidadeMedida) {
                this.unidadeMedida = unidadeMedida;
            }

            @Generated
            public void setTempoProducao(Double tempoProducao) {
                this.tempoProducao = tempoProducao;
            }

            @Generated
            public void setTempoEsperado(Double tempoEsperado) {
                this.tempoEsperado = tempoEsperado;
            }

            @Generated
            public void setQuantidadeRefugo(Double quantidadeRefugo) {
                this.quantidadeRefugo = quantidadeRefugo;
            }

            @Generated
            public void setQuantidadeProduzida(Double quantidadeProduzida) {
                this.quantidadeProduzida = quantidadeProduzida;
            }

            @Generated
            public void setQuantidadeEsperada(Double quantidadeEsperada) {
                this.quantidadeEsperada = quantidadeEsperada;
            }

            @Generated
            public void setPercQualidade(Double percQualidade) {
                this.percQualidade = percQualidade;
            }

            @Generated
            public void setPercPerformance(Double percPerformance) {
                this.percPerformance = percPerformance;
            }

            @Generated
            public void setApontamentos(List<DTOOeeApontamentos> apontamentos) {
                this.apontamentos = apontamentos;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DTOOeeProducoesProdutosDia)) {
                    return false;
                }
                DTOOeeProducoesProdutosDia other = (DTOOeeProducoesProdutosDia)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$identificador = this.getIdentificador();
                Long other$identificador = other.getIdentificador();
                if (this$identificador == null ? other$identificador != null : !((Object)this$identificador).equals(other$identificador)) {
                    return false;
                }
                Double this$tempoProducao = this.getTempoProducao();
                Double other$tempoProducao = other.getTempoProducao();
                if (this$tempoProducao == null ? other$tempoProducao != null : !((Object)this$tempoProducao).equals(other$tempoProducao)) {
                    return false;
                }
                Double this$tempoEsperado = this.getTempoEsperado();
                Double other$tempoEsperado = other.getTempoEsperado();
                if (this$tempoEsperado == null ? other$tempoEsperado != null : !((Object)this$tempoEsperado).equals(other$tempoEsperado)) {
                    return false;
                }
                Double this$quantidadeRefugo = this.getQuantidadeRefugo();
                Double other$quantidadeRefugo = other.getQuantidadeRefugo();
                if (this$quantidadeRefugo == null ? other$quantidadeRefugo != null : !((Object)this$quantidadeRefugo).equals(other$quantidadeRefugo)) {
                    return false;
                }
                Double this$quantidadeProduzida = this.getQuantidadeProduzida();
                Double other$quantidadeProduzida = other.getQuantidadeProduzida();
                if (this$quantidadeProduzida == null ? other$quantidadeProduzida != null : !((Object)this$quantidadeProduzida).equals(other$quantidadeProduzida)) {
                    return false;
                }
                Double this$quantidadeEsperada = this.getQuantidadeEsperada();
                Double other$quantidadeEsperada = other.getQuantidadeEsperada();
                if (this$quantidadeEsperada == null ? other$quantidadeEsperada != null : !((Object)this$quantidadeEsperada).equals(other$quantidadeEsperada)) {
                    return false;
                }
                Double this$percQualidade = this.getPercQualidade();
                Double other$percQualidade = other.getPercQualidade();
                if (this$percQualidade == null ? other$percQualidade != null : !((Object)this$percQualidade).equals(other$percQualidade)) {
                    return false;
                }
                Double this$percPerformance = this.getPercPerformance();
                Double other$percPerformance = other.getPercPerformance();
                if (this$percPerformance == null ? other$percPerformance != null : !((Object)this$percPerformance).equals(other$percPerformance)) {
                    return false;
                }
                String this$codigoAuxiliar = this.getCodigoAuxiliar();
                String other$codigoAuxiliar = other.getCodigoAuxiliar();
                if (this$codigoAuxiliar == null ? other$codigoAuxiliar != null : !this$codigoAuxiliar.equals(other$codigoAuxiliar)) {
                    return false;
                }
                String this$produto = this.getProduto();
                String other$produto = other.getProduto();
                if (this$produto == null ? other$produto != null : !this$produto.equals(other$produto)) {
                    return false;
                }
                String this$unidadeMedida = this.getUnidadeMedida();
                String other$unidadeMedida = other.getUnidadeMedida();
                if (this$unidadeMedida == null ? other$unidadeMedida != null : !this$unidadeMedida.equals(other$unidadeMedida)) {
                    return false;
                }
                List<DTOOeeApontamentos> this$apontamentos = this.getApontamentos();
                List<DTOOeeApontamentos> other$apontamentos = other.getApontamentos();
                return !(this$apontamentos == null ? other$apontamentos != null : !((Object)this$apontamentos).equals(other$apontamentos));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DTOOeeProducoesProdutosDia;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $identificador = this.getIdentificador();
                result = result * 59 + ($identificador == null ? 43 : ((Object)$identificador).hashCode());
                Double $tempoProducao = this.getTempoProducao();
                result = result * 59 + ($tempoProducao == null ? 43 : ((Object)$tempoProducao).hashCode());
                Double $tempoEsperado = this.getTempoEsperado();
                result = result * 59 + ($tempoEsperado == null ? 43 : ((Object)$tempoEsperado).hashCode());
                Double $quantidadeRefugo = this.getQuantidadeRefugo();
                result = result * 59 + ($quantidadeRefugo == null ? 43 : ((Object)$quantidadeRefugo).hashCode());
                Double $quantidadeProduzida = this.getQuantidadeProduzida();
                result = result * 59 + ($quantidadeProduzida == null ? 43 : ((Object)$quantidadeProduzida).hashCode());
                Double $quantidadeEsperada = this.getQuantidadeEsperada();
                result = result * 59 + ($quantidadeEsperada == null ? 43 : ((Object)$quantidadeEsperada).hashCode());
                Double $percQualidade = this.getPercQualidade();
                result = result * 59 + ($percQualidade == null ? 43 : ((Object)$percQualidade).hashCode());
                Double $percPerformance = this.getPercPerformance();
                result = result * 59 + ($percPerformance == null ? 43 : ((Object)$percPerformance).hashCode());
                String $codigoAuxiliar = this.getCodigoAuxiliar();
                result = result * 59 + ($codigoAuxiliar == null ? 43 : $codigoAuxiliar.hashCode());
                String $produto = this.getProduto();
                result = result * 59 + ($produto == null ? 43 : $produto.hashCode());
                String $unidadeMedida = this.getUnidadeMedida();
                result = result * 59 + ($unidadeMedida == null ? 43 : $unidadeMedida.hashCode());
                List<DTOOeeApontamentos> $apontamentos = this.getApontamentos();
                result = result * 59 + ($apontamentos == null ? 43 : ((Object)$apontamentos).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia(identificador=" + this.getIdentificador() + ", codigoAuxiliar=" + this.getCodigoAuxiliar() + ", produto=" + this.getProduto() + ", unidadeMedida=" + this.getUnidadeMedida() + ", tempoProducao=" + this.getTempoProducao() + ", tempoEsperado=" + this.getTempoEsperado() + ", quantidadeRefugo=" + this.getQuantidadeRefugo() + ", quantidadeProduzida=" + this.getQuantidadeProduzida() + ", quantidadeEsperada=" + this.getQuantidadeEsperada() + ", percQualidade=" + this.getPercQualidade() + ", percPerformance=" + this.getPercPerformance() + ", apontamentos=" + String.valueOf(this.getApontamentos()) + ")";
            }
        }

        public static class DTOOeeColetasDia {
            @ToMapProperty(value="F_DATA_DIA")
            private Date dataColeta;
            @ToMapProperty(value="F_TEMPO_PRODUCAO_DIA")
            private Double tempoProducao = 0.0;
            @ToMapProperty(value="F_TEMPO_PLANEJADO_DIA")
            private Double tempoPlanejado = 0.0;
            @ToMapProperty(value="F_QTD_REFUGO_DIA")
            private Double quantidadeRefugo = 0.0;
            @ToMapProperty(value="F_QTD_PRODUZIDA_DIA")
            private Double quantidadeProduzida = 0.0;
            @ToMapProperty(value="F_QTD_ESPERADA_DIA")
            private Double quantidadeEsperada = 0.0;
            @ToMapProperty(value="F_PERC_DISPONIBILIDADE_DIA")
            private Double percDisponibilidade = 0.0;
            @ToMapProperty(value="F_PERC_QUALIDADE_DIA")
            private Double percQualidade = 0.0;
            @ToMapProperty(value="F_PERC_PERFORMANCE_DIA")
            private Double percPerformance = 0.0;
            @ToMapProperty(value="F_PERC_OEE_DIA")
            private Double percOee = 0.0;
            @ToMapProperty(value="F_PRODUCOES_DIA")
            private List<DTOOeeProducoesProdutosDia> producoesProdutos = new LinkedList<DTOOeeProducoesProdutosDia>();

            @Generated
            public DTOOeeColetasDia() {
            }

            @Generated
            public Date getDataColeta() {
                return this.dataColeta;
            }

            @Generated
            public Double getTempoProducao() {
                return this.tempoProducao;
            }

            @Generated
            public Double getTempoPlanejado() {
                return this.tempoPlanejado;
            }

            @Generated
            public Double getQuantidadeRefugo() {
                return this.quantidadeRefugo;
            }

            @Generated
            public Double getQuantidadeProduzida() {
                return this.quantidadeProduzida;
            }

            @Generated
            public Double getQuantidadeEsperada() {
                return this.quantidadeEsperada;
            }

            @Generated
            public Double getPercDisponibilidade() {
                return this.percDisponibilidade;
            }

            @Generated
            public Double getPercQualidade() {
                return this.percQualidade;
            }

            @Generated
            public Double getPercPerformance() {
                return this.percPerformance;
            }

            @Generated
            public Double getPercOee() {
                return this.percOee;
            }

            @Generated
            public List<DTOOeeProducoesProdutosDia> getProducoesProdutos() {
                return this.producoesProdutos;
            }

            @Generated
            public void setDataColeta(Date dataColeta) {
                this.dataColeta = dataColeta;
            }

            @Generated
            public void setTempoProducao(Double tempoProducao) {
                this.tempoProducao = tempoProducao;
            }

            @Generated
            public void setTempoPlanejado(Double tempoPlanejado) {
                this.tempoPlanejado = tempoPlanejado;
            }

            @Generated
            public void setQuantidadeRefugo(Double quantidadeRefugo) {
                this.quantidadeRefugo = quantidadeRefugo;
            }

            @Generated
            public void setQuantidadeProduzida(Double quantidadeProduzida) {
                this.quantidadeProduzida = quantidadeProduzida;
            }

            @Generated
            public void setQuantidadeEsperada(Double quantidadeEsperada) {
                this.quantidadeEsperada = quantidadeEsperada;
            }

            @Generated
            public void setPercDisponibilidade(Double percDisponibilidade) {
                this.percDisponibilidade = percDisponibilidade;
            }

            @Generated
            public void setPercQualidade(Double percQualidade) {
                this.percQualidade = percQualidade;
            }

            @Generated
            public void setPercPerformance(Double percPerformance) {
                this.percPerformance = percPerformance;
            }

            @Generated
            public void setPercOee(Double percOee) {
                this.percOee = percOee;
            }

            @Generated
            public void setProducoesProdutos(List<DTOOeeProducoesProdutosDia> producoesProdutos) {
                this.producoesProdutos = producoesProdutos;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DTOOeeColetasDia)) {
                    return false;
                }
                DTOOeeColetasDia other = (DTOOeeColetasDia)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$tempoProducao = this.getTempoProducao();
                Double other$tempoProducao = other.getTempoProducao();
                if (this$tempoProducao == null ? other$tempoProducao != null : !((Object)this$tempoProducao).equals(other$tempoProducao)) {
                    return false;
                }
                Double this$tempoPlanejado = this.getTempoPlanejado();
                Double other$tempoPlanejado = other.getTempoPlanejado();
                if (this$tempoPlanejado == null ? other$tempoPlanejado != null : !((Object)this$tempoPlanejado).equals(other$tempoPlanejado)) {
                    return false;
                }
                Double this$quantidadeRefugo = this.getQuantidadeRefugo();
                Double other$quantidadeRefugo = other.getQuantidadeRefugo();
                if (this$quantidadeRefugo == null ? other$quantidadeRefugo != null : !((Object)this$quantidadeRefugo).equals(other$quantidadeRefugo)) {
                    return false;
                }
                Double this$quantidadeProduzida = this.getQuantidadeProduzida();
                Double other$quantidadeProduzida = other.getQuantidadeProduzida();
                if (this$quantidadeProduzida == null ? other$quantidadeProduzida != null : !((Object)this$quantidadeProduzida).equals(other$quantidadeProduzida)) {
                    return false;
                }
                Double this$quantidadeEsperada = this.getQuantidadeEsperada();
                Double other$quantidadeEsperada = other.getQuantidadeEsperada();
                if (this$quantidadeEsperada == null ? other$quantidadeEsperada != null : !((Object)this$quantidadeEsperada).equals(other$quantidadeEsperada)) {
                    return false;
                }
                Double this$percDisponibilidade = this.getPercDisponibilidade();
                Double other$percDisponibilidade = other.getPercDisponibilidade();
                if (this$percDisponibilidade == null ? other$percDisponibilidade != null : !((Object)this$percDisponibilidade).equals(other$percDisponibilidade)) {
                    return false;
                }
                Double this$percQualidade = this.getPercQualidade();
                Double other$percQualidade = other.getPercQualidade();
                if (this$percQualidade == null ? other$percQualidade != null : !((Object)this$percQualidade).equals(other$percQualidade)) {
                    return false;
                }
                Double this$percPerformance = this.getPercPerformance();
                Double other$percPerformance = other.getPercPerformance();
                if (this$percPerformance == null ? other$percPerformance != null : !((Object)this$percPerformance).equals(other$percPerformance)) {
                    return false;
                }
                Double this$percOee = this.getPercOee();
                Double other$percOee = other.getPercOee();
                if (this$percOee == null ? other$percOee != null : !((Object)this$percOee).equals(other$percOee)) {
                    return false;
                }
                Date this$dataColeta = this.getDataColeta();
                Date other$dataColeta = other.getDataColeta();
                if (this$dataColeta == null ? other$dataColeta != null : !((Object)this$dataColeta).equals(other$dataColeta)) {
                    return false;
                }
                List<DTOOeeProducoesProdutosDia> this$producoesProdutos = this.getProducoesProdutos();
                List<DTOOeeProducoesProdutosDia> other$producoesProdutos = other.getProducoesProdutos();
                return !(this$producoesProdutos == null ? other$producoesProdutos != null : !((Object)this$producoesProdutos).equals(other$producoesProdutos));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DTOOeeColetasDia;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $tempoProducao = this.getTempoProducao();
                result = result * 59 + ($tempoProducao == null ? 43 : ((Object)$tempoProducao).hashCode());
                Double $tempoPlanejado = this.getTempoPlanejado();
                result = result * 59 + ($tempoPlanejado == null ? 43 : ((Object)$tempoPlanejado).hashCode());
                Double $quantidadeRefugo = this.getQuantidadeRefugo();
                result = result * 59 + ($quantidadeRefugo == null ? 43 : ((Object)$quantidadeRefugo).hashCode());
                Double $quantidadeProduzida = this.getQuantidadeProduzida();
                result = result * 59 + ($quantidadeProduzida == null ? 43 : ((Object)$quantidadeProduzida).hashCode());
                Double $quantidadeEsperada = this.getQuantidadeEsperada();
                result = result * 59 + ($quantidadeEsperada == null ? 43 : ((Object)$quantidadeEsperada).hashCode());
                Double $percDisponibilidade = this.getPercDisponibilidade();
                result = result * 59 + ($percDisponibilidade == null ? 43 : ((Object)$percDisponibilidade).hashCode());
                Double $percQualidade = this.getPercQualidade();
                result = result * 59 + ($percQualidade == null ? 43 : ((Object)$percQualidade).hashCode());
                Double $percPerformance = this.getPercPerformance();
                result = result * 59 + ($percPerformance == null ? 43 : ((Object)$percPerformance).hashCode());
                Double $percOee = this.getPercOee();
                result = result * 59 + ($percOee == null ? 43 : ((Object)$percOee).hashCode());
                Date $dataColeta = this.getDataColeta();
                result = result * 59 + ($dataColeta == null ? 43 : ((Object)$dataColeta).hashCode());
                List<DTOOeeProducoesProdutosDia> $producoesProdutos = this.getProducoesProdutos();
                result = result * 59 + ($producoesProdutos == null ? 43 : ((Object)$producoesProdutos).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia(dataColeta=" + String.valueOf(this.getDataColeta()) + ", tempoProducao=" + this.getTempoProducao() + ", tempoPlanejado=" + this.getTempoPlanejado() + ", quantidadeRefugo=" + this.getQuantidadeRefugo() + ", quantidadeProduzida=" + this.getQuantidadeProduzida() + ", quantidadeEsperada=" + this.getQuantidadeEsperada() + ", percDisponibilidade=" + this.getPercDisponibilidade() + ", percQualidade=" + this.getPercQualidade() + ", percPerformance=" + this.getPercPerformance() + ", percOee=" + this.getPercOee() + ", producoesProdutos=" + String.valueOf(this.getProducoesProdutos()) + ")";
            }
        }

        public static class DTOOEEEquipamento {
            @ToMapProperty(value="F_ID_EQUIPAMENTO")
            private Long idEquipamento;
            @ToMapProperty(value="F_COD_EQUIPAMENTO")
            private String codEquipamento;
            @ToMapProperty(value="F_NOME_EQUIPAMENTO")
            private String descricao;
            @ToMapProperty(value="F_ID_SENSOR_EQUIPAMENTO")
            private Long idSensor;
            @ToMapProperty(value="F_SIGLA_SENSOR_EQUIPAMENTO")
            private String siglaSensor;
            @ToMapProperty(value="F_ID_TIPO_COLETA_DADOS_EQUIPAMENTO")
            private Long idTipoColetaDados;
            @ToMapProperty(value="F_COLETA_DADOS_EQUIPAMENTO")
            private String coletaDados;
            @ToMapProperty(value="F_TEMPO_PRODUCAO_EQUIPAMENTO")
            private Double tempoProducao = 0.0;
            @ToMapProperty(value="F_TEMPO_PLANEJADO_EQUIPAMENTO")
            private Double tempoPlanejado = 0.0;
            @ToMapProperty(value="F_QTD_REFUGO_EQUIPAMENTO")
            private Double quantidadeRefugo = 0.0;
            @ToMapProperty(value="F_QTD_PRODUZIDA_EQUIPAMENTO")
            private Double quantidadeProduzida = 0.0;
            @ToMapProperty(value="F_QTD_ESPERADA_EQUIPAMENTO")
            private Double quantidadeEsperada = 0.0;
            @ToMapProperty(value="F_PERC_DISPONIBILIDADE_EQUIPAMENTO")
            private Double percDisponibilidade = 0.0;
            @ToMapProperty(value="F_PERC_QUALIDADE_EQUIPAMENTO")
            private Double percQualidade = 0.0;
            @ToMapProperty(value="F_PERC_PERFORMANCE_EQUIPAMENTO")
            private Double percPerformance = 0.0;
            @ToMapProperty(value="F_PERC_OEE_EQUIPAMENTO")
            private Double percOee = 0.0;
            @ToMapProperty(value="F_COLETAS_DIA_EQUIPAMENTO")
            private List<DTOOeeColetasDia> coletasDia = new LinkedList<DTOOeeColetasDia>();

            @Generated
            public DTOOEEEquipamento() {
            }

            @Generated
            public Long getIdEquipamento() {
                return this.idEquipamento;
            }

            @Generated
            public String getCodEquipamento() {
                return this.codEquipamento;
            }

            @Generated
            public String getDescricao() {
                return this.descricao;
            }

            @Generated
            public Long getIdSensor() {
                return this.idSensor;
            }

            @Generated
            public String getSiglaSensor() {
                return this.siglaSensor;
            }

            @Generated
            public Long getIdTipoColetaDados() {
                return this.idTipoColetaDados;
            }

            @Generated
            public String getColetaDados() {
                return this.coletaDados;
            }

            @Generated
            public Double getTempoProducao() {
                return this.tempoProducao;
            }

            @Generated
            public Double getTempoPlanejado() {
                return this.tempoPlanejado;
            }

            @Generated
            public Double getQuantidadeRefugo() {
                return this.quantidadeRefugo;
            }

            @Generated
            public Double getQuantidadeProduzida() {
                return this.quantidadeProduzida;
            }

            @Generated
            public Double getQuantidadeEsperada() {
                return this.quantidadeEsperada;
            }

            @Generated
            public Double getPercDisponibilidade() {
                return this.percDisponibilidade;
            }

            @Generated
            public Double getPercQualidade() {
                return this.percQualidade;
            }

            @Generated
            public Double getPercPerformance() {
                return this.percPerformance;
            }

            @Generated
            public Double getPercOee() {
                return this.percOee;
            }

            @Generated
            public List<DTOOeeColetasDia> getColetasDia() {
                return this.coletasDia;
            }

            @Generated
            public void setIdEquipamento(Long idEquipamento) {
                this.idEquipamento = idEquipamento;
            }

            @Generated
            public void setCodEquipamento(String codEquipamento) {
                this.codEquipamento = codEquipamento;
            }

            @Generated
            public void setDescricao(String descricao) {
                this.descricao = descricao;
            }

            @Generated
            public void setIdSensor(Long idSensor) {
                this.idSensor = idSensor;
            }

            @Generated
            public void setSiglaSensor(String siglaSensor) {
                this.siglaSensor = siglaSensor;
            }

            @Generated
            public void setIdTipoColetaDados(Long idTipoColetaDados) {
                this.idTipoColetaDados = idTipoColetaDados;
            }

            @Generated
            public void setColetaDados(String coletaDados) {
                this.coletaDados = coletaDados;
            }

            @Generated
            public void setTempoProducao(Double tempoProducao) {
                this.tempoProducao = tempoProducao;
            }

            @Generated
            public void setTempoPlanejado(Double tempoPlanejado) {
                this.tempoPlanejado = tempoPlanejado;
            }

            @Generated
            public void setQuantidadeRefugo(Double quantidadeRefugo) {
                this.quantidadeRefugo = quantidadeRefugo;
            }

            @Generated
            public void setQuantidadeProduzida(Double quantidadeProduzida) {
                this.quantidadeProduzida = quantidadeProduzida;
            }

            @Generated
            public void setQuantidadeEsperada(Double quantidadeEsperada) {
                this.quantidadeEsperada = quantidadeEsperada;
            }

            @Generated
            public void setPercDisponibilidade(Double percDisponibilidade) {
                this.percDisponibilidade = percDisponibilidade;
            }

            @Generated
            public void setPercQualidade(Double percQualidade) {
                this.percQualidade = percQualidade;
            }

            @Generated
            public void setPercPerformance(Double percPerformance) {
                this.percPerformance = percPerformance;
            }

            @Generated
            public void setPercOee(Double percOee) {
                this.percOee = percOee;
            }

            @Generated
            public void setColetasDia(List<DTOOeeColetasDia> coletasDia) {
                this.coletasDia = coletasDia;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DTOOEEEquipamento)) {
                    return false;
                }
                DTOOEEEquipamento other = (DTOOEEEquipamento)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$idEquipamento = this.getIdEquipamento();
                Long other$idEquipamento = other.getIdEquipamento();
                if (this$idEquipamento == null ? other$idEquipamento != null : !((Object)this$idEquipamento).equals(other$idEquipamento)) {
                    return false;
                }
                Long this$idSensor = this.getIdSensor();
                Long other$idSensor = other.getIdSensor();
                if (this$idSensor == null ? other$idSensor != null : !((Object)this$idSensor).equals(other$idSensor)) {
                    return false;
                }
                Long this$idTipoColetaDados = this.getIdTipoColetaDados();
                Long other$idTipoColetaDados = other.getIdTipoColetaDados();
                if (this$idTipoColetaDados == null ? other$idTipoColetaDados != null : !((Object)this$idTipoColetaDados).equals(other$idTipoColetaDados)) {
                    return false;
                }
                Double this$tempoProducao = this.getTempoProducao();
                Double other$tempoProducao = other.getTempoProducao();
                if (this$tempoProducao == null ? other$tempoProducao != null : !((Object)this$tempoProducao).equals(other$tempoProducao)) {
                    return false;
                }
                Double this$tempoPlanejado = this.getTempoPlanejado();
                Double other$tempoPlanejado = other.getTempoPlanejado();
                if (this$tempoPlanejado == null ? other$tempoPlanejado != null : !((Object)this$tempoPlanejado).equals(other$tempoPlanejado)) {
                    return false;
                }
                Double this$quantidadeRefugo = this.getQuantidadeRefugo();
                Double other$quantidadeRefugo = other.getQuantidadeRefugo();
                if (this$quantidadeRefugo == null ? other$quantidadeRefugo != null : !((Object)this$quantidadeRefugo).equals(other$quantidadeRefugo)) {
                    return false;
                }
                Double this$quantidadeProduzida = this.getQuantidadeProduzida();
                Double other$quantidadeProduzida = other.getQuantidadeProduzida();
                if (this$quantidadeProduzida == null ? other$quantidadeProduzida != null : !((Object)this$quantidadeProduzida).equals(other$quantidadeProduzida)) {
                    return false;
                }
                Double this$quantidadeEsperada = this.getQuantidadeEsperada();
                Double other$quantidadeEsperada = other.getQuantidadeEsperada();
                if (this$quantidadeEsperada == null ? other$quantidadeEsperada != null : !((Object)this$quantidadeEsperada).equals(other$quantidadeEsperada)) {
                    return false;
                }
                Double this$percDisponibilidade = this.getPercDisponibilidade();
                Double other$percDisponibilidade = other.getPercDisponibilidade();
                if (this$percDisponibilidade == null ? other$percDisponibilidade != null : !((Object)this$percDisponibilidade).equals(other$percDisponibilidade)) {
                    return false;
                }
                Double this$percQualidade = this.getPercQualidade();
                Double other$percQualidade = other.getPercQualidade();
                if (this$percQualidade == null ? other$percQualidade != null : !((Object)this$percQualidade).equals(other$percQualidade)) {
                    return false;
                }
                Double this$percPerformance = this.getPercPerformance();
                Double other$percPerformance = other.getPercPerformance();
                if (this$percPerformance == null ? other$percPerformance != null : !((Object)this$percPerformance).equals(other$percPerformance)) {
                    return false;
                }
                Double this$percOee = this.getPercOee();
                Double other$percOee = other.getPercOee();
                if (this$percOee == null ? other$percOee != null : !((Object)this$percOee).equals(other$percOee)) {
                    return false;
                }
                String this$codEquipamento = this.getCodEquipamento();
                String other$codEquipamento = other.getCodEquipamento();
                if (this$codEquipamento == null ? other$codEquipamento != null : !this$codEquipamento.equals(other$codEquipamento)) {
                    return false;
                }
                String this$descricao = this.getDescricao();
                String other$descricao = other.getDescricao();
                if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
                    return false;
                }
                String this$siglaSensor = this.getSiglaSensor();
                String other$siglaSensor = other.getSiglaSensor();
                if (this$siglaSensor == null ? other$siglaSensor != null : !this$siglaSensor.equals(other$siglaSensor)) {
                    return false;
                }
                String this$coletaDados = this.getColetaDados();
                String other$coletaDados = other.getColetaDados();
                if (this$coletaDados == null ? other$coletaDados != null : !this$coletaDados.equals(other$coletaDados)) {
                    return false;
                }
                List<DTOOeeColetasDia> this$coletasDia = this.getColetasDia();
                List<DTOOeeColetasDia> other$coletasDia = other.getColetasDia();
                return !(this$coletasDia == null ? other$coletasDia != null : !((Object)this$coletasDia).equals(other$coletasDia));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DTOOEEEquipamento;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $idEquipamento = this.getIdEquipamento();
                result = result * 59 + ($idEquipamento == null ? 43 : ((Object)$idEquipamento).hashCode());
                Long $idSensor = this.getIdSensor();
                result = result * 59 + ($idSensor == null ? 43 : ((Object)$idSensor).hashCode());
                Long $idTipoColetaDados = this.getIdTipoColetaDados();
                result = result * 59 + ($idTipoColetaDados == null ? 43 : ((Object)$idTipoColetaDados).hashCode());
                Double $tempoProducao = this.getTempoProducao();
                result = result * 59 + ($tempoProducao == null ? 43 : ((Object)$tempoProducao).hashCode());
                Double $tempoPlanejado = this.getTempoPlanejado();
                result = result * 59 + ($tempoPlanejado == null ? 43 : ((Object)$tempoPlanejado).hashCode());
                Double $quantidadeRefugo = this.getQuantidadeRefugo();
                result = result * 59 + ($quantidadeRefugo == null ? 43 : ((Object)$quantidadeRefugo).hashCode());
                Double $quantidadeProduzida = this.getQuantidadeProduzida();
                result = result * 59 + ($quantidadeProduzida == null ? 43 : ((Object)$quantidadeProduzida).hashCode());
                Double $quantidadeEsperada = this.getQuantidadeEsperada();
                result = result * 59 + ($quantidadeEsperada == null ? 43 : ((Object)$quantidadeEsperada).hashCode());
                Double $percDisponibilidade = this.getPercDisponibilidade();
                result = result * 59 + ($percDisponibilidade == null ? 43 : ((Object)$percDisponibilidade).hashCode());
                Double $percQualidade = this.getPercQualidade();
                result = result * 59 + ($percQualidade == null ? 43 : ((Object)$percQualidade).hashCode());
                Double $percPerformance = this.getPercPerformance();
                result = result * 59 + ($percPerformance == null ? 43 : ((Object)$percPerformance).hashCode());
                Double $percOee = this.getPercOee();
                result = result * 59 + ($percOee == null ? 43 : ((Object)$percOee).hashCode());
                String $codEquipamento = this.getCodEquipamento();
                result = result * 59 + ($codEquipamento == null ? 43 : $codEquipamento.hashCode());
                String $descricao = this.getDescricao();
                result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
                String $siglaSensor = this.getSiglaSensor();
                result = result * 59 + ($siglaSensor == null ? 43 : $siglaSensor.hashCode());
                String $coletaDados = this.getColetaDados();
                result = result * 59 + ($coletaDados == null ? 43 : $coletaDados.hashCode());
                List<DTOOeeColetasDia> $coletasDia = this.getColetasDia();
                result = result * 59 + ($coletasDia == null ? 43 : ((Object)$coletasDia).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento(idEquipamento=" + this.getIdEquipamento() + ", codEquipamento=" + this.getCodEquipamento() + ", descricao=" + this.getDescricao() + ", idSensor=" + this.getIdSensor() + ", siglaSensor=" + this.getSiglaSensor() + ", idTipoColetaDados=" + this.getIdTipoColetaDados() + ", coletaDados=" + this.getColetaDados() + ", tempoProducao=" + this.getTempoProducao() + ", tempoPlanejado=" + this.getTempoPlanejado() + ", quantidadeRefugo=" + this.getQuantidadeRefugo() + ", quantidadeProduzida=" + this.getQuantidadeProduzida() + ", quantidadeEsperada=" + this.getQuantidadeEsperada() + ", percDisponibilidade=" + this.getPercDisponibilidade() + ", percQualidade=" + this.getPercQualidade() + ", percPerformance=" + this.getPercPerformance() + ", percOee=" + this.getPercOee() + ", coletasDia=" + String.valueOf(this.getColetasDia()) + ")";
            }
        }
    }
}

