/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.celulaprodutiva;

import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapColetaDadosDiariaIOT;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoQtd;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceDesempenhoOEECelProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.coletadadosativo.ServiceColetaDadosAtivoImpl;
import com.touchcomp.basementorservice.service.impl.equipcoletadadosativoiot.ServiceEquipColetaDadosAtivoIOTImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.ServiceEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.planejtempotrabalhopcp.ServicePlanejTempoTrabalhoPCPImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceDesempenhoOEEEquipamentoImpl
extends ServiceGenericImpl {
    final ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl;
    final ServiceEventoOsProducaoLinhaProdImpl serviceEventoOSProducaoImpl;
    final ServicePlanejTempoTrabalhoPCPImpl servicePlanejamentoTempoImpl;
    final ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColetaDadosAtivoIOTImpl;
    final ServiceColetaDadosAtivoImpl serviceColetaDadosAtivoImpl;
    private final Short P_TEMPO_PLANEJADO_PCP = 1;
    private final Short P_TEMPO_PLANEJADO_EQUIP_IOT_DISPONIBILIDADE = 2;
    private final Short P_TEMPO_PLANEJADO_EQUIP_IOT_EXPECTATIVA = 3;
    private final Short P_TEMPO_PRODUCAO_PCP = 1;
    private final Short P_TEMPO_PRODUCAO_IOT = 2;

    public ServiceDesempenhoOEEEquipamentoImpl(ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl, ServiceEventoOsProducaoLinhaProdImpl serviceEventoOSProducaoImpl, ServicePlanejTempoTrabalhoPCPImpl servicePlanejamentoTempoImpl, ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColetaDadosAtivoIOTImpl, ServiceColetaDadosAtivoImpl serviceColetaDadosAtivoImpl) {
        this.serviceCelulaProdutivaImpl = serviceCelulaProdutivaImpl;
        this.serviceEventoOSProducaoImpl = serviceEventoOSProducaoImpl;
        this.servicePlanejamentoTempoImpl = servicePlanejamentoTempoImpl;
        this.serviceEquipColetaDadosAtivoIOTImpl = serviceEquipColetaDadosAtivoIOTImpl;
        this.serviceColetaDadosAtivoImpl = serviceColetaDadosAtivoImpl;
    }

    public List<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva> calcularOEE(ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params) {
        Empresa emp = this.getSharedData().getEmpresa(params.getIdEmpresa());
        if (emp == null) {
            return new LinkedList<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva>();
        }
        List<CelulaProdutiva> celulas = this.serviceCelulaProdutivaImpl.getCelulasAtivas(emp, params.getFiltrarCelulaProdutiva(), params.getIdCelulasProdutivas());
        LinkedList<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva> celulasProdutivas = new LinkedList<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva>();
        for (CelulaProdutiva celula : celulas) {
            List<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento> equipamentos = this.getEquipamentos(celula, params);
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva dto = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva();
            dto.setDescricao(celula.getDescricao());
            dto.setIdentificador(celula.getIdentificador());
            dto.setEquipamentos(equipamentos);
            celulasProdutivas.add(dto);
            for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento dtoEquip : equipamentos) {
                EquipColetaDadosAtivoSensorIOT sensorIOT = this.serviceEquipColetaDadosAtivoIOTImpl.getSensorEquipamento(dtoEquip.getIdEquipamento());
                this.putTempoProgramadoEquipamento(celula, dtoEquip, params, sensorIOT);
                this.putProducoesEquipamento(celula, dtoEquip, params, sensorIOT);
                this.putTemposColetadosIOT(celula, dtoEquip, params, sensorIOT);
            }
        }
        this.calcularIndicadoresTipoEquipamentos(celulasProdutivas);
        return celulasProdutivas;
    }

    private List<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento> getEquipamentos(CelulaProdutiva celula, ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params) {
        LinkedList<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento> equipamentos = new LinkedList<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento>();
        List<CelulaProdutivaEquipamento> equipamentosAtivos = this.serviceCelulaProdutivaImpl.getEquipamentos((short)1, ToolMethods.toList((Object[])new Object[]{celula.getIdentificador()}), params.getFiltrarEquipamentos(), params.getIdEquipamentos(), params.getFiltrarCentroCusto(), params.getIdCentrosCusto(), params.getFiltrarEmpresaProprietarias(), params.getIdEmpresasProprietarias(), params.getFiltrarFabricantes(), params.getIdFabricantes(), params.getFiltrarFornecedores(), params.getIdFornecedores(), params.getFiltrarTipoEquipamento(), params.getIdTipoEquipamentos());
        for (CelulaProdutivaEquipamento equi : equipamentosAtivos) {
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento dtoEquip = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento();
            dtoEquip.setIdEquipamento(equi.getEquipamento().getIdentificador());
            dtoEquip.setCodEquipamento(equi.getEquipamento().getCodigo());
            dtoEquip.setDescricao(equi.getEquipamento().getNome());
            equipamentos.add(dtoEquip);
        }
        return equipamentos;
    }

    private void putTempoProgramadoEquipamento(CelulaProdutiva celula, ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento dtoEquip, ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params, EquipColetaDadosAtivoSensorIOT sensorIOT) {
        List<DiaPlanejTempoTrabalhoPCP> diasTrabalho = this.servicePlanejamentoTempoImpl.getDiasTrabalhoPlanejados(celula, params.getDataInicial(), params.getDataFinal());
        int nrDias = 0;
        for (DiaPlanejTempoTrabalhoPCP dia : diasTrabalho) {
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia dto = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia();
            dto.setDataColeta(dia.getDia());
            this.setTempoProgramado(dto, sensorIOT, dia, params);
            dtoEquip.getColetasDia().add(dto);
            ++nrDias;
        }
    }

    private void putProducoesEquipamento(CelulaProdutiva celula, ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento dtoEquip, ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params, EquipColetaDadosAtivoSensorIOT sensorIOT) {
        List<GenericMapValues<GenMapEvtProducaoQtd>> producoes = this.serviceEventoOSProducaoImpl.getApontamentosProducaoQtd((short)1, celula.getIdentificador(), params.getFiltrarEquipamentos(), dtoEquip.getIdEquipamento(), (short)1, EnumConstTipoProducao.PRODUCAO, params.getDataInicial(), params.getDataFinal(), false);
        List<GenericMapValues<GenMapEvtProducaoQtd>> refugos = this.serviceEventoOSProducaoImpl.getApontamentosProducaoProdSubosQtd((short)1, celula.getIdentificador(), params.getFiltrarEquipamentos(), dtoEquip.getIdEquipamento(), (short)1, EnumConstTipoProducao.REFUGO, params.getDataInicial(), params.getDataFinal(), true);
        producoes.addAll(refugos);
        for (GenericMapValues<GenMapEvtProducaoQtd> producao : producoes) {
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia produtoDia;
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia dia;
            Optional<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia> foundDia = dtoEquip.getColetasDia().stream().filter(i -> TMethods.isEquals((Object)i.getDataColeta(), (Object)producao.getDate(GenMapEvtProducaoQtd.DATA))).findFirst();
            if (!foundDia.isPresent()) {
                dia = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia();
                dia.setDataColeta(producao.getDate(GenMapEvtProducaoQtd.DATA));
                this.setTempoProgramado(dia, sensorIOT, null, params);
                dtoEquip.getColetasDia().add(dia);
            } else {
                dia = foundDia.get();
            }
            Optional<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia> foundProduto = dia.getProducoesProdutos().stream().filter(i -> TMethods.isEquals((Object)i.getIdentificador(), (Object)producao.getLong(GenMapEvtProducaoQtd.ID_PRODUTO))).findFirst();
            if (!foundProduto.isPresent()) {
                produtoDia = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia();
                produtoDia.setCodigoAuxiliar(producao.getString(GenMapEvtProducaoQtd.CODIGO_AUX_PRODUTO));
                produtoDia.setIdentificador(producao.getLong(GenMapEvtProducaoQtd.ID_PRODUTO));
                produtoDia.setProduto(producao.getString(GenMapEvtProducaoQtd.PRODUTO));
                produtoDia.setUnidadeMedida(producao.getString(GenMapEvtProducaoQtd.UN_PRODUTO));
                dia.getProducoesProdutos().add(produtoDia);
            } else {
                produtoDia = foundProduto.get();
            }
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeApontamentos apontamento = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeApontamentos();
            apontamento.setHorasProducao(producao.getDouble(GenMapEvtProducaoQtd.HORA_PRODUCAO));
            apontamento.setHorasProducaoRoteiro(producao.getDouble(GenMapEvtProducaoQtd.HORA_PRODUCAO_ROTEIRO));
            apontamento.setQuantidadeProduzida(producao.getDouble(GenMapEvtProducaoQtd.QUANTIDADE_TOTAL));
            apontamento.setTipoProducao(producao.getShort(GenMapEvtProducaoQtd.TIPO_PRODUCAO));
            produtoDia.getApontamentos().add(apontamento);
        }
    }

    private void setTempoProgramado(ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia dto, EquipColetaDadosAtivoSensorIOT sensorIOT, DiaPlanejTempoTrabalhoPCP dia, ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params) {
        if (sensorIOT != null && TMethods.isEquals((Object)params.getTipoOrigemTempoPlanejado(), (Object)this.P_TEMPO_PLANEJADO_EQUIP_IOT_DISPONIBILIDADE)) {
            dto.setTempoPlanejado(sensorIOT.getDisponibilidadeTempoDiario());
        } else if (sensorIOT != null && TMethods.isEquals((Object)params.getTipoOrigemTempoPlanejado(), (Object)this.P_TEMPO_PLANEJADO_EQUIP_IOT_EXPECTATIVA)) {
            dto.setTempoPlanejado(sensorIOT.getExpectativaTempoProdDiario());
        } else if (dia != null) {
            dto.setTempoPlanejado(dia.getNumeroHorasTrab());
        }
    }

    private void calcularIndicadoresTipoEquipamentos(List<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva> celulasProdutivas) {
        for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva celula : celulasProdutivas) {
            double percPerformance = 0.0;
            double percDisponibilidade = 0.0;
            double percQualidade = 0.0;
            for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento equipamento : celula.getEquipamentos()) {
                this.calcularEquipamento(equipamento);
                percPerformance += equipamento.getPercPerformance().doubleValue();
                percDisponibilidade += equipamento.getPercDisponibilidade().doubleValue();
                percQualidade += equipamento.getPercQualidade().doubleValue();
            }
            int contador = !celula.getEquipamentos().isEmpty() ? celula.getEquipamentos().size() : 1;
            celula.setPercPerformance(percPerformance / (double)contador);
            celula.setPercDisponibilidade(percDisponibilidade / (double)contador);
            celula.setPercQualidade(percQualidade / (double)contador);
            celula.setPercOee(celula.getPercDisponibilidade() / 100.0 * celula.getPercPerformance() / 100.0 * celula.getPercQualidade() / 100.0 * 100.0);
        }
    }

    private void calcularDia(ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia dia) {
        double percPerformanceDia = 0.0;
        double percQualidadeDia = 0.0;
        double tempoProducao = 0.0;
        for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeProducoesProdutosDia produto : dia.getProducoesProdutos()) {
            double quantidadeEsperadaProd = 0.0;
            double quantidadeProduzidaProd = 0.0;
            double quantidadeRefugoProd = 0.0;
            double tempoEsperadoProd = 0.0;
            double tempoProducaoProd = 0.0;
            for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeApontamentos apontamento : produto.getApontamentos()) {
                if (ToolMethods.isEquals((Object)EnumConstTipoProducao.PRODUCAO.getValue(), (Object)apontamento.getTipoProducao())) {
                    apontamento.setQuantidadeEsperada(apontamento.getQuantidadeProduzida() / apontamento.getHorasProducaoRoteiro() * apontamento.getHorasProducao());
                    quantidadeProduzidaProd += apontamento.getQuantidadeProduzida().doubleValue();
                    quantidadeEsperadaProd += apontamento.getQuantidadeEsperada().doubleValue();
                    tempoEsperadoProd += apontamento.getHorasProducaoRoteiro().doubleValue();
                    tempoProducaoProd += apontamento.getHorasProducao().doubleValue();
                    continue;
                }
                quantidadeRefugoProd += apontamento.getQuantidadeProduzida().doubleValue();
            }
            produto.setQuantidadeEsperada(quantidadeEsperadaProd);
            produto.setQuantidadeProduzida(quantidadeProduzidaProd);
            produto.setQuantidadeRefugo(quantidadeRefugoProd);
            produto.setTempoProducao(tempoProducaoProd);
            produto.setTempoEsperado(tempoEsperadoProd);
            if (produto.getQuantidadeEsperada() > 0.0) {
                produto.setPercPerformance(produto.getQuantidadeProduzida() / produto.getQuantidadeEsperada() * 100.0);
            }
            if (produto.getQuantidadeProduzida() + produto.getQuantidadeRefugo() > 0.0) {
                produto.setPercQualidade(produto.getQuantidadeProduzida() / (produto.getQuantidadeProduzida() + produto.getQuantidadeRefugo()) * 100.0);
            }
            percPerformanceDia += produto.getPercPerformance().doubleValue();
            percQualidadeDia += produto.getPercQualidade().doubleValue();
            tempoProducao += produto.getTempoProducao().doubleValue();
        }
        int contador = !dia.getProducoesProdutos().isEmpty() ? dia.getProducoesProdutos().size() : 1;
        dia.setTempoProducao(tempoProducao);
        dia.setPercQualidade(percQualidadeDia / (double)contador);
        dia.setPercPerformance(percPerformanceDia / (double)contador);
        if (dia.getTempoPlanejado() > 0.0) {
            dia.setPercDisponibilidade(dia.getTempoProducao() / dia.getTempoPlanejado() * 100.0);
        }
        dia.setPercOee(dia.getPercDisponibilidade() / 100.0 * dia.getPercPerformance() / 100.0 * dia.getPercQualidade() / 100.0 * 100.0);
    }

    private void calcularEquipamento(ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento equipamento) {
        double percPerformance = 0.0;
        double percDisponibilidade = 0.0;
        double percQualidade = 0.0;
        for (ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia dia : equipamento.getColetasDia()) {
            this.calcularDia(dia);
            percDisponibilidade += dia.getPercDisponibilidade().doubleValue();
            percPerformance += dia.getPercPerformance().doubleValue();
            percQualidade += dia.getPercQualidade().doubleValue();
        }
        int contador = !equipamento.getColetasDia().isEmpty() ? equipamento.getColetasDia().size() : 1;
        equipamento.setPercPerformance(percPerformance / (double)contador);
        equipamento.setPercDisponibilidade(percDisponibilidade / (double)contador);
        equipamento.setPercQualidade(percQualidade / (double)contador);
        equipamento.setPercOee(equipamento.getPercDisponibilidade() / 100.0 * equipamento.getPercPerformance() / 100.0 * equipamento.getPercQualidade() / 100.0 * 100.0);
    }

    private void putTemposColetadosIOT(CelulaProdutiva celula, ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOEEEquipamento dtoEquip, ServiceDesempenhoOEECelProdutivaImpl.DTOOEEParams params, EquipColetaDadosAtivoSensorIOT sensorIOT) {
        if (!ToolMethods.isEquals((Object)this.P_TEMPO_PRODUCAO_IOT, (Object)params.getTipoOrigemTempoProducao())) {
            return;
        }
        List<GenericMapValues<GenMapColetaDadosDiariaIOT>> tempoColetado = this.serviceColetaDadosAtivoImpl.getColetasDiarias(sensorIOT, params.getDataInicial(), params.getDataFinal());
        for (GenericMapValues<GenMapColetaDadosDiariaIOT> dia : tempoColetado) {
            ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia coleta;
            Optional<ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia> found = dtoEquip.getColetasDia().stream().filter(i -> TMethods.isEquals((Object)TDate.dataSemHora((Date)dia.getDate(GenMapColetaDadosDiariaIOT.DATA_COLETA)), (Object)i.getDataColeta())).findFirst();
            if (found.isPresent()) {
                coleta = found.get();
            } else {
                coleta = new ServiceDesempenhoOEECelProdutivaImpl.DTOOEECelulaProdutiva.DTOOeeColetasDia();
                coleta.setDataColeta(dia.getDate(GenMapColetaDadosDiariaIOT.DATA_COLETA));
                dtoEquip.getColetasDia().add(coleta);
            }
            coleta.setTempoProducao(dia.getDouble(GenMapColetaDadosDiariaIOT.TEMPO_COLETA));
        }
    }
}

